<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//En este controlador se encuentran todas las acciones que ayudarán a realizar las funciones del módulo 
class Acceso extends CI_Controller
{
    //Constructor que manda a traer el modelo,librerias, helper y la base de datos. 
    public function __construct()
    {
        parent::__construct();
		$this->load->model('acceso/acceso_model');
		$this->load->model('HAccesos/Franquiciatario/HistoricoAccesos_models');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url','form'));
		$this->load->database('default');
    }
	
	//Funcion que valida el tipo de usuario y direcciona al controlador que le corresponde 
	public function index(){	
		switch ($this->session->userdata('Rol_IdRol','Usuario','Franquicias_IdFranquicias')) {
			case '':
				$this->load->view('acceso/login_view');
				break;
			case '1':
				redirect(base_url().'acceso/administrador');
				break;
			case '2':
				redirect(base_url().'acceso/franquiciatario');
				break;	
			case '3':
				redirect(base_url().'acceso/cosmetologo');
				break;
			default:
				$this->load->view('acceso/login_view');
				break;	
		}
		
	}


	//Funcion que valida si existe el usuario ingresado 
	public function new_user(){
		if ($this->input->post()) {
			/*Comprobar que el campo no venga vacio o nullo */
			$contrasenia = $this->input->post('Contrasenia');
			$usuario = $this->input->post('Usuario');
			if($contrasenia === '' || $contrasenia === null || $usuario === '' || $usuario === null){
				echo json_encode("error");/*"<!DOCTYPE html>
					<html>
					<head>
						<title></title>
						<script type='text/javascript' src='".base_url()."assets/plugins/jQuery/jquery-3.3.1.js'></script>
						<script src='".base_url()."assets/plugins/sweetalert/sweetalert.min.js'></script> 
					</head>
					<body>
					
					<script>  
						swal({
							title:'Advertencia!',
							text:'Verifique los datos introducidos!',
							icon:'warning'
						}).then(function() {
							window.location.href='".base_url()."acceso/acceso'; 
							
						});
					</script> 
					</body>
					</html>";*/
			}else{
				$this->form_validation->set_rules('Usuario', 'usuario', 'required|trim|min_length[5]|max_length[25]');
				$this->form_validation->set_rules('Contrasenia', 'contraseña', 'required|trim|max_length[20]');
	
				//lanzamos mensajes de error si es que los hay
				$this->form_validation->set_message('required', 'El campo %s es requerido');
				$this->form_validation->set_message('min_length', 'El campo %s debe tener al menos %s carácteres');
				$this->form_validation->set_message('max_length', 'El campo %s debe tener al menos %s carácteres');
				$check_user="";
				if($this->form_validation->run() == FALSE){
					$this->index();
				}else{
					$usuario = $this->input->post('Usuario');
					$contrasenia = md5($this->input->post('Contrasenia'));
					$date = $this->input->post('date');
					$check_user = $this->acceso_model->login_user($usuario,$contrasenia);

					date_default_timezone_set("America/New_York");
					$fechaS = date("Y-m-d");
					$fechaC = substr($date, 0, 10);
					
					if($check_user == true){
						if($fechaC === $fechaS){						
							$data = array(
								'is_logued_in' 	=> 		TRUE,
								'IdUsuarios' 	=> 		$check_user->IdUsuarios,
								'Rol_IdRol'		=>		$check_user->Rol_IdRol,
								'IdFranquicia' 		=> 		$check_user->Franquicias_IdFranquicias,
								'Usuario' 		=> 		$check_user->Usuario
							);
							$this->session->set_userdata($data);
							$id = $this->insertAccesos($date);
							$this->session->set_userdata('IdAcceso', $id);
							//$this->index();
							echo json_encode("success");
						}else{
							echo json_encode("time"); 
						/*"<!DOCTYPE html>
							<html>
							<head>
								<title></title>
								<script type='text/javascript' src='".base_url()."assets/plugins/jQuery/jquery-3.3.1.js'></script>
								<script src='".base_url()."assets/plugins/sweetalert/sweetalert.min.js'></script> 
							</head>
							<body>
							
							<script>  
								swal({
									title:'Advertencia!',
									text:'Verifique la hora y fecha de tu equipo!',
									icon:'warning'
								}).then(function() {
									window.location.href='".base_url()."acceso/acceso'; 
									
								});
							</script> 
							</body>
						</html>";*/
						}
					}else if($check_user == false){
						echo json_encode("incorrectos");
						/*"<!DOCTYPE html>
							<html>
							<head>
								<title></title>
								<script type='text/javascript' src='".base_url()."assets/plugins/jQuery/jquery-3.3.1.js'></script>
								<script src='".base_url()."assets/plugins/sweetalert/sweetalert.min.js'></script> 
							</head>
							<body>
							
							<script>  
								swal({
									title:'Advertencia!',
									text:'Los datos introducidos son incorrectos!',
									icon:'warning'
								}).then(function() {
									window.location.href='".base_url()."acceso/acceso'; 
									
								});
							</script> 
							</body>
						</html>";*/
						// redirect(base_url().'acceso/acceso');
						//base_url().'acceso/acceso';
						//el error se redirecciona a la vista de acceso/acceso
					}
				}
				
			}				
			// $this->session->set_flashdata('usuario_incorrecto','Verifique los datos introducidos!');
			// redirect(base_url().'acceso/acceso','refresh');
		}else{
			echo json_encode("error1");/*"<!DOCTYPE html>
					<html>
					<head>
						<title></title>
						<script type='text/javascript' src='".base_url()."assets/plugins/jQuery/jquery-3.3.1.js'></script>
						<script src='".base_url()."assets/plugins/sweetalert/sweetalert.min.js'></script> 
					</head>
					<body>
					
					<script>  
						swal({
							title:'Advertencia!',
							text:'Verifique los datos introducidos!',
							icon:'warning'
						}).then(function() {
							window.location.href='".base_url()."acceso/acceso'; 
							
						});
					</script> 
					</body>
					</html>";*/
		}
	}

	public function getIp(){
		if (isset($_SERVER["HTTP_CLIENT_IP"])){
			return $_SERVER["HTTP_CLIENT_IP"];
		}
		elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])){
			return $_SERVER["HTTP_X_FORWARDED_FOR"];
		}
		elseif (isset($_SERVER["HTTP_X_FORWARDED"])){
			return $_SERVER["HTTP_X_FORWARDED"];
		}
		elseif (isset($_SERVER["HTTP_FORWARDED_FOR"])){
			return $_SERVER["HTTP_FORWARDED_FOR"];
		}
		elseif (isset($_SERVER["HTTP_FORWARDED"])){
			return $_SERVER["HTTP_FORWARDED"];
		}
		else{
			return $_SERVER["REMOTE_ADDR"];
		}
	}

	public function insertAccesos($date){
		$ip = $this->getIp();
		$id = $this->HistoricoAccesos_models->registroHistoricoA($this->session->userdata('IdUsuarios'), $ip, $date);
		//var_dump($this->HistoricoAccesos_models->getAccesos());
		//exit();
		return $id;
	}

	public function getAccesos(){
		$this->HistoricoAccesos_models->getAccesos();
	}
	
	//Funcion que destruye la sesión
	public function logout_ci($f1){
		//$response = '';
		$fecha = $this->input->post('fecha');
		$id = $this->session->userdata('IdAcceso');

		$salida = str_replace('%20', ' ', $f1);
		$response = $this->HistoricoAccesos_models->updateRegistro($id, $salida);
		// echo $response;
		// exit();
		$this->session->sess_destroy();
		echo json_encode($response);
		//$this->index();
	}

}
