<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//Este controlador manda a traer las acciones para que el modulo pueda realizar sus funciones(Franquiciatario)
class CajaC extends CI_Controller{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct(){
		parent::__construct();		
		$this->load->model('caja/Cosmetologo/cajaC_models');
		$this->load->library(array('session','form_validation'));
		$this->load->library('Mydompdf');
		$this->load->library('CifrasEnLetras');
		
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista caja_views
	public function index(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'){
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias'] = $this->cajaC_models->BuscarFranquicia();
    	/*	var_dump($this->session->userdata('IdUsuarios'));*/
    	$data['datosFranquiciaTicket'] = $this->cajaC_models->BuscarDatosFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
        $this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo'); 
		$data['cabinas']=$this->cabinas(); 
		$data['ReUsuario']=$this->cajaC_models->BuscarUsuario();
		$data['Usuarios']=$this->cajaC_models->BuscarUsuarios();
		$data['ReUsuarioProp']=$this->cajaC_models->BuscarUsuarioC();
		$data['Zona']=$this->cajaC_models->BuscarZona();
		$data['Exi']=$this->cajaC_models->BuscarPagos();
		$data['Contra']=$this->cajaC_models->BuscarContra();
	    foreach ($data['Zona'] as $i => $Zona) 
		$this->load->view('caja/Franquiciatario/caja_views',$data);
		$this->load->view('layout/footer');
		} 
	}

	function limpia_espacios($cadena){
    $cadena = str_replace(' ', '', $cadena);
    return $cadena;
    }
	public function cabinas()
	{
		$cabinasExistentes=$this->cajaC_models->BuscarCabina();
		$coloresCabina= array(
			"FACIAL"  =>  '#37579D',
			"FACIAL 2"  =>  '#D8907C',
			"CORPORAL"  =>  '#C0473E',
			"CORPORAL 2"  =>  '#BE304A',
			"RELAJANTES/MASAJES"  =>  '#47A3A0',
			"CAVITACION"  =>  '#DFA130',
			"IPL/E-LIGHT"  =>  '#76B9E5',
			"PESTAÑAS"  =>  '#1E7999',
			"SAUNA"  =>  '#EAC595',
			"SAUNA 2" =>  '#4C418E',
			"ADICIONAL" =>  '#902456',
			"CAPSULA INFRAROJA" =>  '#BD2367',
			"UÑAS 1" =>  '#A71929',
			"UÑAS 2" =>  '#7890C4',
			"UÑAS 3" =>  '#9DAB2D',
		);
		$i=0;
		foreach($cabinasExistentes as $i => $cabina)
		{
			$colores[$i]['id'] = $i;
			$colores[$i]['nombre'] = $cabina;
			switch($cabina)
			{
				case 'FACIAL':
					$colores[$i]['color'] = 'facial';
					break;
				case 'FACIAL 2':
					$colores[$i]['color'] = 'facial-2';
					break;
				case 'CORPORAL':
					$colores[$i]['color'] = 'corporal';
					break;
				case 'CORPORAL 2':
					$colores[$i]['color'] = 'corporal-2';
					break;
				case 'RELAJANTES/MASAJES':
					$colores[$i]['color'] = 'relajantes-masajes';
					break;
				case 'CAVITACION':
					$colores[$i]['color'] = 'cavitacion';
					break;
				case 'IPL/E-LIGHT':
					$colores[$i]['color'] = 'ipl-e-light';
					break;
				case 'PESTAÑAS':
					$colores[$i]['color'] = 'pestañas';
					break;
				case 'SAUNA':
					$colores[$i]['color'] = 'sauna';
					break;
				case 'SAUNA 2':
					$colores[$i]['color'] = 'sauna-2';
					break;
				case 'ADICIONAL':
					$colores[$i]['color'] = 'adicional';
					break;
				case 'CAPSULA INFRAROJA':
					$colores[$i]['color'] = 'capsula-infraroja';
					break;
				case 'UÑAS 1':
					$colores[$i]['color'] = 'uñas-1';
					break;
				case 'UÑAS 2':
					$colores[$i]['color'] = 'uñas-2';
					break;
				case 'UÑAS 3':
					$colores[$i]['color'] = 'uñas-3';
					break;
				default;
				$colores[$i]['color'] = 'blanco';
				break;
			}
			
			$i++;
			
		}
		
		return ($colores);
	}
	public function AgregarVenta(){
		/*Lineas de encabezado no guardan venta cuando estan activas*/
		// if($this->session->userdata('Rol_IdRol')==FALSE || 
		// 	$this->session->userdata('Rol_IdRol') == '1'|| 
		// 	$this->session->userdata('Rol_IdRol') == '2')
		// {
		// 	redirect(base_url().'acceso/acceso');
		// } else {
		$buscarFolio=$this->cajaC_models->buscarFolio();
		$folioVenta=$buscarFolio+1;
		$folios=array(
			'FolioVenta'=>$folioVenta,
			'franquicias_IdFranquicias'=>$this->cajaC_models->BuscarIdFranquicia(),
			'IdUsuariosLog'=>$this->session->userdata('IdUsuarios'),
		);
		$insertaFolio=$this->cajaC_models->insertaFolio($folios);
		if($insertaFolio!=FALSE){
			$parametro ['FolioVenta']=$folioVenta;
		}
		$fecha=$this->input->post('fecha');
 		$hora=$this->input->post('hora');
 	  	$nuevaFecha = $this->limpia_espacios($fecha);
 	  	$nuevaHora = $this->limpia_espacios($hora);
 	  	
		$parametro ['IdVentas']= $this->input->post('franquicia').$nuevaFecha.$nuevaHora;
		$parametro['franquicias_IdFranquicias'] = $this->input->post('franquicia');
		$parametro['ClienteVenta'] = $this->input->post('title');
		$parametro['IdCliente'] = $this->input->post('idc');
		$parametro['TotalVenta'] = $this->input->post('totaltotal1');
		$parametro['VendedorUsuario'] = $this->input->post('Vendedor');
		$parametro['Comentario'] = $this->input->post('comentario');
		$parametro['FechaVenta'] = $this->input->post('fecha')." ".$parametro['hora']= $this->input->post('hora');
		$parametro['Subtotal'] = $this->input->post('Sub1');
		$parametro['Iva'] = $this->input->post('IVA');
		$parametro['TotalVentaGeneral'] = $this->input->post('Totalgen');
		$parametro['AbonoVenta'] = $this->input->post('Abono');
		$parametro['AdeudoVenta'] = $this->input->post('Adeudo');
		$parametro['Contado'] = $this->input->post('ContadoD');
		$parametro['TipoPagoUno'] = $this->input->post('Tpago1');
		$parametro['CantidadTarjetaUno'] = $this->input->post('cantidadTarjeta1');
		$parametro['FolioTarjetaUno'] =$this->input->post('folioT1');
		$parametro['TipoPagoDos'] = $this->input->post('Tpago2');
		$parametro['CantidadTarjetaDos'] = $this->input->post('cantidadTarjeta2');
		$parametro['FolioTarjetaDos'] = $this->input->post('folioT2');
		$parametro['UsuarioPropina'] =$this->input->post('propina');
		$parametro['TipoPagoPropina'] = $this->input->post('opcion');
		$parametro['PropinaVenta'] = $this->input->post('cantidadPor');
		$parametro['CTarjetaCredPro'] = $this->input->post('TCpropina');
		$parametro['FolioCredPropina'] = $this->input->post('TCfolio');
		$parametro['CTarjetaDebPro'] = $this->input->post('TDpropina');
		$parametro['FolioDebPropina'] = $this->input->post('TDfolio');
		$parametro['TotalPropina'] = $this->input->post('TPropina');
		$parametro['UsuarioLog'] = $this->input->post('Vendedor');
		$parametro['folio'] = $this->input->post('folio-autoincrementable-venta');
		$datos = $this->input->post('listaDeproductosVendida');
		$folioAutoIncrementable = $this->input->post('folio-autoincrementable-venta');		
		
		$arr = $this->input->post();
		/*var_dump($arr);*/
		//sacando la lista de productos
		$productosVendidos = $this->input->post('listaFinal');
		$serviciosVendidos = $this->input->post('serviciosFinal');
		$promosVendidas = $this->input->post('promocionesFinal');
		$promosInsVendidas = $this->input->post('promocionesInsFinal');


		if($productosVendidos != ''){
			$productosDetalle = $this->arrayDatos($productosVendidos);
			/*var_dump($productosDetalle);*/
		}
		else {
			$productosDetalle = null;
		}
		if($serviciosVendidos != ''){
			$serviciosDetalle = $this->arrayDatos($serviciosVendidos);
		}
		else{
			$serviciosDetalle = null;
		}
		if($promosVendidas != '' ){
			$promosDetalle = $this->arrayDatos($promosVendidas);
			/*var_dump($promosDetalle);*/
		}
		else{
			$promosDetalle = null;
		}
		if($promosInsVendidas != '' ){
			/*var_dump($promosInsVendidas);*/
			$promosInsDetalle = $this->arrayDatos($promosInsVendidas);
			/*echo "Detalle ins";
			var_dump($promosInsDetalle);*/
		}
		else{
			$promosInsDetalle = null;
		}

		$res = $this->cajaC_models->guardar($parametro,$productosDetalle,$fecha,$hora,$serviciosDetalle,$promosDetalle,$promosInsDetalle,$folioAutoIncrementable);


		/*if($res == true){*/
			$idVenta=$parametro ['IdVentas'];
			echo "<script>alert('Venta exitosa, Datos guardados correctamente');
			window.location.href='".base_url()."caja/Cosmetologo/CajaC/mostrarTicket/$idVenta';
			</script>";

		/*}*/
//}
}
	
	public function arrayDatos($datosarray){
		$arrayProductos = explode(',//,,',$datosarray);
		for($i=0; $i<sizeof($arrayProductos); $i++)
  			{
		      //saco el valor de cada elemento
			  $productosDetalle[$i] = explode('*',$arrayProductos[$i]);
		    }

		    return $productosDetalle;
	}
	public function enviaDatos(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$nombre = $this->uri->segment(6);
		$result = $this->cajaC_models->BuscaCliente($id);
		if(count($result)>0){
				foreach ($result as $row){
				$IdClientes = $row->IdClientes;
				$NombreCliente=$row->NombreCliente;
				} 
					$data = array(
						'IdClientes' => $IdClientes,
						'NombreCliente' => $NombreCliente,
					);
				}

    	$data['Franquicias'] = $this->cajaC_models->BuscarFranquicia();
    /*	var_dump($this->session->userdata('IdUsuarios'));*/
    	$data['datosFranquiciaTicket'] = $this->cajaC_models->BuscarDatosFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
        $this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo'); 

		$data['cabinas']=$this->cabinas(); 
		$data['ReUsuario']=$this->cajaC_models->BuscarUsuario();
		$data['Usuarios']=$this->cajaC_models->BuscarUsuarios();
		$data['ReUsuarioProp']=$this->cajaC_models->BuscarUsuarioC();
		$data['Zona']=$this->cajaC_models->BuscarZona();
		$data['Exi']=$this->cajaC_models->BuscarPagos();
		$data['Contra']=$this->cajaC_models->BuscarContra();
	    foreach ($data['Zona'] as $i => $Zona) 
		$this->load->view('caja/Franquiciatario/caja_views',$data);
		$this->load->view('layout/footer');
		}
	}


	public function clientes(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		if(isset($_GET['term'])){
			$result = $this->cajaC_models->BuscarCliente($_GET['term']);
			if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
						'label' => $row->NombreCliente,
						'id'=> $row->IdClientes,
					);
					echo json_encode($arr_result);
				}
			}else {
				  echo "<script>alert('No se encontrarón los datos solicitados');
				  window.location.href='".base_url()."clientes/cosmetologo/clienteC';
				  </script>";
			}
		}}


	public function productos(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		if(isset($_GET['term'])){
			$result = $this->cajaC_models->BuscarProducto($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombreProducto,
					'precios' => $row->PrecioVenta,
					'id' => $row->IdProductosFranquicias,
					'PiezasT'=>$row->PiezasTotales,
				);
					echo json_encode($arr_result);
				}
			}
	}
}

	public function servicios(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		if(isset($_GET['term'])){
			$result = $this->cajaC_models->BuscarServicio($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombreServicio,
					'precios' => $row->PreciosServicio,
					'id' => $row->IdServiciosFranquicias,
				);
					echo json_encode($arr_result);
				}
			}
	}
}

		public function serviciosG(){
			if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		if(isset($_GET['term'])){
			$servicioG = $this->cajaC_models->BuscarServicioG($_GET['term']);
				if(count($servicioG)>0){
				foreach ($servicioG as $row) 
					$arr_servicioG[] = array(
					'label' => $row->NombreServicio,
					'precios' => $row->PreciosServicio,
					'id' => $row->Codigo_Servicios,
				);
					echo json_encode($arr_servicioG);
				}

			}
	}
}
//Promociones Institucionales
		public function promocionesIn(){
			if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		if(isset($_GET['term'])){
			$result = $this->cajaC_models->BuscarPromociones($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombrePromocion,
					'id' => $row->IdPromociones,
					'precio' => $row->Precio,
					'sesiones' => $row->FolioPromocion,
				);
					echo json_encode($arr_result);
				}
			}
	}
}
		//Promociones Franquicias
		public function promocionesF(){
			if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		if(isset($_GET['term'])){
			$result = $this->cajaC_models->BuscarPromocion($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombrePromocion,
					'id' => $row->IdPromociones,
					'precios' => $row->Precio,
					'sesiones' => $row->FolioPromocion,
				);
					echo json_encode($arr_result);
				}
			}
	}
}
	

	public function certificados(){
		if(isset($_GET['term'])){
			$result = $this->cajaC_models->BuscarCertificado($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombreServicio,
					'precios' => $row->PreciosServicio,
					'id' => $row->IdServiciosFranquicias,
				);
					echo json_encode($arr_result);
				}
			}
	}



	public function foliosVenta(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$var = $this->cajaC_models->foliosVenta();
		/*$var = $this->input->post('name');*/
		echo json_encode( $var);
		}
	}
		//funcion para agregar un nuevo cliente que nos muestra la vista con todos sus formularios correspondientes
	public function mostrarTicket()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);

    	$result = $this->cajaC_models->obtenerenlaceV($id);

		if($result != FALSE){
			foreach ($result->result() as $fila) {
				$folio = $fila->folio;
				$FechaVenta = $fila->FechaVenta;
				$FolioVenta = $fila->FolioVenta;
				$IdVentas = $fila->IdVentas;
				$TotalVentaGeneral = $fila->TotalVentaGeneral;
				$ClienteVenta = $fila->ClienteVenta;
				$Subtotal=$fila->Subtotal;
				$Iva=$fila->Iva;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$AbonoVenta=$fila->AbonoVenta;
				$VendedorUsuario=$fila->VendedorUsuario;
				$TotalPropina=$fila->TotalPropina;
				$UsuarioPropina=$fila->UsuarioPropina;
				$Comentario=$fila->Comentario;
				$Contado=$fila->Contado;
				$CantidadTarjetaUno=$fila->CantidadTarjetaUno;
				$CantidadTarjetaDos=$fila->CantidadTarjetaDos;	
				

			}
			$data = array(
				'folio' => $folio,
				'FechaVenta' => $FechaVenta,
				'FolioVenta' => $FolioVenta,
				'IdVentas' => $IdVentas,
				'TotalVentaGeneral' => $TotalVentaGeneral,
				'ClienteVenta' => $ClienteVenta,
				'Subtotal' => $Subtotal,
				'Iva' => $Iva,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,
				'VendedorUsuario' => $VendedorUsuario,
				'TotalPropina' => $TotalPropina,
				'UsuarioPropina' => $UsuarioPropina,
				'Comentario' => $Comentario,
				'Contado' => $Contado,
				'CantidadTarjetaUno' => $CantidadTarjetaUno,
				'CantidadTarjetaDos' => $CantidadTarjetaDos,
					
			);

		}else{
				$data ='';
				return FALSE;	
		}
		$data['Franquicias']=$this->cajaC_models->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from(' ventas_has_productosfranquicias');
		$this->db->join('productosfranquicias','productosfranquicias_IdProductosFranquicias = IdProductosFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales = 	IdProductosGenerales','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta1']=$this->db->get()->result();

//........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
	    $this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
		
		$this->db->where('IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta2']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta3']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from('ventas_has_promociones');
		$this->db->join('promociones','IdPromociones = promociones_IdPromociones','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias', $i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta4']=$this->db->get()->result();
//..........................................................
		$this->db->select('*');
		$this->db->from('franquicias_has_leyendasgenerales');
		$this->db->join('leyendasgenerales','LeyendasGenerales_IdLeyendas = IdLeyendas','inner');
		$this->db->where('franquicias_has_leyendasgenerales.Franquicias_IdFranquicias', $i);
		$this->db->order_by("FechaCreacionL","desc");
		$data['leyenda']=$this->db->get()->result();
		
		$data['ReUsuario']=$this->cajaC_models->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->cajaC_models->BuscarDatosFranquicia();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('caja/Cosmetologo/ticket_view', $data);
		$this->load->view('layout/footer');
		}
	}

public function Ticketpdf(){
	
	
     if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id=$this->uri->segment(5);
		$result = $this->cajaC_models->obtenerenlaceV($id);

		if($result != FALSE){
			foreach ($result->result() as $fila) {
				$folio = $fila->folio;
				$FechaVenta = $fila->FechaVenta;
				$IdVentas = $fila->IdVentas;
				$TotalVentaGeneral = $fila->TotalVentaGeneral;
				$ClienteVenta = $fila->ClienteVenta;
				$Subtotal=$fila->Subtotal;
				$Iva=$fila->Iva;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$AbonoVenta=$fila->AbonoVenta;
				$VendedorUsuario=$fila->VendedorUsuario;
				$TotalPropina=$fila->TotalPropina;
				$UsuarioPropina=$fila->UsuarioPropina;
				$Comentario=$fila->Comentario;
				$Contado=$fila->Contado;
				$TipoPagoUno=$fila->CantidadTarjetaUno;
				$TipoPagoDos=$fila->CantidadTarjetaDos;
				$CantidadTarjetaUno=$fila->CantidadTarjetaUno;
				$CantidadTarjetaDos=$fila->CantidadTarjetaDos;
				$franquicias_IdFranquicias=$fila->franquicias_IdFranquicias;
				
				

			}
			$data = array(
				'folio' => $folio,
				'FechaVenta' => $FechaVenta,
				'IdVentas' => $IdVentas,
				'TotalVentaGeneral' => $TotalVentaGeneral,
				'ClienteVenta' => $ClienteVenta,
				'Subtotal' => $Subtotal,
				'Iva' => $Iva,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,
				'VendedorUsuario' => $VendedorUsuario,
				'TotalPropina' => $TotalPropina,
				'UsuarioPropina' => $UsuarioPropina,
				'Comentario' => $Comentario,
				'Contado' => $Contado,
				'TipoPagoUno' => $TipoPagoUno,
				'CantidadTarjetaUno' => $CantidadTarjetaUno,
				'TipoPagoDos' => $TipoPagoDos,
				'CantidadTarjetaDos' => $CantidadTarjetaDos,
				'franquicias_IdFranquicias' => $franquicias_IdFranquicias,
					
			);

		}else{
				$data ='';
				return FALSE;	
		}

		$data['Franquicias']=$this->cajaC_models->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from(' ventas_has_productosfranquicias');
		$this->db->join('productosfranquicias','productosfranquicias_IdProductosFranquicias = IdProductosFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales = 	IdProductosGenerales','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta1']=$this->db->get()->result();

//........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
	    $this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
		
		$this->db->where('IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta2']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta3']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from('ventas_has_promociones');
		$this->db->join('promociones','IdPromociones = promociones_IdPromociones','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias', $i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta4']=$this->db->get()->result();

		
		$this->db->select('*');
		$this->db->from('franquicias_has_leyendasgenerales');
		$this->db->join('leyendasgenerales','LeyendasGenerales_IdLeyendas = IdLeyendas','inner');
		$this->db->where('franquicias_has_leyendasgenerales.Franquicias_IdFranquicias', $i);
		$this->db->order_by("FechaCreacionL","desc");
		$data['leyenda']=$this->db->get()->result();


		$data['ReUsuario']=$this->cajaC_models->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->cajaC_models->BuscarDatosFranquicia();	
		
		
		$data['letras'] =CifrasEnLetras::convertirEurosEnLetras($AbonoVenta);
			
		$html=($this->load->view('caja/Cosmetologo/generador',$data, true));
    	$this->mydompdf->load_html($html,'UTF-8');	
    	$this->mydompdf->set_paper(array(0,0,250,1200)); 
    	$this->mydompdf->render();	
   		$this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); 
   		$this->mydompdf->set_base_path('assets/dist/css/styles.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("Ticket de venta_".$folio.".pdf");
 }
}
  


	}




