<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//Este controlador manda a traer las acciones para que el modulo pueda realizar sus funciones(Franquiciatario)
class CajaF extends CI_Controller{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct(){
		parent::__construct();		
		$this->load->model('caja/Franquiciatario/cajaF_models');
		$this->load->library(array('session','form_validation'));
		$this->load->library('Mydompdf');
		$this->load->library('CifrasEnLetras');
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista caja_views
	public function index(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {		
			$data['Franquicias'] = $this->cajaF_models->BuscarFranquicia();
			/*	var_dump($this->session->userdata('IdUsuarios'));*/
			$data['datosFranquiciaTicket'] = $this->cajaF_models->BuscarDatosFranquicia();
			foreach ($data['Franquicias'] as $i => $Franquicias) 
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$data['cabinas']=$this->cabinas(); 
			$data['ReCabina']=$this->cajaF_models->BuscarCabina();
			$data['Usuarios']=$this->cajaF_models->BuscarUsuarios();
			$data['ReUsuario']=$this->cajaF_models->BuscarUsuario();
			$data['Zona']=$this->cajaF_models->BuscarZona();
			$data['Exi']=$this->cajaF_models->BuscarPagos();
			$data['Contra']=$this->cajaF_models->BuscarContra();
			foreach ($data['Zona'] as $i => $Zona) 
			$this->load->view('caja/Franquiciatario/caja_views',$data);
			$this->load->view('layout/footer');
		}
	}

	public function cabinas() {
		$cabinasExistentes=$this->cajaF_models->BuscarCabina();
		$i=0;
		foreach($cabinasExistentes as $i => $cabina) {
			$colores[$i]['id'] = $i;
			$colores[$i]['nombre'] = $cabina;
			switch($cabina)
			{
				case 'FACIAL':
					$colores[$i]['color'] = 'facial';
					break;
				case 'FACIAL 2':
					$colores[$i]['color'] = 'facial-2';
					break;
				case 'CORPORAL':
					$colores[$i]['color'] = 'corporal';
					break;
				case 'CORPORAL 2':
					$colores[$i]['color'] = 'corporal-2';
					break;
				case 'RELAJANTES/MASAJES':
					$colores[$i]['color'] = 'relajantes-masajes';
					break;
				case 'CAVITACION':
					$colores[$i]['color'] = 'cavitacion';
					break;
				case 'IPL/E-LIGHT':
					$colores[$i]['color'] = 'ipl-e-light';
					break;
				case 'PESTAÑAS':
					$colores[$i]['color'] = 'pestañas';
					break;
				case 'SAUNA':
					$colores[$i]['color'] = 'sauna';
					break;
				case 'SAUNA 2':
					$colores[$i]['color'] = 'sauna-2';
					break;
				case 'ADICIONAL':
					$colores[$i]['color'] = 'adicional';
					break;
				case 'CAPSULA INFRAROJA':
					$colores[$i]['color'] = 'capsula-infraroja';
					break;
				case 'UÑAS 1':
					$colores[$i]['color'] = 'uñas-1';
					break;
				case 'UÑAS 2':
					$colores[$i]['color'] = 'uñas-2';
					break;
				case 'UÑAS 3':
					$colores[$i]['color'] = 'uñas-3';
					break;
				default;
				$colores[$i]['color'] = 'blanco';
				break;
			}
			
			$i++;
			
		}
		
		return ($colores);
	}
	function limpia_espacios($cadena){
    $cadena = str_replace(' ', '', $cadena);
    return $cadena;
    }
	public function guardarCliente(){
		$data['Franquicias'] = $this->cajaF_models->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
		$campos = array(
							'NombreCliente' => $_POST['nombre'], 
							'CelularCliente' => $_POST['telefono'],
							'CorreoCliente' => $_POST['correoE'], 
							'Franquicias_IdFranquicias' => $i
						);
			$this->cajaF_models->guardarCliente($campos);
	}
	public function AgregarVenta(){
		/*Lineas de encabezado no guardan venta cuando estan activas*/
		// if($this->session->userdata('Rol_IdRol')==FALSE || 
		// 	$this->session->userdata('Rol_IdRol') == '1'|| 
		// 	$this->session->userdata('Rol_IdRol') == '3')
		// {
		// 	redirect(base_url().'acceso/acceso');
		// } else {
		$buscarFolio=$this->cajaF_models->buscarFolio();
		$folioVenta=$buscarFolio+1;
		$folios=array(
			'FolioVenta'=>$folioVenta,
			'franquicias_IdFranquicias'=>$this->cajaF_models->BuscarIdFranquicia(),
			'IdUsuariosLog'=>$this->session->userdata('IdUsuarios'),
		);
		$insertaFolio=$this->cajaF_models->insertaFolio($folios);
		if($insertaFolio!=FALSE){
			$parametro ['FolioVenta']=$folioVenta;
		}
		$fecha=$this->input->post('fecha');
 		$hora=$this->input->post('hora');
 	  	$nuevaFecha = $this->limpia_espacios($fecha);
 	  	$nuevaHora = $this->limpia_espacios($hora);

		$parametro ['IdVentas']= $this->input->post('franquicia').$nuevaFecha.$nuevaHora;
		$parametro['franquicias_IdFranquicias'] = $this->input->post('franquicia');
		$parametro['ClienteVenta'] = $this->input->post('title');
		$parametro['IdCliente'] = $this->input->post('idc');
		$parametro['TotalVenta'] = $this->input->post('totaltotal1');
		$parametro['VendedorUsuario'] = $this->input->post('Vendedor');
		$parametro['Comentario'] = $this->input->post('comentario');
		$parametro['FechaVenta'] = $this->input->post('fecha')." ".$parametro['hora']= $this->input->post('hora');
		$parametro['Subtotal'] = $this->input->post('Sub1');
		$parametro['Iva'] = $this->input->post('IVA');
		$parametro['TotalVentaGeneral'] = $this->input->post('Totalgen');
		$parametro['AbonoVenta'] = $this->input->post('Abono');
		$parametro['AdeudoVenta'] = $this->input->post('Adeudo');
		$parametro['Contado'] = $this->input->post('ContadoD');
		$parametro['TipoPagoUno'] = $this->input->post('Tpago1');
		$parametro['CantidadTarjetaUno'] = $this->input->post('cantidadTarjeta1');
		$parametro['FolioTarjetaUno'] =$this->input->post('folioT1');
		$parametro['TipoPagoDos'] = $this->input->post('Tpago2');
		$parametro['CantidadTarjetaDos'] = $this->input->post('cantidadTarjeta2');
		$parametro['FolioTarjetaDos'] = $this->input->post('folioT2');
		$parametro['UsuarioPropina'] =$this->input->post('propina');
		$parametro['TipoPagoPropina'] = $this->input->post('opcion');
		$parametro['PropinaVenta'] = $this->input->post('cantidadPor');
		$parametro['CTarjetaCredPro'] = $this->input->post('TCpropina');
		$parametro['FolioCredPropina'] = $this->input->post('TCfolio');
		$parametro['CTarjetaDebPro'] = $this->input->post('TDpropina');
		$parametro['FolioDebPropina'] = $this->input->post('TDfolio');
		$parametro['TotalPropina'] = $this->input->post('TPropina');
		$parametro['UsuarioLog'] = $this->input->post('UsuarioLog');
		$parametro['folio'] = $this->input->post('folio-autoincrementable-venta');
		$datos = $this->input->post('listaDeproductosVendida');
				
		$arr = $this->input->post();
		$folioAutoIncrementable = $this->input->post('folio-autoincrementable-venta');
		/*var_dump($arr);*/
		//sacando la lista de productos
		$productosVendidos = $this->input->post('listaFinal');
		$serviciosVendidos = $this->input->post('serviciosFinal');
		$promosVendidas = $this->input->post('promocionesFinal');
		$promosInsVendidas = $this->input->post('promocionesInsFinal');


		if($productosVendidos != ''){
			$productosDetalle = $this->arrayDatos($productosVendidos);
			/*var_dump($productosDetalle);*/
		}
		else {
			$productosDetalle = null;
		}
		if($serviciosVendidos != ''){
			$serviciosDetalle = $this->arrayDatos($serviciosVendidos);
		}
		else{
			$serviciosDetalle = null;
		}
		if($promosVendidas != '' ){
			$promosDetalle = $this->arrayDatos($promosVendidas);
			/*var_dump($promosDetalle);*/
		}
		else{
			$promosDetalle = null;
		}
		if($promosInsVendidas != '' ){
			/*var_dump($promosInsVendidas);*/
			$promosInsDetalle = $this->arrayDatos($promosInsVendidas);
			/*echo "Detalle ins";
			var_dump($promosInsDetalle);*/
		}
		else{
			$promosInsDetalle = null;
		}
		
		$res = $this->cajaF_models->guardar($parametro,$productosDetalle,$fecha,$hora,$serviciosDetalle,$promosDetalle,$promosInsDetalle,$folioAutoIncrementable);


		/*if($res == true){*/
 		$idVenta=$parametro ['IdVentas'];
		echo "<script>alert('Venta exitosa, Datos guardados correctamente');
		window.location.href='".base_url()."caja/Franquiciatario/CajaF/mostrarTicket/$idVenta';
		</script>";
			// echo "<script>alert('Venta exitosa, Datos guardados correctamente');</script>";
			// redirect("caja/Franquiciatario/CajaF/mostrarTicket/$idVenta",'refresh');


			  // redirect('pagos/franquiciatario/PagosF','refresh');
		/*}*/
//}
}
	
	public function arrayDatos($datosarray){
		
		$arrayProductos = explode(',//,,',$datosarray);

		for($i=0; $i<sizeof($arrayProductos); $i++)
  			{
		      //saco el valor de cada elemento

			  $productosDetalle[$i] = explode('*',$arrayProductos[$i]);
		    }

		    return $productosDetalle;
	}


	public function enviaDatos(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$nombre = $this->uri->segment(6);
		$result = $this->cajaF_models->BuscaCliente($id);
		if(count($result)>0){
				foreach ($result as $row){
				$IdClientes = $row->IdClientes;
				$NombreCliente=$row->NombreCliente;
				} 
					$data = array(
						'IdClientes' => $IdClientes,
						'NombreCliente' => $NombreCliente,
					);
				}
				else{echo "no entra";}
		$data['Franquicias'] = $this->cajaF_models->BuscarFranquicia();
    /*	var_dump($this->session->userdata('IdUsuarios'));*/
    	$data['datosFranquiciaTicket'] = $this->cajaF_models->BuscarDatosFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
        $this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia'); 

		$data['cabinas']=$this->cabinas(); 
		$data['ReCabina']=$this->cajaF_models->BuscarCabina();
		$data['Usuarios']=$this->cajaF_models->BuscarUsuarios();
		$data['ReUsuario']=$this->cajaF_models->BuscarUsuario();
		$data['Zona']=$this->cajaF_models->BuscarZona();
		$data['Exi']=$this->cajaF_models->BuscarPagos();
		$data['Contra']=$this->cajaF_models->BuscarContra();
	    foreach ($data['Zona'] as $i => $Zona) 
		$this->load->view('caja/Franquiciatario/caja_views',$data); 
		$this->load->view('layout/footer');
	 }

	}
	public function buscarCliente(){
		$nombre=$_POST['nombre'];
		$this->cajaF_models->BuscarNombreCliente($nombre);
	}

	public function clientes(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		if(isset($_GET['term'])){
			$result = $this->cajaF_models->BuscarCliente($_GET['term']);
			if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
						'label' => $row->NombreCliente,
						'id'=> $row->IdClientes,
					);
					echo json_encode($arr_result);
				}
			}else {
				echo "<script>alert('No se encontraron los datos solicitados');
				window.location.href='".base_url()."clientes/franquiciatario/clienteF';
				</script>";
				  // echo "<script>alert('No se encontrarón los datos solicitados');</script>";
            // redirect('clientes/franquiciatario/clienteF','refresh');
			}
		}
	}


	public function productos(){
		if(isset($_GET['term'])){
			$result = $this->cajaF_models->BuscarProducto($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombreProducto,
					'precios' => $row->PrecioVenta,
					'id' => $row->IdProductosFranquicias,
					'PiezasT'=>$row->PiezasTotales,
				);
					echo json_encode($arr_result);
				}
			}
	}

	public function servAgendadoSelect($Id){
		$res = $this->cajaF_models->BuscarServicioAGF($Id);
		$res1 = $this->cajaF_models->BuscarServicioGAG($Id);
		$res2 = $this->cajaF_models->BuscarPromocionesAG($Id);

		if ($res) {
			$NombreServicio=$res->NombreServicio;
			$PreciosServicio=$res->PreciosServicio;
			$idServicioAG=$Id;
			$identificador='SA';
		}if ($res1) {
			$NombreServicio=$res1->NombreServicio;
			$PreciosServicio=$res1->PreciosServicio;
			$idServicioAG=$Id;
			$identificador='SG';
		} else if ($res2){
			$NombreServicio=$res2->NombrePromocion;
			$PreciosServicio=$res2->Precio;
			$idServicioAG=$Id;
			if ($res2->tipopromocion_IdTipoPromocion===2 || $res2->tipopromocion_IdTipoPromocion===4) {
				$identificador='PF';
			} else {
				$identificador='PG';
			}
			
		}

		$servicioAG[] = array(
			'label' => $NombreServicio,
			'precio' => $PreciosServicio,
			'sesiones' => 1,
			'identificador' => $identificador,
			'id' => $Id,
		);

		echo json_encode($servicioAG);
	}

	public function serviciosAgendados($idClient){
		$response = $this->cajaF_models->ServiciosAgendados($idClient);
		/*$promocionesI = $this->cajaF_models->promocionesI();
		$promocionesF= $this->cajaF_models->promocionesF();

		$servicioAG=array();
		//$arr_promocionesI=array();
		//$arr_promocionesF=array();*/
		//$servicioAG=array();
		if (count($response)>0) {
			foreach ($response as $row) {
				//echo count($response);
				//echo "<br><br>";
				//print  json_encode($row[0]);
				//print  json_encode($row);
				//exit();
				//echo $row[0]['ServiciosFranquicias_IdServiciosFranquicias'];
				$idServicio = $row->ServiciosFranquicias_IdServiciosFranquicias;//json_encode();
				
				$res = $this->cajaF_models->BuscarServicioAGF($idServicio);
				$res1 = $this->cajaF_models->BuscarServicioGAG($idServicio);
				$res2 = $this->cajaF_models->BuscarPromocionesAG($row->Promociones_IdPromociones);
				
				$NombreServicio="";
				$PreciosServicio="";
				$idServicioAG="";
				$identificador="";
				if ($res) {
					$NombreServicio=$res->NombreServicio;
					$PreciosServicio=$res->PreciosServicio;
					$idServicioAG=$idServicio;
					$identificador='SA';
				}if ($res1) {
					$NombreServicio=$res1->NombreServicio;
					$PreciosServicio=$res1->PreciosServicio;
					$idServicioAG=$idServicio;
					$identificador='SG';
				} else if ($res2){
					$NombreServicio=$res2->NombrePromocion;
					$PreciosServicio=$res2->Precio;
					$idServicioAG=$row->Promociones_IdPromociones;
					if ($res2->tipopromocion_IdTipoPromocion===2 || $res2->tipopromocion_IdTipoPromocion===4) {
						$identificador='PF';
					} else {
						$identificador='PG';
					}					
				}			
	
				$servicioAG[] = array(
					'title' => $NombreServicio,
					'precio' => $PreciosServicio,
					'sesiones' => '',
					'identificador' => $identificador,
					'id' => $idServicioAG.'$'.$row->IdAgenda,
				);
			}
		} else {
			$servicioAG=array();
		}

		echo json_encode($servicioAG);
	}

	public function servicios(){
		if(isset($_GET['term'])){
			$result = $this->cajaF_models->BuscarServicio($_GET['term']);
			$servicioG = $this->cajaF_models->BuscarServicioG($_GET['term']);
			$promocionesI = $this->cajaF_models->BuscarPromocionesI($_GET['term']);
			$promocionesF = $this->cajaF_models->BuscarPromocionF($_GET['term']);

			/*if(count($response)>0){
				foreach ($response as $row) {
					$res = $this->cajaF_models->BuscarServicioAGF($row->ServiciosFranquicias_IdServiciosFranquicias);
					$res1 = $this->cajaF_models->BuscarServicioGAG($row->ServiciosFranquicias_IdServiciosFranquicias);
					$res2 = $this->cajaF_models->BuscarPromocionesAG($row->Promociones_IdPromociones);

					if ($res>0) {
						$NombreServicio=$res->NombreServicio;
						$PreciosServicio=$res->PreciosServicio;
						$idServicioAG=$row->ServiciosFranquicias_IdServiciosFranquicias;
					}if ($res1>0) {
						$NombreServicio=$res1->NombreServicio;
						$PreciosServicio=$res1->PreciosServicio;
						$idServicioAG=$row->ServiciosFranquicias_IdServiciosFranquicias;
					} else if ($res2>0){
						$NombreServicio=$res2->NombrePromocion;
						$PreciosServicio=$res2->Precio;
						$idServicioAG=$row->Promociones_IdPromociones;
					}					

					$servicioAG[] = array(
						'label' => $NombreServicio."SC",
						'precio' => $PreciosServicio,
						'sesiones' => '',
						'identificador' => 'SC',
						'id' => $idServicioAG,
					);
				}
			}else{
				// $servicioA[] ='';
				$servicioAG[] = array();
			}*/
			
			if(count($result)>0){
				foreach ($result as $row) {
					$servicioA[] = array(
						'label' => $row->NombreServicio,
						'precio' => $row->PreciosServicio,
						'sesiones' => '',
						'identificador' => 'SA',
						'id' => $row->IdServiciosFranquicias.'$',
					);
				}
			}else{
				// $servicioA[] ='';
				$servicioA[] = array();
			}

			if(count($servicioG)>0){
				foreach ($servicioG as $row) {
					$arr_servicioG[] = array(
					'label' => $row->NombreServicio,
					'precio' => $row->PreciosServicio,
					'sesiones' => '',
					'identificador' => 'SG',
					'id' => $row->Codigo_Servicios.'$',
					);
				}
			}else{
				// $arr_servicioG[] ='';
				$arr_servicioG[] = array();
			}

			if(count($promocionesI)>0){
				foreach ($promocionesI as $row) {
					$arr_promocionesI[] = array(
					'label' => $row->NombrePromocion,
					'precio' => $row->Precio,
					'sesiones' => $row->FolioPromocion,
					'identificador' => 'PI',
					'id' => $row->IdPromociones.'$',
					);
					
				}
			}else{ 
				// $arr_promocionesI[] ='';
				$arr_promocionesI[] = array();
			}

			if(count($promocionesF)>0){
				foreach ($promocionesF as $row) {
					$arr_promocionesF[] = array(
					'label' => $row->NombrePromocion,
					'precio' => $row->Precio,
					'sesiones' => $row->FolioPromocion,
					'identificador' => 'PF',
					'id' => $row->IdPromociones.'$',
					);
				}
			}else{ 
				// $arr_promocionesF[] ='';
				$arr_promocionesF[] = array();
			}
			// $resultado = $servicioA + $arr_servicioG;
			$resultado=array_merge($servicioA, $arr_servicioG, $arr_promocionesI, $arr_promocionesF);
			// $resultado2 = $resultado + $arr_promocionesI;
			$resultado2 = $servicioA + $arr_promocionesI;
			echo json_encode($resultado);			
		}
	}
	
	public function serviciosG(){
		if(isset($_GET['term'])){
			$servicioG = $this->cajaF_models->BuscarServicioG($_GET['term']);
				if(count($servicioG)>0){
				foreach ($servicioG as $row) 
					$arr_servicioG[] = array(
					'label' => $row->NombreServicio,
					'precios' => $row->PreciosServicio,
					'id' => $row->Codigo_Servicios,
				);
					echo json_encode($arr_servicioG);
				}
			}
		
}
//Promociones Institucionales
		public function promocionesIn(){
		if(isset($_GET['term'])){
			$result = $this->cajaF_models->BuscarPromociones($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombrePromocion,
					'precio' => $row->Precio,
					'sesiones' => $row->FolioPromocion,
					'id' => $row->IdPromociones,
				);
					echo json_encode($arr_result);
				}
			}
	}
		//Promociones Franquicias
		public function promocionesF(){
		if(isset($_GET['term'])){
			$result = $this->cajaF_models->BuscarPromocion($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombrePromocion,
					'precios' => $row->Precio,
					'sesiones' => $row->FolioPromocion,
					'id' => $row->IdPromociones,
				);
					echo json_encode($arr_result);
				}
			}
	}
	

	public function certificados(){
		if(isset($_GET['term'])){
			$result = $this->cajaF_models->BuscarCertificado($_GET['term']);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'label' => $row->NombreServicio,
					'precios' => $row->PreciosServicio,
					'id' => $row->IdServiciosFranquicias,
				);
					echo json_encode($arr_result);
				}
			}
	}
	public function buscarAdeudos(){
		$id=$_POST['id'];
		$result = $this->cajaF_models->buscarAdeudos($id);
		echo json_encode($result);
	}
	public function todosAdeudos(){
		$id=$_POST['id'];
		$productos = $this->cajaF_models->buscarAdeudoProductos($id);
		$serviciosA = $this->cajaF_models->buscarAdeudoServiciosA($id);
		$serviciosG = $this->cajaF_models->buscarAdeudoServiciosG($id);
		$promociones = $this->cajaF_models->buscarAdeudoPromociones($id);
		if($productos!=FALSE)
		{
			$prod=$productos;
		}else{
			$prod[]='';
		}
		if($serviciosA!=FALSE)
		{
			$serv=$serviciosA;
		}else{
			$serv[]='';
		}
		if($serviciosG!=FALSE)
		{
			$serG=$serviciosG;
		}else{
			$serG[]='';
		}
		if($promociones!=FALSE)
		{
			$promo=$promociones;
		}else{
			$promo[]='';
		}

		$array_final=array_merge($prod, $serv, $serG, $promo);
		
		echo json_encode($array_final);
		// echo $id;
	}
	public function foliosVenta(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {

		$var = $this->cajaF_models->foliosVenta();
		/*$var = $this->input->post('name');*/
		echo json_encode( $var);
	}
	}

public function mostrarTicket()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);

    	$result = $this->cajaF_models->obtenerenlaceV($id);

		if($result != FALSE){
			foreach ($result->result() as $fila) {
				$folio = $fila->folio;
				$FechaVenta = $fila->FechaVenta;
				$FolioVenta = $fila->FolioVenta;
				$IdVentas = $fila->IdVentas;
				$TotalVentaGeneral = $fila->TotalVentaGeneral;
				$ClienteVenta = $fila->ClienteVenta;
				$Subtotal=$fila->Subtotal;
				$Iva=$fila->Iva;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$AbonoVenta=$fila->AbonoVenta;
				$VendedorUsuario=$fila->VendedorUsuario;
				$TotalPropina=$fila->TotalPropina;
				$UsuarioPropina=$fila->UsuarioPropina;
				$Comentario=$fila->Comentario;
				$Contado=$fila->Contado;
				$CantidadTarjetaUno=$fila->CantidadTarjetaUno;
				$CantidadTarjetaDos=$fila->CantidadTarjetaDos;			

			}
			$data = array(
				'folio' => $folio,
				'FechaVenta' => $FechaVenta,
				'FolioVenta' => $FolioVenta,
				'IdVentas' => $IdVentas,
				'TotalVentaGeneral' => $TotalVentaGeneral,
				'ClienteVenta' => $ClienteVenta,
				'Subtotal' => $Subtotal,
				'Iva' => $Iva,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,
				'VendedorUsuario' => $VendedorUsuario,
				'TotalPropina' => $TotalPropina,
				'UsuarioPropina' => $UsuarioPropina,
				'Comentario' => $Comentario,
				'Contado' => $Contado,
				'CantidadTarjetaUno' => $CantidadTarjetaUno,
				'CantidadTarjetaDos' => $CantidadTarjetaDos,
					
			);

		}else{
				$data ='';
				return FALSE;	
		}
		$data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from(' ventas_has_productosfranquicias');
		$this->db->join('productosfranquicias','productosfranquicias_IdProductosFranquicias = IdProductosFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales = 	IdProductosGenerales','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta1']=$this->db->get()->result();

//........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
	    $this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
		
		$this->db->where('IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta2']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta3']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from('ventas_has_promociones');
		$this->db->join('promociones','IdPromociones = promociones_IdPromociones','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias', $i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta4']=$this->db->get()->result();
//............................................................
		$this->db->select('*');
		$this->db->from('franquicias_has_leyendasgenerales');
		$this->db->join('leyendasgenerales','LeyendasGenerales_IdLeyendas = IdLeyendas','inner');
		$this->db->where('franquicias_has_leyendasgenerales.Franquicias_IdFranquicias', $i);
		$this->db->order_by("FechaCreacionL","desc");
		$data['leyenda']=$this->db->get()->result();

		$data['ReUsuario']=$this->cajaF_models->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->cajaF_models->BuscarDatosFranquicia();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('caja/Franquiciatario/ticket_view', $data);
		$this->load->view('layout/footer');
		}
	}

public function Ticketpdf(){
	
	
     if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id=$this->uri->segment(5);
		$result = $this->cajaF_models->obtenerenlaceV($id);

		if($result != FALSE){
			foreach ($result->result() as $fila) {
				$folio = $fila->folio;
				$FechaVenta = $fila->FechaVenta;
				$FolioVenta = $fila->FolioVenta;
				$IdVentas = $fila->IdVentas;
				$TotalVentaGeneral = $fila->TotalVentaGeneral;
				$ClienteVenta = $fila->ClienteVenta;
				$Subtotal=$fila->Subtotal;
				$Iva=$fila->Iva;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$AbonoVenta=$fila->AbonoVenta;
				$VendedorUsuario=$fila->VendedorUsuario;
				$TotalPropina=$fila->TotalPropina;
				$UsuarioPropina=$fila->UsuarioPropina;
				$Comentario=$fila->Comentario;
				$Contado=$fila->Contado;
				$TipoPagoUno=$fila->CantidadTarjetaUno;
				$TipoPagoDos=$fila->CantidadTarjetaDos;
				$CantidadTarjetaUno=$fila->CantidadTarjetaUno;
				$CantidadTarjetaDos=$fila->CantidadTarjetaDos;
				$franquicias_IdFranquicias=$fila->franquicias_IdFranquicias;
			}
			$data = array(
				'folio' => $folio,
				'FechaVenta' => $FechaVenta,
				'FolioVenta' => $FolioVenta,
				'IdVentas' => $IdVentas,
				'TotalVentaGeneral' => $TotalVentaGeneral,
				'ClienteVenta' => $ClienteVenta,
				'Subtotal' => $Subtotal,
				'Iva' => $Iva,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,
				'VendedorUsuario' => $VendedorUsuario,
				'TotalPropina' => $TotalPropina,
				'UsuarioPropina' => $UsuarioPropina,
				'Comentario' => $Comentario,
				'Contado' => $Contado,
				'TipoPagoUno' => $TipoPagoUno,
				'CantidadTarjetaUno' => $CantidadTarjetaUno,
				'TipoPagoDos' => $TipoPagoDos,
				'CantidadTarjetaDos' => $CantidadTarjetaDos,
				'franquicias_IdFranquicias' => $franquicias_IdFranquicias,
			);

		}else{
				$data ='';
				return FALSE;	
		}

		$data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from(' ventas_has_productosfranquicias');
		$this->db->join('productosfranquicias','productosfranquicias_IdProductosFranquicias = IdProductosFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales = 	IdProductosGenerales','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta1']=$this->db->get()->result();

//........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
	    $this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
		
		$this->db->where('IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta2']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta3']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from('ventas_has_promociones');
		$this->db->join('promociones','IdPromociones = promociones_IdPromociones','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias', $i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta4']=$this->db->get()->result();

		
		$this->db->select('*');
		$this->db->from('franquicias_has_leyendasgenerales');
		$this->db->join('leyendasgenerales','LeyendasGenerales_IdLeyendas = IdLeyendas','inner');
		$this->db->where('franquicias_has_leyendasgenerales.Franquicias_IdFranquicias', $i);
		$this->db->order_by("FechaCreacionL","desc");
		$data['leyenda']=$this->db->get()->result();


		$data['ReUsuario']=$this->cajaF_models->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->cajaF_models->BuscarDatosFranquicia();	
		
		
		$data['letras'] =CifrasEnLetras::convertirEurosEnLetras($AbonoVenta);
			
		$html=($this->load->view('caja/Franquiciatario/generador',$data, true));
    	$this->mydompdf->load_html($html,'UTF-8');	
    	$this->mydompdf->set_paper(array(0,0,250,1200)); 
    	$this->mydompdf->render();	
   		$this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); 
   		$this->mydompdf->set_base_path('assets/dist/css/styles.css'); //agregar de nuevo el css
       	$this->mydompdf->stream("Ticket de venta_".$FolioVenta.".pdf");
       	
     
 }
}


		public function agendarCliente()
		{
			$franquicia = $this->cajaF_models->BuscarIdFranquicia();
			$servicio='';
			$promocion='';
			if($_POST['tipo']=='serviciostable')
			{
				$servicio=$_POST['codigo'];
			}else{
				$promocion=$_POST['codigo'];
			}
			$campos = array(
							'Franquicias_IdFranquicias' => $franquicia, 
							'Clientes_IdClientes' => $_POST['cliente'], 
							'Categoria_IdCategoria' => '7', 
							'ServiciosFranquicias_IdServiciosFranquicias' => $servicio, 
							'Promociones_IdPromociones' => $promocion, 
							'Fecha' => date("y-m-d", strtotime($_POST['fecha'])), 
							'HoraInicio' => date("H:i:s", strtotime($_POST['inicio'])), 
							'HoraFin' => date("H:i:s", strtotime($_POST['fin'])), 
							'Cabina_IdCabina' => $_POST['cabina'], 
							'estatuscitas_IdEstatusCita'=>'5',
							'Observaciones' => $_POST['observaciones'], 
							'Usuarios_IdUsuarios' => $_POST['cosmetologo'], 
							);
							 $this->cajaF_models->agendarCliente($campos);
			// echo json_encode($campos);
		}
	}




