<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class CabinaA extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('franquicias/cabinas/administrador/accionesCabina_model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url','form'));

	}
	
public function index(){ //es la pantalla principal de las cabinas (lista de cabinas)
	
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
	$this->db->select('*');
	$this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');
	$this->db->order_by('NombreFranquicia','asc');
	$data['consulta']=$this->db->get('cabina')->result();
	$this->load->view('layout/header');
	$this->load->view('layout/menuAdmin');
	$datos['ReFranq']=$this->accionesCabina_model->BuscarFranq();
	$this->load->view('franquicias/cabinas/administrador/listaCabina_view',$data );
	$this->load->view('layout/footer');
		}
	}


	public function agregar(){ // en esta función se muestra la vista para agregar una nueva cabina
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$datos['ReFranq']=$this->accionesCabina_model->BuscarFranq();
		$this->load->view('franquicias/cabinas/administrador/agregarCabina_view',$datos);
		$this->load->view('layout/footer');
	
	}}

	public function guardar(){ // aca se mandan los datos capturados en la vista al modelo para que puedan ser guardados en la bd
	
		$parametro['NombreCabina']= $this->input->post('NombreCabina');
		$parametro['franquicias_IdFranquicias']= $this->input->post('NombreFranquicia');
		
		$this->accionesCabina_model->guardar($parametro);
		//echo "<script>alert('Datos guardados correctamente');</script>";
		//redirect('franquicias/cabinas/administrador/cabinaA', 'refresh');
		echo "<script>alert('Datos guardados correctamente');
				window.location.href='".base_url()."franquicias/cabinas/administrador/cabinaA';
				</script>";
		}

	public function eliminar() { //esta funcion permite eliminar una cabina por medio de su id que es pasado mediante la url 
		$id= $this->uri->segment(6);
		$this->accionesCabina_model->eliminar($id);	 

	
	}


//esta funcioón muestra en la vista los datos guardados anteriormente de una cabina para asi poder visualisar que cambios se desean realizar
public function editar(){
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(6);
		$obtenerenlace = $this->accionesCabina_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdCabina = $fila->IdCabina;
				$NombreCabina=$fila->NombreCabina;
				$franquicias_IdFranquicias=$fila->franquicias_IdFranquicias;

			}
			$data = array(
				'IdCabina' => $IdCabina,
				'NombreCabina' => $NombreCabina,
				'franquicias_IdFranquicias' => $franquicias_IdFranquicias);
			
			}else{
				$data ='';
				return FALSE;
			
		}
		
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->accionesCabina_model->BuscarFranq();
		$this->load->view('franquicias/cabinas/administrador/editarCabina_view', $data);
		$this->load->view('layout/footer');
	}
}
//esta funcion manda en un arreglo los datos que se desean cambiar al modelo para que se puedan guardar en la bd

	public function editarenlace()
	{
		 // if (!$this->session->userdata('Rol_IdRol')){
   //     redirect('acceso/acceso');
   //   } else {
		$IdCabina= $this -> uri->segment(6);
		$data=array(
			
			'NombreCabina' => $this -> input ->post('NombreCabina', true),
			'IdCabina' => $this -> input ->post('IdCabina', true),
			'franquicias_IdFranquicias' => $this -> input ->post('franquicias_IdFranquicias', true)
			);
		$this->accionesCabina_model->editarenlace($IdCabina, $data);
		//redirect('franquicias/cabinas/administrador/cabinaA','refresh');
		echo "<script>alert('Cabina actualizada correctamente');
				window.location.href='".base_url()."franquicias/cabinas/administrador/cabinaA';
				</script>";
	}
//}


	public function buscar ()//esta funcion permite buscar una cabina por medio de su nombre y mostrar su información correspondiente
	{	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');

		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accionesCabina_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->accionesCabina_model->BuscarFranq();
		$this->load->view('franquicias/cabinas/administrador/buscarCabina_view', $data);
		$this->load->view('layout/footer');
	}
}


}