<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class InventarioF extends CI_Controller
{
	public function __construct()
	{ 
		parent::__construct();		
		$this->load->library(array('session','form_validation'));
	   //cargamos la libreria DOMPDF previamente se debe realizar el archivo MydomPDF para la conexion del la libreria y el controlador.
        $this->load->library('mydompdf');
		$this->load->model('inventario/Franquiciatario/inventario_models');
	}

	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->inventario_models->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
		$this->db->select('*');
		$this->db->join('productosgenerales','productosGenerales_IdProductosGenerales = IdProductosGenerales','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
		$this->db->order_by('NombreTipoProducto');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('productosfranquicias')->result();
        $this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->inventario_models->BuscarTipo(); 
		$this->load->view('inventario/Franquiciatario/inventario_views',$data);
		$this->load->view('layout/footer');
   		} 
 	}


    public function Buscar()
    {
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} 
		else {
			$data = [];
			$var = $this->input->post('filtro');
			$query = $this->inventario_models->buscarporTipo($var);
			
			if(count($query->result()) != null ){
				foreach($query->result() as $inventario) {
					$id="'".$inventario->IdProductosFranquicias."'";
					$piezas=$inventario->PiezasTotales;
					$producto="'".$inventario->NombreProducto."'";
					if($inventario->NombreTipoProducto=='INTERNO')
					{
						$boton='<button type="button" class="btn btn-primary editarProducto" id="botonEditar" name="botonEditar" onClick="productosInternos('.$id.','.$piezas.','.$producto.')"><span class="glyphicon glyphicon-pencil"></span></button>';
					}else{
						$boton='<button type="button" class="btn btn-primary editarProducto" id="botonEditar" name="botonEditar" onClick="inventarioProductos('.$id.','.$piezas.','.$producto.')"><span class="glyphicon glyphicon-pencil"></span></button>';

					}
					if($inventario->PiezasTotales==0)
					{
						$estado="AGOTADO";
					}elseif($inventario->StockMinimo>=$inventario->PiezasTotales)
					{
						$estado="STOCK MINIMO";
					}else{
						$estado="";
					}
					
					$data[] = array(
						$inventario->IdProductosFranquicias,
						$inventario->NombreProducto,		
						$inventario->NombreTipoProducto,
						$inventario->NombreCategoria,
						$inventario->StockMinimo,
						$inventario->PiezasTotales ."\x20\x20\x20". $boton,
						// $inventario->PiezasTotales,
						$inventario->PrecioVenta,
						date("d-m-Y H:i:s", strtotime($inventario->FechaModificacion)),
						$estado,

					);
				}	
			}

			echo json_encode($data);
		
    	}
	  }
	  function actualizar()
	  {
		  $id=$_POST['codigo'];
		  $piezasTotales=$_POST['piezas'];
		  $query = $this->inventario_models->actualizar($id, $piezasTotales);
		//   echo json_encode($piezasTotales);
	  }
}