<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Franquiciatario)
class ProductoAdicionalA extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('productos/Franquiciatario/productoAdicionalA_model');
		$this->load->library(array('session','form_validation'));
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal 
	//Hace la consulta para mostrar todos los productos al público que esten registrados en la franquicia del usuario logueado
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->productoAdicionalA_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$this->db->where('TipoProducto_IdTipoProducto','3');
		$data['consulta']=$this->db->get('productosfranquicias')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('productos/Franquiciatario/listaProductoAdicionalA_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Función que elimina al usuario
	public function eliminar() 
	{
		 $id= $this->uri->segment(5);
		 $this->productoAdicionalA_model->eliminar($id);
	}

	//Funcion que valia que el usuario este logueado y que manda a traer la vista con los datos del producto seleccionado
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->productoAdicionalA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdProductosFranquicias = $fila->IdProductosFranquicias;
				$ProductosGenerales_IdProductosGenerales= $fila->ProductosGenerales_IdProductosGenerales;
				$NombreProducto=$fila->NombreProducto;
				$TipoProducto_IdTipoProducto=$fila->TipoProducto_IdTipoProducto;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$StockMinimo=$fila->StockMinimo;
				$PrecioVenta=$fila->PrecioVenta;
				$PrecioCompra=$fila->PrecioCompra;
				$DescripcionProducto = $fila->DescripcionProducto;
				$PiezasTotales= $fila->PiezasTotales;
			}$data = array(
				'IdProductosFranquicias' => $IdProductosFranquicias,
				'ProductosGenerales_IdProductosGenerales' => $ProductosGenerales_IdProductosGenerales,
				'NombreProducto' => $NombreProducto,
				'TipoProducto_IdTipoProducto' =>$TipoProducto_IdTipoProducto,		
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'StockMinimo' => $StockMinimo,
				'PrecioVenta' => $PrecioVenta,
				'PrecioCompra' => $PrecioCompra,
				'PiezasTotales' => $fila->PiezasTotales,
				'DescripcionProducto' => $DescripcionProducto);
			}else{
				$data ='';
				return FALSE;	
		}
		$data['ReCategoria']=$this->productoAdicionalA_model->BuscarCategoria();
  		$data['ReTipo']=$this->productoAdicionalA_model->BuscarTipo();
  		$data['ReFranquicias']=$this->productoAdicionalA_model->BuscarFranquicia();
  		$data['ReUsuario']=$this->productoAdicionalA_model->BuscarUsuario();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('productos/Franquiciatario/editarProductoAdicional_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Función que manda a traer la vista con los datos del producto seleccionado
	public function editarenlace()
	{
		$IdProductosGenerales= $this -> uri->segment(5);
		$data=array(

        'PrecioVenta' => $this->input->post('PrecioVenta',true),
			);

		$dataa= implode(";", $data);

		$dataas=array(

        'PrecioCompra' => $this->input->post('PrecioCompra',true),
			);

		$datas= implode(";", $dataas);



		$dato = array('PiezasTotales' => $this->input->post('total',true),
		);

		$datoo= implode(";", $dato);
		$this->productoAdicionalA_model->editarenlace($IdProductosGenerales, $dataa,$datoo,$datas);
	}

	
	//Función que muestra el tipo del producto 
	public function MostrarTipo()
	{
		$options ="";
		if($this->input->post('IdTipoProducto')){
			$IdTipo=$this->input->post('IdTipoProducto');
			$Nombre=$this->productoPublicoA_model->BuscarTipo($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el tipo de categoría
	public function MostrarCategoria()
	{
		$options ="";
		if($this->input->post('IdCategoria')){
			$IdCategoria=$this->input->post('IdCategoria');
			$NombreCategoria=$this->productoProductoA_model->BuscarCategoria($IdCategoria);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra todos los productos al público registrados
	public function MostrarProducto()
	{
		$options ="";
		if($this->input->post('IdProductosGenerales')){
			$IdProductosGenerales=$this->input->post('IdProductosGenerales');
			$NombreProducto=$this->productoPublicoA_model->BuscarCategoria($IdProductosGenerales);
			foreach ($NombreProducto as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra la franquicia a la que pertenece el usuario logueado 
	public function MostrarFranquicia()
	{
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('IdFranquicias');
			$NombreFranquicia=$this->productoPublicoA_model->BuscarFranquicia($IdFranquicias);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el nombre del usuario logueado 
	public function MostrarUsuario()
	{
		$options ="";
		if($this->input->post('IdUsuarios')){
			$IdUsuarios=$this->input->post('IdUsuarios');
			$NombreUsuario=$this->productoPublicoA_model->BuscarUsuario($IdUsuarios);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"></option>
                <?php
			}
		}
	}
	
}