<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Franquiciatario)
class ProductoPublico extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('productos/Franquiciatario/productoPublicoA_model');
		$this->load->library(array('session','form_validation'));
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal 
	//Hace la consulta para mostrar todos los productos al público que esten registrados en la franquicia del usuario logueado
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->productoPublicoA_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$this->db->where('TipoProducto_IdTipoProducto','2');
		$data['consulta']=$this->db->get('productosfranquicias')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('productos/Franquiciatario/listaProductoPublicoA_view',$data);
		$this->load->view('layout/footer');
		}
	}


	//Funcion que valida que el usuario este logueado y manda a traer la vista para registrar el producto interno 
	public function agregar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$datos['consulta']=$this->db->get('usuarios')->result();
		$this->db->select('*');
		$datos['consulta']=$this->db->get('productosgenerales')->result();
  		$datos['ReTipo']=$this->productoPublicoA_model->BuscarTipo();
  		$datos['ReProducto']=$this->productoPublicoA_model->BuscarProducto();
  		$datos['ReFranquicia']=$this->productoPublicoA_model->BuscarFranquicia();
  		$datos['ReUsuario']=$this->productoPublicoA_model->BuscarUsuario();
  		$datos['ReCategoria']=$this->productoPublicoA_model->BuscarCategoria();
		$this->load->view('productos/Franquiciatario/agregaProductoPublicoA_view',$datos);
		$this->load->view('layout/footer');
		}
	}

	//Funcion que muestra los datos del producto seleccionado  
	public function productos()
	{
		if(isset($_GET['term'])){
			$result = $this->productoPublicoA_model->buscarProductoAd($_GET['term']);
			if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
						'label' => $row->NombreProducto,
						'TipoProducto' => $row->NombreTipoProducto,
						'Categoria' => $row->NombreCategoria,
						'StockMinimo' => $row->StockMinimo,
						'PrecioVenta' => $row->PrecioVenta,
						'PrecioCompra' => $row->PrecioCompra,
						'DescripcionProducto'	=> $row->DescripcionProducto,
						'IdProductosGenerales'	=> $row->IdProductosGenerales,
					);
						echo json_encode($arr_result);
					}
			}
		}

	//Funcion que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar()
	{
		$parametro['IdProductosFranquicias']= "FMAS".$this->input->post('Franquicia').$parametro['IdProductosGenerales']= $this->input->post('IdProductosGenerales');
		$parametro['ProductosGenerales_IdProductosGenerales']=$this->input->post('IdProductosGenerales');
		$parametro['PiezasTotales']= $this->input->post('total')+ $parametro['total']= $this->input->post('PiezasTotales');
		$parametro['Franquicias_IdFranquicias'] = $this->input->post('Franquicia');
        $parametro['Usuarios_IdUsuarios'] = $this->input->post('Usuario');
		$this->productoPublicoA_model->guardar($parametro);	
	}

	//Función que elimina al usuario
	public function eliminar() 
	{
		 $id= $this->uri->segment(5);
		 $this->productoPublicoA_model->eliminar($id);
		 redirect('productos/Franquiciatario/productoPublico');
	}

	//Funcion que valia que el usuario este logueado y que manda a traer la vista con los datos del producto seleccionado
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->productoPublicoA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdProductosFranquicias = $fila->IdProductosFranquicias;
				$NombreProducto=$fila->NombreProducto;
				$TipoProducto_IdTipoProducto=$fila->TipoProducto_IdTipoProducto;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$StockMinimo=$fila->StockMinimo;
				$PrecioVenta=$fila->PrecioVenta;
				$PrecioCompra=$fila->PrecioCompra;
				$DescripcionProducto = $fila->DescripcionProducto;
				$PiezasTotales= $fila->PiezasTotales;
			}$data = array(
				'IdProductosFranquicias' => $IdProductosFranquicias,
				'NombreProducto' => $NombreProducto,
				'TipoProducto_IdTipoProducto' =>$TipoProducto_IdTipoProducto,		
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'StockMinimo' => $StockMinimo,
				'PrecioVenta' => $PrecioVenta,
				'PrecioCompra' => $PrecioCompra,
				'PiezasTotales' => $fila->PiezasTotales,
				'DescripcionProducto' => $DescripcionProducto);
			}else{
				$data ='';
				return FALSE;
		}
		$data['ReTipo']=$this->productoPublicoA_model->BuscarTipo();
  		$data['ReCategoria']=$this->productoPublicoA_model->BuscarCategoria();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('productos/Franquiciatario/editarProductoPublico_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Función que manda a traer la vista con los datos del producto seleccionado
	public function editarenlace()
	{
		$IdProductosGenerales= $this -> uri->segment(5);
		$data=array(
        'PiezasTotales' => $this->input->post('total',true),
			);
		$this->productoPublicoA_model->editarenlace($IdProductosGenerales, $data);
	}

	//Función que muestra el tipo del producto 
	public function MostrarTipo()
	{
		$options ="";
		$IdProductosGenerales=$this->input->post('IdProductosGenerales');
		if($IdProductosGenerales){
			$this->load->model('serviciosAdicionalesA_model');
			$zonas=$this->productoPublicoA_model->BuscarZona($IdFranquicias);
			foreach ($zonas as $zona) {

				echo "<option value='".$zona['Zona_IdZona']."'>".$zona['NombreZona']."</option>";
			}
		}
	}

	//Función que muestra el tipo de categoría
	public function MuestraCategoria()
	{
		$options ="";
		$IdProductosGenerales=$this->input->post('IdProductosGenerales');
		if($IdProductosGenerales){
			$this->load->model('productoPublicoA_model');
			$ProductosGenerales=$this->productoPublicoA_model->BuscarCategoria($IdProductosGenerales);
			foreach ($ProductosGenerales as $ProductoPublico) {

				echo "<option value='".$ProductoPublico['Categoria_IdCategoria']."'>".$ProductoPublico['NombreCategoria']."</option>";
			}
		}
	}

	//Función que muestra todos los productos al público registrados
	public function MostrarProducto()
	{
		$options ="";
		if($this->input->post('IdProductosGenerales')){
			$IdProductosGenerales=$this->input->post('IdProductosGenerales');
			$NombreProducto=$this->productoPublicoA_model->BuscarCategoria($IdProductosGenerales);
			}
	}



	//Función que muestra la franquicia a la que pertenece el usuario logueado 
	public function MostrarFranquicia()
	{
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('IdFranquicias');
			$NombreFranquicia=$this->productoPublicoA_model->BuscarFranquicia($IdFranquicias);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el nombre del usuario logueado 
	public function MostrarUsuario()
	{
		$options ="";
		if($this->input->post('IdUsuarios')){
			$IdUsuarios=$this->input->post('IdUsuarios');
			$NombreUsuario=$this->productoPublicoA_model->BuscarUsuario($IdUsuarios);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"></option>
                <?php
			}
		}
	}	
}