<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class PromocionFijaA extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('promociones/administrador/promocionFijaA_model');
		$this->load->library(array('session','form_validation'));

	}


//esta función es la pantalla principal de este módulo (lista de promociones institucionales)
	public function index()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->where('TipoPromocion_IdTipoPromocion',3);
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$this->db->order_by("NombrePromocion","asc");
		$data['consulta']=$this->db->get('promociones')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/listapromocionFijaA_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function listaPromociones()
	{
		$this->promocionFijaA_model->buscarPromociones();
	}
	public function agregar()
	{ //aca se muestra la cista para agregar una nueva promocion institucional
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$datos['ReTipoPromocion']=$this->promocionFijaA_model->BuscarTipoPromocion();
		$datos['ReCategoria']=$this->promocionFijaA_model->BuscarCategoria();
		$datos['ReZona']=$this->promocionFijaA_model->BuscarZona();
		$this->load->view('promociones/administrador/agregarpromocionFijaA_view', $datos);
		$this->load->view('layout/footer');
		}
	}

	public function guardar()
	{// esta funcion manda los datos capturados en la vista al modelo para que puedan ser guardados en la bd
		$parametro['NombrePromocion']= "PF-".$this->input->post('txt_NombrePromocionpro')."   ".$parametro['txt_cantidad']= $this->input->post('txt_cantidad')." SESIONES";
		$parametro['FolioPromocion']="FMASGPF";
		$parametro['Precio']= $this->input->post('txtnumero_servicios');
		$parametro['SesionesPromocion']= $this->input->post('txt_cantidad');
		$parametro['DuracionPromocion']= $this->input->post('tiempo');
		$parametro['DescripcionPromocion']= $this->input->post('txt_DescripcionPromocion');
		$parametro['Categoria_IdCategoria']= $this->input->post('txtcategoria');
		$parametro['FechaInicioPromocion']= $this->input->post('txt_fechai');
		$parametro['FechaTerminoPromocion']= $this->input->post('txt_fechaf');
		$parametro['Estatus']= $this->input->post('txt_estatus');
		$parametro['TipoPromocion_IdTipoPromocion']= $this->input->post('txt_idtipopro');
		$parametro['Zona_IdZona']= $this->input->post('txt_idzona');
		$parametro['ClasePromocion']= $this->input->post('Clase');
		$parametro['ClasificacionPromocion']= $this->input->post('Clasificacion');
		$this->promocionFijaA_model->guardar($parametro);

	}


	public function eliminar() 
	{ //eta funcion elimina una promoción de acuerdo al id seleccionado (segmento 5 de la url)
		 $id= $this->uri->segment(5);
		 $this->promocionFijaA_model->eliminar($id);
		 redirect('promociones/administrador/promocionFijaA');
	}


	public function editar()
	{// aca se cargan los datos que han sido guardado anteriormente de una promocion institucional
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->promocionFijaA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$NombrePromocion=$fila->NombrePromocion;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$Estatus=$fila->Estatus;
				$tipopromocion_IdTipoPromocion=$fila->tipopromocion_IdTipoPromocion;
				$categoria_IdCategoria = $fila->categoria_IdCategoria;
				$zona_IdZona=$fila->zona_IdZona;
				$ClasePromocion=$fila->ClasePromocion;
				$ClasificacionPromocion=$fila->ClasificacionPromocion;
				$DuracionPromocion=$fila->DuracionPromocion;
			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'NombrePromocion' => $NombrePromocion,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'Estatus' => $Estatus,
				'tipopromocion_IdTipoPromocion' => $tipopromocion_IdTipoPromocion,
				'categoria_IdCategoria' => $categoria_IdCategoria,
				'ClasePromocion' => $ClasePromocion,
				'ClasificacionPromocion' => $ClasificacionPromocion,
				'zona_IdZona' => $zona_IdZona,
				'DuracionPromocion' => $DuracionPromocion
			);
			}else{
				$data ='';
				return FALSE;
			
		}
		$data['ReTipoPromocion']=$this->promocionFijaA_model->BuscarTipoPromocion();
		$data['ReCategoria']=$this->promocionFijaA_model->BuscarCategoria();
		$data['ReZona']=$this->promocionFijaA_model->BuscarZona();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/editarpromocionFijaA_view', $data);
		$this->load->view('layout/footer');
		}
	}
//esta funcion manda los datos que se quieren modificar al modelo para que se puedan realizar los cambios en la bd
	public function editarenlace ()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$IdPromociones= $this -> uri->segment(5);
		$data=array(
			'NombrePromocion' => $this -> input ->post('NombrePromocion', true),
			'Precio' => $this -> input ->post('Precio', true),
			'DuracionPromocion'=> $this ->input->post('tiempo',true),
			'DescripcionPromocion' => $this -> input ->post('DescripcionPromocion', true),
			'FechaInicioPromocion' => $this -> input ->post('FechaInicioPromocion', true),
			'FechaTerminoPromocion' => $this -> input ->post('FechaTerminoPromocion', true),
			'Estatus' => $this -> input ->post('txt_estatus', true),
			'Categoria_IdCategoria' => $this -> input ->post('Categoria_IdCategoria', true),
			'ClasificacionPromocion' => $this -> input ->post('ClasificacionPromocion', true),
			'ClasePromocion' => $this -> input ->post('ClasePromocion', true),
			'Zona_IdZona' => $this -> input ->post('Zona_IdZona', true)		
			);
		$this->promocionFijaA_model->editarenlace($IdPromociones, $data);	
		}
	}
// esta funcion permite buscar una promoción por medio de su nombre 
public function buscar ()
	{		
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');

		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->promocionFijaA_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/buscarpromocionFija_view', $data);
		$this->load->view('layout/footer');
		}
	}


	public function editarA()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		
		$id= $this->uri->segment(5);
		$obtenerenlaceA = $this->promocioninstitucionalA_model->obtenerenlaceA($id);
		if($obtenerenlaceA != FALSE){
			foreach ($obtenerenlaceA->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$TipoPromocion_IdTipoPromocion=$fila->TipoPromocion_IdTipoPromocion;
				$NombrePromocion=$fila->NombrePromocion;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$parametro['IdZ']= $this->input->post('IdZ');
				$Zona_IdZona=$fila->Zona_IdZona;

			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'TipoPromocion_IdTipoPromocion' => $TipoPromocion_IdTipoPromocion,
				'NombrePromocion' => $NombrePromocion,
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'IdZ' => $parametro['IdZ'],
				'Zona_IdZona' => $Zona_IdZona);
			}else{
				$data ='';
				return FALSE;		
		}	
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranquicia']=$this->promocionFijaA_model->BuscarFranquicia();
		$this->load->view('promociones/administrador/asignarpromocion_view', $data);
		$this->load->view('layout/footer');
		}
	}
	
	public function editarenlaceA ()
	{
		$IdPromociones= $this -> uri->segment(5);
		$data=array(
			'PromocionesGenerales_IdPromociones' => $this -> input ->post('IdPromociones'),
			'IdPromocionesFranquicias' => $this -> input ->post('IdZ'),
			'Franquicias_IdFranquicias' => $this -> input ->post('txt_franquicia')		
			);
		$this->promocionFijaA_model->editarenlaceA($IdPromociones, $data);
		redirect('promociones/administrador/promocioninstitucionalA');
	}
}

