<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class PromocioninstitucionalA extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library(array('session','form_validation'));
		$this->load->model('promociones/administrador/promocioninstitucionalA_model');
	}

	public function index()
	{ //esta función es la pantalla principal de este módulo (lista de promociones institucionales)
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->where('TipoPromocion_IdTipoPromocion',1);
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$this->db->order_by("NombrePromocion","asc");
		$data['consulta']=$this->db->get('promociones')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/listapromocioninstitucionalA_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function listaPromociones()
	{
		$this->promocioninstitucionalA_model->buscarPromociones();
	}
	public function agregar()
	{ //aca se muestra la cista para agregar una nueva promocion institucional
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$datos['ReTipoPromocion']=$this->promocioninstitucionalA_model->BuscarTipoPromocion();
		$datos['ReCategoria']=$this->promocioninstitucionalA_model->BuscarCategoria();
		$datos['ReZona']=$this->promocioninstitucionalA_model->BuscarZona();
		$this->load->view('promociones/administrador/agregarpromocioninstitucionalA_view', $datos);
		$this->load->view('layout/footer');
		}
	}

	public function guardar()
	{// esta funcion manda los datos capturados en la vista al modelo para que puedan ser guardados en la bd
		$parametro['tipopromocion_IdTipoPromocion']= $this->input->post('txt_idtipopro');
		$parametro['NombrePromocion']= "PI-".$this->input->post('txt_NombrePromocionpro')."   ".$parametro['txt_cantidad']= $this->input->post('txt_cantidad')." SESIONES";
		$parametro['FolioPromocion']="FMASGPI";
		$parametro['categoria_IdCategoria']= $this->input->post('txtcategoria');
		$parametro['Precio']= $this->input->post('txtnumero_servicios');
		$parametro['SesionesPromocion']= $this->input->post('txt_cantidad');
		$parametro['DuracionPromocion']= $this->input->post('tiempo');
		$parametro['DescripcionPromocion']= $this->input->post('txt_DescripcionPromocion');
		$parametro['FechaInicioPromocion']= $this->input->post('txt_fechai');
		$parametro['FechaTerminoPromocion']= $this->input->post('txt_fechaf');
		$parametro['Estatus']= $this->input->post('txt_estatus');
		$parametro['zona_IdZona']= $this->input->post('txt_idzona');
		$parametro['ClasePromocion']= $this->input->post('Clase');
		$parametro['ClasificacionPromocion']= $this->input->post('Clasificacion');
		
		$this->promocioninstitucionalA_model->guardar($parametro);
		redirect('promociones/administrador/promocioninstitucionalA');

	}


	public function eliminar() 
	{ //eta funcion elimina una promoción de acuerdo al id seleccionado (segmento 5 de la url)
		 $id= $this->uri->segment(5);
		 $this->promocioninstitucionalA_model->eliminar($id);
		 redirect('promociones/administrador/promocioninstitucionalA');
	}


	public function editar()
	{// aca se cargan los datos que han sido guardado anteriormente de una promocion institucional
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->promocioninstitucionalA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$tipopromocion_IdTipoPromocion=$fila->tipopromocion_IdTipoPromocion;
				$NombrePromocion=$fila->NombrePromocion;
				$categoria_IdCategoria = $fila->categoria_IdCategoria;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$Estatus=$fila->Estatus;
				$zona_IdZona=$fila->zona_IdZona;
				$ClasePromocion=$fila->ClasePromocion;
				$ClasificacionPromocion=$fila->ClasificacionPromocion;
				$DuracionPromocion=$fila->DuracionPromocion;
			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'tipopromocion_IdTipoPromocion' => $tipopromocion_IdTipoPromocion,
				'NombrePromocion' => $NombrePromocion,
				'categoria_IdCategoria' => $categoria_IdCategoria,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'ClasePromocion' => $ClasePromocion,
				'ClasificacionPromocion' => $ClasificacionPromocion,
				'Estatus' => $Estatus,
				'zona_IdZona' => $zona_IdZona,
				'DuracionPromocion' => $DuracionPromocion
			);
			}else{
				$data ='';
				return FALSE;
			
		}
		$data['ReTipoPromocion']=$this->promocioninstitucionalA_model->BuscarTipoPromocion();
		$data['ReCategoria']=$this->promocioninstitucionalA_model->BuscarCategoria();
		$data['ReZona']=$this->promocioninstitucionalA_model->BuscarZona();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/editarpromocioninstitucionalA_view', $data);
		$this->load->view('layout/footer');
		}
	}
//esta funcion manda los datos que se quieren modificar al modelo para que se puedan realizar los cambios en la bd
	public function editarenlace ()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$IdPromociones= $this -> uri->segment(5);
		$data=array(
			'NombrePromocion' => $this -> input ->post('NombrePromocion', true),
			'Categoria_IdCategoria' => $this -> input ->post('Categoria_IdCategoria', true),
			'Precio' => $this -> input ->post('Precio', true),
			'DuracionPromocion'=> $this ->input->post('tiempo',true),
			'DescripcionPromocion' => $this -> input ->post('DescripcionPromocion', true),
			'FechaInicioPromocion' => $this -> input ->post('FechaInicioPromocion', true),
			'FechaTerminoPromocion' => $this -> input ->post('FechaTerminoPromocion', true),
			'Estatus' => $this -> input ->post('txt_estatus', true),
			'ClasificacionPromocion' => $this -> input ->post('ClasificacionPromocion', true),
			'ClasePromocion' => $this -> input ->post('ClasePromocion', true),
			'Zona_IdZona' => $this -> input ->post('Zona_IdZona', true)		
			);
		$this->promocioninstitucionalA_model->editarenlace($IdPromociones, $data);	
		}
	}

	public function buscar ()
	// esta funcion permite buscar una promoción por medio de su nombre 
	{		
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');

		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->promocioninstitucionalA_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/buscarpromocioninstitucionalA_view', $data);
		$this->load->view('layout/footer');
		}
	}
//esta función muestra los tipos de promociones que existen en una lista desplegable para poder dar de alta una promoción
	public function MostrarTipoPromocion()
	{
		$options ="";
		if($this->input->post('TipoPromocion')){
			$IdTipoPromocion=$this->input->post('tipopromocion');
			$NombrePromocion=$this->promocioninstitucionalA_model->BuscarTipoPromocion($IdTipoPromocion);
			foreach ($NombrePromocion as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipopromocion_name ?></option>
                <?php
			}
		}

	}
//esta función muestra loas catgorías que existen en una lista desplegable para poder dar de alta una promoción
	public function MostrarCategoria()
	{
		$options ="";
		if($this->input->post('categoria')){
			$IdCategoria=$this->input->post('categoria');
			$NombreCategoria=$this->promocioninstitucionalA_model->BuscarCategoria($IdCategoria);
			foreach ($NombreCategoria as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}

	}
//esta función muestra las zonas que existen en una lista desplegable para poder dar de alta una promoción
	public function MostrarZona()
	{
		$options ="";
		if($this->input->post('IdZona')){
			$IdZona=$this->input->post('Zona');
			$NombreZona=$this->promocioninstitucionalA_model->BuscarZona($IdZona);
			foreach ($NombreZona as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $zona_name ?></option>
                <?php
			}
		}
	}

	public function editarA()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlaceA = $this->promocioninstitucionalA_model->obtenerenlaceA($id);
		if($obtenerenlaceA != FALSE){
			foreach ($obtenerenlaceA->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$TipoPromocion_IdTipoPromocion=$fila->TipoPromocion_IdTipoPromocion;
				$NombrePromocion=$fila->NombrePromocion;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$parametro['IdZ']= $this->input->post('IdZ');
				$Zona_IdZona=$fila->Zona_IdZona;
			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'TipoPromocion_IdTipoPromocion' => $TipoPromocion_IdTipoPromocion,
				'NombrePromocion' => $NombrePromocion,
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'IdZ' => $parametro['IdZ'],
				'Zona_IdZona' => $Zona_IdZona);
			}else{
				$data ='';
				return FALSE;	
			}
			$this->load->view('layout/header');
			$this->load->view('layout/menuAdmin');
			$data['ReFranquicia']=$this->promocioninstitucionalA_model->BuscarFranquicia();
			$this->load->view('promociones/administrador/asignarpromocion_view', $data);
			$this->load->view('layout/footer');
		}
	}


	public function editarenlaceA ()
	{
		$IdPromociones= $this -> uri->segment(5);
		$data=array(
			'PromocionesGenerales_IdPromociones' => $this -> input ->post('IdPromociones'),
			'IdPromocionesFranquicias' => $this -> input ->post('IdZ'),
			'Franquicias_IdFranquicias' => $this -> input ->post('txt_franquicia')		
			);
		$this->promocioninstitucionalA_model->editarenlaceA($IdPromociones, $data);
		redirect('promociones/administrador/promocioninstitucionalA');
	}

//esta función muestra las franquicias que existen en una lista desplegable para poder dar de alta una promoción
	public function MostrarFranquicia()
	{ 
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('franquicias');
			$NombreFranquicia=$this->promocioninstitucionalA_model->BuscarFranquicia($IdFranquicias);
			foreach ($NombreFranquicia as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}
	}
}
	


	
