<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class PromocionFijaF extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('promociones/franquiciatario/promocionFijaF_model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url'));
	}

	//Acá se muestra la pantalla principal del módulo (lista de promociones)
	public function index()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->promocionFijaF_model->BuscarFranquicia();
		 foreach ($data['Franquicias'] as $i => $Franquicias) 

		 $data['Zona']=$this->promocionFijaF_model->BuscarZonaPer();
		 foreach ($data['Zona'] as $a => $Zona)
		$this->db->where('TipoPromocion_IdTipoPromocion',3	);
		$this->db->where('Estatus','ACTIVA');
		$this->db->where('Zona_IdZona',$a);
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$data['consulta']=$this->db->get('promociones')->result();
		
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/listapromocionFijaF_view',$data);
		$this->load->view('layout/footer');
		}
	}

	
	//Esta función muestra en un formulario los datos de una promoción que ah sido guardada anteriormente para ver su información y poder ser modificada
	public function editar()
	{ 
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->promocionFijaF_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$tipopromocion_IdTipoPromocion=$fila->tipopromocion_IdTipoPromocion;
				$NombrePromocion=$fila->NombrePromocion;
				$categoria_IdCategoria = $fila->categoria_IdCategoria;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$zona_IdZona=$fila->zona_IdZona;
			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'tipopromocion_IdTipoPromocion' => $tipopromocion_IdTipoPromocion,
				'NombrePromocion' => $NombrePromocion,
				'categoria_IdCategoria' => $categoria_IdCategoria,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'zona_IdZona' => $zona_IdZona);

			}else{
				$data ='';
				return FALSE;	
		}
		$data['ReCategoria']=$this->promocionFijaF_model->BuscarCategoria();
		$data['ReZona']=$this->promocionFijaF_model->BuscarZona();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/editarpromocionFijaF_view', $data);
		$this->load->view('layout/footer');
		}
	}

	//Esta función permite buscar una promoción por medio de su nombre,
	public function buscar ()
	{
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {	
  

		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->promocionFijaF_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('promociones/franquiciatario/buscarpromocionFijaF_view', $data);
		$this->load->view('layout/footer');
		}
	}	
}

	
