<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class RVentas extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
	
		$this->load->library(array('session','form_validation'));
		$this->load->model('reportes/Administrador/Ventas_model');
	}

	public function index()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->model('reportes/Administrador/Ventas_model');
   		$data["ventas"] = $this->Ventas_model->fetch_data();
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$data['consulta']=$this->db->get('ventas')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Ventas_model->BuscarFranq();
		$this->load->view('reportes/Administrador/ReporteVentas_view',$data);
		$this->load->view('layout/footer');
		}
	}

 	public function actiongeneral()
	{
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$data=$this->db->get('ventas');
		$this->load->model("Ventas_model");
		$this->load->library("GenerarReporteExcel/excel");
		$object = new PHPExcel();
		$object->setActiveSheetIndex(0);     
		$object->getActiveSheet()->setTitle('Reporte General de Ventas');
		$object->getActiveSheet()->getStyle('3')->applyFromArray(
		    array(
		  'font' => array(
		  'bold' => TRUE
		)
		)
		); 
		   
		  $table_columns = array ("FOLIO","FRANQUICIA","NOMBRE CLIENTE","FECHA VENTA", "TOTAL VENTA", "ADEUDO");

		  $column = 0;
		  $field = 3;
		  
		  foreach($table_columns as $field)
		  {
		   $object->getActiveSheet()->setCellValueByColumnAndRow($column,3, $field);
		   $column++;
		  }

		  $ventas = $this->Ventas_model->fetch_data();

		  $excel_row = 4;

		  foreach($ventas as $row)
		  {
		//Funcion para dar el tamaño a cada columna del formato excel.
		    $object->getActiveSheet()->getColumnDimension('A')->setWidth(20);
		    $object->getActiveSheet()->getColumnDimension('B')->setWidth(40);
		    $object->getActiveSheet()->getColumnDimension('C')->setWidth(20);
		    $object->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		    $object->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		    $object->getActiveSheet()->getColumnDimension('F')->setWidth(10);
		    
		//Funcion para mostrar los datos de cada columna que tendran el documento en excel.
		   $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->IdVentas);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->NombreFranquicia); 
		   $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->ClienteVenta);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->FechaVenta);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->TotalVenta);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->AdeudoVenta);
		   
		   $excel_row++;  
		}
		 //Funcion que genera el excel para su descarga.
		  $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
		  header('Content-Type: application/vnd.ms-excel');
		  header('Content-Disposition: attachment;filename="Reporte General de Ventas.xls"');
		   // Forzamos a la descarga
		  $object_writer->save('php://output');
		  
	}
	//Función que busca las ventas de la franquicia seleccionada en el combo
	public function buscarVentaFranquicia()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		$fran = $this->input->get('franquicias', TRUE);

		if ($query) {
			$result = $this->pagosA_model->buscarVentaFranquicia(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/buscarVentaF_view',$data,$fran);
		$this->load->view('layout/footer');
		}
	}


	public function buscarVentaF ()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		$fran = $this->input->get('franquicias', TRUE);

		if ($query) {
			$result = $this->pagosA_model->buscarVentaFranP1(trim($query,$fran));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
			$data['ReFranq']=$this->pagosA_model->BuscarFranq();
				$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/buscarPagoV_view',$data);
		$this->load->view('layout/footer');
		}
	}

	public function buscarV ()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarV($query);
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/buscarPagoV_view',$data);
		$this->load->view('layout/footer');
	}

	public function pago1()
	{
		$this->db->select('*');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		
		$data['consulta']=$this->db->get('pago1')->result();

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosF_view',$data);
		$this->load->view('layout/footer');
	
	}

	public function buscarp1 ()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarP1(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,		
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosP1_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Función que busca las ventas de la franquicia seleccionada en el combo
	public function buscarVentaFranPaU()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarVP1(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/buscarVP1_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//funcion para agregar un nuevo cliente que nos muestra la vista con todos sus formularios correspondientes
	public function editarP1()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$TotalDescuento = $fila->TotalDescuento;
				$ClienteVenta = $fila->ClienteVenta;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$Fecha1 = $fila->Fecha1;
				$Contado1=$fila->Contado1;
				$TCredito1=$fila->TCredito1;
				$TCFolio1 = $fila->TCFolio1;
				$TDebito1=$fila->TDebito1;
				$TDFolio1=$fila->TDFolio1;
				$Usuario1 = $fila->Usuario1;
			}
			$data = array(
				'ventas_IdVentas' => $ventas_IdVentas,
				'TotalDescuento' => $TotalDescuento,
				'ClienteVenta' => $ClienteVenta,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'Fecha1' => $Fecha1,
				'Contado1' => $Contado1,
				'TCredito1' => $TCredito1,
				'TCFolio1' => $TCFolio1,
				'TDebito1' => $TDebito1,
				'TDFolio1' => $TDFolio1,
				'Usuario1' => $Usuario1,
			
			);
		}else{
				$data ='';
				return FALSE;
			
		}

		$data['ReUsuario']=$this->pagosA_model->BuscarUsuario();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('pagos/administrador/editarPago1_view', $data);
		$this->load->view('layout/footer');
		}
	}

	public function pago2()
	{	
		$this->db->select('*');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		
		$data['consulta']=$this->db->get('pago2')->result();

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosF2_view',$data);
		$this->load->view('layout/footer');
	
	}

	public function buscarVentaFranPaD()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarVP2(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('pagos/administrador/buscarVP2_view',$data);
		$this->load->view('layout/footer');
		}
	}

		public function buscarP2 ()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarP2(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosP2_view',$data);
		$this->load->view('layout/footer');
	}

	//funcion para agregar un nuevo cliente que nos muestra la vista con todos sus formularios correspondientes
	public function editarP2()
		{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosA_model->obtenerenlace2($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$TotalDescuento = $fila->TotalDescuento;
				$ClienteVenta = $fila->ClienteVenta;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$Fecha2 = $fila->Fecha2;
				$Contado2=$fila->Contado2;
				$TCredito2=$fila->TCredito2;
				$TCFolio2 = $fila->TCFolio2;
				$TDebito2=$fila->TDebito2;
				$TDFolio2=$fila->TDFolio2;
				$Usuario2 = $fila->Usuario2;
			}
			$data = array(
				'ventas_IdVentas' => $ventas_IdVentas,
				'TotalDescuento' => $TotalDescuento,
				'ClienteVenta' => $ClienteVenta,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'Fecha2' => $Fecha2,
				'Contado2' => $Contado2,
				'TCredito2' => $TCredito2,
				'TCFolio2' => $TCFolio2,
				'TDebito2' => $TDebito2,
				'TDFolio2' => $TDFolio2,
				'Usuario2' => $Usuario2,
			);
		}else{
				$data ='';
				return FALSE;	
		}
		$data['ReUsuario']=$this->pagosA_model->BuscarUsuario();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('pagos/administrador/editarPago2_view', $data);
		$this->load->view('layout/footer');
	}
}
	
	public function pago3()
	{
		$this->db->select('*');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		
		$data['consulta']=$this->db->get('pago3')->result();

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosF3_view',$data);
		$this->load->view('layout/footer');
	
	}

	public function buscarVentaFranPaT()
	{
	$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarVP3(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,				
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('pagos/administrador/buscarVP3_view',$data);
		$this->load->view('layout/footer');
	}
	
	//funcion para agregar un nuevo cliente que nos muestra la vista con todos sus formularios correspondientes
	public function editarP3()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosA_model->obtenerenlace3($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$TotalDescuento = $fila->TotalDescuento;
				$ClienteVenta = $fila->ClienteVenta;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$Fecha3 = $fila->Fecha3;
				$Contado3=$fila->Contado3;
				$TCredito3=$fila->TCredito3;
				$TCFolio3 = $fila->TCFolio3;
				$TDebito3=$fila->TDebito3;
				$TDFolio3=$fila->TDFolio3;
				$Usuario3 = $fila->Usuario3;
			}
			$data = array(
				'ventas_IdVentas' => $ventas_IdVentas,
				'TotalDescuento' => $TotalDescuento,
				'ClienteVenta' => $ClienteVenta,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'Fecha3' => $Fecha3,
				'Contado3' => $Contado3,
				'TCredito3' => $TCredito3,
				'TCFolio3' => $TCFolio3,
				'TDebito3' => $TDebito3,
				'TDFolio3' => $TDFolio3,
				'Usuario3' => $Usuario3,
			);
		}else{
				$data ='';
				return FALSE;
		}
		$data['ReUsuario']=$this->pagosA_model->BuscarUsuario();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('pagos/administrador/editarPago3_view', $data);
		$this->load->view('layout/footer');
		}
	}

	public function buscarP3 ()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarP3(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,	
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosP3_view',$data);
		$this->load->view('layout/footer');
	}

	public function pago4()
	{
		$this->db->select('*');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$data['consulta']=$this->db->get('pago4')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosF4_view',$data);
		$this->load->view('layout/footer');
	}

	public function buscarVentaFranPaC()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarVP4(trim($query));
			if ($result != FALSE){
				$data = array(
					'result' => $result,
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('pagos/administrador/buscarVP4_view',$data);
		$this->load->view('layout/footer');
		}
	}


public function buscarp4 ()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosA_model->buscarP4(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->pagosA_model->BuscarFranq();
		$this->load->view('pagos/administrador/listapagosP4_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//funcion para agregar un nuevo cliente que nos muestra la vista con todos sus formularios correspondientes
	public function editarP4()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosA_model->obtenerenlace4($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$TotalDescuento = $fila->TotalDescuento;
				$ClienteVenta = $fila->ClienteVenta;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$Fecha4 = $fila->Fecha4;
				$Contado4=$fila->Contado4;
				$TCredito4=$fila->TCredito4;
				$TCFolio4 = $fila->TCFolio4;
				$TDebito4=$fila->TDebito4;
				$TDFolio4=$fila->TDFolio4;
				$Usuario4 = $fila->Usuario4;
			}
			$data = array(
				'ventas_IdVentas' => $ventas_IdVentas,
				'TotalDescuento' => $TotalDescuento,
				'ClienteVenta' => $ClienteVenta,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'Fecha4' => $Fecha4,
				'Contado4' => $Contado4,
				'TCredito4' => $TCredito4,
				'TCFolio4' => $TCFolio4,
				'TDebito4' => $TDebito4,
				'TDFolio4' => $TDFolio4,
				'Usuario4' => $Usuario4,
			);
		}else{
				$data ='';
				return FALSE;	
		}
		$data['ReUsuario']=$this->pagosA_model->BuscarUsuario();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('pagos/administrador/editarPago4_view', $data);
		$this->load->view('layout/footer');
		}
	}
}