<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class ClientesR extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Clientes_model');
		$this->load->library(array('session','form_validation')); 
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal clientes_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
 
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReFecha']=$this->Clientes_model->BuscarFecha();
		$this->load->view('reportes/Franquiciatario/MenuClientes',$data);
		$this->load->view('layout/footer');
		}
	}
	
	public function buscarporfecha()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('clientes','FechaCreacion = FechaCreacion','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Clientes_model->buscarporfecha(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarClientes_view',$data);
		$data['ReFecha']=$this->Clientes_model->BuscarFecha();
		$this->load->view('layout/footer');
		}
	}

	public function buscar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarClientes_view',$data);
		$data['ReFecha']=$this->Clientes_model->BuscarFecha();
		$this->load->view('layout/footer');
	}
}