<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Administrador general)
class ProductoR extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Productos_Model');
		$this->load->library(array('session','form_validation'));
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaProductoAdicionalA_view 
	//Hace la consulta para mostrar todos los productos adicionales
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {	
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$data['ReCat']=$this->Productos_Model->BuscarCategoria();
		$this->load->view('reportes/Franquiciatario/MenuProducto',$data);
		$this->load->view('layout/footer');
		}
	}
	//Función que manda a traer la vista buscarProductos_view 
	//Hace la busqueda del producto seleccionado
	public function buscarportipo()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
			$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Productos_Model->buscarportipo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarProducto_view',$data);
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$this->load->view('layout/footer');
		}
	}

	public function buscarporcategoria()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Productos_Model->buscarporcategoria(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarProducto_view',$data);
		$data['ReCat']=$this->Productos_Model->BuscarCategoria();
		$this->load->view('layout/footer');
		}
	}

	public function buscar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarProducto_view',$data);
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$data['ReCat']=$this->Productos_Model->BuscarCategoria();
		$this->load->view('layout/footer');
	}
}