<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RClientes extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Clientes_Model');
    //cargamos la libreria DOMPDF previamente se debe realizar el archivo MydomPDF para la conexion del la libreria y el controlador.
    $this->load->library('mydompdf');
		$this->load->library(array('session','form_validation')); 
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal FranquiciasR_view
	public function index()
  {
		if($this->session->userdata('Rol_IdRol')==FALSE || 
      $this->session->userdata('Rol_IdRol') == '1'|| 
      $this->session->userdata('Rol_IdRol') == '3')
    {
      redirect(base_url().'acceso/acceso');
    } else {
    $data['Franquicias']=$this->Clientes_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
    $this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('clientes')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
	  $this->load->view('reportes/Franquiciatario/Clientes_view',$data);
		$this->load->view('layout/footer');
	 }
  }

	//creacion del reporte general de Usuarios
  public function ReporteGClientes()
  {
    if($this->session->userdata('Rol_IdRol')==FALSE || 
      $this->session->userdata('Rol_IdRol') == '1'|| 
      $this->session->userdata('Rol_IdRol') == '3')
    {
      redirect(base_url().'acceso/acceso');
    } else {
      $data['Franquicias']=$this->Clientes_Model->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
      $this->db->select('*');
      $this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
      $this->db->where('Franquicias_IdFranquicias',$i);
      $data['consulta']=$this->db->get('clientes')->result();
      $this->load->view('layout/headerFran');
      $this->load->view('layout/menuFranquicia'); 
      $html=($this->load->view('reportes/Franquiciatario/ReporteGClientes', $data, true));
      $this->mydompdf->load_html($html);  
      $this->mydompdf->set_paper('a4', 'landscape'); 
      $this->mydompdf->render();
      $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      $this->mydompdf->stream("Reporte General de Clientes.pdf", array("Attachment" => false));
      $this->load->view('layout/footer');
    }
  }

  public function buscar()
  {
		if($this->session->userdata('Rol_IdRol')==FALSE || 
      $this->session->userdata('Rol_IdRol') == '1'|| 
      $this->session->userdata('Rol_IdRol') == '3')
    {
      redirect(base_url().'acceso/acceso');
    } else {
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarClientes_view',$data);
		$data['ReFecha']=$this->Clientes_Model->BuscarFecha();
		$this->load->view('layout/footer');
	}
      
  public function BuscarFranquicia()
  {
     $this->db->select('*');
     $this->db->from('clientes');
     $this->db->join('Franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdClientes',$this->session->userdata('IdClientes'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
  }
}