<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RProductos extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Productos_Model');
		$this->load->library(array('session','form_validation')); 
		$this->load->library('mydompdf');
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal FranquiciasR_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->Productos_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
    	$this->db->select('*');
     	$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     	$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
     	$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
     	$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
     	$this->db->where('Franquicias_IdFranquicias',$i);
	    $data['consulta']=$this->db->get('productosfranquicias')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$data['ReCat']=$this->Productos_Model-> BuscarCategoria();
		$this->load->view('reportes/Franquiciatario/Productos_view',$data);
		$this->load->view('layout/footer');
    	}
	}

	public function ReportePGeneral()
	{
     	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->Productos_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
    	$this->db->select('*');
     	$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     	$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
     	$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
     	$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
     	$this->db->where('Franquicias_IdFranquicias',$i);
	    $data['consulta']=$this->db->get('productosfranquicias')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$data['ReCat']=$this->Productos_Model-> BuscarCategoria();
		$html=($this->load->view('reportes/Franquiciatario/ReporteProG', $data, true));
    	$this->mydompdf->load_html($html);	
    	$this->mydompdf->set_paper('a4', 'landscape'); 
   		$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("Reporte General de Productos.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
 		}
	}

	public function buscarportipo()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->Productos_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
       $this->db->select('*');
	   $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
			$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
			$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);	
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Productos_Model->buscarportipo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
	// 	$html=($this->load->view('reportes/Franquiciatario/ReportePorTipoF', $data, true));
 //    	$this->mydompdf->load_html($html);	
 //    	$this->mydompdf->set_paper('a4', 'landscape'); 
 //   		$this->mydompdf->render();
	//     $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
 //    	$this->mydompdf->stream("Reporte de Productos Por Tipo producto.pdf", array("Attachment" => false));
	// 	$this->load->view('layout/footer');
	 	}
 	}

	public function buscarporcategoria()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->Productos_Model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
			$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
			$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
			$this->db->where('Franquicias_IdFranquicias',$i);
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Productos_Model->buscarporcategoria(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReCat']=$this->Productos_Model->BuscarCategoria();
		$html=($this->load->view('reportes/Franquiciatario/ReportePorCatF', $data, true));
    	$this->mydompdf->load_html($html);	
    	$this->mydompdf->set_paper('a4', 'landscape'); 
   		$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("Reporte de Productos por Categoria.pdf", array("Attachment" => false));
		$this->load->view('layout/footer');
		}
  	}

	public function buscar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarProducto_view',$data);
		$data['ReTipo']=$this->Productos_Model->BuscarTipo();
		$data['ReCat']=$this->Productos_Model->BuscarCategoria();
		$this->load->view('layout/footer');
	}
 }