<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class ReporteGastos extends CI_Controller
{
	public function __construct(){
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/ReporteGastos_Model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper('url'); 
	}

	public function index(){ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('reportes/Franquiciatario/ReporteGastosView');	
			$this->load->view('layout/footer');
		}

	}

	public function reporteGastosTotales(){
		//	sleep(3);
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->ReporteGastos_Model->reporteGastosTotales($inicio,$fin);
		//$query2 = $this->ReporteGastos_Model->ingresosDesglosados($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){ 
			foreach($query['F2']->result() as $pago) {
				$data[] = array(
					$pago->FechaCreacion,
					$pago->Tipo,
					$pago->NombreGasto,	
					$pago->Cantidad,
					$pago->Precio,
					$pago->Total,
					$pago->NombreUsuario,
				);
			}	
		}
		echo json_encode($data);
	}	


	public function reporteGastosPorTipo(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$tipo = $this->input->post('tipo');
		$query= $this->ReporteGastos_Model->reporteGastosPorTipo($inicio,$fin, $tipo);
		$data = [];

		if(count($query['F2']->result()) != null ){ 
			foreach($query['F2']->result() as $pago) {
				$data[] = array(
					$pago->FechaCreacion,
					$pago->Tipo,
					$pago->NombreGasto,	
					$pago->Cantidad,
					$pago->Precio,
					$pago->Total,
					$pago->NombreUsuario,
				);
			}	
		}
		echo json_encode($data);
	}	

	/*public function reportePagosPromociones(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->ReporteGastos_Model->reportePagosPromociones($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){ 
			foreach($query['F2']->result() as $pago) {
				$data[] = array(
					$pago->FechaCreacion,
					$pago->Tipo,
					$pago->nombreGasto,	
					$pago->Cantidad,
					$pago->Precio,
					$pago->Total,
					$pago->NombreUsuario,
				);
			}	
		}
		echo json_encode($data);

	}*/
}