<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class ReportePagos extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/ReportesPagos_Model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper('url'); 
	}

	public function index()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('reportes/Franquiciatario/ReportePagos');	
			$this->load->view('layout/footer');
		}

	}

	public function reportePagosServicios(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->ReportesPagos_Model->reportePagosServicios($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){
			foreach($query['F2']->result() as $pago) {
				$data[] = array(
					$pago->folio2,
					$pago->FolioVenta2,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					$pago->SesionesS,
					$pago->Fecha2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$pago->TipoTarjeta2,
				);
			}	
		}


		if(count($query['F3']->result()) != null ){
			foreach($query['F3']->result() as $pago) {
				$data[] = array(
					$pago->folio3,
					$pago->FolioVenta3,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					$pago->SesionesS,
					$pago->Fecha3,
					$pago->Contado3,
					$pago->CTarjeta3,
					$pago->TipoTarjeta3,

				);
			}
		}


		if(count($query['F4']->result()) != null ){
			foreach($query['F4']->result() as $pago) {
				$data[] = array(
					$pago->folio4,
					$pago->FolioVenta4,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					$pago->SesionesS,
					$pago->Fecha4,
					$pago->Contado4,
					$pago->CTarjeta4,
					$pago->TipoTarjeta4,

				);
			}
		}
		if(count($query['F2G']->result()) != null ){
			foreach($query['F2G']->result() as $pago) {
				$data[] = array(
					$pago->folio2,
					$pago->FolioVenta2,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					$pago->SesionesS,
					$pago->Fecha2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$pago->TipoTarjeta2,

				);
			}	
		}
		if(count($query['F3G']->result()) != null ){
			foreach($query['F3G']->result() as $pago) {
				$data[] = array(
					$pago->folio3,
					$pago->FolioVenta3,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					$pago->SesionesS,
					$pago->Fecha3,
					$pago->Contado3,
					$pago->CTarjeta3,
					$pago->TipoTarjeta3,

				);
			}	
		}
		if(count($query['F4G']->result()) != null ){
			foreach($query['F4G']->result() as $pago) {
				$data[] = array(
					$pago->folio4,
					$pago->FolioVenta4,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					$pago->SesionesS,
					$pago->Fecha4,
					$pago->Contado4,
					$pago->CTarjeta4,
					$pago->TipoTarjeta4,

				);
			}	
		}
		echo json_encode($data);

	}	



	public function reportePagosPromociones(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->ReportesPagos_Model->reportePagosPromociones($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){
			foreach($query['F2']->result() as $pago) {
				$data[] = array(
					$pago->folio2,
					$pago->FolioVenta2,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombrePromocion,
					$pago->SesionesPr,
					$pago->Fecha2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$pago->TipoTarjeta2,

				);
			}	
		}


		if(count($query['F3']->result()) != null ){
			foreach($query['F3']->result() as $pago) {
				$data[] = array(
					$pago->folio3,
					$pago->FolioVenta3,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombrePromocion,
					$pago->SesionesPr,
					$pago->Fecha3,
					$pago->Contado3,
					$pago->CTarjeta3,
					$pago->TipoTarjeta3,

				);
			}
		}


		if(count($query['F4']->result()) != null ){
			foreach($query['F4']->result() as $pago) {
				$data[] = array(
					$pago->folio4,
					$pago->FolioVenta4,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombrePromocion,
					$pago->SesionesPr,
					$pago->Fecha4,
					$pago->Contado4,
					$pago->CTarjeta4,
					$pago->TipoTarjeta4,
				);
			}
		}

		echo json_encode($data);

	}


	public function reportePagosProductos(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->ReportesPagos_Model->reportePagosProductos($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){
			foreach($query['F2']->result() as $pago) {
				$tarjeta = $pago->TipoTarjeta2;
					if( $tarjeta == 1){
						$tarjeta = "TARJETA DE CRÉDITO";
					}
					else if($tarjeta == 2){
						$tarjeta= "TARJETA DE DÉBITO";
					}
					else {
						$tarjeta = "";
					}
				$data[] = array(
					$pago->folio2,
					$pago->FolioVenta2,
					date("d-m-Y", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreProducto,
					$pago->PiezasP,
					$pago->Fecha2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$tarjeta,
				);
			}	
		}


		/*if(count($query['F3']->result()) != null ){
			foreach($query['F3']->result() as $pago) {
				$data[] = array(
					$pago->IdVentas,
					$pago->FechaVenta,		
					$pago->ClienteVenta,
					$pago->NombreProducto,
					$pago->Fecha3,
					$pago->Contado3,
					$pago->CTarjeta3,

				);
			}
		}


		if(count($query['F4']->result()) != null ){
			foreach($query['F4']->result() as $pago) {
				$data[] = array(
					$pago->IdVentas,
					$pago->FechaVenta,		
					$pago->ClienteVenta,
					$pago->NombreProducto,
					$pago->Fecha4,
					$pago->Contado4,
					$pago->CTarjeta4,

				);
			}
		}*/
		echo json_encode($data);
/*		echo json_encode($query['F2']->result());
*/
	}
}