<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Administrador general)
class ServiciosAdicionalesA extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('servicios/Administrador/serviciosAdicionalesA_model');
		$this->load->library(array('session','form_validation'));
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaServiciosAdicionales y hace la consulta para mostrar todos los servicios adicionales
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio=IdTipoServicio','inner');
		$this->db->where('TipoServicio_IdTipoServicio','1');
		//$this->db->order_by("Franquicias_IdFranquicias","asc");
		$data['consulta']=$this->db->get('serviciosfranquicias')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('servicios/Administrador/listaServiciosAdicionales',$data);
		$this->load->view('layout/footer'); 
		} 
	}

		//Funcion que manda a traer la vista agregaServicioAdicionalA_view para registrar el servicio adicional
	public function agregar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$datos['ReModelo']=$this->serviciosAdicionalesA_model->BuscarModelo();
		$datos['ReTipoS']=$this->serviciosAdicionalesA_model->BuscarTipoS();
	    $datos['ReCategoria']=$this->serviciosAdicionalesA_model->BuscarCategoria();
	    //$datos['ReZona']=$this->serviciosAdicionalesA_model->BuscarZona($datos);
	    $datos['ReFranquicias']=$this->serviciosAdicionalesA_model->BuscarFranquicia();
  		$datos['ReUsuario']=$this->serviciosAdicionalesA_model->BuscarUsuario();
		$this->load->view('servicios/Administrador/agregaServicioAdicionalA_view',$datos);
		$this->load->view('layout/footer');
		}
	}
	
	//Funcion que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar()
	{
		$parametro['Codigo_Servicios']= "SA".$this->input->post('Franquicia').$parametro['txt_id']= $this->input->post('txt_id');
		$parametro['Modelo_IdModelo']= $this->input->post('Modelo');
		$parametro['NombreServicio']= "SA-".$this->input->post('txt_nombre')." ".$parametro['SesionesServicio']=$this->input->post('txt_sesiones')." "."SESIONES";
		$parametro['TipoServicio_IdTipoServicio']= $this->input->post('TipoS');
		$parametro['Categoria_IdCategoria']= $this->input->post('Categoria');
		$parametro['PreciosServicio']=$this->input->post('text_precio');
		$parametro['DuracionServicio']= $this->input->post('txt_minutos');
		$parametro['SesionesServicio']= $this->input->post('txt_sesiones');
		$parametro['DescripcionServicio']= $this->input->post('text_descripcion');
		$parametro['ObservacionesServicio']=$this->input->post('text_observaciones');
		 $parametro['ClasificacionServicio'] = $this->input->post('Clasificacion');
		$parametro['Zona_IdZona']=$this->input->post('Zona');

		$servicio=$this->db->insert_id();
		
		$parametro['IdServiciosFranquicias']= "FMAS".$this->input->post('Franquicia').$parametro['txt_id']= $this->input->post('txt_id');
		$parametro['ServiciosGenerales_IdServiciosGenerales']= $this->input->post($servicio);
		$parametro['Franquicias_IdFranquicias']=$this->input->post('Franquicia');
		$parametro['Usuarios_IdUsuarios']=$this->input->post('Usuario');
		$this->serviciosAdicionalesA_model->GuardarServicioG($parametro);	
	}

	//Función que manda a traer la vista buscarServiciosAdicionales_view y hace la busqueda del servicio seleccionado 
	public function buscar ()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->serviciosAdicionalesA_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,					
				);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('servicios/Administrador/buscarServiciosAdicionales_view', $data);
		$this->load->view('layout/footer');
	}
	
	//Función que manda a traer la vista editarServiAdicional_view con los datos del servicio seleccionado
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->serviciosAdicionalesA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdServiciosGenerales=$fila->IdServiciosGenerales;
				$Codigo_Servicios=$fila->Codigo_Servicios;
				$Modelo_IdModelo=$fila->Modelo_IdModelo;
				$NombreServicio = $fila->NombreServicio;
				$TipoServicio_IdTipoServicio=$fila->TipoServicio_IdTipoServicio;
				$Categoria_IdCategoria=$fila->Categoria_IdCategoria;
				$PreciosServicio=$fila->PreciosServicio;
				$DescripcionServicio=$fila->DescripcionServicio;
				$ObservacionesServicio=$fila->ObservacionesServicio;
				$Zona_IdZona=$fila->Zona_IdZona;
				$ClasificacionServicio = $fila->ClasificacionServicio;
				$DuracionServicio = $fila->DuracionServicio;
			}
			$data = array(
				'IdServiciosGenerales'=>$IdServiciosGenerales,
				'Codigo_Servicios' => $Codigo_Servicios,
				'Modelo_IdModelo' => $Modelo_IdModelo,
				'NombreServicio' => $NombreServicio,
				'TipoServicio_IdTipoServicio' => $TipoServicio_IdTipoServicio,
				'Categoria_IdCategoria' => $Categoria_IdCategoria,	
				'PreciosServicio' => $PreciosServicio,
			    'DescripcionServicio' => $DescripcionServicio,
			    'ObservacionesServicio' => $ObservacionesServicio,
			    'ClasificacionServicio' => $ClasificacionServicio,
			    'Zona_IdZona' => $Zona_IdZona,
				'DuracionServicio'=>$DuracionServicio
			);
				
			}else{
				$data ='';
				return FALSE;	
			}
		$data['ReModelo']=$this->serviciosAdicionalesA_model->BuscarModelo();
		$data['ReTipoS']=$this->serviciosAdicionalesA_model->BuscarTipoS();
	    $data['ReCategoria']=$this->serviciosAdicionalesA_model->BuscarCategoria();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('servicios/Administrador/editarServiAdicional_view',$data);
		$this->load->view('layout/footer');
		}
	}


	//Función que guarda los datos actualizados del servicio
	public function editarenlace ()
	{
		$IdServiciosGenerales= $this -> uri->segment(5);
		$data=array(
			'IdServiciosGenerales' => $this ->input ->post('IdServiciosGenerales', true),
			'Codigo_Servicios' => $this ->input ->post('Codigo_Servicios', true),
			'Modelo_IdModelo' => $this ->input ->post('Modelo_IdModelo', true),
			'NombreServicio' => $this ->input ->post('NombreServicio', true),
			'DuracionServicio' => $this->input->post('txt_minutos', true),
			'TipoServicio_IdTipoServicio' => $this ->input->post('TipoServicio_IdTipoServicio', true),
			'Categoria_IdCategoria' => $this ->input->post('Categoria_IdCategoria', true),
			'PreciosServicio' => $this ->input ->post('PreciosServicio', true),
			'DescripcionServicio' => $this ->input->post('DescripcionServicio', true),
			'ClasificacionServicio' => $this ->input->post('ClasificacionServicio', true),
			'ObservacionesServicio' => $this ->input ->post('ObservacionesServicio', true)
			);
		$this->serviciosAdicionalesA_model->editarenlace($IdServiciosGenerales, $data);
	}

	//Función que elimina al servicio
	public function eliminar() 
	{
		 $id= $this->uri->segment(5);
		 $this->serviciosAdicionalesA_model->eliminar($id);
		 redirect('servicios/Administrador/serviciosAdicionalesA');
	}

	//Funcion que muestra la zona
	public function MostrarZona()
	{
		$options ="";
		$IdFranquicias=$this->input->post('IdFranquicias');
		if($IdFranquicias){
			$this->load->model('serviciosAdicionalesA_model');
			$zonas=$this->serviciosAdicionalesA_model->BuscarZona($IdFranquicias);
			foreach ($zonas as $zona) {

				echo "<option value='".$zona['Zona_IdZona']."'>".$zona['NombreZona']."</option>";
			}
		}
	}
	
}
