<?php
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Cosmetólogo)
class ServiciosAdicionalesC extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('servicios/Cosmetologo/serviciosAdicionalesC_model');
		$this->load->library(array('session','form_validation'));
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaServiciosAdicionales
	//Hace la consulta para mostrar todos los servicios adicionales que esten registrados en la franquicia del usuario logueado
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->serviciosAdicionalesC_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','join');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio=IdTipoServicio','join');	
		$this->db->where("(TipoServicio_IdTipoServicio = '1' OR TipoServicio_IdTipoServicio = '4')");
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('serviciosfranquicias')->result();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('servicios/Cosmetologo/listaServiciosAdicionales',$data);
		$this->load->view('layout/footer');
		}
	}



	//Función que manda a traer la vista editarServiAdicional_view y muestra los datos del servicio adicional
	public function VerInformacion()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->serviciosAdicionalesC_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdServiciosFranquicias=$fila->IdServiciosFranquicias;
				$Modelo_IdModelo=$fila->Modelo_IdModelo;
				$NombreServicio = $fila->NombreServicio;
				$TipoServicio_IdTipoServicio=$fila->TipoServicio_IdTipoServicio;
				$Categoria_IdCategoria=$fila->Categoria_IdCategoria;
				$SesionesServicio=$fila->SesionesServicio;
				$PreciosServicio=$fila->PreciosServicio;
				$DescripcionServicio=$fila->DescripcionServicio;
				$ObservacionesServicio=$fila->ObservacionesServicio;
				$Zona_IdZona=$fila->Zona_IdZona;
			}
			$data = array(
				'IdServiciosFranquicias' => $IdServiciosFranquicias,
				'Modelo_IdModelo' => $Modelo_IdModelo,
				'NombreServicio' => $NombreServicio,
				'TipoServicio_IdTipoServicio' => $TipoServicio_IdTipoServicio,
				'Categoria_IdCategoria' => $Categoria_IdCategoria,	
				'SesionesServicio' => $SesionesServicio,
				'PreciosServicio' => $PreciosServicio,
			    'DescripcionServicio' => $DescripcionServicio,
			    'ObservacionesServicio' => $ObservacionesServicio,
			    'Zona_IdZona' => $Zona_IdZona);
			}else{
				$data ='';
				return FALSE;
			}
		$data['ReModelo']=$this->serviciosAdicionalesC_model->BuscarModelo();
		$data['ReTipo']=$this->serviciosAdicionalesC_model->BuscarTipoS();
		$data['ReCategoria']=$this->serviciosAdicionalesC_model->BuscarCategoria();
		$data['ReZona']=$this->serviciosAdicionalesC_model->BuscarZona();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('servicios/Cosmetologo/editarServiAdicional_view',$data);
		$this->load->view('layout/footer');
		}
	}
	
}