<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realize sus funciones(Franquiciatario)
class UsuariosF extends CI_Controller
{ 
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct(){
		parent::__construct();
		$this->load->model('usuarios/Franquiciatario/usuariosF_model');
		$this->load->model('HAccesos/Franquiciatario/HistoricoAccesos_models');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url','form'));	
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaUsuariosF_view y hace la consulta para mostrar todos los usuarios registrados en la franquicia del usuario logueado 
	public function index()	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
   		$data['Franquicias']=$this->usuariosF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)    
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol=IdRol','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('usuarios')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('usuarios/Franquiciatario/listaUsuariosF_view',$data);
		$this->load->view('layout/footer');
		}
	}
	
	//Funcion que manda a traer la vista usuariosA_view para registrar un nuevo usuario
	public function agregar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$datos['ReFranquicias']=$this->usuariosF_model->BuscarFranquicia();
		$datos['ReRol']=$this->usuariosF_model->BuscarRol();
		$this->load->view('usuarios/Franquiciatario/agregarUsuariosF_view',$datos);
		$this->load->view('layout/footer');
		}
	}

	public function regex_string($str) { 
		if (1 !== preg_match("/^[a-zñáéíóúüA-ZÑÁÉÍÓÚÜ ,.]*$/u", $str)) { 
			$this->form_validation->set_message('regex_string', 'El campo %s no tiene un formato válido!'); 
			return FALSE; 
		} else { 
			return TRUE; } 
	}

	//Funcion que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar(){ 

		if($this->input->post()){
			$Contrasenia = $this->input->post("txt_contrasenia");
			
			if ($Contrasenia == "" || $Contrasenia == null) {
				$result['type'] = "errorPassword";
				$result['result'] = "El campo Contraseña es obligatorio.";
		        echo json_encode($result);	
			}else{
				$this->form_validation->set_rules('txtnombre_completo', 'Nombre', 'trim|required|callback_regex_string|min_length[3]|max_length[30]');
				$this->form_validation->set_rules('txtapellido_paterno', 'Apellido Paterno', 'trim|required|callback_regex_string|min_length[3]|max_length[25]');
				$this->form_validation->set_rules('txtapellido_materno', 'Apellido Materno', 'trim|required|callback_regex_string|min_length[3]|max_length[25]');
				$this->form_validation->set_rules('text_usuario', 'Usuario', 'trim|required|min_length[6]|max_length[25]|alpha_numeric|is_unique[usuarios.Usuario]');
				$this->form_validation->set_rules('txt_contrasenia', 'Contraseña', 'trim|required|max_length[20]');
				$this->form_validation->set_rules('text_fecha', 'Fecha', 'trim|required');
				$this->form_validation->set_rules('text_telefono', 'Número telefonico', 'trim|required|numeric|exact_length[10]');	
				$this->form_validation->set_rules('text_direccion', 'Dirección', 'trim|required|min_length[15]');
				$this->form_validation->set_rules('rol', 'Rol', 'trim|required');
				$this->form_validation->set_rules('Estatus', 'Estado', 'trim|required');
				$this->form_validation->set_rules('text_profesion', 'Profesión', 'trim|required|callback_regex_string');
				$this->form_validation->set_rules('franquicias', 'Franquicias', 'trim|required');

				if ($this->form_validation->run() == FALSE){						
					switch ($this->form_validation->run() == FALSE) {
						case form_error("txtnombre_completo"):
							$result['type'] = "errorNombre";
							$result['result'] = form_error("txtnombre_completo");
							echo json_encode($result);
							break;
						case form_error("txtapellido_paterno"):
							$result['type'] = "errorApellidop";
							$result['result'] = form_error("txtapellido_paterno");
							echo json_encode($result);
							break;
						case form_error("txtapellido_materno"):
							$result['type'] = "errorApellidom";
							$result['result'] = form_error("txtapellido_materno");
							echo json_encode($result);
							break;
						case form_error("text_usuario"):
							$result['type'] = "errorUsuario";
							$result['result'] = form_error("text_usuario");
							echo json_encode($result);
							break;
						case form_error("txt_contrasenia"):
							$result['type'] = "errorPassword";
							$result['result'] = form_error("txt_contrasenia");
							echo json_encode($result);
							break;
						case form_error("text_fecha"):
							$result['type'] = "errorFecha";
							$result['result'] = form_error("text_fecha");
							echo json_encode($result);
							break;
						case form_error("text_telefono"):
							$result['type'] = "errorTelefono";
							$result['result'] = form_error("text_telefono");
							echo json_encode($result);
							break;
						case form_error("text_direccion"):
							$result['type'] = "errorDireccion";
							$result['result'] = form_error("text_direccion");
							echo json_encode($result);
							break;
						case form_error("rol"):
							$result['type'] = "errorRol";
							$result['result'] = form_error("rol");
							echo json_encode($result);
							break;
						case form_error("Estatus"):
							$result['type'] = "errorEstatus";
							$result['result'] = form_error("Estatus");
							echo json_encode($result);
							break;
						case form_error("text_profesion"):
							$result['type'] = "errorProfecion";
							$result['result'] = form_error("text_profesion");
							echo json_encode($result);
							break;
						case form_error("franquicias"):
							$result['type'] = "errorFranquicias";
							$result['result'] = form_error("franquicias");
							echo json_encode($result);
							break;
						default:
							# code...
							break;
					}
				}else{
					$data = $this->input->post();
					$Nombrecompleto = $data['txtnombre_completo'];
					$Apellidop = $data['txtapellido_paterno'];
					$Apellidom = $data['txtapellido_materno'];
					$Usuario = $data['text_usuario']; 
					$Contrasenia = md5($data['txt_contrasenia']);
					$Estatus = $data['Estatus'];
					$FechaNacimiento = $data['text_fecha']; 
					$NumeroTelefonicoUsuario = $data['text_telefono']; 
					$DireccionUsuario = $data['text_direccion']; 
					$Rol_IdRol = $data['rol']; 
					$ProfesionUsuario = $data['text_profesion']; 
					$Franquicias_IdFranquicias = $data['franquicias']; 

					$id_usuario = $this->usuariosF_model->GuardarUsuario($Nombrecompleto,$Apellidop,$Apellidom,$Usuario,$Contrasenia,$Estatus,$FechaNacimiento,$NumeroTelefonicoUsuario,$DireccionUsuario,$Rol_IdRol,$ProfesionUsuario,$Franquicias_IdFranquicias);

					if ($id_usuario) {
						$result['type'] = "success";
						$result['result'] = $id_usuario;
					}else{
						$result['type'] = "error";
						$result['result'] = "error al guardar los datos";
					}			 	    	
					echo json_encode($result);	
				}                      
			}
		}else{
			$result['type'] = "error";
			$result['result'] = "error al guardar los datos";
		}
	}
	//Función que manda a traer la vista editarUsuariosA_view con los datos del usuario seleccionado
	public function editar(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['ReFranquicias']=$this->usuariosF_model->BuscarFranquicia();
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->usuariosF_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdUsuarios = $fila->IdUsuarios;
				$NombreUsuario=$fila->NombreUsuario;
				$Usuario=$fila->Usuario;
				$Contrasenia = $fila->Contrasenia;
				$Estatus = $fila->Estatus;
				$FechaNacimiento=$fila->FechaNacimiento;
				$NumeroTelefonicoUsuario=$fila->NumeroTelefonicoUsuario;
				$DireccionUsuario = $fila->DireccionUsuario;
				$Rol_IdRol= $fila->Rol_IdRol;
				$ProfesionUsuario= $fila->ProfesionUsuario;
				$Franquicias_IdFranquicias=$fila->Franquicias_IdFranquicias;
			}
			$data = array(
				'IdUsuarios' => $IdUsuarios,
				'NombreUsuario' => $NombreUsuario,
				'Usuario' => $Usuario,
				'Contrasenia' => $Contrasenia,
				'Estatus' => $Estatus,
				'FechaNacimiento' => $FechaNacimiento,
				'NumeroTelefonicoUsuario' => $NumeroTelefonicoUsuario,
				'DireccionUsuario' => $DireccionUsuario,
				'Rol_IdRol' => $Rol_IdRol,
				'ProfesionUsuario' => $ProfesionUsuario,
				'Franquicias_IdFranquicias' => $Franquicias_IdFranquicias);
			}else{
				$data ='';
				return FALSE;	
		}
		$data['ReFranquicias']=$this->usuariosF_model->BuscarFranquicia();
		$data['ReRol']=$this->usuariosF_model->BuscarRol();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('usuarios/Franquiciatario/editarUsuariosF_view', $data);
		$this->load->view('layout/footer');
		}
	}

	//Función que guarda los datos actualizados del usuario
	public function editarenlace($id, $f1){
		if($this->input->post()){
			if($this->input->post("Contrasenia")){
				if(ctype_space($this->input->post("Contrasenia"))){//if ($this->input->post("Contrasenia") == "" || $this->input->post("Contrasenia") == null) {
					$result['type'] = "errorPassword";
					$result['result'] = "Formato de Contraseña invalidooooooo.";
					echo json_encode($result);	
					exit();
				}else{
					$this->form_validation->set_rules('Contrasenia', 'Contraseña', 'trim|max_length[20]');
				}
			}
			$this->form_validation->set_rules('FechaNacimiento', 'Fecha', 'trim|required');
			$this->form_validation->set_rules('NumeroTelefonicoUsuario', 'Número telefonico', 'trim|required|numeric|exact_length[10]');	
			$this->form_validation->set_rules('DireccionUsuario', 'Dirección', 'trim|required|min_length[15]');
			$this->form_validation->set_rules('Rol_IdRol', 'Rol', 'trim|required');
			$this->form_validation->set_rules('Estatus', 'Estado', 'trim|required');
			$this->form_validation->set_rules('ProfesionUsuario', 'Profesión', 'trim|required|callback_regex_string');
			
			if ($this->form_validation->run() == FALSE){						
				switch ($this->form_validation->run() == FALSE) {
					case form_error("Contrasenia"):
						$result['type'] = "errorPassword";
						$result['result'] = form_error("Contrasenia");
						echo json_encode($result);
						break;
					case form_error("FechaNacimiento"):
						$result['type'] = "errorFecha";
						$result['result'] = form_error("FechaNacimiento");
						echo json_encode($result);
						break;
					case form_error("NumeroTelefonicoUsuario"):
						$result['type'] = "errorTelefono";
						$result['result'] = form_error("NumeroTelefonicoUsuario");
						echo json_encode($result);
						break;
					case form_error("DireccionUsuario"):
						$result['type'] = "errorDireccion";
						$result['result'] = form_error("DireccionUsuario");
						echo json_encode($result);
						break;
					case form_error("Rol_IdRol"):
						$result['type'] = "errorRol";
						$result['result'] = form_error("Rol_IdRol");
						echo json_encode($result);
						break;
					case form_error("Estatus"):
						$result['type'] = "errorEstatus";
						$result['result'] = form_error("Estatus");
						echo json_encode($result);
						break;
					case form_error("ProfesionUsuario"):
						$result['type'] = "errorProfecion";
						$result['result'] = form_error("ProfesionUsuario");
						echo json_encode($result);
						break;
					default:
						# code...
						break;
				}
			}else{
				$data = $this->input->post();
				$Clave = '00000';
				if($this->input->post("Contrasenia")){
					$Clave = md5($data['Contrasenia']);
				}else{
					$Clave = null;
				}
				$Estatus = $data['Estatus'];
				$FechaNacimiento = $data['FechaNacimiento']; 
				$NumeroTelefonicoUsuario = $data['NumeroTelefonicoUsuario']; 
				$DireccionUsuario = $data['DireccionUsuario']; 
				$Rol_IdRol = $data['Rol_IdRol']; 
				$ProfesionUsuario = $data['ProfesionUsuario']; 
				if ($Clave != null) {
					$response = $this->usuariosF_model->editarenlace($id,$Clave,$Estatus,$FechaNacimiento,$NumeroTelefonicoUsuario,$DireccionUsuario,$Rol_IdRol,$ProfesionUsuario);
					if($id == $this->session->userdata('IdUsuarios')){
						$idA = $this->session->userdata('IdAcceso');
						$salida = str_replace('%20', ' ', $f1);
						$res = $this->HistoricoAccesos_models->updateRegistro($idA, $salida);
						    
						$this->session->sess_destroy();
					}
				}else{
					$response = $this->usuariosF_model->editarenlace($id,null,$Estatus,$FechaNacimiento,$NumeroTelefonicoUsuario,$DireccionUsuario,$Rol_IdRol,$ProfesionUsuario);
				}
					if ($response) {
						$result['type'] = "success";
						$result['result'] = $response;
						echo json_encode($result);
						exit();
					}else{
						$result['type'] = "error";
						$result['result'] = "error al guardar los datos";
						echo json_encode($result);
						exit();
					}	
				exit();
				if($this->input->post("Contrasenia")){
					
				}else{
					$response2 = $this->usuariosF_model->editarenlace($id,null,$Estatus,$FechaNacimiento,$NumeroTelefonicoUsuario,$DireccionUsuario,$Rol_IdRol,$ProfesionUsuario);
					if ($response2) {
						$result['type'] = "success";
						$result['result'] = $response2;
						echo json_encode($result);
						exit();
					}else{
						$result['type'] = "error";
						$result['result'] = "error al guardar los datossss".$response2;
						echo json_encode($result);
						exit();
					}	
				}		 	    	
				echo json_encode($result);	
			} 
			exit();
			if($this->input->post("Contrasenia")){
				if(ctype_space($this->input->post("Contrasenia"))){//if ($this->input->post("Contrasenia") == "" || $this->input->post("Contrasenia") == null) {
					$result['type'] = "errorPassword";
					$result['result'] = "Formato de Contraseña invalido.";
					echo json_encode($result);	
				}else if(!ctype_space($this->input->post("Contrasenia"))){
					$this->form_validation->set_rules('Contrasenia', 'Contraseña', 'trim|max_length[20]');
					$this->form_validation->set_rules('FechaNacimiento', 'Fecha', 'trim|required');
					$this->form_validation->set_rules('NumeroTelefonicoUsuario', 'Número telefonico', 'trim|required|numeric|exact_length[10]');	
					$this->form_validation->set_rules('DireccionUsuario', 'Dirección', 'trim|required|min_length[15]');
					$this->form_validation->set_rules('Rol_IdRol', 'Rol', 'trim|required');
					$this->form_validation->set_rules('Estatus', 'Estado', 'trim|required');
					$this->form_validation->set_rules('ProfesionUsuario', 'Profesión', 'trim|required|callback_regex_string');
					
					if ($this->form_validation->run() == FALSE){						
						switch ($this->form_validation->run() == FALSE) {
							case form_error("Contrasenia"):
								$result['type'] = "errorPassword";
								$result['result'] = form_error("Contrasenia");
								echo json_encode($result);
								break;
							case form_error("FechaNacimiento"):
								$result['type'] = "errorFecha";
								$result['result'] = form_error("FechaNacimiento");
								echo json_encode($result);
								break;
							case form_error("NumeroTelefonicoUsuario"):
								$result['type'] = "errorTelefono";
								$result['result'] = form_error("NumeroTelefonicoUsuario");
								echo json_encode($result);
								break;
							case form_error("DireccionUsuario"):
								$result['type'] = "errorDireccion";
								$result['result'] = form_error("DireccionUsuario");
								echo json_encode($result);
								break;
							case form_error("Rol_IdRol"):
								$result['type'] = "errorRol";
								$result['result'] = form_error("Rol_IdRol");
								echo json_encode($result);
								break;
							case form_error("Estatus"):
								$result['type'] = "errorEstatus";
								$result['result'] = form_error("Estatus");
								echo json_encode($result);
								break;
							case form_error("ProfesionUsuario"):
								$result['type'] = "errorProfecion";
								$result['result'] = form_error("ProfesionUsuario");
								echo json_encode($result);
								break;
							default:
								# code...
								break;
						}
					}else{
						$data = $this->input->post();
						$Contrasenia = md5($data['Contrasenia']);
						$Estatus = $data['Estatus'];
						$FechaNacimiento = $data['FechaNacimiento']; 
						$NumeroTelefonicoUsuario = $data['NumeroTelefonicoUsuario']; 
						$DireccionUsuario = $data['DireccionUsuario']; 
						$Rol_IdRol = $data['Rol_IdRol']; 
						$ProfesionUsuario = $data['ProfesionUsuario']; 
						
						$response = $this->usuariosF_model->editarenlace($id,$Contrasenia,$Estatus,$FechaNacimiento,$NumeroTelefonicoUsuario,$DireccionUsuario,$Rol_IdRol,$ProfesionUsuario);

						if ($response) {
							$result['type'] = "success";
							$result['result'] = $response;
						}else{
							$result['type'] = "error";
							$result['result'] = "error al guardar los datos";
						}			 	    	
						echo json_encode($result);	
					} 
				}
			}else{
				$this->form_validation->set_rules('FechaNacimiento', 'Fecha', 'trim|required');
				$this->form_validation->set_rules('NumeroTelefonicoUsuario', 'Número telefonico', 'trim|required|numeric|exact_length[10]');	
				$this->form_validation->set_rules('DireccionUsuario', 'Dirección', 'trim|required|min_length[15]');
				$this->form_validation->set_rules('Rol_IdRol', 'Rol', 'trim|required');
				$this->form_validation->set_rules('Estatus', 'Estado', 'trim|required');
				$this->form_validation->set_rules('ProfesionUsuario', 'Profesión', 'trim|required|callback_regex_string');
				
				if ($this->form_validation->run() == FALSE){						
					switch ($this->form_validation->run() == FALSE) {
						case form_error("FechaNacimiento"):
							$result['type'] = "errorFecha";
							$result['result'] = form_error("FechaNacimiento");
							echo json_encode($result);
							break;
						case form_error("NumeroTelefonicoUsuario"):
							$result['type'] = "errorTelefono";
							$result['result'] = form_error("NumeroTelefonicoUsuario");
							echo json_encode($result);
							break;
						case form_error("DireccionUsuario"):
							$result['type'] = "errorDireccion";
							$result['result'] = form_error("DireccionUsuario");
							echo json_encode($result);
							break;
						case form_error("Rol_IdRol"):
							$result['type'] = "errorRol";
							$result['result'] = form_error("Rol_IdRol");
							echo json_encode($result);
							break;
						case form_error("Estatus"):
							$result['type'] = "errorEstatus";
							$result['result'] = form_error("Estatus");
							echo json_encode($result);
							break;
						case form_error("ProfesionUsuario"):
							$result['type'] = "errorProfecion";
							$result['result'] = form_error("ProfesionUsuario");
							echo json_encode($result);
							break;
						default:
							# code...
							break;
					}
				}else{
					$data = $this->input->post();
					$Estatus = $data['Estatus'];
					$FechaNacimiento = $data['FechaNacimiento']; 
					$NumeroTelefonicoUsuario = $data['NumeroTelefonicoUsuario']; 
					$DireccionUsuario = $data['DireccionUsuario']; 
					$Rol_IdRol = $data['Rol_IdRol']; 
					$ProfesionUsuario = $data['ProfesionUsuario']; 
					
					$response = $this->usuariosF_model->editarenlace2($id,$Estatus,$FechaNacimiento,$NumeroTelefonicoUsuario,$DireccionUsuario,$Rol_IdRol,$ProfesionUsuario);

					if ($response) {
						$result['type'] = "success";
						$result['result'] = $response;
					}else{
						$result['type'] = "error";
						$result['result'] = "error al guardar los datos";
					}			 	    	
					echo json_encode($result);	
				} 
			}
		}else{
			$result['type'] = "error";
            $result['result'] = "Error al cargar datos!";
            echo json_encode($result);
		}
		// $IdUsuarios= $this -> uri->segment(5);
		// $data['ReFranquicias']=$this->usuariosF_model->BuscarFranquicia();
		// $data=array(
		// 	'IdUsuarios' => $this ->input ->post('IdUsuarios', true),
		// 	'NombreUsuario' => $this ->input ->post('NombreUsuario', true),
		// 	'Usuario' => $this ->input ->post('Usuario', true),
		// 	'Contrasenia' =>md5($this->input->post('Contrasenia',true)),
		// 	'Estatus' => $this ->input->post('Estatus',true),
		// 	'FechaNacimiento' => $this ->input->post('FechaNacimiento', true),
		// 	'NumeroTelefonicoUsuario' => $this ->input->post('NumeroTelefonicoUsuario',true),
		// 	'Rol_IdRol' => $this ->input ->post('Rol_IdRol', true),
		// 	'DireccionUsuario' => $this ->input ->post('DireccionUsuario',true),
		// 	'ProfesionUsuario' => $this ->input ->post('ProfesionUsuario', true),
		// 	'Franquicias_IdFranquicias' => $this ->input ->post('Franquicias_IdFranquicias', true)	
		// 	);
		// 	echo $this->usuariosF_model->editarenlace($IdUsuarios, $data);
	}

	//Función que manda a traer la vista buscarUsuariosF_view y hace la busqueda del usuario seleccionado de a cuerdo a la franquicia con la que se logueo
	public function buscar()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->usuariosF_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
				);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('usuarios/Franquiciatario/buscarUsuariosF_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Función que muestra los roles 
	public function MostrarRol()
	{
		$options ="";
		if($this->input->post('IdRol')){
			$IdRol=$this->input->post('IdRol');
			$NombreRol=$this->usuariosF_model->BuscarRol($IdRol);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?=$fila-> rol ?>"><?=$fila -> nombrerol ?></option>

                <?php
			}
		}
	}

	//Muestra la franquicia registrada
	public function MostrarFranquicia()
	{
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('IdFranquicias');
			$Nombre=$this->usuariosA_model->BuscarFranquicia($IdFranquicias);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"></option>
                <?php
			}
		}
	}
}