<?php
class CajaF_models extends CI_Model { 
   //En este modelo se encuentran todas las consultas que se harán en diferentes tablas(Franquiciatario)
   public function __construct() {
      parent::__construct();
   }
   public function guardarCliente($campos)
   {
      $this->db->insert('clientes',$campos);
      $id=  $this->db->insert_id();
      $res=$this->db->affected_rows();
      if($res==1)
      {
         echo $id;
      }
   }

   public function guardar($parametro,$productosDetalle,$fecha,$hora,$servicios,$promociones,$promosIns,$folioAutoincrementable){
      $campos=array(  
         'IdVentas' => $parametro['IdVentas'],
         'FolioVenta' => $parametro['FolioVenta'],
         'franquicias_IdFranquicias' => $parametro['franquicias_IdFranquicias'],
         'ClienteVenta' => $parametro['ClienteVenta'],
         'IdCliente' => $parametro['IdCliente'],
         'FechaVenta' => $parametro['FechaVenta'],
         'Subtotal' => $parametro['Subtotal'],
         'Iva' => $parametro['Iva'],
         'TotalVenta' => $parametro['TotalVenta'],
         'TotalVentaGeneral' => $parametro['TotalVentaGeneral'],
         'VendedorUsuario' => $parametro['VendedorUsuario'],
         'Comentario' => $parametro['Comentario'],
         'AbonoVenta' => $parametro['AbonoVenta'],
         'AdeudoVenta' => $parametro['AdeudoVenta'],
         'Contado' => $parametro['Contado'],
         'TipoPagoUno' => $parametro['TipoPagoUno'],
         'CantidadTarjetaUno' => $parametro['CantidadTarjetaUno'],
         'FolioTarjetaUno' => $parametro['FolioTarjetaUno'],
         'TipoPagoDos' => $parametro['TipoPagoDos'],
         'CantidadTarjetaDos' => $parametro['CantidadTarjetaDos'],
         'FolioTarjetaDos' => $parametro['FolioTarjetaDos'],
         'UsuarioPropina' => $parametro['UsuarioPropina'],
         'TipoPagoPropina' => $parametro['TipoPagoPropina'],
         'PropinaVenta' => $parametro['PropinaVenta'],
         'CTarjetaCredPro' => $parametro['CTarjetaCredPro'],
         'FolioCredPropina' => $parametro['FolioCredPropina'],
         'CTarjetaDebPro' => $parametro['CTarjetaDebPro'],
         'FolioDebPropina' => $parametro['FolioDebPropina'],
         'TotalPropina' => $parametro['TotalPropina'],
          'UsuarioLog' => $parametro['UsuarioLog'],
          'folio' => $parametro['folio'],
          'EstatusV' => 'ACTIVA',
         
            );
         $vendedor = $campos['VendedorUsuario'];
         $idFranquicia = $campos['franquicias_IdFranquicias'];
          $this->db->insert('ventas',$campos);
          $res=$this->db->affected_rows();

          //obteniendo el id de la venta
          $id = $this->obtenerIdVenta(); 

          $nuevaHora = $this->limpia_espacios($hora);
          $fechainsercion = $fecha." ".$nuevaHora;

          //si esta vacio alguno de los arrays
          if( !empty( $productosDetalle )){
            $detalle = $this->insertarDetalleVenta($productosDetalle,$fechainsercion,$parametro['IdVentas'], $parametro['FolioVenta'], $idFranquicia,$vendedor,$folioAutoincrementable);
            /*$update =  $this->actualizarStock($productosDetalle);*/
          }
          if ( !empty( $servicios ) ) {
            $dServicios = $this->insertarDetalleServicios($servicios,$fechainsercion,$parametro['IdVentas'], $parametro['FolioVenta'], $vendedor,$folioAutoincrementable);
          }
          if( !empty( $promociones )){
            $dpromociones = $this->insertarDetallePromociones($promociones,$fechainsercion,$parametro['IdVentas'], $parametro['FolioVenta'], $vendedor,$folioAutoincrementable);
            /*var_dump($dpromociones);*/
          }
          if( !empty( $promosIns )){
            $dpromocionesIns = $this->insertarDetallePromosIns($promosIns,$fechainsercion,$parametro['IdVentas'], $parametro['FolioVenta'], $vendedor,$folioAutoincrementable);
            /*var_dump($dpromocionesIns);*/
          }       

       /* if( $detalle == 0 && $dServicios == 0 && $dpromociones == 0 && $dpromocionesIns == 0 ){*/
           /* echo "<script>alert('No se registrarón los datos solicitados');</script>";*/
          /* return true;*/
       /*  }
         else {*/
                // echo "<script>alert('Venta exitosa, Datos guardados correctamente');</script>";
                // redirect('caja/Franquiciatario/cajaF','refresh');
             /*   return false;
        }*/
        }


    public function BuscarIdFranquicia(){
         $this->db->select('*');
         $this->db->from('usuarios');
         $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
         $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
         $query=$this->db->get();
           if ($query->num_rows() > 0) { 
            foreach($query->result() as $row) 
                  return $row->IdFranquicias; }
      } 
  
     public function foliosVenta(){
        $franquicia = $this->BuscarIdFranquicia();
       $this->db->limit(1);
       $this->db->select('folio');
       $this->db->from('ventas');
       $this->db->where('franquicias_IdFranquicias',$franquicia);
       $this->db->order_by('FechaCreacion','DESC');
       $query = $this->db->get();
       if( $query->num_rows() > 0){
        return $query->result()[0]->folio;
       }
       else if ($query->num_rows() == 0){
        return 0;
       }
        else {
            return 0;
        }
        
     }   

     public function buscarAdeudos($id){
      $franquicia = $this->BuscarIdFranquicia();
      $this->db->select('*');
      $this->db->from('ventas');
      $this->db->where('Franquicias_IdFranquicias', $franquicia);
      $this->db->where('IdCliente', $id);
		$this->db->where('EstatusV', 'ACTIVA');
      $this->db->where("AdeudoVenta > 0");
      $query = $this->db->get();
      if( $query->num_rows() > 0){
         return 'adeudo';
        }
        else {
         return 0;
        }
     }
   
     public function buscarAdeudoProductos($id){
      $franquicia = $this->BuscarIdFranquicia();
      $this->db->select('*');
      $this->db->from('ventas_has_productosfranquicias');
      $this->db->join('ventas','ventas_IdVentas=IdVentas','inner');
      $this->db->join('productosfranquicias','IdProductosFranquicias=productosfranquicias_IdProductosFranquicias','inner');
      $this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
      $this->db->where('ventas.Franquicias_IdFranquicias', $franquicia);
      $this->db->where('IdCliente', $id);
		$this->db->where('EstatusV', 'ACTIVA');
      $this->db->where("Adeudo > 0");
      $query = $this->db->get();
      if( $query->num_rows() > 0){
         $i=0;
         foreach($query->result() as $fila)
         {
            $productos[$i][0]=$fila->IdVentasProductos;
            $productos[$i][1]=$fila->IdProductosFranquicias;
            $productos[$i][2]=$fila->NombreProducto;
            $productos[$i][3]=$fila->Abono;
            $productos[$i][4]=$fila->Adeudo;
            $productos[$i][5]=$fila->folio2;
            $productos[$i][6]='PROD';
            $productos[$i][7]=$fila->ventas_IdVentas;
            $productos[$i][8]=date("d-m-Y H:i:s", strtotime($fila->FechaVenta));
            $i++;
         }
         return $productos;
        }
        else {
         return FALSE;
        }
     }
     public function buscarAdeudoServiciosA($id){
      $franquicia = $this->BuscarIdFranquicia();
      $this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
      $this->db->where('EstatusV', 'ACTIVA');
      $this->db->where('ventas.IdCliente', $id);
		$this->db->where('ventas.franquicias_IdFranquicias',$franquicia);
		$this->db->where('Adeudo > 0');
      $query = $this->db->get();
      if( $query->num_rows() > 0){
         $i=0;
         foreach($query->result() as $fila)
         {
            $servicios[$i][0]=$fila->IdVentasServicios;
            $servicios[$i][1]=$fila->serviciosfranquicias_IdServiciosFranquicias;
            $servicios[$i][2]=$fila->NombreServicio;
            $servicios[$i][3]=$fila->Abono;
            $servicios[$i][4]=$fila->Adeudo;
            if(($fila->Contado2==null && $fila->CTarjeta2==null) || ($fila->Contado2==0 && $fila->CTarjeta2==0))
            {
               $servicios[$i][5]=$fila->folio2;
            }elseif (($fila->Contado3==null && $fila->CTarjeta3==null)|| ($fila->Contado3==0 && $fila->CTarjeta3==0)) {
               $servicios[$i][5]=$fila->folio3;
            }else{
               $servicios[$i][5]=$fila->folio4;
            }
            $servicios[$i][6]='SA';  
            $servicios[$i][7]=$fila->ventas_IdVentas;
            $servicios[$i][8]=date("d-m-Y H:i:s", strtotime($fila->FechaVenta));                   
            $i++;
         }
         return $servicios;
        }
        else {
         return FALSE;
        }
     }
     public function buscarAdeudoServiciosG($id){
      $franquicia = $this->BuscarIdFranquicia();
      $this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	   $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$franquicia);
      $this->db->where('EstatusV', 'ACTIVA');
      $this->db->where('ventas.IdCliente', $id);
		$this->db->where('Adeudo > 0');
      $query = $this->db->get();
      if( $query->num_rows() > 0){
         $i=0;
         foreach($query->result() as $fila)
         {
            $servicios[$i][0]=$fila->IdVentasServicios;
            $servicios[$i][1]=$fila->serviciosfranquicias_IdServiciosFranquicias;
            $servicios[$i][2]=$fila->NombreServicio;
            $servicios[$i][3]=$fila->Abono;
            $servicios[$i][4]=$fila->Adeudo;
            if(($fila->Contado2==null && $fila->CTarjeta2==null) || ($fila->Contado2==0 && $fila->CTarjeta2==0))
            {
               $servicios[$i][5]=$fila->folio2;
            }elseif(($fila->Contado3==null && $fila->CTarjeta3==null)|| ($fila->Contado3==0 && $fila->CTarjeta3==0)) {
               $servicios[$i][5]=$fila->folio3;
            }else{
               $servicios[$i][5]=$fila->folio4;
            } 
            $servicios[$i][6]='SG';
            $servicios[$i][7]=$fila->ventas_IdVentas;
            $servicios[$i][8]=date("d-m-Y H:i:s", strtotime($fila->FechaVenta));
            $i++;
         }
         return $servicios;
        }
        else {
         return FALSE;
        }
     }
     public function buscarAdeudoPromociones($id){
      $franquicia = $this->BuscarIdFranquicia();

      $this->db->select('*');
		$this->db->from('ventas_has_promociones');
		$this->db->join('promociones','IdPromociones = promociones_IdPromociones','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias', $franquicia);
		$this->db->where('EstatusV', 'ACTIVA');
		$this->db->where('Adeudo > 0');
      $this->db->where('ventas.IdCliente', $id);
      $query = $this->db->get();
      if( $query->num_rows() > 0){
         $i=0;
         foreach($query->result() as $fila)
         {
            $promociones[$i][0]=$fila->IdVentasPromociones;
            $promociones[$i][1]=$fila->FolioPromocion;
            $promociones[$i][2]=$fila->NombrePromocion;
            $promociones[$i][3]=$fila->Abono;
            $promociones[$i][4]=$fila->Adeudo;
            if(($fila->Contado2==null && $fila->CTarjeta2==null) || ($fila->Contado2==0 && $fila->CTarjeta2==0))
            {
               $promociones[$i][5]=$fila->folio2;
            }elseif(($fila->Contado3==null && $fila->CTarjeta3==null)|| ($fila->Contado3==0 && $fila->CTarjeta3==0)) {
               $promociones[$i][5]=$fila->folio3;
            }else{
               $promociones[$i][5]=$fila->folio4;
            } 
            $promociones[$i][6]='PROM';
            $promociones[$i][7]=$fila->ventas_IdVentas;
            $promociones[$i][8]=date("d-m-Y H:i:s", strtotime($fila->FechaVenta));
            $i++;
         }
         return $promociones;
        }
        else {
         return FALSE;
        }
     }
    public function insertarDetallePromosIns($promosIns,$fecha,$id,$folio,$vendedor,$folioAutoincrementable){
    $i=0;
    date_default_timezone_set("America/Mexico_City");
        $idPromo ="";
    foreach ( $promosIns as $var ) {
        //$idPromo = $this->obtenerIdPromocionIns($var[1]);
        /*echo "IDPROMO ->".$i." ->".$idPromo;
        echo "<br>";*/
        $hoy = date("Y-m-d h:i:s");                   // 2001-03-10 12:16:18 (el formato DATETIME de MySQL)
        $servicio = explode("$", (string) $var[1]."ABC");
         if ($servicio[1]==="ABC") {
               $idAgenda="";
               $conteo=(int)$var[4];
         }else{
               $idAgenda = substr($servicio[1], 0, -3);
               $conteo=(int)$var[4]-1;
         }
        
                $campos[$i]=array(  
                                 'ventas_IdVentas' => $id,
                                 'agenda_IdAgenda' => $idAgenda,
                                 'promociones_IdPromociones' =>$servicio[0],
                                 'Precio' =>( float ) $var[3],
                                 'SesionesPr' =>( int ) $var[4],
                                 'conteoDetalleVentas' =>$conteo,
                                 'SubTotalPr' =>( float ) $var[5],
                                 'DescuentoPr' => $var[6],
                                 'ComentarioDesPr' => $var[7],
                                 'exhibiciones_IdExhibiciones' =>( int ) $var[8],
                                 'Abono' =>( float ) $var[9],
                                 'Adeudo' =>( float ) $var[10],
                                 'FolioPr' =>( string ) $var[11],
                                 'FechaCreacion' => $fecha,
                                 'FechaModificacion' => $hoy,
                                 'NombreCertificadoPr' => $var[12],
                                 'TotalPagar' => $var[13],
                                 'Contado1' => $var[14],
                                 'TipoTarjeta1' => $var[15],
                                 'CTarjeta1' => $var[16],
                                 'TipoTarjeta1A' => $var[17],
                                 'CTarjeta1A' => $var[18],
                                 'Fecha1' => $fecha,
                                 'FolioVenta1'=>$folio,
                                 'Usuario1' => $vendedor,
                                 'folio' => $folioAutoincrementable,
                                 'folio2' => $folioAutoincrementable."-"."4".$var[0]."02",
                                 'folio3' => $folioAutoincrementable."-"."4".$var[0]."03",
                                 'folio4' => $folioAutoincrementable."-"."4".$var[0]."04"
                );
            $this->db->insert('ventas_has_promociones',$campos[$i]);

            $idventAg=$this->db->insert_id();
            
            if ($servicio[1]!="ABC") {
               $this->actualizaAgenda($idventAg, $idAgenda);
            }

            $res=$this->db->affected_rows();
            /*var_dump($campos[$i]);*/
            $i++;

     }
        $res=$this->db->affected_rows();
        return $res; 
    } 

    public function insertarDetallePromociones($data,$fecha,$id,$folio,$vendedor,$folioAutoincrementable){
    $i=0;
    date_default_timezone_set("America/Mexico_City");
        $idPromo ="";
    foreach ( $data as $var ) {
        //$idPromo = $this->obtenerIdPromocion($var[1]);
       /* echo "IDPROMO ->".$i." ->".$idPromo;
        echo "<br>";*/
        $hoy = date("Y-m-d h:i:s");                   // 2001-03-10 12:16:18 (el formato DATETIME de MySQL)   
        $servicio = explode("$", (string) $var[1]."ABC");
        if ($servicio[1]==="ABC") {
            $idAgenda="";
            $conteo=(int)$var[4];
         }else{
            $idAgenda = substr($servicio[1], 0, -3);
            $conteo=(int)$var[4]-1;
         }
        
                $campos[$i]=array(  
                                 'ventas_IdVentas' => $id,
                                 'agenda_IdAgenda' => $idAgenda,
                                 'promociones_IdPromociones' =>$servicio[0],
                                 'Precio' =>( float ) $var[3],
                                 'SesionesPr' =>( int ) $var[4],
                                 'conteoDetalleVentas' =>$conteo,
                                 'SubTotalPr' =>( float ) $var[5],
                                 'DescuentoPr' => $var[6],
                                 'ComentarioDesPr' => $var[7],
                                 'exhibiciones_IdExhibiciones' =>( int ) $var[8],
                                 'Abono' =>( float ) $var[9],
                                 'Adeudo' =>( float ) $var[10],
                                 'FolioPr' =>( string ) $var[11],
                                 'FechaCreacion' => $fecha,
                                 'FechaModificacion' => $hoy,                                 
                                 'NombreCertificadoPr' => $var[12],
                                 'TotalPagar' => $var[13],
                                 'Contado1' => $var[14],
                                 'TipoTarjeta1' => $var[15],
                                 'CTarjeta1' => $var[16],
                                 'TipoTarjeta1A' => $var[17],
                                 'CTarjeta1A' => $var[18],
                                 'Fecha1' => $fecha,
                                 'FolioVenta1' => $folio,
                                 'Usuario1' => $vendedor,
                                 'folio' => $folioAutoincrementable,
                                 'folio2' => $folioAutoincrementable."-"."3".$var[0]."02",
                                 'folio3' => $folioAutoincrementable."-"."3".$var[0]."03",
                                 'folio4' => $folioAutoincrementable."-"."3".$var[0]."04"
                );
            $this->db->insert('ventas_has_promociones',$campos[$i]);
            $idventAg=$this->db->insert_id();
            
            if ($servicio[1]!="ABC") {
               $this->actualizaAgenda($idventAg, $idAgenda);
            }

            $res=$this->db->affected_rows();
            /*var_dump($campos[$i]);*/
            $i++;

     }
        $res=$this->db->affected_rows();
        return $res; 
    } 
      public function BuscarCabina(){
         $i = $this->BuscarIdFranquicia();
         $this->db->select('*'); 
         $this->db->from('cabina');
         // $this->db->join('cabina','IdCabina=IdCabina','inner');
         $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
         $this->db->where('Franquicias_IdFranquicias',$i);
         //$this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
         $query=$this->db->get();
            if ($query->num_rows() > 0) { 
            foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdCabina, ENT_QUOTES)] = htmlspecialchars($row->NombreCabina, ENT_QUOTES); 
               $query->free_result(); 
               return $arrDatos; 
            }else{
   
            echo "<script>alert('No se ha encontrado niguna cabina asignada a su franquicia');
            window.location.href='".base_url()."acceso/acceso';
            </script>";      
         }
   }


    //funcion para obtener el id de la promocion
    public function obtenerIdPromocion($folio){
    $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
    foreach ($data['Franquicias'] as $i => $Franquicias) 
       $this->db->select('IdPromociones');
       $this->db->from('promociones');
       $this->db->where('FolioPromocion',$folio);
       $this->db->where('franquicias_IdFranquicias',$i);
       $query = $this->db->get();
       $res = $query->row();
       return $res->IdPromociones;
      
    }
    //funcion para obtener el id de la promocion
    public function obtenerIdPromocionIns($folio){ 
    $data['Zona']=$this->cajaF_models->BuscarZona();
    foreach ($data['Zona'] as $i => $Zona) 
       $this->db->select('IdPromociones');
       $this->db->from('promociones');
       $this->db->where('FolioPromocion',$folio);
       $this->db->where('Zona_IdZona',$i);
       $query = $this->db->get();
       $res = $query->row();
       return $res->IdPromociones;
      
    }
    //funcion para obtener el id de la venta insertada
    public function obtenerIdVenta(){
        /*$query = $this->db->query('SELECT IdVentas FROM ventas ORDER BY IdVentas LIMIT 1');*/
      /* $this->db->select('IdVentas');
       $this->db->from('ventas');
       $this->db->where('FolioPromocion',$folio);
        $row = $query->row();
        return $row->IdVentas;*/
    }

    //Funcion para fuardar el detalle de la venta
    /*public function saveDetalleVenta($datos,$fecha,$hora,$id)
    {
        
        
        return $this->insertarDetalleVenta($datos,$fechainsercion,$id);
    }*/

    public function insertarDetalleVenta($data,$fecha,$id,$folio,$idFranquicia,$vendedor,$folioAutoincrementable){
    $i=0;
    date_default_timezone_set("America/Mexico_City");
    foreach ( $data as $var ) {

        $hoy = date("Y-m-d h:i:s");                   // 2001-03-10 12:16:18 (el formato DATETIME de MySQL)
                   
                $campos[$i]=array(  
                                 'ventas_IdVentas' => $id,
                                 'productosfranquicias_IdProductosFranquicias' => $var[1],
                                 'Precio' =>( int ) $var[3],
                                 'PiezasP' =>( int ) $var[5],
                                 'SubTotalP' =>( float ) $var[6],
                                 'Descuento' =>( float ) $var[8],
                                 'ExhibicionesProducto' =>( int ) $var[10],
                                 'Abono' =>( float ) $var[11],
                                 'Adeudo' =>( float ) $var[12],
                                 'TotalPagar' =>( float ) $var[13],
                                 'ComentarioDes' => $var[9],
                                 'FechaCreacion' => $fecha,
                                 'FechaModificacion' => $hoy,
                                 'Contado1' => $var[14],
                                 'TipoTarjeta1' => $var[15],
                                 'CTarjeta1' => $var[16],
                                 'TipoTarjeta1A' => $var[17],
                                 'CTarjeta1A' => $var[18],
                                 'Fecha1' => $fecha,
                                 'FolioVenta1' =>$folio, 
                                 'Usuario1' =>$vendedor,
                                 'folio' => $folioAutoincrementable,
                                 'folio2' => $folioAutoincrementable."-"."1".$var[0]."02"
                );
            $this->db->insert('ventas_has_productosfranquicias',$campos[$i]);
            $res=$this->db->affected_rows();
            

            $numPiezasActuales = $this->piezaActualesProducto($idFranquicia,$var[1]);

            //Validamos q el adeudo sea 0 y que ademas las piezas sean mayor a cero para hacer el update del stock
            if($var[12] == 0 && $numPiezasActuales > 0){
                $this->actualizarStock($numPiezasActuales,$var[5],$hoy,$idFranquicia,$var[1]);
            }
            $i++;
     }
        $res=$this->db->affected_rows();
       /* return $res;*/
    }

    public function actualizarStock($numPiezasActuales,$piezasPedidas,$hoy,$idFranquicia,$folio){
                $data = array(
                        'PiezasTotales' =>( int )  $numPiezasActuales-$piezasPedidas,
                        'FechaModificacion' => $hoy,
                     );
                $this->db->where('Franquicias_IdFranquicias', $idFranquicia);
                $this->db->where('IdProductosFranquicias', $folio);
                $this->db->update('productosfranquicias', $data);
                $res=$this->db->affected_rows();
                return $res;
    }

    public function piezaActualesProducto($id,$folio){
        $this->db->select('PiezasTotales');
       $this->db->from('productosfranquicias');
       $this->db->where('IdProductosFranquicias',$folio);
       $this->db->where('Franquicias_IdFranquicias',$id);
       $query = $this->db->get();
       $res = $query->row();
       return $res->PiezasTotales;
    }

    public function insertarDetalleServicios($data,$fecha,$id,$folio,$vendedor,$folioAutoincrementable){
    $i=0;
    date_default_timezone_set("America/Mexico_City");
    foreach ( $data as $var ) {
        $hoy = date("Y-m-d h:i:s");  // 2001-03-10 12:16:18 (el formato DATETIME de MySQL)
        $servicio = explode("$", (string) $var[1]."ABC");
        //echo json_encode( $servicio,'$servicio');

        if ($servicio[1]==="ABC") {
            $idAgenda="";
            $conteo=(int)$var[4];
        }else{
            $idAgenda = substr($servicio[1], 0, -3);
            $conteo=(int)$var[4]-1;
        }
        
                $campos[$i]=array(  
                                 'ventas_IdVentas' => $id,
                                 'agenda_IdAgenda' => $idAgenda,
                                 'serviciosfranquicias_IdServiciosFranquicias' =>$servicio[0],
								         'serviciosfranquicias_NombreServicio' => (string) $var[2],
                                 'SesionesS' =>(int)$var[4],
                                 'conteoDetalleVentas' =>$conteo,
                                 'Precio' =>( float ) $var[3],
                                 'SubTotalS' =>( float ) $var[5],
                                 'exhibiciones_IdExhibiciones' =>( int ) $var[9],
                                 'Abono' =>( float ) $var[10],
                                 'Adeudo' =>( float ) $var[11],
                                 'DescuentoS' =>( float )  $var[7],
                                 'ComentarioDesS' => $var[8],
                                 'NombreCertificadoS' => $var[13],
                                 'TotalPagar' => $var[14],
                                 'Contado1' => $var[15],
                                 'TipoTarjeta1' => $var[16],
                                 'CTarjeta1' => $var[17],
                                 'TipoTarjeta1A' => $var[18],
                                 'CTarjeta1A' => $var[19],
                                 'FolioC' => $var[12],
                                'Fecha1' => $fecha,
                                'FolioVenta1' => $folio,
                                'Usuario1' => $vendedor,
                                'folio' => $folioAutoincrementable,
                                'folio2' => $folioAutoincrementable."-"."2".$var[0]."02",
                                'folio3' => $folioAutoincrementable."-"."2".$var[0]."03",
                                'folio4' => $folioAutoincrementable."-"."2".$var[0]."04"
                );
            /*var_dump($campos[$i]);*/
            $this->db->insert('ventas_has_serviciosfranquicias',$campos[$i]);
            $idventAg=$this->db->insert_id();
            
            if ($servicio[1]!="ABC") {
               $this->actualizaAgenda($idventAg, $idAgenda);
            }

            $res=$this->db->affected_rows();
            $i++;
     }
        $res=$this->db->affected_rows();
        return $res;
    }

    public function actualizaAgenda($idventAg, $idAgenda){
      $this->db->set('ventas_IdDetalleVenta', $idventAg);
      $this->db->where('agenda_IdAgenda', $idAgenda);
      $this->db->update('agenda');
    }

    function limpia_espacios($cadena){
    $cadena = str_replace(' ', '', $cadena);
    return $cadena;
    }

    public function BuscaCliente($id){
    $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
    foreach ($data['Franquicias'] as $i => $Franquicias) 
       $this->db->select('*');
       $this->db->where('Franquicias_IdFranquicias',$i);
       $this->db->where('IdClientes',$id);
       $this->db->order_by('NombreCliente','ASC');
       return $this->db->get('clientes')->result();
      
         }
    public function BuscarNombreCliente($nombre){
      $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias) 
         $this->db->select('*');
         $this->db->where('Franquicias_IdFranquicias',$i);
         $this->db->where('NombreCliente',$nombre);
         $query = $this->db->get('clientes');
         if ($query->num_rows() > 0) { 
            echo 2;
         }else{
            echo 1;
         }
     }
    //Consulta que busca los clientes registrados en la franquicia a la que pertenece el ususario logueado
    public function BuscarCliente($title){
    $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
    foreach ($data['Franquicias'] as $i => $Franquicias) 
       $this->db->select('*');
       $this->db->where('Franquicias_IdFranquicias',$i);
       $this->db->like('NombreCliente',$title);
       $this->db->order_by('NombreCliente','ASC');
       return $this->db->get('clientes')->result();
      
         }


   //Consulta que busca los productos registrados en la franquicia a la que pertenece el ususario logueado
    public function BuscarProducto($producto){
        
    $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
    foreach ($data['Franquicias'] as $i => $Franquicias)
       $this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
       $this->db->where("(tipoproducto_IdTipoProducto = '2' OR tipoproducto_IdTipoProducto ='3')");
       // $this->db->where('PiezasTotales >','0');
       $this->db->where('Franquicias_IdFranquicias',$i);
       $this->db->like('NombreProducto',$producto); 
       $this->db->order_by('NombreProducto',"ASC");
       return  $this->db->get('productosfranquicias')->result();
         $this->db->select('*');
        $this->db->from('serviciosfranquicias');
        $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','inner');
        $this->db->where('Franquicias_IdFranquicias',$i);
        $this->db->like('NombreServicio',$servicio);
        $this->db->order_by('NombreServicio','ASC');
        return $this->db->get()->result();

       
         }

   public function ServiciosAgendados($idClient){
      //$this->db->distinct();
      $this->db->select("*");
      $this->db->from("agenda");
      $this->db->where("Clientes_IdClientes",$idClient);
      $this->db->where("ventas_IdDetalleVenta","");
      $this->db->where("FechaCreacion>=","2022-08-05 00:00:00");
      $response = $this->db->get()->result();

      $servicioAG=array();

      foreach ($response as $row) {
         if ($row->IdAgenda === $row->agenda_IdAgenda) {
            array_push($servicioAG,$row);
         }
         /*$this->db->select("*");
         $this->db->from("agenda");
         $this->db->where("IdAgenda",$row->IdAgenda);
         $this->db->where("Clientes_IdClientes",$idClient);
         $this->db->where("ventas_IdDetalleVenta","");
         $this->db->where("agenda_IdAgenda",$row->IdAgenda);
         $this->db->where("FechaCreacion>=","2022-08-05 00:00:00");
         array_push($servicioAG,$this->db->get()->result_array());*/
         //$servicioAG=$this->db->get()->result();
      }
      return $servicioAG;
   }

   public function BuscarServicioGAG($id){
      $this->db->select("*");
      $this->db->from("serviciosgenerales");
      $this->db->where("Codigo_Servicios",$id);
      return $this->db->get()->row();
   }

   public function BuscarServicioAGF($id){
      $this->db->select("*");
      $this->db->from("serviciosfranquicias");
      $this->db->join("serviciosgenerales", 'ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','inner');
      $this->db->where("IdServiciosFranquicias",$id);
      return $this->db->get()->row();
   }

   public function BuscarPromocionesAG($id){
      $this->db->select("*");
      $this->db->from("promociones");
      $this->db->where("FolioPromocion",$id);
      return $this->db->get()->row();
   }

   //Consulta que busca los servicios registrados en la franquicia a la que pertenece el ususario logueado
   public function BuscarServicio($servicioG){
      $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
        $this->db->select('*');
        $this->db->from('serviciosfranquicias');
        $this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales=IdServiciosGenerales','inner');
        $this->db->where('Franquicias_IdFranquicias',$i);
        $this->db->like('NombreServicio',$servicioG);
        $this->db->order_by('NombreServicio','ASC');
        return $this->db->get()->result();
         }

 public function BuscarServicioG($servicioG){
    $data['Zona']=$this->cajaF_models->BuscarZona();
    foreach ($data['Zona'] as $i => $Zona) 
    $data['Modelo']=$this->cajaF_models->BuscarModelo();
    foreach ($data['Modelo'] as $j => $Modelo)

         $this->db->select('*');
         $this->db->from('serviciosgenerales');
         $this->db->where('Zona_IdZona',$i);
         $this->db->where('Modelo_IdModelo',$j);
        $this->db->WHERE("(TipoServicio_IdTipoServicio = '2' OR TipoServicio_IdTipoServicio = '3')");
        $this->db->like('NombreServicio',$servicioG);
        $this->db->order_by('NombreServicio','ASC');
        return $this->db->get()->result();

         }
//Busca promocion Institucional
    public function BuscarPromociones(){
    $data['Zona']=$this->cajaF_models->BuscarZona();
    foreach ($data['Zona'] as $a => $Zona) 
    $this->db->where('Zona_IdZona',$a);
    $this->db->where("(tipopromocion_IdTipoPromocion = '1' OR tipopromocion_IdTipoPromocion ='3')");
    $this->db->where('Estatus','ACTIVA');
    $this->db->where('ClasePromocion','Servicio');
    $this->db->order_by('NombrePromocion',"ASC");
    return $this->db->get('promociones')->result();

    }

//Busca Promociones Franquicias
         //Consulta que busca las promociones registradas en la franquicia a la que pertenece el ususario logueado
    public function BuscarPromocion(){
        $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
        foreach ($data['Franquicias'] as $i => $Franquicias)
        // $data['Zona']=$this->cajaF_models->BuscarZona();
        // foreach ($data['Zona'] as $a => $Zona) 
        // $this->db->where("(Zona_IdZona= '".$a."' AND Franquicias_IdFranquicias = '".$i."')");
       $this->db->where('Franquicias_IdFranquicias',$i);
        $this->db->where('Estatus','ACTIVA');
        $this->db->order_by('NombrePromocion',"ASC");
        return $this->db->get('promociones')->result();
    }
    public function BuscarPromocionesI($promocion){
      $data['Zona']=$this->cajaF_models->BuscarZona();
      foreach ($data['Zona'] as $a => $Zona) 
      $this->db->where('Zona_IdZona',$a);
      $this->db->where("(tipopromocion_IdTipoPromocion = '1' OR tipopromocion_IdTipoPromocion ='3')");
      $this->db->where('Estatus','ACTIVA');
      $this->db->where('ClasePromocion','Servicio');
      $this->db->like('NombrePromocion',$promocion);
      $this->db->order_by('NombrePromocion',"ASC");
      return $this->db->get('promociones')->result();
  
      }

   public function promocionesI(){
      $data['Zona']=$this->cajaF_models->BuscarZona();
      foreach ($data['Zona'] as $a => $Zona) 
      $this->db->where('Zona_IdZona',$a);
      $this->db->where("(tipopromocion_IdTipoPromocion = '1' OR tipopromocion_IdTipoPromocion ='3')");
      $this->db->where('Estatus','ACTIVA');
      $this->db->where('ClasePromocion','Servicio');
      $this->db->order_by('NombrePromocion',"ASC");
      return $this->db->get('promociones')->result();
   }
  
      //Busca Promociones Franquicias
      //Consulta que busca las promociones registradas en la franquicia a la que pertenece el ususario logueado
      public function BuscarPromocionF($promocion){
          $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
          foreach ($data['Franquicias'] as $i => $Franquicias)
          // $data['Zona']=$this->cajaF_models->BuscarZona();
          // foreach ($data['Zona'] as $a => $Zona) 
          // $this->db->where("(Zona_IdZona= '".$a."' AND Franquicias_IdFranquicias = '".$i."')");
         $this->db->where('Franquicias_IdFranquicias',$i);
          $this->db->where('Estatus','ACTIVA');
          $this->db->like('NombrePromocion',$promocion);
          $this->db->order_by('NombrePromocion',"ASC");
          return $this->db->get('promociones')->result();
      }

      public function promocionesF(){
         $this->db->select("*");
         $this->db->from('promociones');
         $this->db->where('Estatus','ACTIVA');
         $this->db->where('Franquicias_IdFranquicias',$this->session->userdata('IdFranquicia'));
         $this->db->order_by('NombrePromocion',"ASC");
         return $this->db->get()->result();
      }


    //Consulta que busca los datos de el ususario logueado
    public function BuscarUsuario(){
    $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
    foreach ($data['Franquicias'] as $i => $Franquicias)

    $this->db->select('*');
    $this->db->from('usuarios');
    $this->db->where('Franquicias_IdFranquicias',$i);
    $this->db->where('Estatus', 'Activo');
    $query = $this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->NombreUsuario, ENT_QUOTES)] = htmlspecialchars($row->NombreUsuario, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

   public function BuscarUsuarios(){
      $data['Franquicias']=$this->cajaF_models->BuscarFranquicia();
      foreach ($data['Franquicias'] as $i => $Franquicias)
   
      $this->db->select('*');
      $this->db->from('usuarios');
      $this->db->where('Franquicias_IdFranquicias',$i);
      $this->db->where('Estatus', 'Activo');
      $query = $this->db->get();
         if ($query->num_rows() > 0) { 
            foreach($query->result() as $row) 
            $arrDatos[htmlspecialchars($row->IdUsuarios, ENT_QUOTES)] = htmlspecialchars($row->NombreUsuario, ENT_QUOTES); 
               $query->free_result(); 
               return $arrDatos; }
            }
    //Consulta que busca la franquicia a la que pertenece el usuario logueado 
    public function BuscarFranquicia(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }
    public function BuscarDatosFranquicia(){
     $this->db->select('*');
     $this->db->from('franquicias');
     $this->db->join('usuarios','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
         $query=$this->db->get();
        $res = $query->row();
         return $res;   
    }

     //Consulta que busca la franquicia a la que pertenece el usuario logueado 
     public function BuscarZona(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->join('zona','Zona_IdZona=IdZona','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdZona, ENT_QUOTES)] = htmlspecialchars($row->NombreZona, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

     //Consulta que busca la franquicia a la que pertenece el usuario logueado 
     public function BuscarPagos(){
     $this->db->select('*');
     $this->db->from('exhibiciones');
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdExhibiciones, ENT_QUOTES)] = htmlspecialchars($row->NombreEx, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

    public function BuscarContra(){
    $this->db->select('Contrasenia');
    $this->db->from('usuarios');
    $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
    $query = $this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->Contrasenia, ENT_QUOTES)] = htmlspecialchars($row->Contrasenia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

     public function BuscarModelo(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->join('modelo','Modelo_IdModelo=IdModelo','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdModelo, ENT_QUOTES)] = htmlspecialchars($row->IdModelo, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }
      public function obtenerenlaceV ($query){ 
  //permite acceder al id del cliente que se desea editar por medio de la variable $id que es pasada por el controlador     
      $this->db->where('IdVentas', $query);
      $query=$this->db->get('ventas');
      if($query->num_rows()>0){
         return $query;

      }else{
         return FALSE;
      }

   }
    /*public function getIdFranquicia($numeroFranquicia){
    $this->db->select('Contrasenia');
    $this->db->from('usuarios');
    $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
    $query = $this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->Contrasenia, ENT_QUOTES)] = htmlspecialchars($row->Contrasenia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

    }*/
    public function agendarCliente($campos)
    {
       $this->db->insert('agenda',$campos);
       $id=  $this->db->insert_id();
       $res=$this->db->affected_rows();
       if($res==1)
       {
          echo $id;
       }else{
          echo 'error';
       }
    }

   //  --------Funciones de actualización de folio---
   
   public function buscarFolio()
   {
      $franquicia = $this->BuscarIdFranquicia();
      $this->db->limit(1);
      $this->db->select('FolioVenta');
      $this->db->from('foliosventas');
      $this->db->where('franquicias_IdFranquicias',$franquicia);
      $this->db->order_by('IdFoliosVentas','DESC');
      $query = $this->db->get();
      if( $query->num_rows() > 0){
       return $query->result()[0]->FolioVenta;
      }
      else if ($query->num_rows() == 0){
       return 0;
      }
       else {
           return 0;
       }       
   }
   public function insertaFolio($folios)
   {
      $this->db->insert('foliosventas',$folios);
      $id=$this->db->insert_id();
      $res=$this->db->affected_rows();
      if($res>0)
         return $id;
      else
         return FALSE;
   }
 }