<?php
class Accionescliente_model extends CI_Model { 
   public function __construct() {
      parent::__construct();
   }

   public static $tablename = "clientes";


   public function guardar($parametro){ //guarda los datos de un nuevo cliente en la bd
     $campos=array(
    
         'NombreCliente' => $parametro['NombreCliente'],
         'FechaNacimientoCliente' => $parametro['FechaNacimientoCliente'],
         'TelefonoCliente' => $parametro['TelefonoCliente'],
         'CelularCliente' => $parametro['CelularCliente'],
         'CorreoCliente' => $parametro['CorreoCliente'],
         'DireccionCliente' => $parametro['DireccionCliente'],
         'EdadCliente' => $parametro['EdadCliente'],
         'SexoCliente' => $parametro['SexoCliente'],
         'EstadoCivil' => $parametro['EstadoCivil'],
         'Ocupacion' => $parametro['Ocupacion'],
         'MedioInformacion' => $parametro['MedioInformacion'],
         'RecomendadoPor' => $parametro['RecomendadoPor'],
         'Franquicias_IdFranquicias' => $parametro['Franquicias_IdFranquicias'],
         'Autoriza' => $parametro['Autoriza']
      );
      $this->db->insert('clientes',$campos);
      $id=  $this->db->insert_id();
      //Valida que se haya hecho la consulta
        $res=$this->db->affected_rows();
          if($res==1){
            //Muestra una alerta de que los datos se guardarón correctamente
            // echo "<script>alert('Datos guardados correctamente');</script>";
            // redirect('clientes/administrador/ClienteA', 'refresh');
            echo "<script>alert('Datos guardados correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";

          }else{
            //Muestra una alerta de que los datos no se guardarón correctamente
            // echo "<script>alert('Los datos no se pudierón ser guardados correctamente');</script>";
           // redirect('clientes/administrador/ClienteA', 'refresh');
           echo "<script>alert('Los datos no pudieron ser guardados correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";
          }

   }

  
  public function eliminar ($id){ //elimina un cliente por medio de la variable $id que es pasada por el controlador
      
      $this->db->where('IdClientes', $id);
      $this->db->delete('clientes');
       $res=$this->db->affected_rows();
      //Valida que se haya hecho la consulta
      if($res==-1){
        //Muestra una alerta de que los datos no se eliminarón correctamente
       // echo "<script>alert('Error, no se pudierón eliminar los datos debido a que se estan usuando en otras tablas');</script>";
            // redirect('clientes/administrador/ClienteA', 'refresh');
        echo "<script>alert('Error, no se pudieron eliminar los datos debido a que se están usuando en otras tablas');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";
      }else{
        //Muestra una alerta de que los datos se eliminarón correctamente
        // echo "<script>alert('Los datos se han eliminado correctamente');</script>";
        // redirect('clientes/administrador/ClienteA', 'refresh');
        echo "<script>alert('Los datos se han eliminado correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";
      }
   }



  public function obtenerenlace ($id){ //permite acceder al id del cliente que se desea editar por medio de la variable $id que es pasada por el controlador
      $this->db->where('IdClientes', $id);
      $query=$this->db->get('clientes');
      if($query->num_rows()>0){
         return $query;

      }else{
         return FALSE;
      }

   }


  function editarenlace ($IdClientes, $data)//permite guardar en la bd la información que se modificó del cliente
   {
      $this->db->where('IdClientes', $IdClientes);
      $this->db->update('clientes', $data);
      $res=$this->db->affected_rows();
      //Valida que se haya hecho la consulta
      if($res==1){
        //Muestra una alerta de que los datos se guardarón correctamente
        // echo "<script>alert('Datos guardados correctamente');</script>";
         // redirect('clientes/administrador/clienteA', 'refresh');
        echo "<script>alert('Datos guardados correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";
      }else if($res==-1){
        //Muestra una alerta cuando no se realizo
        // echo "<script>alert('Los datos no pudierón ser guardados correctamente');</script>";
        // redirect("clientes/administrador/ClienteA/editar/$IdClientes",'refresh');
        echo "<script>alert('Los datos no pudieron ser guardados correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA/editar/$IdClientes';
  </script>";
      }else if($res==0){
        // echo "<script>alert('No se hizo nungun cambio');</script>";
         // redirect('clientes/administrador/ClienteA','refresh');
        echo "<script>alert('No se hizo ningún cambio');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";
      }
   }

  function buscar($query) { //Realiza una búsqueda en la bd por medio de la variable $query que es pasada por el controlador (nombre del cliente)
        
    $this->db->like('NombreCliente', $query);
    $query = $this->db->get('clientes');
    if ($query->num_rows() > 0){
      return $query;
    }else{
       return FALSE;
    }
  }


 public function buscarporfranquicia($query) {// Realiza una consulta a la bd para buscar los cliente de la franquicia seleccionada
  

    $this->db->where('Franquicias_IdFranquicias', $query);
    $query = $this->db->get('clientes');

    if ($query->num_rows() > 0){
      return $query;
    }else{
      // echo "<script>alert('No se encontrarón los datos solicitados');</script>";
       // redirect('clientes/administrador/ClienteA', 'refresh');
      echo "<script>alert('No se encontraron los datos solicitados');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";
    }
  }




 public function BuscarCliente(){// Realiza una consulta a la bd para buscar los clientes que existen y poder mandar el resultado
      $this->db->select('*');
      $this->db->from('clientes');
      $query=$this->db->get();
      return $query->result_array();
         }



  public function BuscarFranquicia(){// Realiza una consulta a la bd para buscar las franquicias que existen y poder mandar el resultado
     $query = $this->db-> query('SELECT IdFranquicias,NombreFranquicia FROM franquicias'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }


   public function BuscarFranq(){// Realiza una consulta a la bd para buscar las franquicias que existen y poder mandar el resultado
     $query = $this->db-> query('SELECT IdFranquicias,NombreFranquicia FROM franquicias ORDER BY NombreFranquicia ASC'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

     public function obtenerNombre ($id){
      $id= $this->uri->segment(5);
      $query = $this->db-> query("SELECT IdClientes,NombreCliente FROM clientes WHERE IdClientes= '".$id."'"); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdClientes, ENT_QUOTES)] = htmlspecialchars($row->NombreCliente, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
            }

     public function BuscarZona(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->join('zona','Zona_IdZona=IdZona','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdZona, ENT_QUOTES)] = htmlspecialchars($row->NombreZona, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }
         
       public function BuscarModelo(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->join('modelo','Modelo_IdModelo=IdModelo','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdModelo, ENT_QUOTES)] = htmlspecialchars($row->IdModelo, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

      public function guardarExpediente($parametro){//guarda los datos de un nuevo expediente en la bd

     $campos=array(
        
     'Clientes_IdClientes' => $parametro['Clientes_IdClientes'],
     'TFacial' => $parametro['TFacial'],
     'TEligth' => $parametro['TEligth'],
     'TReductivo' => $parametro['TReductivo'],
     'SupervisionMedica' => $parametro['SupervisionMedica'],
     'TratamientoMedico' => $parametro['TratamientoMedico'],
     'CualTratamientoMedico' => $parametro['CualTratamientoMedico'],
     'TratamientoQuirurgico' => $parametro['TratamientoQuirurgico'],
     'CualTratamientoQuirugjico' => $parametro['CualTratamientoQuirugjico'],
     'TieneAlergias' => $parametro['TieneAlergias'],
     'CualesAlergias' => $parametro['CualesAlergias'],
     'EnfermedadesPadecidas' => $parametro['EnfermedadesPadecidas'],
     'CirugiasPlasticas' => $parametro['CirugiasPlasticas'],
     'CualesCirugiasPlasticas' => $parametro['CualesCirugiasPlasticas'],
     'Implantes' => $parametro['Implantes'],
     'CualesImplantes' => $parametro['CualesImplantes'],
     'DesajustesOseos' => $parametro['DesajustesOseos'],
     'CualesDesajustesOseos' => $parametro['CualesDesajustesOseos'],
     'MedicamentosUltimosMeses' => $parametro['MedicamentosUltimosMeses'],
     'CualesMedicamentos' => $parametro['CualesMedicamentos'],
     'AutorizaciónMedica' => $parametro['AutorizaciónMedica'],
     'DiagnosticoyObservaciones' => $parametro['DiagnosticoyObservaciones'],
     'Historia' => $parametro['Historia']
     
      );
      $this->db->insert('expediente',$campos);
      $res=$this->db->affected_rows();
      //Verifica que la consulta se realizo 
      if($res==0){
         //Muestra una alerta cuando no se realizo
         // echo "<script>alert('Datos guardados correctamente');</script>";
        // redirect('clientes/administrador/ClienteA/editar/$IdClientes');
        echo "<script>alert('Datos guardados correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA/editar/$IdClientes';
  </script>";
      }else{
        //Verifica que la consulta se realizo 
        // echo "<script>alert('Los datos no pudierón ser guardados correctamente');</script>";
        // redirect('clientes/administrador/ClienteA/AgregarExpediente');
        echo "<script>alert('Los datos no pudieron ser guardados correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA/AgregarExpediente';
  </script>";
    }
  
   }
         
}
