<?php
class ReportesPagos_Model extends CI_Model
{ 

  public function reportePagosServicios($inicio,$fin){
    $data = [];
    $data['F2'] = $this->reportePagosServiciosF($inicio,$fin,'Fecha2');
    $data['F3'] = $this->reportePagosServiciosF($inicio,$fin,'Fecha3');
    $data['F4'] = $this->reportePagosServiciosF($inicio,$fin,'Fecha4');
    $data['F2G'] = $this->reportePagosServiciosGeneralesF($inicio,$fin,'Fecha2');
    $data['F3G'] = $this->reportePagosServiciosGeneralesF($inicio,$fin,'Fecha3');
    $data['F4G'] = $this->reportePagosServiciosGeneralesF($inicio,$fin,'Fecha4');

    return $data;
  }

  public function reportePagosServiciosF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("*");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('serviciosfranquicias','IdServiciosFranquicias=serviciosfranquicias_IdServiciosFranquicias','inner');
    $this->db->join('serviciosgenerales','IdServiciosGenerales=ServiciosGenerales_IdServiciosGenerales','inner');
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_serviciosfranquicias');
    $query = $this->db->get();
    return $query;
      
  }

  public function reportePagosServiciosGeneralesF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("*");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('serviciosgenerales','Codigo_Servicios=serviciosfranquicias_IdServiciosFranquicias ','inner');
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_serviciosfranquicias');
    $query = $this->db->get();
    return $query;
      
  }


  public function reportePagosPromociones($inicio,$fin){
    $data = [];
    $data['F2'] = $this->reportePagosPromocionesF($inicio,$fin,'Fecha2');
    $data['F3'] = $this->reportePagosPromocionesF($inicio,$fin,'Fecha3');
    $data['F4'] = $this->reportePagosPromocionesF($inicio,$fin,'Fecha4');


    return $data;
  }


  public function reportePagosPromocionesF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("*");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('promociones','IdPromociones=promociones_IdPromociones','inner');
   /* $this->db->join('serviciosgenerales','IdServiciosGenerales=ServiciosGenerales_IdServiciosGenerales','inner');*/
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_promociones');
    $query = $this->db->get();
    return $query;
      
  }

   public function reportePagosProductos($inicio,$fin){
    $data = [];
    $data['F2'] = $this->ProductosF($inicio,$fin,'Fecha2');
    return $data;
  }


  public function ProductosF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("*");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('productosfranquicias','IdProductosFranquicias=productosfranquicias_IdProductosFranquicias','inner');
    $this->db->join('productosgenerales','IdProductosGenerales=ProductosGenerales_IdProductosGenerales','inner');
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_productosfranquicias');
    $query = $this->db->get();
    return $query;
      
  }

   public function BuscarIdFranquicia(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
              return $row->IdFranquicias; }
  } 
  

}
?>