
'use strict';
window.addEventListener( 'load', function( event )
 { 
    $.fn.datepicker.dates['en'] = {
        days: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"],
        daysShort: ["Dom", "Lun", "Mar", "Mier", "Jue", "Vier", "Sab"],
        daysMin: ["D", "L", "Ma", "Mi", "J", "V", "S"],
        months: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
        monthsShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        today: "Today",
        clear: "Clear",

        weekStart: 0
    };

    $.datepicker.setDefaults($.datepicker.regional['en']);     
     var today = new Date();
    /* $(".date-picker").attr("data-date-end-date","today+2m");*/
    $(".termino-picker").datepicker({
      isRTL: false,
      format: "yyyy-mm-dd",
      viewMode: "months,days", 
      minViewMode: "months,days",
      autoclose: true,
      startDate: new Date(today.getFullYear(), today.getMonth(), today.getDate()),
      todayHighlight: true,
    });
     $(".date-picker").datepicker({
        isRTL: false,
        format: "dd-mm-yyyy",
        viewMode: "months,days", 
        minViewMode: "months,days",
        autoclose: true,
    });
    $('.date-picker').datepicker('setDate', 'today');
    $('#filtrarReportes').click(function(){
        
      $.fn.dataTable.ext.errMode = 'none';
      $('#reporte-promoiones').on('error.dt', function(e, settings, techNote, message) {
         console.log( 'An error has been reported by DataTables: ', message);
      });
      $('#reporte-promoiones').empty();
      
      $('#reporte-promoiones').unbind();
      
          var fechainicio = $('#fechainicio').val();
          var fechafin = $("#fechafin").val();
          var tipo = $('#tipo').val();
          var status = $('#status').val();
          var nombreReporte='';
          var tituloReporte='';
          switch(tipo){
            case "":
                nombreReporte='ReportePromociones';
                tituloReporte='Reporte de promociones';
            break;
            // case "1":
            //     nombreReporte='ReportePromocionesInstitucionales';
            //     tituloReporte='Reporte de promociones institucionales';
            // break;
            case "2":
                nombreReporte='ReportePromocionesLocales';
                tituloReporte='Reporte de promociones locales';
            break;
            // case "3":
            //     nombreReporte='ReportePromocionesFijas';
            //     tituloReporte='Reporte de promociones fijas';
            // break;
            case "4":
                    nombreReporte='ReportePromocionesEmergentes';
                    tituloReporte='Reporte de promociones emergentes';
            break;

          }
          console.log(fechainicio);
          console.log(fechafin);
          console.log(tipo);

      
      
          if( fechainicio != '' && fechafin != '' )
          {
            $('#modal-loader').modal();
                   
                  $.ajax({
                  url:base_url+"promociones/franquiciatario/PromocionesF/buscarPromociones",
                  type:'POST',
                  dataType: 'json',
                  data:{finicio : fechainicio, ffin : fechafin, status:status, tipo:tipo},
                  success:function(response){
                    $('#modal-loader').modal('hide');
                       console.log(response);
                      console.log("exito");
                      toastr.success('Se realizó tu busqueda se encontraron '+ response.length +' resultados').css("width","100%");
                      var columns = [
                          { "title":"Promoción" },
                          { "title":"Categoría" },
                          { "title":"Tipo" },
                          { "title":"Precio" },
                          { "title":"Fecha Inicio" },
                          { "title":"Fecha Termino" },
                          { "title":"Estado" },
                      ];   
      
                       var hide = [
                              { targets: [0,1,2,3,4,5,6], visible: true},
                             /* { targets: [8], visible: false }*/
                          ];
                        
      
                    //   $("#reporte-promoiones").append('<tfoot class="dataFooter"><tr><th></th><th></th><th></th><th></th><th></th><th></th><th></th></tr></tfoot>'); 
                      $('#reporte-promoiones').DataTable( {
                          dom: 'T<"clear">Bfrtip',
                          responsive: true,
                          columnDefs: hide,
                          data: response,
                          columns: columns,
                          ServerSide: true,
                           destroy: true,
                           footer: false,
                           processing: true,
                           "order": [[ 5, "desc" ]],
                           buttons: [
                          {
                              extend: 'print',
                              text:"IMPRIMIR",
                              footer: true,
                              orientation: 'landscape',
                              pageSize: 'A4',
                              /*messageTop: 'Reporte de Ventas',*/
                              title: 'Reporte de promociones',
                              exportOptions: {
      
                               body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                                columns: [0,1,2,3,4,5,6]//son las columnas q quiero q se vean al exportarse          
      
                            },

                              customize: function ( win ) {
      
                                  $(win.document.body)
                                  .css( 'font-size', '8pt' )
                                  .prepend(
                                      '<div style="width: 100%; font-size:2em; text-align: center;">Reporte de promociones</div>'
                                      );
      
                                  $(win.document.body).find( 'table' )
                                  .addClass( 'compact' )
                                  .css( 'font-size', 'inherit' );
                                  $(win.document.body).find( 'table' )
                                  .addClass( 'mayus' )
                                  .css( 'text-transform', 'uppercase' );
                                  $(win.document.body).find( 'table' )
                                  .css( 'margin-left', '3em');
                                  $(win.document.body).find( 'table' )
                                  .css('margin-right','3em' );
                              },
                              
                          },
                          {
                              
                              extend: 'pdf',
                              text:"PDF",
                              footer: true,
                              filename: nombreReporte,
                              /*messageTop: 'Reporte de Ventas',*/
                              orientation: 'landscape',
                              pageSize: 'A4',
                              title: tituloReporte,
                              key: { 
                                  key: 'e',
                                  altKey: false
                              },
        
                              exportOptions: {
      
                                  body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                                  footer: true,
                                  columns:[0,1,2,3,4,5,6],//son las columnas q quiero q se vean al exportarse 
                                  
      
                              },
                              
                              // body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                              customize: function ( doc ) {
                                doc.content[1].table.widths = ['16%','14%','14%','14%','14%','14%','14%'];
                                doc.defaultStyle.alignment = 'center';
                                
                              },
                          },
                          {
                              extend: 'excel',
                              text:"EXCEL",
                              footer: true,
                              filename: nombreReporte,
                              title: tituloReporte,
                              exportOptions: {
                                modifier: {
                                    alignment: 'center',
                                    page: 'all',                             
                                }
                                , body : {margin: [ 0, 0, 0, 0 ], pageMargins: [ 0, 0, 0, 0 ]},
                                footer: true,
                                columns: [0,1,2,3,4,5,6]//son las columnas q quiero q se vean al exportarse          
      
                            },
                              
                              
                          }
                          // 'copy', 'csv', 'excel',
                          ],
      
                          language: {
                            "lengthMenu": "Mostrar _MENU_ registros por pagina",
                            "zeroRecords": "No se encontraron resultados en su busqueda",
                            "searchPlaceholder": "Buscar registros",
                            "info": "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros",
                            "infoEmpty": "No existen registros",
                            "infoFiltered": "(filtrado de un total de _MAX_ registros)",
                            "search": "Buscar:",
                            "paginate": {
                                "first": "Primero",
                                "last": "Último",
                                "next": "Siguiente",
                                "previous": "Anterior"
                            },
                        },
                           
                      });
                      $('#reporte-promoiones').wrap("<div id='scrooll_div' class='scrollbar-tabla' style='width: 100%;'></div>");
                      $('#scrooll_div').doubleScroll({
                            resetOnWindowResize: true
                          });
                      return false;
      
                  },//end success ajax response
                  error:function(xhr, textStatus, errorThrown, error){
                    console.log(xhr.responseText);
                      console.log("error");
                  },
      
                  });//end ajax
          return false;
      
      }//end fechainicio y fechafin vacia
      else{
           toastr.error("Hace falta una Fecha");
          console.log("error");
          return false;
      }
      });//end click

      var botonActivar=document.getElementById('activar');
      botonActivar.addEventListener('click', function(){
        var id=document.getElementById('idPromocion').value;
        var fechaTermino=document.getElementById('fechaTermino').value;
        var tiempo=document.getElementById('minutos').value;
        if(fechaTermino=="") {
          document.getElementById("contenedorFT").classList.add("has-error");
          $('#contenedorFT').notify("Ingrese fecha de termino",{
            position:'bottom left',
            className:'error'
          })
        } else if(tiempo==""){
          document.getElementById("contenedorT").classList.add("has-error");
          $('#contenedorT').notify("Ingrese tiempo de duración del servicio",{
            position:'bottom left',
            className:'error'
          })
        } else{
          document.getElementById("contenedorFT").classList.remove("has-error");
          document.getElementById("contenedorT").classList.remove("has-error");
          $('#modalActivar').modal('hide');
          $('#modal-loader').modal();
          $.ajax({
            url:base_url+"promociones/franquiciatario/PromocionesF/activarPromocion",
            type:'POST',
            dataType: 'json',
            data:{id:id, fecha:fechaTermino, tiempo:tiempo},
            success:function(r){
            console.log(r);
            $('#modal-loader').modal('hide');
              swal({
                title: "¡Promoción activada correctamente!",
                icon: "success",
                buttons:'Aceptar',
              })
              .then((value) => {            
                  $('#filtrarReportes').trigger( "click" );          
              });
            },//end success ajax response
            error:function(xhr, textStatus, errorThrown, error){
              console.log(xhr.responseText);
              swal("¡No se puede conectar al servidor!","Contacte al departamento de sistemas si persiste el problema","warning")
              .then((value) => {
                location.href="";
              }); 
              },
          });//end ajax
        }
      });
 }); //Fin window.addEventListener
//  ---------------Funciones----------------
function cambiarStatus(id, nombre)
{
  console.log(id);
  console.log(nombre);
  document.getElementById('idPromocion').value=id;
  document.getElementById('nombrePromocion').innerHTML=nombre;
  document.getElementById('fechaTermino').value="";
  document.getElementById("contenedorFT").classList.remove("has-error");
  $('#modalActivar').modal();
}