<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
class HAccesos extends CI_Controller
{
	public function __construct(){
		parent::__construct();
		$this->load->model('HAccesos/Administrador/HistoricoAccesos_models');
		$this->load->library(array('session','form_validation'));
		$this->load->helper('url'); 
	}

	public function index() 
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$this->load->view('layout/header');
			$this->load->view('layout/menuAdmin');
			$this->load->view('reportes/Administrador/ReporteHistoricoA');	
			$this->load->view('layout/footer');
		}

	}

	public function getAccesos(){
		//	sleep(3);
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query= $this->HistoricoAccesos_models->getAccesos($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){ 
			foreach($query['F2']->result() as $HAccesos) {
				$data[] = array(
					$HAccesos->NombreUsuario,
					$HAccesos->IpAcceso,
					$HAccesos->FechaInicioS,	
					$HAccesos->FechaFinS
				);
			}	
		}
		echo json_encode($data);		
	}

	public function getAccesosPorSemana(){
		$fecha = date('Y-m-d');//'2020-03-13';
		$diaInicio="Monday";
		$diaFin="Sunday";
	
		$strFecha = strtotime($fecha);
	
		$fechaInicio = date('Y-m-d',strtotime('last '.$diaInicio,$strFecha));
		$fechaFin = date('Y-m-d',strtotime('next '.$diaFin,$strFecha));
	
		if(date("l",$strFecha)==$diaInicio){
			$fechaInicio= date("Y-m-d",$strFecha);
		}
		if(date("l",$strFecha)==$diaFin){
			$fechaFin= date("Y-m-d",$strFecha);
		}
		//echo $fechaInicio.'_____________'.$fechaFin.'<br>';
		$response = $this->HistoricoAccesos_models->getAccesos($fechaInicio, $fechaFin);
		$data = [];

		if(count($response['F2']->result()) != null ){ 
			foreach($response['F2']->result() as $HAccesos) {
				$data[] = array(
					$HAccesos->NombreUsuario,
					$HAccesos->IpAcceso,
					$HAccesos->FechaInicioS,	
					$HAccesos->FechaFinS
				);
			}	
		}
		echo json_encode($data);
	}

	public function pruebas(){
		$fecha = date('Y-m-d');//'2020-03-13';
		$diaInicio="Monday";
		$diaFin="Sunday";
	
		$strFecha = strtotime($fecha);
	
		$fechaInicio = date('Y-m-d',strtotime('last '.$diaInicio,$strFecha));
		$fechaFin = date('Y-m-d',strtotime('next '.$diaFin,$strFecha));
	
		if(date("l",$strFecha)==$diaInicio){
			$fechaInicio= date("Y-m-d",$strFecha);
		}
		if(date("l",$strFecha)==$diaFin){
			$fechaFin= date("Y-m-d",$strFecha);
		}
		echo $fechaInicio.'_____________'.$fechaFin.'<br>';
		$response = $this->HistoricoAccesos_models->getAccesos($fechaInicio, $fechaFin);
		$data = [];

		if(count($response['F2']->result()) != null ){ 
			foreach($response['F2']->result() as $HAccesos) {
				$data[] = array(
					$HAccesos->NombreUsuario,
					$HAccesos->IpAcceso,
					$HAccesos->FechaInicioS,	
					$HAccesos->FechaFinS
				);
			}	
		}
		echo json_encode($data);	
		exit();
		var_dump($this->HistoricoAccesos_models->prueba());
	}
}
