<?php
ini_set('memory_limit', '-1');
class ExpedienteC extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('expediente/cosmetologo/ExpedienteC_model');
		$this->load->library(array('session','form_validation'));
        $this->load->library('Mydompdf');
        $this->load->helper(array('url'));

	}

	//Muestra la vista principal crearexpediente_view para crear un nuevo expediente
	public function index()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {	
            $id= $this->uri->segment(5);

            $this->db->select('*');
            $this->db->from('clientes');
            $this->db->where('IdClientes', $id);
            $query = $this->db->get();
            foreach ($query->result() as $valor) 
                $data['NombreCliente'] = $valor->NombreCliente;
                $data['EdadCliente'] = $valor->EdadCliente;
                $data['FechaNacimientoCliente'] = $valor->FechaNacimientoCliente;
                $data['SexoCliente'] = $valor->SexoCliente;
                $data['id'] = $id;

		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$data['ReClientes']=$this->ExpedienteC_model->BuscarClientes();
		$this->load->view('expediente/cosmetologo/crearexpedienteC_view',$data);
		$this->load->view('layout/footer');
		}
	}
	
	 //Guarda todos los datos del expediente 
	 public function guardar()
	 {
	       $Enfermedades = '';
            $Medicamentos = '';
    
            if($this->input->post('enfermedades') != ''){
                foreach($this->input->post('enfermedades') as $selected){
                    $Enfermedades .=  $selected.",";
                    }
                }else{
                    $Enfermedades =  null;
                }
    
            if($this->input->post('medicamentosUltimosMeses') != ''){
                foreach($this->input->post('medicamentosUltimosMeses') as $selectedMedicamentos){
                    $Medicamentos .=  $selectedMedicamentos.",";
                }
                }else{
                    $Medicamentos =  null;
                }
                
                $SupervisionMedica = '';
        if($this->input->post('SupervisionMedica') != ''){
            foreach($this->input->post('SupervisionMedica') as $selectedSP){
                $SupervisionMedica .=  $selectedSP.",";
                }
            }else{
                $SupervisionMedica =  null;
            }

    
        // $this->db->select('*');
        // $this->db->join('clientes','Clientes_IdClientes= IdClientes','inner');
        $id= $this->uri->segment(5);
                
        $IdUsuarioLog = $this->session->userdata('IdUsuarios');
        $usuario=$this->ExpedienteC_model->obtenerUsuario($IdUsuarioLog);        
            // $obtenerenlaceE = $this->ExpedienteF_model->obtenerenlaceE($id);

            $parametro['Idexpediente']= $this->input->post('txt_idcliente');
            $parametro['Clientes_IdClientes']= $this->input->post('txt_idcliente');

            
            $parametro['SupervisionMedica']= $SupervisionMedica;
            $parametro['EspecificacionSupMed']= $this->input->post('especificacionMedica');

            $parametro['EnfermedadesAfecciones']= $Enfermedades;
            $parametro['OtrasEnfermedades']= $this->input->post('OtrasEnfermedades');
            $parametro['CualesOtrasEnfermedades']= $this->input->post('CualesOtrasEnfermedades');
            $parametro['ComentariosEnfermedades']= $this->input->post('ComentariosEnfermedades');

            $parametro['MedicamentosUltimosMeses']= $Medicamentos;

            $parametro['Fotosensibilizantes'] = $this->input->post('text_sistemico');
            $parametro['Anticancerosos'] = $this->input->post('text_anticancerosos');
            $parametro['Antidepresivos'] = $this->input->post('text_antidepresivos');
            $parametro['Antihistaminicos'] = $this->input->post('text_antihistaminicos');
            $parametro['AntiInflamatorios'] = $this->input->post('text_anti_inflamatorios');
            $parametro['Antituberculosos'] = $this->input->post('text_antituberculosos');
            $parametro['Antibioticos'] = $this->input->post('text_antibioticos');
            $parametro['Antimalaricos'] = $this->input->post('text_antimalaricos');
            $parametro['Antipsicoticos'] = $this->input->post('text_antipsicoticos');
            $parametro['Ansiedad'] = $this->input->post('text_asiendad');
            $parametro['Antiarritmicos'] = $this->input->post('text_antiarritmicos');
            $parametro['Psicomotores'] = $this->input->post('text_psicomotores');
            $parametro['Diureticos'] = $this->input->post('text_diureticos');
            $parametro['Edulcorantes'] = $this->input->post('text_edulcorantes');
            $parametro['Hipoglucemiantes'] = $this->input->post('text_hipoglucemiantes');
            $parametro['Laxantes'] = $this->input->post('text_laxantes');
            $parametro['Psoralenos'] = $this->input->post('text_psoralenos');
            $parametro['Tetraciclinas'] = $this->input->post('text_tetraciclinas');

            $parametro['OtrosMedicamentos']= $this->input->post('OtrosMedicamentos');
            $parametro['CualesOtrosMedicamentos']= $this->input->post('CualesOtrosMedicamentos');
            $parametro['ComentariosMedicamentos']= $this->input->post('ComentariosMedicamentos');

            $parametro['RealizaActividadFisica'] = $this->input->post('RealizaActividadFisica');
            $parametro['QueActividadFisica'] = $this->input->post('QueActividadFisica');
            $parametro['CadaCuantoActividadFisica'] = $this->input->post('CadaCuantoActividadFisica');
            $parametro['LitrosAguaConsume'] = $this->input->post('LitrosAguaConsume');
            $parametro['TieneTatuajes'] = $this->input->post('TieneTatuajes');
            $parametro['ZonaTatuaje'] = $this->input->post('zonaTatuaje');
    
            $parametro['EstaEmbarazada'] = $this->input->post('EstaEmbarazada');
            $parametro['EstaLactando'] = $this->input->post('EstaLactando');
                        
            $parametro['DiagnosticoyObservaciones']= $this->input->post('DiagnosticoyObservaciones');

            $parametro['Historia']= $this->input->post('Time')." ".$parametro['reloj']=$this->input->post('reloj')."-> /// ".$parametro['txt_historia']=$this->input->post('txt_historia')." "." /// ".$usuario." /// ".$this->input->post('usuarioAlmacenamiento')." /// "." ??? ";

            if ($this->input->post('base64') == null || $this->input->post('base64') == "") {
                $parametro['FirmaDigital'] = null;
            }else{
                $path = "files/firmas/";
                if (!is_dir($path)) {
                    mkdir($path, 0777, true);
                    chmod($path, 0777);
                }
                $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                // Need to decode before saving since the data we received is already base64 encoded
                $decodedData=base64_decode($filteredData);
                $NombreClienteF = $this->ExpedienteC_model->cliente($this->input->post('txt_idcliente'));
                // store in server
                $fic_name = $NombreClienteF->NombreCliente.'_'.$this->input->post('txt_idcliente').'_'.date("YmdHis").'.png';                       
                $fp = fopen($path.$fic_name, 'wb');
                $ok = fwrite( $fp, $decodedData);
                fclose( $fp );

                $parametro['FirmaDigital']= $path.$fic_name;
                //$parametro['FirmaDigital']= $this->input->post('base64');
            }

            $parametro['usuarios_IdUsuarios']= $this->input->post('usuario');
            // $parametro['FirmaDigital']= $this->input->post('base64');

            $edadC = $this->input->post('EdadCliente');
            $fechaNac = date("Y-m-d", strtotime($this->input->post('FechaNacimientoCliente')));
            $sexoCliente = $this->input->post('SexoCliente');

    // echo "string";
            
            $modificarClientes = array(
                'FechaNacimientoCliente' => $fechaNac, 
                'EdadCliente' => $edadC, 
                'SexoCliente' => $sexoCliente, 
              );
                $this->db->where('IdClientes',$id);
                $this->db->update('clientes',$modificarClientes);
                $modCliente = $this->db->affected_rows();

                if($modCliente > 0){
                    $resultado = $this->ExpedienteC_model->guardar($parametro);
                     if($resultado != false){
                            echo "1";
                        }else{
                            echo "0";
                        }
                }else{
                    $resultado = $this->ExpedienteC_model->guardar($parametro);
                     if($resultado != false){
                            echo "1";
                        }else{
                            echo "0";
                        }
                }



 
		 
	 }
 

	//Muestra una lista de clientes 
	public function MostrarClientes()
	{
		$options ="";
		if($this->input->post('IdClientes')){
			$IdClientes=$this->input->post('Clientes');
			$NombreCliente=$this->ExpedienteC_model->BuscarClientes($IdClientes);
			foreach ($NombreCliente as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $cliente_name ?></option>
                <?php
			}
		}
	}

	// //Manda a traer los datos del expediente del cliente seleccionado 
    public function editarE()
    {
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
        {
            redirect(base_url().'acceso/acceso');
        } else {
            // $this->db->select('*');
    // $this->db->join('clientes','Clientes_IdClientes= IdClientes','inner');
        $id= $this->uri->segment(5);

            $this->db->select('*');
            $this->db->from('clientes');
            $this->db->where('IdClientes', $id);
            $query = $this->db->get();
            foreach ($query->result() as $valor) {
                $IdClientes = $valor->IdClientes;
                $NombreCliente = $valor->NombreCliente;
                $FechaNacimientoCliente = $valor->FechaNacimientoCliente;
                $SexoCliente = $valor->SexoCliente;
                $EdadCliente = $valor->EdadCliente;
                $FirmaTablaClientes = $valor->RutaFirmaDigital;
                $RutaUltimaFirmaModificada = $valor->RutaUltimaFirmaModificada;
            }


        $obtenerenlaceE = $this->ExpedienteC_model->obtenerenlaceE($id);

        if($obtenerenlaceE != FALSE){
            foreach ($obtenerenlaceE->result() as $fila) {

        $Idexpediente = $fila->Idexpediente;
        $SupervisionMedica = $fila->SupervisionMedica;
        $EspecificacionSupMed = $fila->EspecificacionSupMed;

        $EnfermedadesAfecciones = $fila->EnfermedadesAfecciones;
        $OtrasEnfermedades=$fila->OtrasEnfermedades;
        $CualesOtrasEnfermedades=$fila->CualesOtrasEnfermedades;
        $ComentariosEnfermedades=$fila->ComentariosEnfermedades;
        $MedicamentosUltimosMeses = $fila->MedicamentosUltimosMeses;

        $Fotosensibilizantes = $fila->Fotosensibilizantes;
        $Anticancerosos = $fila->Anticancerosos;
        $Antidepresivos = $fila->Antidepresivos;
        $Antihistaminicos = $fila->Antihistaminicos;
        $AntiInflamatorios = $fila->AntiInflamatorios;
        $Antituberculosos = $fila->Antituberculosos;
        $Antibioticos = $fila->Antibioticos;
        $Antimalaricos = $fila->Antimalaricos;
        $Antipsicoticos = $fila->Antipsicoticos;
        $Ansiedad = $fila->Ansiedad;
        $Antiarritmicos = $fila->Antiarritmicos;
        $Psicomotores = $fila->Psicomotores;
        $Diureticos = $fila->Diureticos;
        $Edulcorantes = $fila->Edulcorantes;
        $Hipoglucemiantes = $fila->Hipoglucemiantes;
        $Laxantes = $fila->Laxantes;
        $Psoralenos = $fila->Psoralenos;
        $Tetraciclinas = $fila->Tetraciclinas;

        $OtrosMedicamentos=$fila->OtrosMedicamentos;
        $CualesOtrosMedicamentos=$fila->CualesOtrosMedicamentos;
        $ComentariosMedicamentos=$fila->ComentariosMedicamentos;

        $DiagnosticoyObservaciones = $fila->DiagnosticoyObservaciones;
        $Historia = $fila->Historia;
        $EstaEmbarazada = $fila->EstaEmbarazada;
        $EstaLactando = $fila->EstaLactando;
        $TieneTatuajes = $fila->TieneTatuajes;
        $ZonaTatuaje = $fila->ZonaTatuaje;
        $LitrosAguaConsume = $fila->LitrosAguaConsume;
        $RealizaActividadFisica = $fila->RealizaActividadFisica;
        $QueActividadFisica = $fila->QueActividadFisica;
        $CadaCuantoActividadFisica = $fila->CadaCuantoActividadFisica;

        $RutaFirmaDigital = $fila->RutaFirmaDigital;
   }
            $data = array(
                'Idexpediente' => $Idexpediente,
                'IdClientes' => $IdClientes,
                'NombreCliente' => $NombreCliente,
                'FechaNacimientoCliente' => $FechaNacimientoCliente,
                'SexoCliente' => $SexoCliente,
                'EdadCliente' => $EdadCliente,
                'SupervisionMedica' => $SupervisionMedica,
                'EspecificacionSupMed' => $EspecificacionSupMed,

                'EnfermedadesAfecciones' => $EnfermedadesAfecciones,
                'OtrasEnfermedades'=> $OtrasEnfermedades,
                'CualesOtrasEnfermedades' => $CualesOtrasEnfermedades,
                'ComentariosEnfermedades' => $ComentariosEnfermedades,
                'MedicamentosUltimosMeses' => $MedicamentosUltimosMeses,

                'Fotosensibilizantes' => $Fotosensibilizantes,
                'Anticancerosos' => $Anticancerosos,
                'Antidepresivos' => $Antidepresivos,
                'Antihistaminicos' => $Antihistaminicos,
                'AntiInflamatorios' => $AntiInflamatorios,
                'Antituberculosos' => $Antituberculosos,
                'Antibioticos' => $Antibioticos,
                'Antimalaricos' => $Antimalaricos,
                'Antipsicoticos' => $Antipsicoticos,
                'Ansiedad' => $Ansiedad,
                'Antiarritmicos' => $Antiarritmicos,
                'Psicomotores' => $Psicomotores,
                'Diureticos' => $Diureticos,
                'Edulcorantes' => $Edulcorantes,
                'Hipoglucemiantes' => $Hipoglucemiantes,
                'Laxantes' => $Laxantes,
                'Psoralenos' => $Psoralenos,
                'Tetraciclinas' => $Tetraciclinas,

                'OtrosMedicamentos'=> $OtrosMedicamentos,
                'CualesOtrosMedicamentos' => $CualesOtrosMedicamentos,
                'ComentariosMedicamentos' => $ComentariosMedicamentos,
                // 'AutorizaciónMedica' => $AutorizaciónMedica,
                // 'CualMedico' => $CualMedico,
                'DiagnosticoyObservaciones' => $DiagnosticoyObservaciones,
                'Historia' => $Historia,
                'EstaEmbarazada' => $EstaEmbarazada,
                'EstaLactando' => $EstaLactando,
                'TieneTatuajes' => $TieneTatuajes,
                'ZonaTatuaje' => $ZonaTatuaje,
                'LitrosAguaConsume' => $LitrosAguaConsume,
                'RealizaActividadFisica' => $RealizaActividadFisica,
                'QueActividadFisica' => $QueActividadFisica,
                'CadaCuantoActividadFisica' => $CadaCuantoActividadFisica,
                'RutaFirmaDigital' => $RutaFirmaDigital,

                'FirmaTablaClientes' => $FirmaTablaClientes,
                'RutaUltimaFirmaModificada' => $RutaUltimaFirmaModificada,
            );
            }else{
                $data ='';
                return FALSE;
        }
        //echo "<script>alert($id);</script>";
        $this->load->view('layout/headerCos');
        $this->load->view('layout/menuCosmetologo');
        $this->load->view('expediente/cosmetologo/editarexpedienteC_view', $data);
        $this->load->view('layout/footer');
        }
    }


public function contestarExpedienteCliente(){
    $idVC= $this->uri->segment(5);
    $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

    if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
        {
            redirect(base_url().'acceso/acceso');
        } else {
            $id= $this->uri->segment(5);

            $this->db->select('*');
            $this->db->from('clientes');
            $this->db->where('IdClientes', $id);
            $query = $this->db->get();
            foreach ($query->result() as $valor) {
                $IdClientes = $valor->IdClientes;
                $NombreCliente = $valor->NombreCliente;
                $FechaNacimientoCliente = $valor->FechaNacimientoCliente;
                $SexoCliente = $valor->SexoCliente;
                $EdadCliente = $valor->EdadCliente;
                $FirmaTablaClientes = $valor->RutaFirmaDigital;
                $RutaUltimaFirmaModificada = $valor->RutaUltimaFirmaModificada;
            }

            $obtenerenlaceE = $this->ExpedienteC_model->buscarExpedienteCliente($id);

            //////////////////////si existe expediente//////////////////////////
                if($obtenerenlaceE != '0'){
                foreach ($obtenerenlaceE->result() as $fila) {
                    $Idexpediente = $fila->Idexpediente;
                    $SupervisionMedica = $fila->SupervisionMedica;
                    $EspecificacionSupMed = $fila->EspecificacionSupMed;

                    $EnfermedadesAfecciones = $fila->EnfermedadesAfecciones;
                    $OtrasEnfermedades=$fila->OtrasEnfermedades;
                    $CualesOtrasEnfermedades=$fila->CualesOtrasEnfermedades;
                    $ComentariosEnfermedades=$fila->ComentariosEnfermedades;
                    $MedicamentosUltimosMeses = $fila->MedicamentosUltimosMeses;

                    $Fotosensibilizantes = $fila->Fotosensibilizantes;
                    $Anticancerosos = $fila->Anticancerosos;
                    $Antidepresivos = $fila->Antidepresivos;
                    $Antihistaminicos = $fila->Antihistaminicos;
                    $AntiInflamatorios = $fila->AntiInflamatorios;
                    $Antituberculosos = $fila->Antituberculosos;
                    $Antibioticos = $fila->Antibioticos;
                    $Antimalaricos = $fila->Antimalaricos;
                    $Antipsicoticos = $fila->Antipsicoticos;
                    $Ansiedad = $fila->Ansiedad;
                    $Antiarritmicos = $fila->Antiarritmicos;
                    $Psicomotores = $fila->Psicomotores;
                    $Diureticos = $fila->Diureticos;
                    $Edulcorantes = $fila->Edulcorantes;
                    $Hipoglucemiantes = $fila->Hipoglucemiantes;
                    $Laxantes = $fila->Laxantes;
                    $Psoralenos = $fila->Psoralenos;
                    $Tetraciclinas = $fila->Tetraciclinas;

                    $OtrosMedicamentos=$fila->OtrosMedicamentos;
                    $CualesOtrosMedicamentos=$fila->CualesOtrosMedicamentos;
                    $ComentariosMedicamentos=$fila->ComentariosMedicamentos;

                    $DiagnosticoyObservaciones = $fila->DiagnosticoyObservaciones;
                    $Historia = $fila->Historia;
                    $EstaEmbarazada = $fila->EstaEmbarazada;
                    $EstaLactando = $fila->EstaLactando;
                    $TieneTatuajes = $fila->TieneTatuajes;
                    $ZonaTatuaje = $fila->ZonaTatuaje;
                    $LitrosAguaConsume = $fila->LitrosAguaConsume;
                    $RealizaActividadFisica = $fila->RealizaActividadFisica;
                    $QueActividadFisica = $fila->QueActividadFisica;
                    $CadaCuantoActividadFisica = $fila->CadaCuantoActividadFisica;
                    $RutaFirmaDigital = $fila->RutaFirmaDigital;
                    }

                    $data = array(
                        'Idexpediente' => $Idexpediente,
                        'IdClientes' => $IdClientes,
                        'NombreCliente' => $NombreCliente,
                        'FechaNacimientoCliente' => $FechaNacimientoCliente,
                        'SexoCliente' => $SexoCliente,
                        'EdadCliente' => $EdadCliente,
                        'SupervisionMedica' => $SupervisionMedica,
                        'EspecificacionSupMed' => $EspecificacionSupMed,
                        'EnfermedadesAfecciones' => $EnfermedadesAfecciones,
                        'OtrasEnfermedades'=> $OtrasEnfermedades,
                        'CualesOtrasEnfermedades' => $CualesOtrasEnfermedades,
                        'ComentariosEnfermedades' => $ComentariosEnfermedades,
                        'MedicamentosUltimosMeses' => $MedicamentosUltimosMeses,

                        'Fotosensibilizantes' => $Fotosensibilizantes,
                        'Anticancerosos' => $Anticancerosos,
                        'Antidepresivos' => $Antidepresivos,
                        'Antihistaminicos' => $Antihistaminicos,
                        'AntiInflamatorios' => $AntiInflamatorios,
                        'Antituberculosos' => $Antituberculosos,
                        'Antibioticos' => $Antibioticos,
                        'Antimalaricos' => $Antimalaricos,
                        'Antipsicoticos' => $Antipsicoticos,
                        'Ansiedad' => $Ansiedad,
                        'Antiarritmicos' => $Antiarritmicos,
                        'Psicomotores' => $Psicomotores,
                        'Diureticos' => $Diureticos,
                        'Edulcorantes' => $Edulcorantes,
                        'Hipoglucemiantes' => $Hipoglucemiantes,
                        'Laxantes' => $Laxantes,
                        'Psoralenos' => $Psoralenos,
                        'Tetraciclinas' => $Tetraciclinas,

                        'OtrosMedicamentos'=> $OtrosMedicamentos,
                        'CualesOtrosMedicamentos' => $CualesOtrosMedicamentos,
                        'ComentariosMedicamentos' => $ComentariosMedicamentos,
                        // 'AutorizaciónMedica' => $AutorizaciónMedica,
                        // 'CualMedico' => $CualMedico,
                        'DiagnosticoyObservaciones' => $DiagnosticoyObservaciones,
                        'Historia' => $Historia,
                        'EstaEmbarazada' => $EstaEmbarazada,
                        'EstaLactando' => $EstaLactando,
                        'TieneTatuajes' => $TieneTatuajes,
                        'ZonaTatuaje' => $ZonaTatuaje,
                        'LitrosAguaConsume' => $LitrosAguaConsume,
                        'RealizaActividadFisica' => $RealizaActividadFisica,
                        'QueActividadFisica' => $QueActividadFisica,
                        'CadaCuantoActividadFisica' => $CadaCuantoActividadFisica,
                        'RutaFirmaDigital' => $RutaFirmaDigital,

                        'FirmaTablaClientes' => $FirmaTablaClientes,
                        'RutaUltimaFirmaModificada' => $RutaUltimaFirmaModificada,
                    );
                    

                }else{
            //////////////////////no existe expediente//////////////////////////
                    $data = array(
                        'Idexpediente' => '',
                        'IdClientes' => $IdClientes,
                        'NombreCliente' => $NombreCliente,
                        'FechaNacimientoCliente' => $FechaNacimientoCliente,
                        'SexoCliente' => $SexoCliente,
                        'EdadCliente' => $EdadCliente,
                        'Historia' => '',
                    );

                    

                }

                $data['Franquicias']=$this->ExpedienteC_model->BuscarFranquicia();
                foreach ($data['Franquicias'] as $i => $Franquicias) 
                $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuarioCAuxiliar($i);
            

        // $this->load->view('layout/headerCos');
        // $this->load->view('layout/menuCosmetologo');
        $this->load->view('expediente/cosmetologo/contestarExpedienteCliente_view',$data);
        // $this->load->view('layout/footer');
            

}
}

public function comprobarUsuario(){
    $idUsuario = $this->input->post('valorSelect');
    $nombreUsuario = $this->input->post('nombreSelect');
    $password = $this->input->post('password');

    $Franquicias=$this->ExpedienteC_model->BuscarFranquicia();
    foreach ($Franquicias as $i => $Franquicias) 

    $this->ExpedienteC_model->comprobarUsuario($idUsuario, $nombreUsuario, $password, $i);
}


	//Edita y guarda los datos del expediente del cliente seleccionado 
    public function editarenlaceE ()
    {
        $IdClientes= $this -> uri->segment(5);

        // $Claustrofobia=$this->input->post('Claustrofobia');
        $Enfermedades = '';
        $Medicamentos = '';
        $SupervisionMedica = '';


        if($this->input->post('SupervisionMedica') != ''){
            foreach($this->input->post('SupervisionMedica') as $selectedSP){
                $SupervisionMedica .=  $selectedSP.",";
                }
        }else{
            $SupervisionMedica =  null;
        }

        if($this->input->post('enfermedades') != ''){
            foreach($this->input->post('enfermedades') as $selected){
                $Enfermedades .=  $selected.",";
                }
        }else{
            $Enfermedades =  null;
        }

        if($this->input->post('medicamentosUltimosMeses') != ''){
            foreach($this->input->post('medicamentosUltimosMeses') as $selectedMedicamentos){
                $Medicamentos .=  $selectedMedicamentos.",";
            }
            }else{
                $Medicamentos =  null;
            }

            $IdUsuarioLog = $this->session->userdata('IdUsuarios');
            $usuario=$this->ExpedienteC_model->obtenerUsuario($IdUsuarioLog);

        $data=array(
            'SupervisionMedica' => $SupervisionMedica,
            'EspecificacionSupMed' => $this->input->post('especificacionMedica'),
            'EnfermedadesAfecciones' => $Enfermedades,
            'OtrasEnfermedades'  =>$this->input->post('OtrasEnfermedades'),
            'CualesOtrasEnfermedades' =>$this->input->post('CualesOtrasEnfermedades'),
            'ComentariosEnfermedades' =>$this->input->post('ComentariosEnfermedades'),
            'MedicamentosUltimosMeses' => $Medicamentos,

            'Fotosensibilizantes' => $this->input->post('text_sistemico'),
            'Anticancerosos' => $this->input->post('text_anticancerosos'),
            'Antidepresivos' => $this->input->post('text_antidepresivos'),
            'Antihistaminicos' => $this->input->post('text_antihistaminicos'),
            'AntiInflamatorios' => $this->input->post('text_anti_inflamatorios'),
            'Antituberculosos' => $this->input->post('text_antituberculosos'),
            'Antibioticos' => $this->input->post('text_antibioticos'),
            'Antimalaricos' => $this->input->post('text_antimalaricos'),
            'Antipsicoticos' => $this->input->post('text_antipsicoticos'),
            'Ansiedad' => $this->input->post('text_asiendad'),
            'Antiarritmicos' => $this->input->post('text_antiarritmicos'),
            'Psicomotores' => $this->input->post('text_psicomotores'),
            'Diureticos' => $this->input->post('text_diureticos'),
            'Edulcorantes' => $this->input->post('text_edulcorantes'),
            'Hipoglucemiantes' => $this->input->post('text_hipoglucemiantes'),
            'Laxantes' => $this->input->post('text_laxantes'),
            'Psoralenos' => $this->input->post('text_psoralenos'),
            'Tetraciclinas' => $this->input->post('text_tetraciclinas'),
            
            'OtrosMedicamentos' => $this->input->post('OtrosMedicamentos'),
            'CualesOtrosMedicamentos' => $this->input->post('CualesOtrosMedicamentos'),
            'ComentariosMedicamentos' => $this->input->post('ComentariosMedicamentos'),

            'EstaEmbarazada' => $this->input->post('EstaEmbarazada'),
              'EstaLactando' => $this->input->post('EstaLactando'),
              'TieneTatuajes' => $this->input->post('TieneTatuajes'),
              'ZonaTatuaje' => $this->input->post('zonaTatuaje'),
              'LitrosAguaConsume' => $this->input->post('LitrosAguaConsume'),
              'RealizaActividadFisica' => $this->input->post('RealizaActividadFisica'),
              'QueActividadFisica' => $this->input->post('QueActividadFisica'),
              'CadaCuantoActividadFisica' => $this->input->post('CadaCuantoActividadFisica'),
            
            'DiagnosticoyObservaciones' => $this->input->post('DiagnosticoyObservaciones'),
            'Historia' => $this->input->post('Historia')." ".$parametro['Time']= $this->input->post('Time')." ".$parametro['reloj']= $this->input->post('reloj')."-> /// ".$parametro['HistoriaMas']= $this->input->post('HistoriaMas')." "." /// ".$usuario." /// ".$this->input->post('usuarioAlmacenamiento')." /// "." ??? ",

            );

        $edadC = $this->input->post('EdadCliente');
        $fechaNac = date("Y-m-d", strtotime($this->input->post('FechaNacimientoCliente')));
        $sexoCliente = $this->input->post('SexoCliente');
        //$FirmaDigital = $this->input->post('base64');
        //$data['FirmaDigital'] => $this->input->post('base64'),

        if ($this->input->post('firmaDig') != "" || $this->input->post('firmaDig') != null) {
            $RutaFirmaDigital = $this->input->post('base64');
            // echo 'algoo'.$this->input->post('base64');
            //  exit();
            $this->ExpedienteC_model->editarenlace($IdClientes, $data, $fechaNac, $sexoCliente, $edadC, $RutaFirmaDigital);
        }else if ($this->input->post('firmaDig1') != "" || $this->input->post('firmaDig1') != null) {
            $RutaFirmaDigital = null;//$this->input->post('base64');
            //echo 'algo1'.$this->input->post('base64');
                //exit();
            $this->ExpedienteC_model->editarenlace($IdClientes, $data, $fechaNac, $sexoCliente, $edadC, $RutaFirmaDigital);
        }else if($this->input->post('firmaDig2') == "sin valor de imagen"){
            if ($this->input->post('base64') == null || $this->input->post('base64') == "") {
                $RutaFirmaDigital = null;
                //echo '2algo'.$this->input->post('base64');
                //exit();
                $this->ExpedienteC_model->editarenlace($IdClientes, $data, $fechaNac, $sexoCliente, $edadC, $RutaFirmaDigital);
            }else{
                $RutaFirmaDigital = $this->input->post('base64');
                //echo 'algo'.$this->input->post('base64');
                //exit();
                $this->ExpedienteC_model->editarenlace($IdClientes, $data, $fechaNac, $sexoCliente, $edadC, $RutaFirmaDigital);            
            }
        }   
    }
//------------------------------------------------------------------------------------------------------------------------------------------------------
	//Historico Facial 

	//Muestra todos los datos del tratamiento facial dependiendo el Expediete del cliente seleccionado 
	public function EFacial()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlaceExpe = $this->ExpedienteC_model->obtenerExpe($id);
		if($obtenerenlaceExpe != FALSE){
			foreach ($obtenerenlaceExpe->result() as $fila) {
					$clientes_IdClientes = $fila->clientes_IdClientes;
				$Idexpediente=$fila->Idexpediente;
				}
				$data = array(
				'clientes_IdClientes' => $clientes_IdClientes,	
				'Idexpediente' => $Idexpediente,	
				);
			}else{
				$data ='';
				return FALSE;	
		}
		$ReNombre=$this->ExpedienteC_model->obtenerNombre($data);
        foreach ($ReNombre as $i => $Nombre)
        $data['ReNombre'] = $Nombre;
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/listafacial_view', $data);
		$this->load->view('layout/footer');
		}
	}
///////////////////////////////////resultado para database de expediente facial/////////////////////////////////////////
public function InfoFacial()
{
    if($this->session->userdata('Rol_IdRol')==FALSE || 
        $this->session->userdata('Rol_IdRol') == '1'|| 
        $this->session->userdata('Rol_IdRol') == '2')
    {
        redirect(base_url().'acceso/acceso');
    } else {
        $idE = $this->input->post('idE');
    $this->db->select('*');
    $this->db->from('facial');  
    $this->db->where('expediente_Idexpediente',$idE);
    $this->db->where('Sesion != 0');
    $query = $this->db->get();
    $cont = $query->num_rows();

    if($query->num_rows() >0){  
            
        foreach ($query->result() as $facial)
            $data[] = array(
                $FechaFacial = $facial->FechaFacial,
                $Sesion=$facial->Sesion,
                $Tratamiento = $facial->TratamientoSeleccionado,
                $Aparato = $facial->Aparato,
                $Potencia = $facial->Potencia,
                $Zona = $facial->Zona,
                $Tiempo = $facial->Tiempo,
                $Disparos = $facial->Disparos,
                $ObservacionesFacial = $facial->ObservacionesFacial,
                $Diagnostico = $facial->Diagnostico,
                $cosmetologo = $facial->Usuario,
                // $botones = "<a href='".base_url()."expediente/franquiciatario/ExpedienteF/editarFacial/".$facial->expediente_Idexpediente."/".$facial->IdFacial."' class='label label-primary'>"."<span class='glyphicon glyphicon-pencil'></a></span>"."&nbsp;&nbsp;"."<a onclick= 'if(confirmarExp() == false) return false'href='".base_url()."expediente/franquiciatario/ExpedienteF/eliminarFacial/".$facial->IdFacial."/".$facial->expediente_Idexpediente."' class='label label-danger'>"."<span class='glyphicon glyphicon-trash'></a></span>",
            );
                
            
            echo json_encode($data);
            }else{
                echo json_encode(null);
            }
    }
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Muestra la vista agregarfacial_view para agregar las sesiones del tratamiento facial dependiendo el Expediete del cliente seleccionado 
	public function agregarFacial()
	{	
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {

        $data['Franquicias']=$this->ExpedienteC_model->BuscarFranquicia();
        foreach ($data['Franquicias'] as $i => $Franquicias) 
        $idCliente=$this->uri->segment(5);

if($this->input->post('IdServicio') != ''){
   
    $IdServicio = $this->input->post('IdServicio');
    $data['tipoVenta'] = $this->input->post('tipoVenta');


    if($this->input->post('tipoVenta') == 'servicio'){
            $this->db->select('*');
            $this->db->from('facial');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventasserviciosF_IdVentasServicios',$IdServicio);
            $query = $this->db->get();
            $numRows = $query->num_rows()+1;

            if($query->num_rows() >0){

                foreach($query->result() as $fila){
                    $tratamientoSelec = $fila->TratamientoSeleccionado;
                    $RutaFirmaDigital = $fila->RutaFirmaDigital;
                    $Sesion = $fila->Sesion;
                }
                if($query->num_rows() == 1 && $Sesion==0){
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = '1';
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    if($this->input->post('nameServicio') != $tratamientoSelec){
                        $data['nameServicio'] = $tratamientoSelec;
                        $data['numSesion'] = $numRows;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }else{
                        $data['nameServicio'] = $this->input->post('nameServicio');
                        $data['numSesion'] = $numRows;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }
                }


            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }

        if($this->input->post('tipoVenta') == 'promocion'){
            $this->db->select('*');
            $this->db->from('facial');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventaspromociones_IdVentasPromociones',$IdServicio);
            // $query = $this->db->get()->result();
            $queryDos = $this->db->get();
            $numRowsDos = $queryDos->num_rows()+1;

            if($queryDos->num_rows() >0){

                foreach($queryDos->result() as $fila){
                    $tratamientoSelec = $fila->TratamientoSeleccionado;
                    $FirmaDigital = $fila->FirmaDigital;
                    $Sesion = $fila->Sesion;
                }
                if($queryDos->num_rows() == 1 && $Sesion==0){
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = '1';
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    if($this->input->post('nameServicio') != $tratamientoSelec){
                        $data['nameServicio'] = $tratamientoSelec;
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }else{
                        $data['nameServicio'] = $this->input->post('nameServicio');
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }
                }

            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }

}else{
        $data['tipoVenta'] = "";
        $data['nameServicio'] = "";
        $data['numSesion'] = "";
        $data['IdServicio'] = "";
    }

    $data['id'] = $idCliente;
    $data['ReNombre']=$this->ExpedienteC_model->obtenerNombre($data);
    // $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuarioC($i);
    $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuario($i);


		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/agregarfacial_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Guarda los datos introducidos en el tratamiento facial 
	public function guardarFacial(){
        $idExp=$this->uri->segment(5);
        $id=$this->session->userdata('IdUsuarios');
        $usuario=$this->ExpedienteC_model->obtenerUsuario($id);

        if($this->input->post('tipoVenta') != ""){

            $tipoVenta = $this->input->post('tipoVenta');
            $IdServicio = $this->input->post('IdServicio');
            $idCliente=$this->input->post('idCliente');
            $NombreServicio = $this->input->post('nomServicio');//$this->ExpedienteF_model->servicio($IdServicio);
            $NombreCliente = $this->ExpedienteC_model->cliente($idCliente);
            $facial = "facial";

            $query=$this->ExpedienteC_model->verificarImagenConsentimiento($tipoVenta, $IdServicio, $idExp, $facial);

            if($query->num_rows() < 1){
                $tipo = $_FILES['file']['type'];        
                $tamanio = $_FILES['file']['size'];
                $nombre = $_FILES['file']['name'];          
                $archivotmp = $_FILES['file']['tmp_name'];

                $fp = fopen($archivotmp, "rb");
                $contenido = fread($fp, $tamanio);
                fclose($fp);

                $max_ancho = 1180;
                $max_alto = 800;

                if($_FILES['file']['type']=='image/png' || $_FILES['file']['type']=='image/jpeg' || $_FILES['file']['type']=='image/gif'){
                    $medidasimagen= getimagesize($_FILES['file']['tmp_name']);

                    //Si las imagenes tienen una resolución y un peso aceptable se suben tal cual
                    if($medidasimagen[0] < 1280 && $_FILES['file']['size'] < 100000){

                        $IdFacial = "";

                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idCliente;
                        $parametro['Sesion']= 0;
                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                            
                        //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                                            //name del input ][ name del archivo
                       if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                            $this->ExpedienteC_model->guardarFacial($parametro, $idExp, $IdServicio, $IdFacial);
                        }
                    }else{
                        // Caso contrario se generan nuevas imagenes optimizadas
                        $nombrearchivo=$_FILES['file']['name'];
                        $rtOriginal=$_FILES['file']['tmp_name'];

                        if($_FILES['file']['type']=='image/jpeg'){
                            $original = imagecreatefromjpeg($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            $original = imagecreatefrompng($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                            $original = imagecreatefromgif($rtOriginal);
                        }

                        list($ancho,$alto)=getimagesize($rtOriginal);
                        $x_ratio = $max_ancho / $ancho;
                        $y_ratio = $max_alto / $alto;

                        if( ($ancho <= $max_ancho) && ($alto <= $max_alto) ){
                            $ancho_final = $ancho;
                            $alto_final = $alto;
                        }
                        else if (($x_ratio * $alto) < $max_alto){
                            $alto_final = ceil($x_ratio * $alto);
                            $ancho_final = $max_ancho;
                        }
                        else{
                            $ancho_final = ceil($y_ratio * $ancho);
                            $alto_final = $max_alto;
                        }

                        $lienzo=imagecreatetruecolor($ancho_final,$alto_final);
                        imagecopyresampled($lienzo,$original,0,0,0,0,$ancho_final, $alto_final,$ancho,$alto);
                        
                        $cal=8;
                        ob_start();
                        if($_FILES['file']['type']=='image/jpeg'){
                            imagejpeg($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            imagepng($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                        imagegif($lienzo);
                        $salida = ob_get_contents();
                        }
                        ob_end_clean();

                        $IdFacial = "";

                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idCliente;
                        $parametro['Sesion']= 0;
                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                        //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                                            //name del input ][ name del archivo
                        if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                            $this->ExpedienteC_model->guardarFacial($parametro, $idExp, $IdServicio, $IdFacial);
                        }
                    }
                }else{
                    $IdFacial = "";

                    $parametro['respuesta'] = "0";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;

                    $parametro['expediente_Idexpediente']= $idCliente;
                    $parametro['Sesion']= 0;
                    $path = "files/expedientesConsentimiento/";
                    if (!is_dir($path)) {
                        mkdir($path, 0777, true);
                        chmod($path, 0777);
                    }
                    $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                    //cliente_IdCliente_Servicio_FechayHora.extencion 
                    $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                    $path = $path.$name;
                    $parametro['ImagenConsentimiento']= $path; 
                                        //name del input ][ name del archivo
                   if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                        $this->ExpedienteC_model->guardarFacial($parametro, $idExp, $IdServicio, $IdFacial);
                    }
                }

            }else if($query->num_rows() > 0){
                foreach ($query->result() as $value) 
                    $IdFacial = $value->IdFacial;
                    $RutaFirmaDigital = $value->RutaFirmaDigital;
                    $Sesion = $value->Sesion;

                    if($query->num_rows() == 1 && $Sesion == 0){
                        $parametro['respuesta'] = "1";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idExp;
                        $parametro['Sesion']= 1;
                        $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                        $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                        $parametro['Aparato']= $this->input->post('txt_aparatos');
                        $parametro['Potencia']= $this->input->post('txt_potencia');
                        $parametro['Zona']= $this->input->post('txt_zona');
                        $parametro['Tiempo']= $this->input->post('txt_tiempo');
                        $parametro['Disparos']= $this->input->post('txt_disparos');
                        $parametro['ObservacionesFacial']= $this->input->post('txt_observaciones');
                        $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
                        $parametro['Usuario']= $this->input->post('usuario');
                        $parametro['UsuarioLog']= $usuario;
                        
                        if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                            $parametro['FirmaDigital']= null;
                        }else{
                            $path = "files/firmas/";
                            if (!is_dir($path)) {
                                mkdir($path, 0777, true);
                                chmod($path, 0777);
                            }
                            $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                            // Need to decode before saving since the data we received is already base64 encoded
                            $decodedData=base64_decode($filteredData);
                            $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                            // store in server
                            $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                            $fp = fopen($path.$fic_name, 'wb');
                            $ok = fwrite( $fp, $decodedData);
                            fclose( $fp );

                            $parametro['FirmaDigital']= $path.$fic_name;
                        }

                        $this->ExpedienteC_model->guardarFacial($parametro, $idExp, $IdServicio, $IdFacial);
                    }else{
                        $IdFacial = "";
                        $parametro['respuesta'] = "2";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idExp;
                        $parametro['Sesion']= $this->input->post('txt_sesion');
                        $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                        $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                        $parametro['Aparato']= $this->input->post('txt_aparatos');
                        $parametro['Potencia']= $this->input->post('txt_potencia');
                        $parametro['Zona']= $this->input->post('txt_zona');
                        $parametro['Tiempo']= $this->input->post('txt_tiempo');
                        $parametro['Disparos']= $this->input->post('txt_disparos');
                        $parametro['ObservacionesFacial']= $this->input->post('txt_observaciones');
                        $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
                        $parametro['Usuario']= $this->input->post('usuario');
                        $parametro['UsuarioLog']= $usuario;
                        $parametro['ImagenConsentimiento']= null;
                        
                        if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                            $parametro['FirmaDigital']= null;
                        }else{
                            $path = "files/firmas/";
                            if (!is_dir($path)) {
                                mkdir($path, 0777, true);
                                chmod($path, 0777);
                            }
                            $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                            // Need to decode before saving since the data we received is already base64 encoded
                            $decodedData=base64_decode($filteredData);
                            $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                            // store in server
                            $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                            $fp = fopen($path.$fic_name, 'wb');
                            $ok = fwrite( $fp, $decodedData);
                            fclose( $fp );

                            $parametro['FirmaDigital']= $path.$fic_name;
                        }

                        $this->ExpedienteC_model->guardarFacial($parametro, $idExp, $IdServicio, $IdFacial);
                    }
            }
        }else{
            $IdFacial = "";
            $IdServicio = "";

            $parametro['respuesta'] = "libre";
            $parametro['tipoVenta']= "";
            $parametro['IdServicio']= "";
            $parametro['expediente_Idexpediente']= $idExp;
            $parametro['Sesion']= $this->input->post('txt_sesion');
            $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
            $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
            $parametro['Aparato']= $this->input->post('txt_aparatos');
            $parametro['Potencia']= $this->input->post('txt_potencia');
            $parametro['Zona']= $this->input->post('txt_zona');
            $parametro['Tiempo']= $this->input->post('txt_tiempo');
            $parametro['Disparos']= $this->input->post('txt_disparos');
            $parametro['ObservacionesFacial']= $this->input->post('txt_observaciones');
            $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
            $parametro['Usuario']= $this->input->post('usuario');
            $parametro['UsuarioLog']= $usuario;
            $parametro['ImagenConsentimiento']= null;
                
            if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                $parametro['FirmaDigital']= null;
            }else{
                $path = "files/firmas/";
                if (!is_dir($path)) {
                    mkdir($path, 0777, true);
                    chmod($path, 0777);
                }
                $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                // Need to decode before saving since the data we received is already base64 encoded
                $decodedData=base64_decode($filteredData);
                $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                // store in server
                $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                $fp = fopen($path.$fic_name, 'wb');
                $ok = fwrite( $fp, $decodedData);
                fclose( $fp );

                $parametro['FirmaDigital']= $path.$fic_name;
            }
            $this->ExpedienteC_model->guardarFacial($parametro, $idExp, $IdServicio, $IdFacial);
        }

	}

	//-----------------------------------------------------------------------------------------------------------------------------------------------------
 	//Historico ELigth  

	//Muestra todos los datos del tratamiento EELigth dependiendo el Expediete del cliente seleccionado 
	public function EELigth()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlaceExpe = $this->ExpedienteC_model->obtenerExpe($id);
		if($obtenerenlaceExpe != FALSE){
			foreach ($obtenerenlaceExpe->result() as $fila) {
					$clientes_IdClientes = $fila->clientes_IdClientes;
					$Idexpediente=$fila->Idexpediente;
				}
				$data = array(
				'clientes_IdClientes' => $clientes_IdClientes,	
				'Idexpediente' => $Idexpediente,	
				);
			}else{
				$data ='';
				return FALSE;	
		}
		// $this->db->select('*');
		// $this->db->where('Expediente_Idexpediente',$this->uri->segment(5));
		// $data['consulta']=$this->db->get('eligth')->result();
		$ReNombre=$this->ExpedienteC_model->obtenerNombre($data);
        foreach ($ReNombre as $i => $Nombre)
        $data['ReNombre'] = $Nombre;
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/listaeligth_view',$data);
		$this->load->view('layout/footer');
		}
	}

    ///////////////////////////////////resultado para database de expediente facial/////////////////////////////////////////
    public function InfoEligth()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
            $idE = $this->input->post('idE');
        $this->db->select('*');
        $this->db->from('eligth');  
        $this->db->where('expediente_Idexpediente',$idE);
        $this->db->where('Sesion != 0');
        $query = $this->db->get();
        $cont = $query->num_rows();

        if($query->num_rows() >0){
                
            foreach ($query->result() as $eligth) {
                $data[] = array(
                    $FechaEligth = $eligth->FechaEligth,
                    $Sesion=$eligth->Sesion,
                    $Tratamiento = $eligth->TratamientoSeleccionado,
                    $Potencia = $eligth->Potencia,
                    $ZonaEligth = $eligth->ZonaEligth,
                    $Disparos = $eligth->Disparos,
                    $ObservacionesEligth = $eligth->ObservacionesEligth,
                    $Diagnostico = $eligth->Diagnostico,
                    $cosmetologo = $eligth->Usuario,
                );
                    
                }
                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }
        }
    }

	//Muestra la vista agregareligth_view para agregar las sesiones del tratamiento Elight dependiendo el Expediete del cliente seleccionado 
	public function agregarEligth()
	{	
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->ExpedienteC_model->BuscarFranquicia();
        foreach ($data['Franquicias'] as $i => $Franquicias) 
        $idCliente=$this->uri->segment(5);

    if($this->input->post('IdServicio') != ''){

        $IdServicio = $this->input->post('IdServicio');
        $data['tipoVenta'] = $this->input->post('tipoVenta');

        if($this->input->post('tipoVenta') == 'servicio'){
            $this->db->select('*');
            $this->db->from('eligth');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventasserviciosF_IdVentasServicios',$IdServicio);
            // $query = $this->db->get()->result();
            $query = $this->db->get();
            // $queryServicio = $this->db->get();
            $numRows = $query->num_rows()+1;

            if($query->num_rows() >0){

                foreach($query->result() as $fila){
                    $tratamientoSelec = $fila->TratamientoSeleccionado;
                    $RutaFirmaDigital = $fila->RutaFirmaDigital;
                    $Sesion = $fila->Sesion;
                }
                if($query->num_rows() == 1 && $Sesion==0){
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = '1';
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    if($this->input->post('nameServicio') != $tratamientoSelec){
                        $data['nameServicio'] = $tratamientoSelec;
                        $data['numSesion'] = $numRows;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }else{
                        $data['nameServicio'] = $this->input->post('nameServicio');
                        $data['numSesion'] = $numRows;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }
                }

            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }

        if($this->input->post('tipoVenta') == 'promocion'){
            $this->db->select('*');
            $this->db->from('eligth');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventaspromociones_IdVentasPromociones',$IdServicio);
            // $query = $this->db->get()->result();
            $queryDos = $this->db->get();
            $numRowsDos = $queryDos->num_rows()+1;

            if($queryDos->num_rows() >0){

                foreach($queryDos->result() as $fila){
                    $tratamientoSelec = $fila->TratamientoSeleccionado;
                    $FirmaDigital = $fila->FirmaDigital;
                    $Sesion = $fila->Sesion;
                }
                if($queryDos->num_rows() == 1 && $Sesion==0){
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = '1';
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    if($this->input->post('nameServicio') != $tratamientoSelec){
                        $data['nameServicio'] = $tratamientoSelec;
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }else{
                        $data['nameServicio'] = $this->input->post('nameServicio');
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }
                }

            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }
    }else{
        $data['tipoVenta'] = "";
        $data['nameServicio'] = "";
        $data['numSesion'] = "";
        $data['IdServicio'] = "";
    }


        $data['id'] = $idCliente;
        $data['ReNombre']=$this->ExpedienteC_model->obtenerNombre($data);
        $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuario($i);
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/agregareligth_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Guarda los datos introducidos en el tratamiento ELigth
	public function guardarEligth(){
        $idExp=$this->uri->segment(5);
        $id=$this->session->userdata('IdUsuarios');
        $usuario=$this->ExpedienteC_model->obtenerUsuario($id);

        if($this->input->post('tipoVenta') != ""){

            $tipoVenta = $this->input->post('tipoVenta');
            $IdServicio = $this->input->post('IdServicio');
            $idCliente=$this->input->post('idCliente');
            $NombreServicio = $this->input->post('nomServicio');//$this->ExpedienteF_model->servicio($IdServicio);
            $NombreCliente = $this->ExpedienteC_model->cliente($idCliente);

            $eligth = "eligth";

            $query=$this->ExpedienteC_model->verificarImagenConsentimiento($tipoVenta, $IdServicio, $idExp, $eligth);

            if($query->num_rows() < 1){
                $tipo = $_FILES['file']['type'];        
                $tamanio = $_FILES['file']['size'];
                $nombre = $_FILES['file']['name'];          
                $archivotmp = $_FILES['file']['tmp_name'];

                $fp = fopen($archivotmp, "rb");
                $contenido = fread($fp, $tamanio);
                fclose($fp);

                $max_ancho = 1180;
                $max_alto = 800;

                if($_FILES['file']['type']=='image/png' || $_FILES['file']['type']=='image/jpeg' || $_FILES['file']['type']=='image/gif'){
                    $medidasimagen= getimagesize($_FILES['file']['tmp_name']);

                    //Si las imagenes tienen una resolución y un peso aceptable se suben tal cual
                    if($medidasimagen[0] < 1280 && $_FILES['file']['size'] < 100000){
                        $IdEligth = "";

                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idCliente;
                        // $parametro['IdServicio']= $IdServicio;
                        $parametro['Sesion']= 0;
                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                        //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                            //name del input ][ name del archivo
                       if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                            $this->ExpedienteC_model->guardarEligth($parametro, $idExp, $IdServicio, $IdEligth);
                        }
                                
                    }else{
                        // Caso contrario se generan nuevas imagenes optimizadas
                        $nombrearchivo=$_FILES['file']['name'];
                        $rtOriginal=$_FILES['file']['tmp_name'];

                        if($_FILES['file']['type']=='image/jpeg'){
                            $original = imagecreatefromjpeg($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            $original = imagecreatefrompng($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                            $original = imagecreatefromgif($rtOriginal);
                        }

                        list($ancho,$alto)=getimagesize($rtOriginal);
                        $x_ratio = $max_ancho / $ancho;
                        $y_ratio = $max_alto / $alto;

                        if( ($ancho <= $max_ancho) && ($alto <= $max_alto) ){
                            $ancho_final = $ancho;
                            $alto_final = $alto;
                        }
                        else if (($x_ratio * $alto) < $max_alto){
                            $alto_final = ceil($x_ratio * $alto);
                            $ancho_final = $max_ancho;
                        }
                        else{
                            $ancho_final = ceil($y_ratio * $ancho);
                            $alto_final = $max_alto;
                        }

                        $lienzo=imagecreatetruecolor($ancho_final,$alto_final);
                        imagecopyresampled($lienzo,$original,0,0,0,0,$ancho_final, $alto_final,$ancho,$alto);
                        
                        $cal=8;
                        ob_start();
                        if($_FILES['file']['type']=='image/jpeg'){
                            imagejpeg($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            imagepng($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                            imagegif($lienzo);
                            $salida = ob_get_contents();
                        }
                        ob_end_clean();

                        $IdEligth = "";

                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idCliente;
                        // $parametro['IdServicio']= $IdServicio;
                        $parametro['Sesion']= 0;
                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                        //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                                            //name del input ][ name del archivo
                       if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                            $this->ExpedienteC_model->guardarEligth($parametro, $idExp, $IdServicio, $IdEligth);
                        }
                    }
                }else{
                    $IdEligth = "";
                    $parametro['respuesta'] = "0";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;

                    $parametro['expediente_Idexpediente']= $idCliente;
                    // $parametro['IdServicio']= $IdServicio;
                    $parametro['Sesion']= 0;
                    $path = "files/expedientesConsentimiento/";
                    if (!is_dir($path)) {
                        mkdir($path, 0777, true);
                        chmod($path, 0777);
                    }
                    $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                    
                    //cliente_IdCliente_Servicio_FechayHora.extencion 
                    $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                                        $path = $path.$name;
                    $parametro['ImagenConsentimiento']= $path; 
                                        //name del input ][ name del archivo
                   if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                        $this->ExpedienteC_model->guardarEligth($parametro, $idExp, $IdServicio, $IdEligth);
                    }
                }

            }else if($query->num_rows() > 0){
                foreach ($query->result() as $value) 
                    $IdEligth = $value->IdEligth;
                    $RutaFirmaDigital = $value->RutaFirmaDigital;
                    $Sesion = $value->Sesion;

                if($query->num_rows() == 1 && $Sesion == 0){
                    $parametro['respuesta'] = "1";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;

                    $parametro['expediente_Idexpediente']= $idExp;
                    $parametro['Sesion']= 1;
                    $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                    $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                    $parametro['Potencia']= $this->input->post('txt_potencia');
                    $parametro['ZonaEligth']= $this->input->post('txt_zona');
                    $parametro['Disparos']= $this->input->post('txt_disparos');
                    $parametro['ObservacionesEligth']= $this->input->post('txt_observaciones');
                    $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
                    $parametro['Usuario']= $this->input->post('usuario');
                    $parametro['UsuarioLog']= $usuario;
                    
                    if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                        $parametro['FirmaDigital']= null;
                    }else{
                        $path = "files/firmas/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                        // Need to decode before saving since the data we received is already base64 encoded
                        $decodedData=base64_decode($filteredData);
                        $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                        // store in server
                        $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                        $fp = fopen($path.$fic_name, 'wb');
                        $ok = fwrite( $fp, $decodedData);
                        fclose( $fp );

                        $parametro['FirmaDigital']= $path.$fic_name;
                    }
                    $this->ExpedienteC_model->guardarEligth($parametro, $idExp, $IdServicio, $IdEligth);
                }else{
                    $IdEligth = "";
                    $parametro['respuesta'] = "2";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;

                    $parametro['expediente_Idexpediente']= $idExp;

                    $parametro['Sesion']= $this->input->post('txt_sesion');
                    $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                    $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                        // $parametro['Tratamiento']= $this->input->post('txt_nombref');
                    $parametro['Potencia']= $this->input->post('txt_potencia');
                    $parametro['ZonaEligth']= $this->input->post('txt_zona');
                    $parametro['Disparos']= $this->input->post('txt_disparos');
                    $parametro['ObservacionesEligth']= $this->input->post('txt_observaciones');
                    $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
                    $parametro['Usuario']= $this->input->post('usuario');
                    $parametro['UsuarioLog']= $usuario;
                    $parametro['ImagenConsentimiento']= null;
                    
                    if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                        $parametro['FirmaDigital']= null;
                    }else{
                        $path = "files/firmas/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                        // Need to decode before saving since the data we received is already base64 encoded
                        $decodedData=base64_decode($filteredData);
                        $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                        // store in server
                        $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                        $fp = fopen($path.$fic_name, 'wb');
                        $ok = fwrite( $fp, $decodedData);
                        fclose( $fp );

                        $parametro['FirmaDigital']= $path.$fic_name;
                    }

                        // echo $this->input->post('base64');
                    $this->ExpedienteC_model->guardarEligth($parametro, $idExp, $IdServicio, $IdEligth);

                }
            }
        }else{
            $IdEligth = "";
            $IdServicio = "";
            $parametro['respuesta'] = "libre";
            $parametro['tipoVenta']= "";
            $parametro['IdServicio']= "";

            $parametro['expediente_Idexpediente']= $idExp;
            $parametro['Sesion']= $this->input->post('txt_sesion');
            $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
            $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
            $parametro['Potencia']= $this->input->post('txt_potencia');
            $parametro['ZonaEligth']= $this->input->post('txt_zona');
            $parametro['Disparos']= $this->input->post('txt_disparos');
            $parametro['ObservacionesEligth']= $this->input->post('txt_observaciones');
            $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
            $parametro['Usuario']= $this->input->post('usuario');
            $parametro['UsuarioLog']= $usuario;
            $parametro['ImagenConsentimiento']= null;

            if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                $parametro['FirmaDigital']= null;
            }else{
                $path = "files/firmas/";
                if (!is_dir($path)) {
                    mkdir($path, 0777, true);
                    chmod($path, 0777);
                }
                $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                // Need to decode before saving since the data we received is already base64 encoded
                $decodedData=base64_decode($filteredData);
                $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                // store in server
                $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                $fp = fopen($path.$fic_name, 'wb');
                $ok = fwrite( $fp, $decodedData);
                fclose( $fp );

                $parametro['FirmaDigital']= $path.$fic_name;
            }

                $this->ExpedienteC_model->guardarEligth($parametro, $idExp, $IdServicio, $IdEligth);
            }

	}


//-------------------------------------------------------------------------------------------------------------------------------------------------------
		//Historico Corporal
	//Muestra todos los datos del tratamiento Corporal dependiendo el Expediete del cliente seleccionado 
	public function Corporal()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlaceExpe = $this->ExpedienteC_model->obtenerExpe($id);
		if($obtenerenlaceExpe != FALSE){
			foreach ($obtenerenlaceExpe->result() as $fila) {
					$clientes_IdClientes = $fila->clientes_IdClientes;
					$Idexpediente=$fila->Idexpediente;
				}
				$data = array(
				'clientes_IdClientes' => $clientes_IdClientes,	
				'Idexpediente' => $Idexpediente,	
				);
			}else{
				$data ='';
				return FALSE;
		}

        $ReNombre=$this->ExpedienteC_model->obtenerNombre($data);
        foreach ($ReNombre as $i => $Nombre)
        $data['ReNombre'] = $Nombre;

		$this->db->select('*');
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/listaCorporal_view',$data);
		$this->load->view('layout/footer');
		}
	}

    ///////////////////////////////////resultado para database de expediente Corporal/////////////////////////////////////////
    public function InfoCorporal()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $idE = $this->input->post('idE');
        $this->db->select('*');
        $this->db->from('corporal');  
        $this->db->where('expediente_Idexpediente',$idE);
        $this->db->where('Sesion != 0');
        $query = $this->db->get();
        $cont = $query->num_rows();

        if($query->num_rows() >0){  

            foreach ($query->result() as $corporal) {
                    $data[] = array(
                        $FechaCorporal = $corporal->FechaCorporal,
                        $Sesion=$corporal->Sesion,
                        $Tratamiento = $corporal->TratamientoSeleccionado,
                        $Aparato = $corporal->Aparato,
                        $Zona = $corporal->Zona,
                        $Tiempo = $corporal->Tiempo,
                        $Observacionescorporal = $corporal->ObservacionCorporal,
                        $Diagnostico = $corporal->Diagnostico,
                        $cosmetologo = $corporal->Usuario,
                        
                    );

                   
                }
                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }

        }
    }

	//Muestra la vista agregarcorporal_view para agregar las sesiones del tratamiento Elight dependiendo el Expediete del cliente seleccionado 
	public function agregarCorporal()
	{	
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
        $data['Franquicias']=$this->ExpedienteC_model->BuscarFranquicia();
        foreach ($data['Franquicias'] as $i => $Franquicias) 
		$idCliente=$this->uri->segment(5);

    if($this->input->post('IdServicio') != ''){

        $IdServicio = $this->input->post('IdServicio');
        $data['tipoVenta'] = $this->input->post('tipoVenta');
        

        if($this->input->post('tipoVenta') == 'servicio'){
            $this->db->select('*');
            $this->db->from('corporal');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventasserviciosF_IdVentasServicios',$IdServicio);
            // $query = $this->db->get()->result();
            $query = $this->db->get();
            // $queryServicio = $this->db->get();
            $numRows = $query->num_rows()+1;

            if($query->num_rows() >0){

               foreach($query->result() as $fila){
                    $tratamientoSelec = $fila->TratamientoSeleccionado;
                    $RutaFirmaDigital = $fila->RutaFirmaDigital;
                    $Sesion = $fila->Sesion;
                }
                if($query->num_rows() == 1 && $Sesion==0){
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = '1';
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{

                    if($this->input->post('nameServicio') != $tratamientoSelec){
                    $data['nameServicio'] = $tratamientoSelec;
                    $data['numSesion'] = $numRows;
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = $numRows;
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }

                }

            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }

        if($this->input->post('tipoVenta') == 'promocion'){
            $this->db->select('*');
            $this->db->from('corporal');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventaspromociones_IdVentasPromociones',$IdServicio);
            // $query = $this->db->get()->result();
            $queryDos = $this->db->get();
            $numRowsDos = $queryDos->num_rows()+1;

            if($queryDos->num_rows() >0){

                foreach($queryDos->result() as $fila){
                    $tratamientoSelec = $fila->TratamientoSeleccionado;
                    $FirmaDigital = $fila->FirmaDigital;
                    $Sesion = $fila->Sesion;
                }
                if($queryDos->num_rows() == 1 && $Sesion==0){
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = '1';
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    if($this->input->post('nameServicio') != $tratamientoSelec){
                        $data['nameServicio'] = $tratamientoSelec;
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }else{
                        $data['nameServicio'] = $this->input->post('nameServicio');
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }
                }
  
            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }
    
    }else{
        $data['tipoVenta'] = "";
        $data['nameServicio'] = "";
        $data['numSesion'] = "";
        $data['IdServicio'] = "";
    }

        $data['id'] = $idCliente;
        $data['ReNombre']=$this->ExpedienteC_model->obtenerNombre($data);
        $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuario($i);

		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/agregarcorporal_view',$data);
		$this->load->view('layout/footer');
		}
	}


	//Guarda los datos introducidos en el tratamiento ELigth
	public function guardarCorporal(){
        $id=$this->session->userdata('IdUsuarios');
        $idExp=$this->uri->segment(5);
        $usuario=$this->ExpedienteC_model->obtenerUsuario($id);

        if($this->input->post('tipoVenta') != ""){

            $tipoVenta= $this->input->post('tipoVenta');
            $IdServicio= $this->input->post('IdServicio');
            $idCliente=$this->input->post('idCliente');
            $NombreServicio = $this->input->post('nomServicio');//$this->ExpedienteF_model->servicio($IdServicio);
            $NombreCliente = $this->ExpedienteC_model->cliente($idCliente);

            $corporal = "corporal";

            $query=$this->ExpedienteC_model->verificarImagenConsentimiento($tipoVenta, $IdServicio, $idExp,$corporal);

            if($query->num_rows() < 1){
                $tipo = $_FILES['file']['type'];        
                $tamanio = $_FILES['file']['size'];
                $nombre = $_FILES['file']['name'];          
                $archivotmp = $_FILES['file']['tmp_name'];

                $fp = fopen($archivotmp, "rb");
                $contenido = fread($fp, $tamanio);
                fclose($fp);

                $max_ancho = 1180;
                $max_alto = 800; 

                if($_FILES['file']['type']=='image/png' || $_FILES['file']['type']=='image/jpeg' || $_FILES['file']['type']=='image/gif'){
                    $medidasimagen= getimagesize($_FILES['file']['tmp_name']);

                    //Si las imagenes tienen una resolución y un peso aceptable se suben tal cual
                    if($medidasimagen[0] < 1280 && $_FILES['file']['size'] < 100000){
                        $IdCorporal = "";

                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idCliente;
                        // $parametro['IdServicio']= $IdServicio;
                        $parametro['Sesion']= 0;

                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                              //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                                                        //name del input ][ name del archivo
                        if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                           $this->ExpedienteC_model->guardarCorporal($parametro, $idExp, $IdServicio, $IdCorporal);
                        }
                        // echo "tipo = ".$tipo;
                    }else{
                        // Caso contrario se generan nuevas imagenes optimizadas
                        $nombrearchivo=$_FILES['file']['name'];
                        $rtOriginal=$_FILES['file']['tmp_name'];

                        if($_FILES['file']['type']=='image/jpeg'){
                            $original = imagecreatefromjpeg($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            $original = imagecreatefrompng($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                            $original = imagecreatefromgif($rtOriginal);
                        }

                        list($ancho,$alto)=getimagesize($rtOriginal);
                        $x_ratio = $max_ancho / $ancho;
                        $y_ratio = $max_alto / $alto;

                        if( ($ancho <= $max_ancho) && ($alto <= $max_alto) ){
                            $ancho_final = $ancho;
                            $alto_final = $alto;
                        }
                        else if (($x_ratio * $alto) < $max_alto){
                            $alto_final = ceil($x_ratio * $alto);
                            $ancho_final = $max_ancho;
                        }
                        else{
                            $ancho_final = ceil($y_ratio * $ancho);
                            $alto_final = $max_alto;
                        }

                        $lienzo=imagecreatetruecolor($ancho_final,$alto_final);
                        imagecopyresampled($lienzo,$original,0,0,0,0,$ancho_final, $alto_final,$ancho,$alto);
                        
                        $cal=8;
                        ob_start();
                        if($_FILES['file']['type']=='image/jpeg'){
                            imagejpeg($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            imagepng($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                            imagegif($lienzo);
                            $salida = ob_get_contents();
                        }
                        ob_end_clean();

                        $IdCorporal = "";

                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idCliente;
                        // $parametro['IdServicio']= $IdServicio;
                        $parametro['Sesion']= 0;
                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                        //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                                            //name del input ][ name del archivo
                       if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                           $this->ExpedienteC_model->guardarCorporal($parametro, $idExp, $IdServicio, $IdCorporal);
                        }
                        // echo "tipo = ".$tipo;
                    }
                }else{
                    $IdCorporal = "";

                    $parametro['respuesta'] = "0";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;
                    $parametro['expediente_Idexpediente']= $idCliente;
                    // $parametro['IdServicio']= $IdServicio;
                    $parametro['Sesion']= 0;
                    $path = "files/expedientesConsentimiento/";
                    if (!is_dir($path)) {
                        mkdir($path, 0777, true);
                        chmod($path, 0777);
                    }
                    $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                    //cliente_IdCliente_Servicio_FechayHora.extencion 
                    $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                    $path = $path.$name;
                    $parametro['ImagenConsentimiento']= $path; 
                            //name del input ][ name del archivo
                    if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                       $this->ExpedienteC_model->guardarCorporal($parametro, $idExp, $IdServicio, $IdCorporal);
                    }
                    // echo "tipo = ".$tipo;
                }

        }else if($query->num_rows() > 0){
            foreach ($query->result() as $value) 
                $IdCorporal = $value->IdCorporal;
                $RutaFirmaDigital = $value->RutaFirmaDigital;
                $Sesion = $value->Sesion;

                if($query->num_rows() == 1 && $Sesion == 0){
                    $parametro['respuesta'] = "1";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;

                    $parametro['expediente_Idexpediente']= $idExp;
                    $parametro['Sesion']= 1;
                    $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                    $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                    $parametro['Aparato']= $this->input->post('Aparato');
                    $parametro['Potencia']= $this->input->post('Potencia');
                    $parametro['Zona']= $this->input->post('Zona');
                    $parametro['Tiempo']= $this->input->post('Tiempo');
                    $parametro['Disparos']= $this->input->post('Disparos');
                    $parametro['Espalda']= $this->input->post('txt_espalda');
                    $parametro['Busto']= $this->input->post('txt_busto');
                    $parametro['Abdomen']= $this->input->post('txt_abdomen');
                    $parametro['Cintura']= $this->input->post('txt_cintura');
                    $parametro['CAlta']= $this->input->post('txt_calta');
                    $parametro['CBaja']= $this->input->post('txt_cbaja');
                    $parametro['PDer']= $this->input->post('txt_pderecha');
                    $parametro['PIzq']= $this->input->post('txt_pizquierda');
                    $parametro['BDer']= $this->input->post('txt_bderecho');
                    $parametro['BIzq']= $this->input->post('txt_bizquierdo');
                    $parametro['ObservacionCorporal']= $this->input->post('txt_observaciones');
                    $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
                    $parametro['Usuario']= $this->input->post('usuario');
                    $parametro['UsuarioLog']= $usuario;

                    if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                        $parametro['FirmaDigital']= null;
                    }else{
                        // echo "respuesta == 1";
                        $path = "files/firmas/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                        // Need to decode before saving since the data we received is already base64 encoded
                        $decodedData=base64_decode($filteredData);
                        $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                        // store in server
                        $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                        $fp = fopen($path.$fic_name, 'wb');
                        $ok = fwrite( $fp, $decodedData);
                        fclose( $fp );

                        $parametro['FirmaDigital']= $path.$fic_name;//$this->input->post('base64');
                    }

                    $this->ExpedienteC_model->guardarCorporal($parametro, $idExp, $IdServicio, $IdCorporal);
                }else{
                    $IdCorporal = "";
                    $parametro['respuesta'] = "2";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;

                    $parametro['expediente_Idexpediente']= $idExp;
                    $parametro['Sesion']= $this->input->post('txt_sesion');
                    $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                    $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                    $parametro['Aparato']= $this->input->post('Aparato');
                    $parametro['Potencia']= $this->input->post('Potencia');
                    $parametro['Zona']= $this->input->post('Zona');
                    $parametro['Tiempo']= $this->input->post('Tiempo');
                    $parametro['Disparos']= $this->input->post('Disparos');
                    $parametro['Espalda']= $this->input->post('txt_espalda');
                    $parametro['Busto']= $this->input->post('txt_busto');
                    $parametro['Abdomen']= $this->input->post('txt_abdomen');
                    $parametro['Cintura']= $this->input->post('txt_cintura');
                    $parametro['CAlta']= $this->input->post('txt_calta');
                    $parametro['CBaja']= $this->input->post('txt_cbaja');
                    $parametro['PDer']= $this->input->post('txt_pderecha');
                    $parametro['PIzq']= $this->input->post('txt_pizquierda');
                    $parametro['BDer']= $this->input->post('txt_bderecho');
                    $parametro['BIzq']= $this->input->post('txt_bizquierdo');
                    $parametro['ObservacionCorporal']= $this->input->post('txt_observaciones');
                    $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
                    $parametro['Usuario']= $this->input->post('usuario');
                    $parametro['UsuarioLog']= $usuario;
                    $parametro['ImagenConsentimiento']= null;
                    
                    if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                        $parametro['FirmaDigital']= null;
                    }else{
                        $path = "files/firmas/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                        // Need to decode before saving since the data we received is already base64 encoded
                        $decodedData=base64_decode($filteredData);
                        $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                        
                        // store in server
                        $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';
                        $fp = fopen($path.$fic_name, 'wb');
                        $ok = fwrite( $fp, $decodedData);
                        fclose( $fp );
                        // echo "respuesta > 1";
                        $parametro['FirmaDigital']= $path.$fic_name;//$this->input->post('base64');
                    }
                    $this->ExpedienteC_model->guardarCorporal($parametro, $idExp, $IdServicio, $IdCorporal);
                }
        }

    }else{
        $IdCorporal = "";
        $IdServicio = "";

        $parametro['respuesta'] = "libre";
        $parametro['tipoVenta']= "";
        $parametro['IdServicio']= "";

        $parametro['expediente_Idexpediente']= $idExp;
        $parametro['Sesion']= $this->input->post('txt_sesion');
        $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
        $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
        $parametro['Aparato']= $this->input->post('Aparato');
        $parametro['Potencia']= $this->input->post('Potencia');
        $parametro['Zona']= $this->input->post('Zona');
        $parametro['Tiempo']= $this->input->post('Tiempo');
        $parametro['Disparos']= $this->input->post('Disparos');
        $parametro['Espalda']= $this->input->post('txt_espalda');
        $parametro['Busto']= $this->input->post('txt_busto');
        $parametro['Abdomen']= $this->input->post('txt_abdomen');
        $parametro['Cintura']= $this->input->post('txt_cintura');
        $parametro['CAlta']= $this->input->post('txt_calta');
        $parametro['CBaja']= $this->input->post('txt_cbaja');
        $parametro['PDer']= $this->input->post('txt_pderecha');
        $parametro['PIzq']= $this->input->post('txt_pizquierda');
        $parametro['BDer']= $this->input->post('txt_bderecho');
        $parametro['BIzq']= $this->input->post('txt_bizquierdo');
        $parametro['ObservacionCorporal']= $this->input->post('txt_observaciones');
        $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
        $parametro['Usuario']= $this->input->post('usuario');
        $parametro['UsuarioLog']= $usuario;
        $parametro['ImagenConsentimiento']= null;
        
        if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
            $parametro['FirmaDigital']= null;
        }else{
            $path = "files/firmas/";
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
                chmod($path, 0777);
            }
            $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
            // Need to decode before saving since the data we received is already base64 encoded
            $decodedData=base64_decode($filteredData);
            $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
            // store in server
            $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';
            $fp = fopen($path.$fic_name, 'wb');
            $ok = fwrite( $fp, $decodedData);
            fclose( $fp );

            $parametro['FirmaDigital']= $path.$fic_name;//$this->input->post('base64');
        }
        $this->ExpedienteC_model->guardarCorporal($parametro, $idExp, $IdServicio, $IdCorporal);
    }


	}

	//-------------------------------------------------------------------------------------------------------------------------------------------------------
		//Historico Pestañas 
//Muestra todos los datos del tratamiento Pestañas dependiendo el Expediete del cliente seleccionado 
	public function EPestanas()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
        $obtenerenlaceExpe = $this->ExpedienteC_model->obtenerExpe($id);
        $obtenerIDCliente = $this->ExpedienteC_model->BuscarIDClientes($id);

        foreach ($obtenerIDCliente->result() as $fila2) {
                    $IdClientes = $fila2->IdClientes;
                    $NombreCliente=$fila2->NombreCliente;
                }

        if($obtenerenlaceExpe != FALSE){
            foreach ($obtenerenlaceExpe->result() as $fila) {
                    $clientes_IdClientes = $fila->clientes_IdClientes;
                    $Idexpediente=$fila->Idexpediente;
                }
                $data = array(
                'clientes_IdClientes' => $clientes_IdClientes,  
                'Idexpediente' => $Idexpediente,    
                );
            }else{

        if($obtenerIDCliente != FALSE){
                $data = array(
                'IdClientes' => $IdClientes,    
                'NombreCliente' => $NombreCliente,  
                );
                $data['Idexpediente']=null;
            }else{
                $data ='';
                return FALSE;
            }
                
        }

        $data['IdCliente']=$IdClientes;
        $data['ReNombre']=$NombreCliente;

		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/listapestanas_view', $data);
		$this->load->view('layout/footer');
		}
	}

///////////////////////////////////resultado para database de expediente facial/////////////////////////////////////////
    public function InfoPestanas()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {

            ///////////////////////////////////////////////////////////

        $idE = $this->input->post('idE');
        $this->db->select('*');
        $this->db->from('pestañas');  
        $this->db->where('clientes_IdClientes',$idE);
        $query = $this->db->get()->result();

        if($query != null){ 
            foreach($query as $fila) {
                $data[] = array(
                    $FechaPestañas = $fila->FechaPestañas,
                    $Sesion=$fila->Sesion,
                    // $consentimientopestañas_IdConsentimien = $fila->consentimientopestañas_IdConsentimien,
                    $Tratamiento = $fila->TratamientoSeleccionado,
                    $Grosor = $fila->Grosor,
                    $Longitud = $fila->Longitud,
                    $Curva = $fila->Curva,
                    $Cantidad = $fila->Cantidad,
                    $ResultadoAler = $fila->ResultadoAler,
                    $ObservacionesPestañas = $fila->ObservacionesPestañas,
                    $Diagnostico = $fila->Diagnostico,
                    $Cosmetologa = $fila->Usuario,
                    // $botones ="<a href='".base_url()."expediente/franquiciatario/ExpedienteF/editarPestanas/".$fila->expediente_Idexpediente."/".$fila->IdPestañas."' class='label label-primary'>"."<span class='glyphicon glyphicon-pencil'></a></span>"."&nbsp;&nbsp;"."<a onclick= 'if(confirmarExp() == false) return false'href='".base_url()."expediente/franquiciatario/ExpedienteF/eliminarPestanas/".$fila->IdPestañas."/".$fila->expediente_Idexpediente."' class='label label-danger'>"."<span class='glyphicon glyphicon-trash'></a></span>",

                );
                    
                }
                
                    echo json_encode($data);
                }else{
                    echo json_encode(null);
                }
                

        }
    }

	public function agregarPestanas()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->ExpedienteC_model->BuscarFranquicia();
        foreach ($data['Franquicias'] as $i => $Franquicias) 
        $idCliente=$this->uri->segment(5);

    if($this->input->post('IdServicio') != ''){

        $IdServicio = $this->input->post('IdServicio');
        $data['tipoVenta'] = $this->input->post('tipoVenta');

        if($this->input->post('tipoVenta') == 'servicio'){
            $this->db->select('*');
            $this->db->from('pestañas');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventasserviciosF_IdVentasServicios',$IdServicio);
            // $query = $this->db->get()->result();
            $query = $this->db->get();
            $numRows = $query->num_rows()+1;

            if($query != null){
                    $data['numSesion'] = $numRows;
                    $data['IdServicio'] = $this->input->post('IdServicio');
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['consentimiento'] = $this->input->post('consentimiento');
            }else{
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['consentimiento'] = $this->input->post('consentimiento');
            }
        }

        if($this->input->post('tipoVenta') == 'promocion'){
            $this->db->select('*');
            $this->db->from('pestañas');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventaspromociones_IdVentasPromociones',$IdServicio);
            // $query = $this->db->get()->result();
            $query = $this->db->get();
            $numRows = $query->num_rows()+1;

            if($query != null){
                    $data['numSesion'] = $numRows;
                    $data['IdServicio'] = $this->input->post('IdServicio');
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['consentimiento'] = $this->input->post('consentimiento');
            
            }else{
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['consentimiento'] = $this->input->post('consentimiento');
            }
        }


}else{
    $data['tipoVenta'] = "";
    $data['numSesion'] = "";
    $data['IdServicio'] = "";
    $data['nameServicio'] = "";
    $data['consentimiento'] = "";
}
///////////////////////////////////////////////////////////////////////////////////////////
        $this->db->select('Idexpediente, FechaModificacion');
        $this->db->from('expediente');
        $this->db->where('Idexpediente',$idCliente);
        $res=$this->db->get();
        if($res->num_rows() >0){
            $data['Expediente']="Existe";
        }else{
            $data['Expediente']="NoExiste";
        }
///////////////////////////////////////////////////////////////////////////////////////////
        $data['ReNombre']=$this->ExpedienteC_model->obtenerNombre($data);
        $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuario($i);
        $data['id']=$idCliente;
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/agregarPestanas_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Guarda los datos introducidos 
	public function guardarPestanas()
	{

        $idExp=$this->uri->segment(5);
        $id=$this->session->userdata('IdUsuarios');
        $usuario=$this->ExpedienteC_model->obtenerUsuario($id);

        $parametro['tipoVenta']= $this->input->post('tipoVenta');
        $parametro['IdServicio']= $this->input->post('IdServicio');
        $parametro['consentimientoPestañas_IdConsentimiento']= $this->input->post('consentimiento');

        $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
        $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');

        $parametro['Sesion']= $this->input->post('txt_sesion');
        $parametro['Grosor']= $this->input->post('txt_grosor');
        $parametro['Longitud']= $this->input->post('txt_longitud');
        $parametro['Curva']= $this->input->post('txt_curva');
        $parametro['Cantidad']= $this->input->post('txt_cantidad');
        $parametro['ResultadoAler']= $this->input->post('txt_resalergia');
        $parametro['ObservacionesPestañas']= $this->input->post('txt_observaciones');
        $parametro['Diagnostico']= $this->input->post('txt_diagnostico');
        
        if($this->input->post('ExpedienteExiste') == 'Existe'){
            $parametro['expediente_Idexpediente']= $this->input->post('txt_idEx');
        }else{
            $parametro['expediente_Idexpediente']= null;
        }
        
        $parametro['clientes_IdClientes']= $this->input->post('txt_idEx');
        $parametro['Usuario']= $this->input->post('usuario');
        $parametro['UsuarioLog']= $usuario;
        
        if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
            $parametro['FirmaDigital']= null;
        }else{
            $path = "files/firmas/";
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
                chmod($path, 0777);
            }
            $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
            // Need to decode before saving since the data we received is already base64 encoded
            $decodedData=base64_decode($filteredData);
            $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
            // store in server
            $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
            $fp = fopen($path.$fic_name, 'wb');
            $ok = fwrite( $fp, $decodedData);
            fclose( $fp );

            $parametro['FirmaDigital']= $path.$fic_name;
        }
    	$this->ExpedienteC_model->guardarPestanas($parametro, $idExp);
	}

	//-------------------------------------------------------------------------------------------------------------------------------------------------------
		//Historico Relajante 
	//Muestra todos los datos del tratamiento relajantel dependiendo el Expediete del cliente seleccionado 
	public function Relajante()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlaceExpe = $this->ExpedienteC_model->obtenerExpe($id);
		if($obtenerenlaceExpe != FALSE){
			foreach ($obtenerenlaceExpe->result() as $fila) {
					$clientes_IdClientes = $fila->clientes_IdClientes;
					$Idexpediente=$fila->Idexpediente;
				}
				$data = array(
				'clientes_IdClientes' => $clientes_IdClientes,	
				'Idexpediente' => $Idexpediente,	
				);
			}else{
				$data ='';
				return FALSE;
		}
		// $this->db->select('*');
		// $this->db->where('Expediente_Idexpediente',$this->uri->segment(5));
		// $data['consulta']=$this->db->get('relajante')->result();
		$ReNombre=$this->ExpedienteC_model->obtenerNombre($data);
        foreach ($ReNombre as $i => $Nombre)
        $data['ReNombre'] = $Nombre;
		// $this->db->select('*');
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/listarelajante_view', $data);
		$this->load->view('layout/footer');
		}
	}

    ///////////////////////////////////resultado para database de expediente Relajante/////////////////////////////////////////
    public function InfoRelajante()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $idE = $this->input->post('idE');
        $this->db->select('*');
        $this->db->from('relajante');  
        $this->db->where('expediente_Idexpediente',$idE);
        $this->db->where('Sesion != 0');
        $query = $this->db->get();
        $cont = $query->num_rows();

        if($query->num_rows() >0){

           foreach($query->result() as $relajante) 
                $data[] = array(
                    $FechaRelajante = $relajante->FechaRelajante,
                    $Sesion=$relajante->Sesion,
                    $Tratamiento = $relajante->TratamientoSeleccionado,
                    $Productos = $relajante->Productos,
                    $ObservacionesRelajante = $relajante->ObservacionesRelajante,
                    $Diagnostico = $relajante->Diagnostico,
                    $cosmetologo = $relajante->Usuario,
                    // $botones = "<a href='".base_url()."expediente/franquiciatario/ExpedienteF/editarRelajante/".$relajante->expediente_Idexpediente."/".$relajante->IdRelajante."' class='label label-primary'>"."<span class='glyphicon glyphicon-pencil'></a></span>"."&nbsp;&nbsp;"."<a onclick= 'if(confirmarExp() == false) return false'href='".base_url()."expediente/franquiciatario/ExpedienteF/eliminarRelajante/".$relajante->IdRelajante."/".$relajante->expediente_Idexpediente."' class='label label-danger'>"."<span class='glyphicon glyphicon-trash'></a></span>",
                );
                    
                
                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }

        }
    }

	public function agregarRelajante()
	{
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
		{
			redirect(base_url().'acceso/acceso');
		} else {
		  $data['Franquicias']=$this->ExpedienteC_model->BuscarFranquicia();
            foreach ($data['Franquicias'] as $i => $Franquicias) 
            $idCliente=$this->uri->segment(5);

if($this->input->post('IdServicio') != ''){

    $IdServicio = $this->input->post('IdServicio');
    $data['tipoVenta'] = $this->input->post('tipoVenta');

    if($this->input->post('tipoVenta') == 'servicio'){
            $this->db->select('*');
            $this->db->from('relajante');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventasserviciosF_IdVentasServicios',$IdServicio);
            // $query = $this->db->get()->result();
            $query = $this->db->get();
            // $queryServicio = $this->db->get();
            $numRows = $query->num_rows()+1;

            if($query->num_rows() >0){

                foreach($query->result() as $fila){
                  $tratamientoSelec = $fila->TratamientoSeleccionado;
                  $RutaFirmaDigital = $fila->RutaFirmaDigital;
                  $Sesion = $fila->Sesion;
                }
                if($query->num_rows() == 1 && $Sesion==0){
                  $data['nameServicio'] = $this->input->post('nameServicio');
                  $data['numSesion'] = '1';
                  $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    if($this->input->post('nameServicio') != $tratamientoSelec){
                    $data['nameServicio'] = $tratamientoSelec;
                    $data['numSesion'] = $numRows;
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    $data['nameServicio'] = $this->input->post('nameServicio');
                    $data['numSesion'] = $numRows;
                    $data['IdServicio'] = $this->input->post('IdServicio');
                }
                }
                
            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }

        if($this->input->post('tipoVenta') == 'promocion'){
            $this->db->select('*');
            $this->db->from('relajante');  
            $this->db->where('expediente_Idexpediente',$idCliente);
            $this->db->where('ventaspromociones_IdVentasPromociones',$IdServicio);
            // $query = $this->db->get()->result();
            $queryDos = $this->db->get();
            $numRowsDos = $queryDos->num_rows()+1;

            if($queryDos->num_rows() >0){

                foreach($queryDos->result() as $fila){
                      $tratamientoSelec = $fila->TratamientoSeleccionado;
                      $FirmaDigital = $fila->FirmaDigital;
                      $Sesion = $fila->Sesion;
                }
                if($queryDos->num_rows() == 1 && $Sesion==0){
                  $data['nameServicio'] = $this->input->post('nameServicio');
                  $data['numSesion'] = '1';
                  $data['IdServicio'] = $this->input->post('IdServicio');
                }else{
                    if($this->input->post('nameServicio') != $tratamientoSelec){
                        $data['nameServicio'] = $tratamientoSelec;
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }else{
                        $data['nameServicio'] = $this->input->post('nameServicio');
                        $data['numSesion'] = $numRowsDos;
                        $data['IdServicio'] = $this->input->post('IdServicio');
                    }
                }

            }else{
                $data['nameServicio'] = $this->input->post('nameServicio');
                $data['numSesion'] = '1';
                $data['IdServicio'] = $this->input->post('IdServicio');
            }
        }

}else{
        $data['tipoVenta'] = "";
        $data['nameServicio'] = "";
        $data['numSesion'] = "";
        $data['IdServicio'] = "";
}

    $data['id'] = $idCliente;
    $data['ReNombre']=$this->ExpedienteC_model->obtenerNombre($data);
    $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuario($i);

		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('expediente/cosmetologo/agregarrelajante_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Guarda los datos introducidos en el tratamiento facial 
	public function guardarRelajante(){
        $idExp=$this->uri->segment(5);
        $id=$this->session->userdata('IdUsuarios');
        $usuario=$this->ExpedienteC_model->obtenerUsuario($id);

        if($this->input->post('tipoVenta') != ""){
            $tipoVenta = $this->input->post('tipoVenta');
            $IdServicio = $this->input->post('IdServicio');     
            $idCliente=$this->input->post('idCliente'); 
            $NombreServicio = $this->input->post('nomServicio');//$this->ExpedienteF_model->servicio($IdServicio);
            $NombreCliente = $this->ExpedienteC_model->cliente($idCliente);
            $relajante = "relajante";
            $query=$this->ExpedienteC_model->verificarImagenConsentimiento($tipoVenta, $IdServicio, $idExp, $relajante);

            if($query->num_rows() < 1){
                $tipo = $_FILES['file']['type'];        
                $tamanio = $_FILES['file']['size'];
                $nombre = $_FILES['file']['name'];          
                $archivotmp = $_FILES['file']['tmp_name'];

                $fp = fopen($archivotmp, "rb");
                $contenido = fread($fp, $tamanio);
                fclose($fp);

                $max_ancho = 1180;
                $max_alto = 800;

                if($_FILES['file']['type']=='image/png' || $_FILES['file']['type']=='image/jpeg' || $_FILES['file']['type']=='image/gif'){
                    $medidasimagen= getimagesize($_FILES['file']['tmp_name']);

                    //Si las imagenes tienen una resolución y un peso aceptable se suben tal cual
                    if($medidasimagen[0] < 1280 && $_FILES['file']['size'] < 100000){
                        $IdRelajante = "";
                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;
                        $parametro['expediente_Idexpediente']= $idCliente;
                        $parametro['Sesion']= 0;
                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                        
                        //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                                    //name del input ][ name del archivo
                        if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                            $this->ExpedienteC_model->guardarRelajante($parametro, $idExp, $IdServicio, $IdRelajante);
                        } 
                    }else{
                        // Caso contrario se generan nuevas imagenes optimizadas
                        $nombrearchivo=$_FILES['file']['name'];
                        $rtOriginal=$_FILES['file']['tmp_name'];

                        if($_FILES['file']['type']=='image/jpeg'){
                            $original = imagecreatefromjpeg($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            $original = imagecreatefrompng($rtOriginal);
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                            $original = imagecreatefromgif($rtOriginal);
                        }

                        list($ancho,$alto)=getimagesize($rtOriginal);
                        $x_ratio = $max_ancho / $ancho;
                        $y_ratio = $max_alto / $alto;

                        if( ($ancho <= $max_ancho) && ($alto <= $max_alto) ){
                            $ancho_final = $ancho;
                            $alto_final = $alto;
                        }
                        else if (($x_ratio * $alto) < $max_alto){
                            $alto_final = ceil($x_ratio * $alto);
                            $ancho_final = $max_ancho;
                        }
                        else{
                            $ancho_final = ceil($y_ratio * $ancho);
                            $alto_final = $max_alto;
                        }

                        $lienzo=imagecreatetruecolor($ancho_final,$alto_final);
                        imagecopyresampled($lienzo,$original,0,0,0,0,$ancho_final, $alto_final,$ancho,$alto);
                                
                        $cal=8;
                        ob_start();
                        if($_FILES['file']['type']=='image/jpeg'){
                            imagejpeg($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/png'){
                            imagepng($lienzo);
                            $salida = ob_get_contents();
                        }
                        else if($_FILES['file']['type']=='image/gif'){
                            imagegif($lienzo);
                            $salida = ob_get_contents();
                        }
                        ob_end_clean();

                        $IdRelajante = "";

                        $parametro['respuesta'] = "0";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idCliente;
                        $parametro['Sesion']= 0;
                        $path = "files/expedientesConsentimiento/";
                        if (!is_dir($path)) {
                            mkdir($path, 0777, true);
                            chmod($path, 0777);
                        }
                        $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                        
                        //cliente_IdCliente_Servicio_FechayHora.extencion 
                        $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                        $path = $path.$name;
                        $parametro['ImagenConsentimiento']= $path; 
                                            //name del input ][ name del archivo
                       if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                            $this->ExpedienteC_model->guardarRelajante($parametro, $idExp, $IdServicio, $IdRelajante);
                        } 
                    }
                }else{

                    $IdRelajante = "";

                    $parametro['respuesta'] = "0";
                    $parametro['tipoVenta']= $tipoVenta;
                    $parametro['IdServicio']= $IdServicio;

                    $parametro['expediente_Idexpediente']= $idCliente;
                    $parametro['Sesion']= 0;
                    $path = "files/expedientesConsentimiento/";
                    if (!is_dir($path)) {
                        mkdir($path, 0777, true);
                        chmod($path, 0777);
                    }
                    $extencion = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                    
                    //cliente_IdCliente_Servicio_FechayHora.extencion 
                    $name = $NombreCliente->NombreCliente.'_'.$idCliente.'_'.$NombreServicio.'_'.date("YmdHis").'.'.$extencion;
                    $path = $path.$name;
                    $parametro['ImagenConsentimiento']= $path; 
                                        //name del input ][ name del archivo
                   if (move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
                        $this->ExpedienteC_model->guardarRelajante($parametro, $idExp, $IdServicio, $IdRelajante);
                    } 
                }

            }else if($query->num_rows() > 0){
                foreach ($query->result() as $value) 
                    $IdRelajante = $value->IdRelajante;
                    $RutaFirmaDigital = $value->RutaFirmaDigital;
                    $Sesion = $value->Sesion;

                    if($query->num_rows() == 1 && $Sesion == 0){
                        $parametro['respuesta'] = "1";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idExp;
                        $parametro['Sesion']= 1;
                        $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                        $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                        $parametro['Productos']= $this->input->post('txt_productos');
                        $parametro['ObservacionesRelajante']= $this->input->post('txt_observaciones');      
                        $parametro['Diagnostico']= $this->input->post('txt_diagnostico');       
                        $parametro['Usuario']= $this->input->post('usuario');
                        $parametro['UsuarioLog']= $usuario;
                        
                        if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                            $parametro['FirmaDigital']= null;
                        }else{
                            $path = "files/firmas/";
                            if (!is_dir($path)) {
                                mkdir($path, 0777, true);
                                chmod($path, 0777);
                            }
                            $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                            // Need to decode before saving since the data we received is already base64 encoded
                            $decodedData=base64_decode($filteredData);
                            $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                            // store in server
                            $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                            $fp = fopen($path.$fic_name, 'wb');
                            $ok = fwrite( $fp, $decodedData);
                            fclose( $fp );

                            $parametro['FirmaDigital']= $path.$fic_name;
                        }

                        $this->ExpedienteC_model->guardarRelajante($parametro, $idExp, $IdServicio, $IdRelajante);
                        // echo "respuesta < 1";
                    }else{
                        $IdRelajante = "";
                        $parametro['respuesta'] = "2";
                        $parametro['tipoVenta']= $tipoVenta;
                        $parametro['IdServicio']= $IdServicio;

                        $parametro['expediente_Idexpediente']= $idExp;
                        $parametro['Sesion']= $this->input->post('txt_sesion');
                        $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                        $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                        $parametro['Productos']= $this->input->post('txt_productos');
                        $parametro['ObservacionesRelajante']= $this->input->post('txt_observaciones');      
                        $parametro['Diagnostico']= $this->input->post('txt_diagnostico');       
                        $parametro['Usuario']= $this->input->post('usuario');
                        $parametro['UsuarioLog']= $usuario;
                        $parametro['ImagenConsentimiento']= null;
                        
                        if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                            $parametro['FirmaDigital']= null;
                        }else{
                            $path = "files/firmas/";
                            if (!is_dir($path)) {
                                mkdir($path, 0777, true);
                                chmod($path, 0777);
                            }
                            $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                            // Need to decode before saving since the data we received is already base64 encoded
                            $decodedData=base64_decode($filteredData);
                            $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                            // store in server
                            $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                            $fp = fopen($path.$fic_name, 'wb');
                            $ok = fwrite( $fp, $decodedData);
                            fclose( $fp );

                            $parametro['FirmaDigital']= $path.$fic_name;
                        }

                        $this->ExpedienteC_model->guardarRelajante($parametro, $idExp, $IdServicio, $IdRelajante);
                    }
                }
            }else{
                $IdRelajante = "";
                $IdServicio = "";
                $parametro['respuesta'] = "libre";
                $parametro['tipoVenta']= "";
                $parametro['IdServicio']= "";
                $parametro['expediente_Idexpediente']= $idExp;
                $parametro['Sesion']= $this->input->post('txt_sesion');
                $parametro['TratamientoVenta']= $this->input->post('txt_tratamientoVenta');
                $parametro['TratamientoSeleccionado']= $this->input->post('txt_tratamientoSeleccionado');
                $parametro['Productos']= $this->input->post('txt_productos');
                $parametro['ObservacionesRelajante']= $this->input->post('txt_observaciones');      
                $parametro['Diagnostico']= $this->input->post('txt_diagnostico');       
                $parametro['Usuario']= $this->input->post('usuario');
                $parametro['UsuarioLog']= $usuario;
                $parametro['ImagenConsentimiento']= null;
                if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
                    $parametro['FirmaDigital']= null;
                }else{
                    $path = "files/firmas/";
                    if (!is_dir($path)) {
                        mkdir($path, 0777, true);
                        chmod($path, 0777);
                    }
                    $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
                    // Need to decode before saving since the data we received is already base64 encoded
                    $decodedData=base64_decode($filteredData);
                    $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
                    // store in server
                    $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
                    $fp = fopen($path.$fic_name, 'wb');
                    $ok = fwrite( $fp, $decodedData);
                    fclose( $fp );

                    $parametro['FirmaDigital']= $path.$fic_name;
                }
                $this->ExpedienteC_model->guardarRelajante($parametro, $idExp, $IdServicio, $IdRelajante);
            }

	   }


///////////////////////////////////resultado para los tratamientos corporales del cliente/////////////////////////////////////////
    public function tratamientosConsentimientoCorporal()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $IdClientes= $this->uri->segment(5);
        $idE = $this->input->post('idE');

        $f=$this->ExpedienteC_model->BuscarFranquicia();
        foreach ($f as $i => $Franquicias) 

        $query=$this->ExpedienteC_model->registrosServiciosGeneralesCorporal($idE);
        $queryTres=$this->ExpedienteC_model->registrosServiciosFranquiciasCorporal($idE);
        $queryDos=$this->ExpedienteC_model->registrosPromocionesCorporal($idE);



        if($query != null || $queryDos != null || $queryTres != null){    
            $corp = "corporal";
//////////////////////////////servicios generales /////////////////////////////////////////////////
            foreach ($query as $corporal) {
                $servicio = 'servicio';
                $IdVentasServicios = $corporal->IdVentasServicios;
                $numSesionesDetalle = $corporal->SesionesS;
                $numSesionesGeneral = $corporal->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $corp);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){

                    $data[] = array(
                        'IdVentas' => $corporal->IdVentas,
                        'IdConsentimiento' => $corporal->ConsentimientoFirmado,
                        'IdVentasServicios' => $IdVentasServicios,
                        'promociones_IdPromociones' => $corporal->serviciosfranquicias_IdServiciosFranquicias,
                        'Codigo_Servicios' => $corporal->Codigo_Servicios,
                        'NombreServicio'=>$corporal->NombreServicio,
                        'servicio' => $servicio,
                        'SesionesDetalleVentas'=> $corporal->SesionesS,
                        'SesionesGeneral'=> $corporal->SesionesServicio,
                        'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                        'VerificacionCertificado'=> $corporal->VerificacionCertificado,
                    );  
                    if($corporal->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                        }
                
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('corporal');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $corporal->IdVentas,
                                    'IdConsentimiento' => $corporal->ConsentimientoFirmado,
                                    'IdVentasServicios' => $IdVentasServicios,
                                    'promociones_IdPromociones' => $corporal->serviciosfranquicias_IdServiciosFranquicias,
                                    'Codigo_Servicios' => $corporal->Codigo_Servicios,
                                    'NombreServicio'=>$corporal->NombreServicio,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $corporal->SesionesS,
                                    'SesionesGeneral'=> $corporal->SesionesServicio,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $corporal->VerificacionCertificado,
                                );  
                                if($corporal->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                    }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                          $arreglo=array(
                                              'StatusServicio' => 'CONCLUIDO',
                                          );
                                        $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                        $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                        $res=$this->db->affected_rows();
                                      }
                                if($corporal->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            
                             }
                        }
                        
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                          $arreglo=array(
                                              'StatusServicio' => 'CONCLUIDO',
                                          );
                                        $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                        $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                        $res=$this->db->affected_rows();
                                      }
                            if($corporal->NombreCertificadoS != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                        }
                    }
                }
            
//////////////////////////////servicios franquicias /////////////////////////////////////////////////
            foreach ($queryTres as $valor) {
                $servicio = 'servicio';
                $IdVentasServicios = $valor->IdVentasServicios;
                $numSesionesDetalle = $valor->SesionesS;
                $numSesionesGeneral = $valor->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $corp);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                $data[] = array(
                    'IdVentas' => $valor->IdVentas,
                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                    'IdVentasServicios' => $valor->IdVentasServicios,
                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                    'NombreServicio'=>$valor->NombreServicio,
                    'servicio' => $servicio,
                    'SesionesDetalleVentas'=> $valor->SesionesS,
                    'SesionesGeneral'=> $valor->SesionesServicio,
                    'totalSesiones'=> $totalSesiones,
                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                );  
                if($valor->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                        }
                
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('corporal');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $valor->IdVentas,
                                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                                    'IdVentasServicios' => $valor->IdVentasServicios,
                                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                                    'NombreServicio'=>$valor->NombreServicio,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $valor->SesionesS,
                                    'SesionesGeneral'=> $valor->SesionesServicio,
                                    'totalSesiones'=> $totalSesiones,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                                );  
                                if($valor->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                        }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                            $arreglo=array(
                                                'StatusServicio' => 'CONCLUIDO',
                                            );
                                        $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                        $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                        $res=$this->db->affected_rows();
                                    }
                                if($valor->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }
                        }
                    }else{
                        $data[] = '';
                        if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasServicios', $IdVentasServicios); 
                            $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                            $res=$this->db->affected_rows();
                        }
                        if($valor->NombreCertificadoS != ''){
                        $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $corp, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                        }
                    }

                    
                    
                }
            }
//////////////////////////////promociones  /////////////////////////////////////////////////
                foreach ($queryDos as $corporalDos) {
                    $idPromo = $corporalDos->promociones_IdPromociones;
                    $servicio = 'promocion';
                    $IdVentasPromociones = $corporalDos->IdVentasPromociones;
                    $numSesionesDetalle = $corporalDos->SesionesPr;
                    $numSesionesGeneral = $corporalDos->SesionesPromocion;

                    $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                    $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasPromociones, $idE, $corp);
                    $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){

                    $data[] = array(
                        'IdVentas' => $corporalDos->IdVentas,
                        'IdConsentimiento' => $corporalDos->ConsentimientoFirmado,
                        'IdVentasServicios' => $corporalDos->IdVentasPromociones,
                        'promociones_IdPromociones' => $idPromo,
                        'Codigo_Servicios' => $corporalDos->FolioPromocion,
                        'NombreServicio'=>$corporalDos->NombrePromocion,
                        'servicio' => $servicio,
                        'SesionesDetalleVentas'=> $corporalDos->SesionesPr,
                        'SesionesGeneral'=> $corporalDos->SesionesPromocion,
                        'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                        'VerificacionCertificado'=> $corporalDos->VerificacionCertificado,
                    );
                if($corporalDos->NombreCertificadoPr != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $corp, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                        }
                
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('corporal');
                        $this->db->where('ventaspromociones_IdVentasPromociones',$IdVentasPromociones);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $corporalDos->IdVentas,
                                    'IdConsentimiento' => $corporalDos->ConsentimientoFirmado,
                                    'IdVentasServicios' => $corporalDos->IdVentasPromociones,
                                    'promociones_IdPromociones' => $idPromo,
                                    'Codigo_Servicios' => $corporalDos->FolioPromocion,
                                    'NombreServicio'=>$corporalDos->NombrePromocion,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $corporalDos->SesionesPr,
                                    'SesionesGeneral'=> $corporalDos->SesionesPromocion,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $corporalDos->VerificacionCertificado,
                                );
                            if($corporalDos->NombreCertificadoPr != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $corp, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                    }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                        $arreglo=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                        $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                                        $this->db->update('ventas_has_promociones',$arreglo); 
                                        $res=$this->db->affected_rows();
                                    }
                                    if($corporalDos->NombreCertificadoPr != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $corp, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                                $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                                $this->db->update('ventas_has_promociones',$arreglo); 
                                $res=$this->db->affected_rows();
                            }
                            if($corporalDos->NombreCertificadoPr != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $corp, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                            }
                    }
                    
                    
                }
                  
                }

                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }

        }
    }
public function modificarCampoConsentimientoVentas(){
    $idCliente = $this->input->post('idCliente');
    $idServicio = $this->input->post('idServicio');

////////////consulta servicios franquicias/////////////////////////////////////
 $queryTres = $this->ExpedienteC_model->DetalleVentasCorporalFranquicias($idCliente, $idServicio);
////////consulta servicios generales////////////////////////
    $query = $this->ExpedienteC_model->DetalleVentasCorporalGeneral($idCliente, $idServicio);
/////////////////////consulta servicios promociones //////////////////////////
     $queryDos = $this->ExpedienteC_model->DetalleVentasCorporalPromociones($idCliente, $idServicio);
////////////////////////////////////////////////
    $data['ConsentimientoFirmado']= '1';

    if($queryTres->num_rows()>0 && $query->num_rows()==0 && $queryDos->num_rows()==0){
        

        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();
         if($res >0){
            echo "1";
         }else{
            echo '0';
         }
         
    }
    if($queryTres->num_rows()==0 && $query->num_rows()>0 && $queryDos->num_rows()==0 ){
        
        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "1";
         }else{
            echo '0';
         }

    }
    if($queryTres->num_rows()==0 &&$query->num_rows()==0 && $queryDos->num_rows()>0 ){
        
        $this->db->where('IdVentasPromociones', $idServicio);
        $this->db->update('ventas_has_promociones', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "2";
         }else{
            echo '0';
         }

    }

}


///////////////////////////////////resultado para los tratamientos e-ligth del cliente/////////////////////////////////////////
    public function tratamientosConsentimientoE_ligth()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $IdClientes= $this->uri->segment(5);
        $idE = $this->input->post('idE');

        // $f=$this->ExpedienteF_model->BuscarFranquicia();
        // foreach ($f as $i => $Franquicias)   

        $query=$this->ExpedienteC_model->registrosServiciosGeneralesE_ligth($idE);
        $queryTres=$this->ExpedienteC_model->registrosServiciosFranquiciasE_ligth($idE);
        $queryDos=$this->ExpedienteC_model->registrosPromocionesE_ligth($idE);



        if($query != null || $queryDos != null || $queryTres != null){     
            $eligth = "eligth";
    //////////////////////////////servicios generales ///////////////////////////////////////////////
            foreach ($query as $facial) {
                $servicio = 'servicio';
                $IdVentasServicios = $facial->IdVentasServicios;
                $numSesionesDetalle = $facial->SesionesS;
                $numSesionesGeneral = $facial->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $eligth);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                    $data[] = array(
                        'IdVentas' => $facial->IdVentas,
                        'IdConsentimiento' => $facial->ConsentimientoFirmado,
                        'IdVentasServicios' => $facial->IdVentasServicios,
                        'promociones_IdPromociones' => $facial->serviciosfranquicias_IdServiciosFranquicias,
                        'Codigo_Servicios' => $facial->Codigo_Servicios,
                        'NombreServicio'=>$facial->NombreServicio,
                        'servicio' => $servicio,
                        'SesionesDetalleVentas'=> $facial->SesionesS,
                        'SesionesGeneral'=> $facial->SesionesServicio,
                        'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                        'VerificacionCertificado'=> $facial->VerificacionCertificado,
                    ); 
                if($facial->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                }
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('eligth');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $facial->IdVentas,
                                    'IdConsentimiento' => $facial->ConsentimientoFirmado,
                                    'IdVentasServicios' => $facial->IdVentasServicios,
                                    'promociones_IdPromociones' => $facial->serviciosfranquicias_IdServiciosFranquicias,
                                    'Codigo_Servicios' => $facial->Codigo_Servicios,
                                    'NombreServicio'=>$facial->NombreServicio,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $facial->SesionesS,
                                    'SesionesGeneral'=> $facial->SesionesServicio,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $facial->VerificacionCertificado,
                                ); 
                            if($facial->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                        $arreglo=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                    $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                    $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                    $res=$this->db->affected_rows();
                                    }
                                    if($facial->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasServicios', $IdVentasServicios); 
                            $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                            $res=$this->db->affected_rows();
                            }
                            if($facial->NombreCertificadoS != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                    }
                    
                    
                }
                 
                }
//////////////////////////////servicios franquicias /////////////////////////////////////////////////
            foreach ($queryTres as $valor) {
                $servicio = 'servicio';
                $IdVentasServicios = $valor->IdVentasServicios;
                $numSesionesDetalle = $valor->SesionesS;
                $numSesionesGeneral = $valor->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $eligth);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                $data[] = array(
                    'IdVentas' => $valor->IdVentas,
                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                    'IdVentasServicios' => $valor->IdVentasServicios,
                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                    'NombreServicio'=>$valor->NombreServicio,
                    'servicio' => $servicio,
                    'SesionesDetalleVentas'=> $valor->SesionesS,
                    'SesionesGeneral'=> $valor->SesionesServicio,
                    // 'totalSesiones'=> $totalSesiones,
                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                );  
                if($valor->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                }   
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('eligth');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $valor->IdVentas,
                                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                                    'IdVentasServicios' => $valor->IdVentasServicios,
                                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                                    'NombreServicio'=>$valor->NombreServicio,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $valor->SesionesS,
                                    'SesionesGeneral'=> $valor->SesionesServicio,
                                    // 'totalSesiones'=> $totalSesiones,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                                );  
                                if($valor->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                        $arreglo=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                    $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                    $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                    $res=$this->db->affected_rows();
                                    }
                                    if($valor->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                        if($numRowsCorporal == $totalSesiones){
                            $arreglo=array(
                                'StatusServicio' => 'CONCLUIDO',
                            );
                        $this->db->where('IdVentasServicios', $IdVentasServicios); 
                        $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                        $res=$this->db->affected_rows();
                        }
                        if($valor->NombreCertificadoS != ''){
                        $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $eligth, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                        }
                    }
                    
                    
                }
            }
//////////////////////////////promociones  /////////////////////////////////////////////////
                foreach ($queryDos as $facialDos) {
                    $idPromo = $facialDos->promociones_IdPromociones;
                    $servicio = 'promocion';
                    // $IdVentasServicios = $facialDos->IdVentasServicios;
                    $IdVentasPromociones = $facialDos->IdVentasPromociones;
                    $numSesionesDetalle = $facialDos->SesionesPr;
                    $numSesionesGeneral = $facialDos->SesionesPromocion;

                    $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                    $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasPromociones, $idE, $eligth);
                    $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                    $data[] = array(
                        'IdVentas' => $facialDos->IdVentas,
                        'IdConsentimiento' => $facialDos->ConsentimientoFirmado,
                        'IdVentasServicios' => $facialDos->IdVentasPromociones,
                        'promociones_IdPromociones' => $idPromo,
                        'Codigo_Servicios' => $facialDos->FolioPromocion,
                        'NombreServicio'=>$facialDos->NombrePromocion,
                        'servicio' => $servicio,
                        'SesionesDetalleVentas'=> $facialDos->SesionesPr,
                        'SesionesGeneral'=> $facialDos->SesionesPromocion,
                        'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                        'VerificacionCertificado'=> $facialDos->VerificacionCertificado,
                    );
                if($facialDos->NombreCertificadoPr != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $eligth, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                }
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('eligth');
                        $this->db->where('ventaspromociones_IdVentasPromociones',$IdVentasPromociones);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $facialDos->IdVentas,
                                    'IdConsentimiento' => $facialDos->ConsentimientoFirmado,
                                    'IdVentasServicios' => $facialDos->IdVentasPromociones,
                                    'promociones_IdPromociones' => $idPromo,
                                    'Codigo_Servicios' => $facialDos->FolioPromocion,
                                    'NombreServicio'=>$facialDos->NombrePromocion,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $facialDos->SesionesPr,
                                    'SesionesGeneral'=> $facialDos->SesionesPromocion,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $facialDos->VerificacionCertificado,
                                );
                            if($facialDos->NombreCertificadoPr != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $eligth, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                            }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                        $arreglo=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                    $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                                    $this->db->update('ventas_has_promociones',$arreglo); 
                                    $res=$this->db->affected_rows();
                                    }
                                    if($facialDos->NombreCertificadoPr != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $eligth, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                            $this->db->update('ventas_has_promociones',$arreglo); 
                            $res=$this->db->affected_rows();
                            }
                            if($facialDos->NombreCertificadoPr != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $eligth, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                            }
                    }
                    
                    
                }
                  
                }

                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }

        }
    }


////////////////////////////////////////////////////////////////////////////////////////////////////
public function modificarCampoConsentimientoVentasE_ligth(){
    $idCliente = $this->input->post('idCliente');
    $idServicio = $this->input->post('idServicio');


////////////consulta servicios franquicias/////////////////////////////////////
    $queryTres = $this->ExpedienteC_model->DetalleVentasEligthFranquicias($idCliente, $idServicio);
////////consulta servicios generales////////////////////////
    $query = $this->ExpedienteC_model->DetalleVentasEligthGeneral($idCliente, $idServicio);
/////////////////////consulta servicios promociones //////////////////////////
    $queryDos = $this->ExpedienteC_model->DetalleVentasEligthPromociones($idCliente, $idServicio);
////////////////////////////////////////////////
////////////////////////////////////////////////
    $data['ConsentimientoFirmado']= '1';

    if($queryTres->num_rows()>0 && $query->num_rows()==0 && $queryDos->num_rows()==0){
        

        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();
         if($res >0){
            echo "1";
         }else{
            echo '0';
         }
         
    }
    if($queryTres->num_rows()==0 && $query->num_rows()>0 && $queryDos->num_rows()==0 ){
        
        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "1";
         }else{
            echo '0';
         }

    }
    if($queryTres->num_rows()==0 &&$query->num_rows()==0 && $queryDos->num_rows()>0 ){
        
        $this->db->where('IdVentasPromociones', $idServicio);
        $this->db->update('ventas_has_promociones', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "2";
         }else{
            echo '0';
         }

    }

}

///////////////////////////////////resultado para los tratamientos faciales del cliente/////////////////////////////////////////
    public function tratamientosConsentimientoFacial()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $IdClientes= $this->uri->segment(5);
        $idE = $this->input->post('idE');

        $f=$this->ExpedienteC_model->BuscarFranquicia();
        foreach ($f as $i => $Franquicias)  

        $query=$this->ExpedienteC_model->registrosServiciosGeneralesFacial($idE);
    $queryTres=$this->ExpedienteC_model->registrosServiciosFranquiciasFacial($idE);
        $queryDos=$this->ExpedienteC_model->registrosPromocionesFacial($idE);



        if($query != null || $queryDos != null || $queryTres != null){  
            $FacialQ = "facial";
//////////////////////////////servicios generales /////////////////////////////////////////////////
            foreach ($query as $facial) {
                $servicio = 'servicio';
                $IdVentasServicios = $facial->IdVentasServicios;
                $numSesionesDetalle = $facial->SesionesS;
                $numSesionesGeneral = $facial->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $FacialQ);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                    $data[] = array(
                        'IdVentas' => $facial->IdVentas,
                        'IdConsentimiento' => $facial->ConsentimientoFirmado,
                        'IdVentasServicios' => $facial->IdVentasServicios,
                        'promociones_IdPromociones' => $facial->serviciosfranquicias_IdServiciosFranquicias,
                        'Codigo_Servicios' => $facial->Codigo_Servicios,
                        'NombreServicio'=>$facial->NombreServicio,
                        'servicio' => $servicio,
                        'SesionesDetalleVentas'=> $facial->SesionesS,
                        'SesionesGeneral'=> $facial->SesionesServicio,
                        'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                        'VerificacionCertificado'=> $facial->VerificacionCertificado,
                    );  
                    if($facial->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                }
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('facial');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $facial->IdVentas,
                                    'IdConsentimiento' => $facial->ConsentimientoFirmado,
                                    'IdVentasServicios' => $facial->IdVentasServicios,
                                    'promociones_IdPromociones' => $facial->serviciosfranquicias_IdServiciosFranquicias,
                                    'Codigo_Servicios' => $facial->Codigo_Servicios,
                                    'NombreServicio'=>$facial->NombreServicio,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $facial->SesionesS,
                                    'SesionesGeneral'=> $facial->SesionesServicio,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $facial->VerificacionCertificado,
                                );  
                                if($facial->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                        $arreglo=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                    $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                    $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                    $res=$this->db->affected_rows();
                                    }
                                    if($facial->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasServicios', $IdVentasServicios); 
                            $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                            $res=$this->db->affected_rows();
                            }
                            if($facial->NombreCertificadoS != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                    }
                }
                }
//////////////////////////////servicios franquicias /////////////////////////////////////////////////
            foreach ($queryTres as $valor) {
                $servicio = 'servicio';
                $IdVentasServicios = $valor->IdVentasServicios;
                $numSesionesDetalle = $valor->SesionesS;
                $numSesionesGeneral = $valor->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $FacialQ);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                $data[] = array(
                    'IdVentas' => $valor->IdVentas,
                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                    'IdVentasServicios' => $valor->IdVentasServicios,
                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                    'NombreServicio'=>$valor->NombreServicio,
                    'servicio' => $servicio,
                    'SesionesDetalleVentas'=> $valor->SesionesS,
                    'SesionesGeneral'=> $valor->SesionesServicio,
                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                );  
               if($valor->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                }
                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('facial');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $valor->IdVentas,
                                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                                    'IdVentasServicios' => $valor->IdVentasServicios,
                                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                                    'NombreServicio'=>$valor->NombreServicio,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $valor->SesionesS,
                                    'SesionesGeneral'=> $valor->SesionesServicio,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                                );  
                               if($valor->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }else{
                                $data[] = '';
                                if($numRowsCorporal == $totalSesiones){
                                    $arreglo=array(
                                        'StatusServicio' => 'CONCLUIDO',
                                    );
                                $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                $res=$this->db->affected_rows();
                                }
                                if($valor->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasServicios', $IdVentasServicios); 
                            $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                            $res=$this->db->affected_rows();
                            }
                            if($valor->NombreCertificadoS != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $FacialQ, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                    }
                    
                    
                }
            }
//////////////////////////////promociones  /////////////////////////////////////////////////
                foreach ($queryDos as $facialDos) {
                    $idPromo = $facialDos->promociones_IdPromociones;
                    $servicio = 'promocion';
                    $IdVentasPromociones = $facialDos->IdVentasPromociones;
                    $numSesionesDetalle = $facialDos->SesionesPr;
                    $numSesionesGeneral = $facialDos->SesionesPromocion;

                    $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                    $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasPromociones, $idE, $FacialQ);
                    $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                    $data[] = array(
                    'IdVentas' => $facialDos->IdVentas,
                    'IdConsentimiento' => $facialDos->ConsentimientoFirmado,
                    'IdVentasServicios' => $facialDos->IdVentasPromociones,
                    'promociones_IdPromociones' => $idPromo,
                    'Codigo_Servicios' => $facialDos->FolioPromocion,
                    'NombreServicio'=>$facialDos->NombrePromocion,
                    'servicio' => $servicio,
                    'SesionesDetalleVentas'=> $facialDos->SesionesPr,
                    'SesionesGeneral'=> $facialDos->SesionesPromocion,
                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                    'VerificacionCertificado'=> $facialDos->VerificacionCertificado,
                );

                if($facialDos->NombreCertificadoPr != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $FacialQ, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                }

                }else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('facial');
                        $this->db->where('ventaspromociones_IdVentasPromociones',$IdVentasPromociones);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $facialDos->IdVentas,
                                    'IdConsentimiento' => $facialDos->ConsentimientoFirmado,
                                    'IdVentasServicios' => $facialDos->IdVentasPromociones,
                                    'promociones_IdPromociones' => $idPromo,
                                    'Codigo_Servicios' => $facialDos->FolioPromocion,
                                    'NombreServicio'=>$facialDos->NombrePromocion,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $facialDos->SesionesPr,
                                    'SesionesGeneral'=> $facialDos->SesionesPromocion,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $facialDos->VerificacionCertificado,
                                );

                                if($facialDos->NombreCertificadoPr != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $FacialQ, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                    $arregloPr=array(
                                                'StatusServicio' => 'CONCLUIDO',
                                            );
                                        $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                                        $this->db->update('ventas_has_promociones',$arregloPr); 
                                        $res=$this->db->affected_rows();
                                                                  
                                        }
                                    if($facialDos->NombreCertificadoPr != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $FacialQ, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                            $arregloPr=array(
                                        'StatusServicio' => 'CONCLUIDO',
                                    );
                                $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                                $this->db->update('ventas_has_promociones',$arregloPr); 
                                $res=$this->db->affected_rows();
                                                          
                                }
                            if($facialDos->NombreCertificadoPr != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $FacialQ, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                            }
                    }
                    
                    
                }
                  
                }

                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }

        }
    }

////////////////////////////////////////////////////////////////////////////////////////////////////
public function modificarCampoConsentimientoVentasFacial(){
    $idCliente = $this->input->post('idCliente');
    $idServicio = $this->input->post('idServicio');
////////////consulta servicios franquicias/////////////////////////////////////
    $query= $this->ExpedienteC_model->DetalleVentasFacialGeneral($idCliente, $idServicio);
////////consulta servicios generales////////////////////////
    $queryTres = $this->ExpedienteC_model->DetalleVentasFacialFranquicias($idCliente, $idServicio);
/////////////////////consulta servicios promociones //////////////////////////
    $queryDos = $this->ExpedienteC_model->DetalleVentasFacialPromociones($idCliente, $idServicio);
////////////////////////////////////////////////
    $data['ConsentimientoFirmado']= '1';

    if($queryTres->num_rows()>0 && $query->num_rows()==0 && $queryDos->num_rows()==0){
        

        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();
         if($res >0){
            echo "1";
         }else{
            echo '0';
         }
         
    }
    if($queryTres->num_rows()==0 && $query->num_rows()>0 && $queryDos->num_rows()==0 ){
        
        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "1";
         }else{
            echo '0';
         }

    }
    if($queryTres->num_rows()==0 && $query->num_rows()==0 && $queryDos->num_rows()>0 ){
        
        $this->db->where('IdVentasPromociones', $idServicio);
        $this->db->update('ventas_has_promociones', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "2";
         }else{
            echo '0';
         }

    }

}

///////////////////////////////////resultado para los tratamientos relajantes del cliente/////////////////////////////////////////
    public function tratamientosConsentimientoRelajantes()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $IdClientes= $this->uri->segment(5);
        $idE = $this->input->post('idE');

        // $f=$this->ExpedienteC_model->BuscarFranquicia();
        // foreach ($f as $i => $Franquicias)  

        $query=$this->ExpedienteC_model->registrosServiciosGeneralesRelajante($idE);
    $queryTres=$this->ExpedienteC_model->registrosServiciosFranquiciasRelajante($idE);
        $queryDos=$this->ExpedienteC_model->registrosPromocionesRelajante($idE);



        if($query != null || $queryDos != null || $queryTres != null){      
            $relajante = "relajante";
//////////////////////////////servicios generales /////////////////////////////////////////////////
            foreach ($query as $valor) {
                $servicio = 'servicio';
                $IdVentasServicios = $valor->IdVentasServicios;
                $numSesionesDetalle = $valor->SesionesS;
                $numSesionesGeneral = $valor->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $relajante);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){

                $data[] = array(
                    'IdVentas' => $valor->IdVentas,
                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                    'IdVentasServicios' => $valor->IdVentasServicios,
                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                    'NombreServicio'=>$valor->NombreServicio,
                    'servicio' => $servicio,
                    'SesionesDetalleVentas'=> $valor->SesionesS,
                    'SesionesGeneral'=> $valor->SesionesServicio,
                    'totalSesiones'=> $totalSesiones,
                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                );  
                if($valor->NombreCertificadoS != ''){
                        $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                    }

                }
                else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('relajante');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $valor->IdVentas,
                                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                                    'IdVentasServicios' => $valor->IdVentasServicios,
                                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                                    'NombreServicio'=>$valor->NombreServicio,
                                    'servicio' => $servicio,
                                    'SesionesDetalleVentas'=> $valor->SesionesS,
                                    'SesionesGeneral'=> $valor->SesionesServicio,
                                    'totalSesiones'=> $totalSesiones,
                                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                                );  
                                if($valor->NombreCertificadoS != ''){
                                        $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                    }
                            }else{
                                $data[] = '';
                                if($numRowsCorporal == $totalSesiones){
                                    $arreglo=array(
                                        'StatusServicio' => 'CONCLUIDO',
                                    );
                                $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                $res=$this->db->affected_rows();
                                }
                                if($valor->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasServicios', $IdVentasServicios); 
                            $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                            $res=$this->db->affected_rows();
                            }
                            if($valor->NombreCertificadoS != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                    }
                }
            }
//////////////////////////////servicios franquicias  /////////////////////////////////////////////////
            foreach ($queryTres as $valor) {
                $servicio = 'servicio';
                $IdVentasServicios = $valor->IdVentasServicios;
                $numSesionesDetalle = $valor->SesionesS;
                $numSesionesGeneral = $valor->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $relajante);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                $data[] = array(
                    'IdVentas' => $valor->IdVentas,
                    'IdConsentimiento' => $valor->ConsentimientoFirmado,
                    'IdVentasServicios' => $valor->IdVentasServicios,
                    'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                    'Codigo_Servicios' => $valor->Codigo_Servicios,
                    'NombreServicio'=>$valor->NombreServicio,
                    'servicio' => $servicio,
                    'SesionesDetalleVentas'=> $valor->SesionesS,
                    'SesionesGeneral'=> $valor->SesionesServicio,
                    'totalSesiones'=> $totalSesiones,
                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                    'VerificacionCertificado'=> $valor->VerificacionCertificado,
                );  
                if($valor->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                    }
                    
                }
                else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('relajante');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                'IdVentas' => $valor->IdVentas,
                                'IdConsentimiento' => $valor->ConsentimientoFirmado,
                                'IdVentasServicios' => $valor->IdVentasServicios,
                                'promociones_IdPromociones' => $valor->serviciosfranquicias_IdServiciosFranquicias,
                                'Codigo_Servicios' => $valor->Codigo_Servicios,
                                'NombreServicio'=>$valor->NombreServicio,
                                'servicio' => $servicio,
                                'SesionesDetalleVentas'=> $valor->SesionesS,
                                'SesionesGeneral'=> $valor->SesionesServicio,
                                'totalSesiones'=> $totalSesiones,
                                'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                'VerificacionCertificado'=> $valor->VerificacionCertificado,
                            );  
                            if($valor->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }else{
                                $data[] = '';
                                if($numRowsCorporal == $totalSesiones){
                                    $arreglo=array(
                                        'StatusServicio' => 'CONCLUIDO',
                                    );
                                $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                $res=$this->db->affected_rows();
                                }
                                if($valor->NombreCertificadoS != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }
                        }
                    }else{
                        $data[] = '';
                        if($numRowsCorporal == $totalSesiones){
                            $arreglo=array(
                                'StatusServicio' => 'CONCLUIDO',
                            );
                        $this->db->where('IdVentasServicios', $IdVentasServicios); 
                        $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                        $res=$this->db->affected_rows();
                        }
                        if($valor->NombreCertificadoS != ''){
                        $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $relajante, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                        }
                    }
                    
                    
                }
            }
//////////////////////////////promociones  /////////////////////////////////////////////////
                foreach ($queryDos as $valorDos) {
                    $idPromo = $valorDos->promociones_IdPromociones;
                    $servicio = 'promocion';
                    $IdVentasPromociones = $valorDos->IdVentasPromociones;
                    $numSesionesDetalle = $valorDos->SesionesPr;
                    $numSesionesGeneral = $valorDos->SesionesPromocion;

                    $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                    $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasPromociones, $idE, $relajante);
                    $numRowsCorporal = $existenciaRegistros->num_rows();

                    if($existenciaRegistros->num_rows() < $totalSesiones){

                $data[] = array(
                    'IdVentas' => $valorDos->IdVentas,
                    'IdConsentimiento' => $valorDos->ConsentimientoFirmado,
                    'IdVentasServicios' => $valorDos->IdVentasPromociones,
                    'promociones_IdPromociones' => $idPromo,
                    'Codigo_Servicios' => $valorDos->FolioPromocion,
                    'NombreServicio'=>$valorDos->NombrePromocion,
                    'servicio' => $servicio,
                    'SesionesDetalleVentas'=> $valorDos->SesionesPr,
                    'SesionesGeneral'=> $valorDos->SesionesPromocion,
                    'totalSesiones'=> $totalSesiones,
                    'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                    'VerificacionCertificado'=> $valorDos->VerificacionCertificado,
                );  
                if($valorDos->NombreCertificadoPr != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $relajante, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                }
                
                }
                else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('relajante');
                        $this->db->where('ventaspromociones_IdVentasPromociones',$IdVentasPromociones);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                'IdVentas' => $valorDos->IdVentas,
                                'IdConsentimiento' => $valorDos->ConsentimientoFirmado,
                                'IdVentasServicios' => $valorDos->IdVentasPromociones,
                                'promociones_IdPromociones' => $idPromo,
                                'Codigo_Servicios' => $valorDos->FolioPromocion,
                                'NombreServicio'=>$valorDos->NombrePromocion,
                                'servicio' => $servicio,
                                'SesionesDetalleVentas'=> $valorDos->SesionesPr,
                                'SesionesGeneral'=> $valorDos->SesionesPromocion,
                                'totalSesiones'=> $totalSesiones,
                                'ExistenciaImagen'=> $existenciaRegistros->num_rows(),
                                'VerificacionCertificado'=> $valorDos->VerificacionCertificado,
                            );  
                            if($valorDos->NombreCertificadoPr != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $relajante, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                            }
                            }else{
                                $data[] = '';
                                if($numRowsCorporal == $totalSesiones){
                                $arregloPr=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                    $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                                    $this->db->update('ventas_has_promociones',$arregloPr); 
                                    $res=$this->db->affected_rows();
                                                              
                                    }
                                if($valorDos->NombreCertificadoPr != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $relajante, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                }
                            }
                        }
                    }else{
                        $data[] = '';
                        if($numRowsCorporal == $totalSesiones){
                        $arregloPr=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                            $this->db->update('ventas_has_promociones',$arregloPr); 
                            $res=$this->db->affected_rows();
                                                      
                            }
                        if($valorDos->NombreCertificadoPr != ''){
                        $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $relajante, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                        }
                    }
                }
            }

                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }

        }
    }

////////////////////////////////////////////////////////////////////////////////////////////////////
public function modificarCampoConsentimientoVentasRelajante(){
    $idCliente = $this->input->post('idCliente');
    $idServicio = $this->input->post('idServicio');

////////////consulta servicios franquicias/////////////////////////////////////
 $queryTres = $this->ExpedienteC_model->DetalleVentasRelajanteFranquicias($idCliente, $idServicio);
////////consulta servicios generales////////////////////////
    $query = $this->ExpedienteC_model->DetalleVentasRelajanteGeneral($idCliente, $idServicio);
/////////////////////consulta servicios promociones //////////////////////////
     $queryDos = $this->ExpedienteC_model->DetalleVentasRelajantePromociones($idCliente, $idServicio);
////////////////////////////////////////////////
    $data['ConsentimientoFirmado']= '1';

   if($queryTres->num_rows()>0 && $query->num_rows()==0 && $queryDos->num_rows()==0){
        

        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();
         if($res >0){
            echo "1";
         }else{
            echo '0';
         }
         
    }
    if($queryTres->num_rows()==0 && $query->num_rows()>0 && $queryDos->num_rows()==0 ){
        
        $this->db->where('IdVentasServicios', $idServicio);
        $this->db->update('ventas_has_serviciosfranquicias', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "1";
         }else{
            echo '0';
         }

    }
    if($queryTres->num_rows()==0 &&$query->num_rows()==0 && $queryDos->num_rows()>0 ){
        
        $this->db->where('IdVentasPromociones', $idServicio);
        $this->db->update('ventas_has_promociones', $data);
         $res=$this->db->affected_rows();

         if($res >0){
            echo "2";
         }else{
            echo '0';
         }

    }

}

///////////////////////////////////resultado para los tratamientos de pestañas del cliente/////////////////////////////////////////
    public function tratamientosConsentimientoPestanas()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {

$idE = $this->input->post('idE');

        $query=$this->ExpedienteC_model->registrosServiciosGeneralesPestanas($idE);
        $queryTres=$this->ExpedienteC_model->registrosServiciosFranquiciasPestanas($idE);
        $queryDos=$this->ExpedienteC_model->registrosPromocionesPestanas($idE);

        if($query != null || $queryDos != null || $queryTres != null){  
            $pestanas = "pestanas";
//////////////////////////////servicios generales ///////////////////////////////////////////////
            foreach ($query as $corporal) {
                $servicio = 'servicio';
                $IdVentasServicios = $corporal->IdVentasServicios;
                $numSesionesDetalle = $corporal->SesionesS;
                $numSesionesGeneral = $corporal->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $pestanas);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($numRowsCorporal < $totalSesiones){
                $data[] = array(
                    'IdVentas' => $corporal->IdVentas,
                    'IdConsentimiento' => $corporal->ConsentimientoFirmado,
                    'IdVentasServicios' => $corporal->IdVentasServicios,
                    'Codigo_Servicios' => $corporal->Codigo_Servicios,
                    'promociones_IdPromociones' => $corporal->serviciosfranquicias_IdServiciosFranquicias,
                    'NombreServicio'=>$corporal->NombreServicio,
                    'servicio' => 'servicio',
                    'VerificacionCertificado'=> $corporal->VerificacionCertificado,
                    'totalSesiones'=> $totalSesiones,
                );

                if($corporal->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                }
                
                }
                else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('pestañas');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $corporal->IdVentas,
                                    'IdConsentimiento' => $corporal->ConsentimientoFirmado,
                                    'IdVentasServicios' => $corporal->IdVentasServicios,
                                    'Codigo_Servicios' => $corporal->Codigo_Servicios,
                                    'promociones_IdPromociones' => $corporal->serviciosfranquicias_IdServiciosFranquicias,
                                    'NombreServicio'=>$corporal->NombreServicio,
                                    'servicio' => 'servicio',
                                    'VerificacionCertificado'=> $corporal->VerificacionCertificado,
                                    'totalSesiones'=> $totalSesiones,
                                );

                                if($corporal->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                        $arreglo=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                    $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                    $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                    $res=$this->db->affected_rows();
                                    }
                                    if($corporal->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasServicios', $IdVentasServicios); 
                            $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                            $res=$this->db->affected_rows();
                            }
                            if($corporal->NombreCertificadoS != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                    }
                    }   
                }
//////////////////////////////servicios franquicias  /////////////////////////////////////////////////
            foreach ($queryTres as $corporalTres) {
                $servicio = 'servicio';
                $IdVentasServicios = $corporalTres->IdVentasServicios;
                $numSesionesDetalle = $corporalTres->SesionesS;
                $numSesionesGeneral = $corporalTres->SesionesServicio;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasServicios, $idE, $pestanas);
                $numRowsCorporal = $existenciaRegistros->num_rows();

                if($numRowsCorporal < $totalSesiones){

                $data[] = array(
                    'IdVentas' => $corporalTres->IdVentas,
                    'IdConsentimiento' => $corporalTres->ConsentimientoFirmado,
                    'IdVentasServicios' => $corporalTres->IdVentasServicios,
                    'Codigo_Servicios' => $corporalTres->Codigo_Servicios,
                    'promociones_IdPromociones' => $corporalTres->serviciosfranquicias_IdServiciosFranquicias,
                    'NombreServicio'=>$corporalTres->NombreServicio,
                    'servicio' => 'servicio',
                    'VerificacionCertificado'=> $corporalTres->VerificacionCertificado,
                    'totalSesiones'=> $totalSesiones,
                );
                if($corporalTres->NombreCertificadoS != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                }
                }
                else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('pestañas');
                        $this->db->where('ventasserviciosF_IdVentasServicios',$IdVentasServicios);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $corporalTres->IdVentas,
                                    'IdConsentimiento' => $corporalTres->ConsentimientoFirmado,
                                    'IdVentasServicios' => $corporalTres->IdVentasServicios,
                                    'Codigo_Servicios' => $corporalTres->Codigo_Servicios,
                                    'promociones_IdPromociones' => $corporalTres->serviciosfranquicias_IdServiciosFranquicias,
                                    'NombreServicio'=>$corporalTres->NombreServicio,
                                    'servicio' => 'servicio',
                                    'VerificacionCertificado'=> $corporalTres->VerificacionCertificado,
                                    'totalSesiones'=> $totalSesiones,
                                );
                                if($corporalTres->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                }
                            }else{
                                $data[] = '';
                                    if($numRowsCorporal == $totalSesiones){
                                        $arreglo=array(
                                            'StatusServicio' => 'CONCLUIDO',
                                        );
                                    $this->db->where('IdVentasServicios', $IdVentasServicios); 
                                    $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                                    $res=$this->db->affected_rows();
                                    }
                                    if($corporalTres->NombreCertificadoS != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                                    }
                            }
                        }
                    }else{
                        $data[] = '';
                            if($numRowsCorporal == $totalSesiones){
                                $arreglo=array(
                                    'StatusServicio' => 'CONCLUIDO',
                                );
                            $this->db->where('IdVentasServicios', $IdVentasServicios); 
                            $this->db->update('ventas_has_serviciosfranquicias',$arreglo); 
                            $res=$this->db->affected_rows();
                            }
                            if($corporalTres->NombreCertificadoS != ''){
                            $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $pestanas, $IdVentasServicios, $totalSesiones, $numRowsCorporal);
                            }
                    }
                    
                    
                }   
                }

//////////////////////////////promociones  /////////////////////////////////////////////////
                foreach ($queryDos as $corporalDos) {
                    $idPromo = $corporalDos->promociones_IdPromociones;
                    $servicio = 'promocion';
                    $IdVentasPromociones = $corporalDos->IdVentasPromociones;
                    $numSesionesDetalle = $corporalDos->SesionesPr;
                    $numSesionesGeneral = $corporalDos->SesionesPromocion;

                $totalSesiones = $numSesionesGeneral * $numSesionesDetalle;

                    $existenciaRegistros = $this->ExpedienteC_model->verificarImagenConsentimiento($servicio, $IdVentasPromociones, $idE, $pestanas);
                    $numRowsCorporal = $existenciaRegistros->num_rows();

                if($existenciaRegistros->num_rows() < $totalSesiones){
                $data[] = array(
                    'IdVentas' => $corporalDos->IdVentas,
                    'IdConsentimiento' => $corporalDos->ConsentimientoFirmado,
                    'IdVentasServicios' => $corporalDos->IdVentasPromociones,
                    'Codigo_Servicios' => $corporalDos->FolioPromocion,
                    'promociones_IdPromociones' => $idPromo,
                    'NombreServicio'=>$corporalDos->NombrePromocion,
                    'servicio' => 'promocion',
                    'VerificacionCertificado'=> $corporalDos->VerificacionCertificado,
                    'totalSesiones'=> $totalSesiones,
                );  
                if($corporalDos->NombreCertificadoPr != ''){
                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $pestanas, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                }
                }
                else{
                    if($totalSesiones == 1){
                        $this->db->select('*');
                        $this->db->from('pestañas');
                        $this->db->where('ventaspromociones_IdVentasPromociones',$IdVentasPromociones);
                        $queryCorp = $this->db->get();
                        if($queryCorp->num_rows() > 0){
                            foreach ($queryCorp->result() as $row)
                                $Sesion = $row->Sesion;
                            if($Sesion == 0){
                                $data[] = array(
                                    'IdVentas' => $corporalDos->IdVentas,
                                    'IdConsentimiento' => $corporalDos->ConsentimientoFirmado,
                                    'IdVentasServicios' => $corporalDos->IdVentasPromociones,
                                    'Codigo_Servicios' => $corporalDos->FolioPromocion,
                                    'promociones_IdPromociones' => $idPromo,
                                    'NombreServicio'=>$corporalDos->NombrePromocion,
                                    'servicio' => 'promocion',
                                    'VerificacionCertificado'=> $corporalDos->VerificacionCertificado,
                                    'totalSesiones'=> $totalSesiones,
                                );  
                                if($corporalDos->NombreCertificadoPr != ''){
                                    $this->ExpedienteC_model->modificarStatusDetalleVentaAsignado($servicio, $pestanas, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                }
                            }else{
                                $data[] = '';
                                if($numRowsCorporal == $totalSesiones){
                                    $arregloPr=array(
                                        'StatusServicio' => 'CONCLUIDO',
                                    );
                                $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                                $this->db->update('ventas_has_promociones',$arregloPr); 
                                $res=$this->db->affected_rows();
                                }
                                if($corporalDos->NombreCertificadoPr != ''){
                                $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $pestanas, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                                }
                            }
                        }
                    }else{
                        $data[] = '';
                        if($numRowsCorporal == $totalSesiones){
                            $arregloPr=array(
                                'StatusServicio' => 'CONCLUIDO',
                            );
                        $this->db->where('IdVentasPromociones', $IdVentasPromociones); 
                        $this->db->update('ventas_has_promociones',$arregloPr); 
                        $res=$this->db->affected_rows();
                        }
                        if($corporalDos->NombreCertificadoPr != ''){
                        $this->ExpedienteC_model->modificarStatusDetalleVenta($servicio, $pestanas, $IdVentasPromociones, $totalSesiones, $numRowsCorporal);
                        }
                    }
                }
                }


echo json_encode($data);
                
                }else{
                    echo json_encode(null);
                }

        }
    }

/*Funcion que lleva a la vista consentimientoPestanas_view donde los datos ya estan llenos y el div bloqueado*/
public function registroConsentimientoPestanasRegistrado(){
    $idVC= $this->uri->segment(5);
    $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

    if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
        {
            redirect(base_url().'acceso/acceso');
        } else {

$IdConsentimiento = $_GET["IdConsentimiento"];
$idCliente = $_GET["idCliente"];
$IdVentas = $_GET["IdVentas"];
$IdServicio = $_GET["IdServicio"];

if($_GET["tipoVenta"] == 'servicio'){
    $query = $this->ExpedienteC_model->ConsentimientoPestanasGeneralesFranquicias($idCliente, $IdVentas, $IdServicio);

            if($query->num_rows() >0){
                foreach ($query->result() as $value)
                    $ConsentimientoFirmado = $value->ConsentimientoFirmado;


                    $this->db->select('*');
                    $this->db->from('consentimientopestañas');
                    $this->db->where('IdConsentimiento',$ConsentimientoFirmado);
                    $queryC = $this->db->get();

                    if($queryC->num_rows() >0){
                        foreach ($queryC->result() as $valueC) {
                            $IdConsentimiento_X = $valueC->IdConsentimiento;
                            $CondicionesMarcadas = $valueC->CondicionesMarcadas;
                            $Costo = $valueC->Costo;
                            $NumExtensiones = $valueC->NumExtensiones;
                            $RutaFirmaDigital = $valueC->RutaFirmaDigital;
                            $FechaCreacion = $valueC->FechaCreacion;
                        }
                        $array=explode(' ', $FechaCreacion);
                        $data = array(
                            'IdConsentimiento' => $IdConsentimiento_X,
                            'CondicionesMarcadas' => $CondicionesMarcadas,
                            'Costo' => $Costo,
                            'NumExtensiones' => $NumExtensiones,
                            'RutaFirmaDigital' => $RutaFirmaDigital,
                            'FechaCreacion' => $array[0],
                            'idCliente' => $_GET["idCliente"],
                            'nombreCliente' => $_GET["nombreCliente"],
                            'nombreServicio' => $_GET["nombreServicio"],
                            'IdServicio' => $_GET["IdServicio"],
                            'IdVentas' => $_GET["IdVentas"],
                            'tipoVenta' => $_GET["tipoVenta"],
                        );
                    }else{
                        $data['idCliente'] =$_GET["idCliente"];
                        $data['nombreCliente'] = $_GET["nombreCliente"];
                        $data['nombreServicio'] = $_GET["nombreServicio"];
                        $data['IdServicio'] = $_GET["IdServicio"];
                        $data['IdVentas'] = $_GET["IdVentas"];
                        $data['tipoVenta'] = $_GET["tipoVenta"];
                        $data['IdConsentimiento'] = $ConsentimientoFirmado;     
                        $data['CondicionesMarcadas'] = 'null';      
                        $data['Costo'] = null;      
                        $data['NumExtensiones'] = null;
                        $data['RutaFirmaDigital'] = '';     
                        $data['FechaCreacion'] = '';         
            
                    }
            }

}else{

$queryP = $this->ExpedienteC_model->ConsentimientoPestanasPromociones($idCliente, $IdVentas, $IdServicio);

            if($queryP->num_rows() >0){
                foreach ($queryP->result() as $valueP)
                    $ConsentimientoFirmadoP = $valueP->ConsentimientoFirmado;


                    $this->db->select('*');
                    $this->db->from('consentimientopestañas');
                    $this->db->where('IdConsentimiento',$ConsentimientoFirmadoP);
                    $queryCP = $this->db->get();
                    if($queryCP->num_rows() >0){
                        foreach ($queryCP->result() as $valueCP) {
                            $IdConsentimiento_X = $valueCP->IdConsentimiento;
                            $CondicionesMarcadas = $valueCP->CondicionesMarcadas;
                            $Costo = $valueCP->Costo;
                            $NumExtensiones = $valueCP->NumExtensiones;
                            $FirmaDigital = $valueCP->FirmaDigital;
                            $RutaFechaCreacion = $valueCP->RutaFechaCreacion;
                        }
                        $array=explode(' ', $FechaCreacion);
                        $data = array(
                            'IdConsentimiento' => $IdConsentimiento_X,
                            'CondicionesMarcadas' => $CondicionesMarcadas,
                            'Costo' => $Costo,
                            'NumExtensiones' => $NumExtensiones,
                            'RutaFirmaDigital' => $RutaFirmaDigital,
                            'FechaCreacion' => $array[0],
                            'idCliente' => $_GET["idCliente"],
                            'nombreCliente' => $_GET["nombreCliente"],
                            'nombreServicio' => $_GET["nombreServicio"],
                            'IdServicio' => $_GET["IdServicio"],
                            'IdVentas' => $_GET["IdVentas"],
                            'tipoVenta' => $_GET["tipoVenta"],
                        );
                    }else{
                        $data['idCliente'] =$_GET["idCliente"];
                        $data['nombreCliente'] = $_GET["nombreCliente"];
                        $data['nombreServicio'] = $_GET["nombreServicio"];
                        $data['IdServicio'] = $_GET["IdServicio"];
                        $data['IdVentas'] = $_GET["IdVentas"];
                        $data['tipoVenta'] = $_GET["tipoVenta"];
                        $data['IdConsentimiento'] = $ConsentimientoFirmadoP;        
                        $data['CondicionesMarcadas'] = 'null';      
                        $data['Costo'] = null;      
                        $data['NumExtensiones'] = null; 
                        $data['RutaFirmaDigital'] = ''; 
                        $data['FechaCreacion'] = '';
            
                    }
            }



}
    

            // $data['idCliente'] =$_GET["idCliente"];
            // $data['nombreCliente'] = $_GET["nombreCliente"];
            // $data['nombreServicio'] = $_GET["nombreServicio"];
            // $data['IdServicio'] = $_GET["IdServicio"];
            // $data['IdVentas'] = $_GET["IdVentas"];
            // $data['tipoVenta'] = $_GET["tipoVenta"];

        $this->load->view('layout/headerCos');
        $this->load->view('layout/menuCosmetologo');
        $this->load->view('expediente/cosmetologo/consentimientoPestanas_view',$data);
        $this->load->view('layout/footer');
        }
}


//Funcion que guarda el consentimiento en la tabla de consentimientoPestañas
public function guardarConsentimiento(){

    $condicionesMarcadas = '';

            if($this->input->post('condicionesMarcadas') != ''){
                foreach($this->input->post('condicionesMarcadas') as $selected){
                    $condicionesMarcadas .=  $selected.",";
                    }
                }else{
                    $condicionesMarcadas =  null;
                }

    $data['IdCliente'] =    $this->uri->segment(5);     
    
    $data['IdVentas'] = $this->input->post('IdVentas');
    $data['IdServicio'] = $this->input->post('IdServicio');
    $data['tipoVenta'] = $this->input->post('tipoVenta');
    $data['nombreCliente'] = $this->input->post('nombreCliente');


    $data['Costo'] = $this->input->post('costo');
    $data['NumExtensiones'] = $this->input->post('numExtensiones');
    $data['CondicionesMarcadas'] = $condicionesMarcadas;

    $path = "files/firmas/";
    if (!is_dir($path)) {
        mkdir($path, 0777, true);
        chmod($path, 0777);
    }
    $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
    // Need to decode before saving since the data we received is already base64 encoded
    $decodedData=base64_decode($filteredData);
    // store in server
    $fic_name = $data['nombreCliente'].'_'.$data['IdCliente'].'_'.date("YmdHis").'.png';                        
    $fp = fopen($path.$fic_name, 'wb');
    $ok = fwrite( $fp, $decodedData);
    fclose( $fp );

    $path = $path.$fic_name;
    $data['RutaFirmaDigital'] = $path;

///////////////////////////
if($this->input->post('tipoVenta') == 'servicio'){
    $this->db->select('*');
    $this->db->from('ventas_has_serviciosfranquicias');
    $this->db->where('ventas_IdVentas', $this->input->post('IdVentas'));
    $this->db->where('IdVentasServicios', $this->input->post('IdServicio'));
    $queryPestanas = $this->db->get();
}else{
    $this->db->select('*');
    $this->db->from('ventas_has_promociones');
    $this->db->where('ventas_IdVentas', $this->input->post('IdVentas'));
    $this->db->where('IdVentasPromociones', $this->input->post('IdServicio'));
    $queryPestanas = $this->db->get();
}
/////////////////////////
foreach ($queryPestanas->result() as $value)
    $consentimiento = $value->ConsentimientoFirmado;

if($consentimiento != "" || $consentimiento != null){
    echo "registrado";
}else{
    $this->ExpedienteC_model->guardarConsentimiento($data);
}
    
    // echo $condicionesMarcadas."--".$costo."--".$numExtensiones."--".$nombreCliente;
    // echo $IdCliente;
}


    //-------------------------------------------------------------------------------------------------------------------------------------------------------
    //Historico Nutricional 
    //Muestra todos los datos nutricionales dependiendo el Expediete del cliente seleccionado 
    public function Nutricional()
    {
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);

    if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $id= $this->uri->segment(5);
        $obtenerenlaceExpe = $this->ExpedienteC_model->obtenerExpe($id);
        $obtenerIDCliente = $this->ExpedienteC_model->BuscarIDClientes($id);

        foreach ($obtenerIDCliente->result() as $fila2) {
                    $IdClientes = $fila2->IdClientes;
                    $NombreCliente=$fila2->NombreCliente;
                }


        if($obtenerenlaceExpe != FALSE){
            foreach ($obtenerenlaceExpe->result() as $fila) {
                    $clientes_IdClientes = $fila->clientes_IdClientes;
                    $Idexpediente=$fila->Idexpediente;
                }
                $data = array(
                'clientes_IdClientes' => $clientes_IdClientes,  
                'Idexpediente' => $Idexpediente,    
                );
            }else{

        if($obtenerIDCliente != FALSE){
                $data = array(
                'IdClientes' => $IdClientes,    
                'NombreCliente' => $NombreCliente,  
                );
                $data['Idexpediente']=null;
            }else{
                $data ='';
                return FALSE;
            }
                
        }

        // $data['ReNombre']=$this->ExpedienteC_model->obtenerNombre($data);
        $data['IdCliente']=$IdClientes;
        $data['ReNombre']=$NombreCliente;
        // $this->db->select('*');
        $this->load->view('layout/headerCos');
        $this->load->view('layout/menuCosmetologo');
        $this->load->view('expediente/cosmetologo/listaNutricion_view', $data);
        $this->load->view('layout/footer');
        }
    }

///////////////////////////////////resultado para database de expediente de nutricion/////////////////////////////////////////
    public function InfoNutricion()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2')
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $idE = $this->input->post('idE');
        $this->db->select('*');
        $this->db->from('nutricion');  
        $this->db->where('clientes_IdClientes',$idE);
        $query = $this->db->get()->result();

        if($query != null){ 
            foreach ($query as $row) {
                $data[] = array(
                    $Fecha = $row->Fecha,
                    $Talla=$row->Talla,
                    $Peso = $row->Peso,
                    $IMC = $row->IMC,
                    $Cintura = $row->Cintura,
                    $Cadera = $row->Cadera,
                    $GrasaCorporal = $row->GrasaCorporal,
                    $MasaMuscular = $row->MasaMuscular,
                    $GrasaVisceral = $row->GrasaVisceral,
                    $RecomendacionesAdicionales = $row->RecomendacionesAdicionales,
                    $cosmetologo = $row->Usuario,
                    // $botones = "<a href='".base_url()."expediente/franquiciatario/ExpedienteF/editarNutricion/".$row->expediente_IdExpediente."/".$row->IdNutricion."' class='label label-primary'>"."<span class='glyphicon glyphicon-pencil'></a></span>"."&nbsp;&nbsp;"."<a onclick= 'confirmarExp() == false) return false 'href='".base_url()."expediente/franquiciatario/ExpedienteF/eliminarNutricion/".$row->IdNutricion."/".$row->expediente_IdExpediente."' class='label label-danger'>"."<span class='glyphicon glyphicon-trash'></a></span>",

                    // "<a href='".base_url()."expediente/franquiciatario/ExpedienteF/editarNutricion/".$row->expediente_IdExpediente."/".$row->IdRelajante."' class='label label-primary'>"."<span class='glyphicon glyphicon-pencil'></a></span>"."&nbsp;&nbsp;".
                );
                    
                }
                echo json_encode($data);
                }else{
                    echo json_encode(null);
                }

        }
    }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //Muestra la vista agregarNutricion_view para agregar nuevos registros dependiendo el Expediete del cliente seleccionado 
    public function agregarNutricion()
    {
        $idVC= $this->uri->segment(5);
        $res = $this->ExpedienteC_model->BuscarClientesFranquicias($idVC);
        
        if($this->session->userdata('Rol_IdRol')==FALSE || 
            $this->session->userdata('Rol_IdRol') == '1'|| 
            $this->session->userdata('Rol_IdRol') == '2'|| $res == "0" || $res == "FALSE")
        {
            redirect(base_url().'acceso/acceso');
        } else {
        $data['Franquicias']=$this->ExpedienteC_model->BuscarFranquicia();
        foreach ($data['Franquicias'] as $i => $Franquicias) 

                ///////////////////////////////////////////////////////////////////////////////////////////
        $this->db->select('Idexpediente, FechaModificacion');
        $this->db->from('expediente');
        $this->db->where('Idexpediente',$this->uri->segment(5));
        $res=$this->db->get();
        if($res->num_rows() >0){
            $data['Expediente']="Existe";
        }else{
            $data['Expediente']="NoExiste";
        }
        ///////////////////////////////////////////////////////////////////////////////////////////

        // $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuarioC($i);
        $data['ReUsuarioC']=$this->ExpedienteC_model->BuscarUsuario($i);
        $data['id']=$this->uri->segment(5);
        $this->load->view('layout/headerCos');
        $this->load->view('layout/menuCosmetologo');
        $this->load->view('expediente/cosmetologo/agregarNutricion_view',$data);
        $this->load->view('layout/footer');
        }
    }

//Guarda los datos introducidos en la tabla nutricion
    public function guardarNutricion()
    {
        $idExp=$this->uri->segment(5);
        $id=$this->session->userdata('IdUsuarios');
        $usuario=$this->ExpedienteC_model->obtenerUsuario($id);

        $parametro['Talla']= $this->input->post('txt_Talla');
        $parametro['Peso']= $this->input->post('txt_Peso');
        $parametro['IMC']= $this->input->post('txt_IMC');
        $parametro['Cintura']= $this->input->post('txt_Cintura');
        $parametro['Cadera']= $this->input->post('txt_Cadera');
        $parametro['GrasaCorporal']= $this->input->post('txt_GrasaCorporal');
        $parametro['MasaMuscular']= $this->input->post('txt_MasaMuscular');
        $parametro['GrasaVisceral']= $this->input->post('txt_GrasaVisceral');
        $parametro['RecomendacionesAdicionales']= $this->input->post('txt_Recomendaciones');

        if($this->input->post('ExpedienteExiste') == 'Existe'){
            $parametro['expediente_IdExpediente']= $this->input->post('txt_idEx');
        }else{
            $parametro['expediente_IdExpediente']= null;
        }
        
        $parametro['clientes_IdClientes']= $this->input->post('txt_idEx');
        
        $parametro['Usuario']= $this->input->post('usuario');
        $parametro['UsuarioLog']= $usuario;
        
        if ($this->input->post('base64') == null || $this->input->post('base64') == '') {
            $parametro['FirmaDigital']= null;
        }else{
            $path = "files/firmas/";
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
                chmod($path, 0777);
            }
            $filteredData=substr($this->input->post('base64'), strpos($this->input->post('base64'), ",")+1);
            // Need to decode before saving since the data we received is already base64 encoded
            $decodedData=base64_decode($filteredData);
            $NombreClienteC = $this->ExpedienteC_model->cliente($idExp);
            // store in server
            $fic_name = $NombreClienteC->NombreCliente.'_'.$idExp.'_'.$this->input->post('txt_tratamientoSeleccionado').'_'.date("YmdHis").'.png';                      
            $fp = fopen($path.$fic_name, 'wb');
            $ok = fwrite( $fp, $decodedData);
            fclose( $fp );

            $parametro['FirmaDigital']= $path.$fic_name;
        }
        $this->ExpedienteC_model->guardarNutri($parametro, $idExp);
        // echo "controlador";
    }

    public function generarConsentimientoPdf()
    {
        if($this->session->userdata('Rol_IdRol')==FALSE || 
        $this->session->userdata('Rol_IdRol') == '1'|| 
        $this->session->userdata('Rol_IdRol') == '2')
    {
        redirect(base_url().'acceso/acceso');
    } else {

        $IdConsentimiento=$_GET['IdConsentimiento']; 
        // $data['nombreCliente'] = $this->input->post('nombreCliente');
        

        $this->db->select('*');
        $this->db->from('consentimientopestañas');
        $this->db->where('IdConsentimiento',$IdConsentimiento);
        $query = $this->db->get();
        if($query->num_rows() >0){
            foreach ($query->result() as $value) {
                $IdConsentimiento = $value->IdConsentimiento;
                $CondicionesMarcadas = $value->CondicionesMarcadas;
                $Costo = $value->Costo;
                $NumExtensiones = $value->NumExtensiones;
                $RutaFirmaDigital = $value->RutaFirmaDigital;
            }
            $data = array(
                'IdConsentimiento' => $IdConsentimiento,
                'CondicionesMarcadas' => $CondicionesMarcadas,
                'Costo' => $Costo,
                'NumExtensiones' => $NumExtensiones,
                'RutaFirmaDigital' => "./".$RutaFirmaDigital,
            );
        }else{
            // $data['IdConsentimiento'] = null;
        }

        $data['nombreCliente'] = $_GET['nombreCliente'];

        $html=($this->load->view('expediente/cosmetologo/PDF_consentimiento_view',$data, true));
        $this->mydompdf->load_html($html,'UTF-8');  
        $this->mydompdf->set_paper('A4', 'portrait'); 
        $this->mydompdf->render();  
        $this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); 
        $this->mydompdf->set_base_path('assets/dist/css/styles.css'); //agregar de nuevo el css
        $this->mydompdf->stream("consentimiento.pdf");
    }
    }


///////////////////////////////////resultado de la busqueda del numero de sesiones del servicio /////////////////////////////////////////

public function numSesionesPromocionesServicios(){
    $IdPromosServicios = $this->input->post('IdPromosServicios');
    $TipoServicio = $this->input->post('TipoServicio');
//////////////////////////////////////////////////////////////////////////////////////////////////
    if($TipoServicio == 'servicio'){
        $query = $this->ExpedienteC_model->numSesionesServicios($IdPromosServicios);
        if($query->num_rows() > 0){
            foreach ($query->result() as $num) {
                echo $num->SesionesServicio;
            }
        }
        
    }else if($TipoServicio == 'promocion'){
        $query2 = $this->ExpedienteC_model->numSesionesPromociones($IdPromosServicios);
        if($query2->num_rows() > 0){
            foreach ($query2->result() as $num2) {
                echo $num2->SesionesPromocion;
            }
        }
    }
}

/////////////////////////////////////////Funcion que valida el limite de sesiones que se pueden almacenar//////////////////////////////////////////
public function validarSesionesFacial(){
    $IdServicio_X = $this->input->post('IdServicio_X');
    $TipoServicio = $this->input->post('TipoServicio');
    $tratamiento = $this->input->post('tratamiento');
//////////////////////////////////////////////////////////////////////////////////////////////////
    if($tratamiento == 'facial'){
        $query2 = $this->ExpedienteC_model->validarSesionesFacial($IdServicio_X, $TipoServicio);
        if($query2->num_rows() > 0){
            foreach ($query2->result() as $value) 
                $FirmaDigital = $value->FirmaDigital;
            
            echo $rows."///".$FirmaDigital;
        }
    }
//////////////////////////////////////////////////////////////////////////////////////////////////
    else if($tratamiento == 'corporal'){
        $query2 = $this->ExpedienteC_model->validarSesionesCorporal($IdServicio_X, $TipoServicio);
        $rows = $query2->num_rows();
        if($query2->num_rows() > 0){
            foreach ($query2->result() as $value) 
                $FirmaDigital = $value->FirmaDigital;

            echo $rows."///".$FirmaDigital;
        }
    }
//////////////////////////////////////////////////////////////////////////////////////////////////
    else if($tratamiento == 'relajante'){
        $query2 = $this->ExpedienteC_model->validarSesionesRelajante($IdServicio_X, $TipoServicio);
        $rows = $query2->num_rows();
        if($query2->num_rows() > 0){
            foreach ($query2->result() as $value) 
                $FirmaDigital = $value->FirmaDigital;
            
            echo $rows."///".$FirmaDigital;
        }
    }
//////////////////////////////////////////////////////////////////////////////////////////////////
    else if($tratamiento == 'eligth'){
        $query2 = $this->ExpedienteC_model->validarSesionesEligth($IdServicio_X, $TipoServicio);
        $rows = $query2->num_rows();
        if($query2->num_rows() > 0){
            foreach ($query2->result() as $value) 
                $FirmaDigital = $value->FirmaDigital;
            
            echo $rows."///".$FirmaDigital;
        }
    }
//////////////////////////////////////////////////////////////////////////////////////////////////
    else if($tratamiento == 'pestañas'){
        $query2 = $this->ExpedienteC_model->validarSesionesPestanas($IdServicio_X, $TipoServicio);
        $rows = $query2->num_rows();
        if($query2->num_rows() > 0){
            foreach ($query2->result() as $value) 
                $FirmaDigital = $value->FirmaDigital;
            
            echo $rows."///".$FirmaDigital;
        }
    }
//////////////////////////////////////////////////////////////////////////////////////////////////  

}

//Funcion que consulta si existe la firma principal en clientes o si existe la firma en el expediente del cliente
public function consultarFirmaPrincipal(){

    $idC=$this->input->post('idC');
    $categoria=$this->input->post('categoria');

    $this->db->select('*');
    $this->db->from('clientes');
    $this->db->where('IdClientes',$idC);
    $query = $this->db->get();

            $this->db->select('*');
            $this->db->from('expediente');
            $this->db->where('Idexpediente',$idC);
            $queryExp = $this->db->get();

    if($query->num_rows() > 0){
        foreach ($query->result() as $value)
            $FirmaDigital = $value->FirmaDigital;
            $UltimaFirmaModificada = $value->UltimaFirmaModificada;

        if($categoria == 'corporal' || $categoria == 'facial' || $categoria == 'relajante' || $categoria == 'eligth'){
            
            if($queryExp->num_rows() > 0){
                foreach ($queryExp->result() as $valueE)
                    $FirmaDigitalE = $valueE->FirmaDigital;

                    if($FirmaDigitalE != null){
                        echo "1";
                    }else{
                        echo "actualizarExp";
                        }
                }else{
                    echo "sinExpediente";
                }

        }
        else{
            if($queryExp->num_rows() > 0){
                foreach ($queryExp->result() as $valueE)
                    $FirmaDigitalE = $valueE->FirmaDigital;

                    if($FirmaDigitalE != null){
                        echo "1";
                    }else{
                        echo "actualizarExp";
                        }
            }else{
                if($FirmaDigital != null){
                echo "1";
                }else{
                    echo "ingresarFirmaPrincipal";
                }
            }

            
        }
            
    
    }
    else{
        echo "NoExisteCliente";
    }

}


}

	




