<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class FranquiciaA extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('franquicias/franquicias/administrador/accionesfranquicia_model');
		$this->load->library(array('session','form_validation'));
		//$this->load->helper(array('url')); 
	}
	
public function index(){ //es la panatalla principal de las franquicias (lista de franquicias)
	
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
	$this->db->select('*');
	$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
	$this->db->join('zona','Zona_IdZona = IdZona','inner');
	$this->db->order_by("Modelo_IdModelo","asc");
	$data['consulta']=$this->db->get('franquicias')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/franquicias/administrador/listafranquicia_view',$data );
		$this->load->view('layout/footer');
		}
	}


	public function agregar(){ // en esta función se muestra la vista para agregar una nueva franquicia
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$datos['ReZona']=$this->accionesfranquicia_model->BuscarZona();
		$datos['ReModelo']=$this->accionesfranquicia_model->BuscarModelo();
		$this->load->view('franquicias/franquicias/administrador/agregarfranquicia_view',$datos);
		$this->load->view('layout/footer');
	
	}}

	public function guardar(){ // aca se mandan los datos capturados en la vista al modelo para que puedan ser guardados en la bd
		$parametro['Modelo_IdModelo']= $this->input->post('txt_modelo');
		$parametro['NombreFranquicia']= $this->input->post('txt_nombref');
		$parametro['RFC']= $this->input->post('txt_rfc');
		$parametro['DomicilioFiscal']= $this->input->post('txt_domiciliofi');
		$parametro['DomicilioFranquicia']= $this->input->post('txt_domiciliofr');
		$parametro['Estado']= $this->input->post('txt_estado');
		$parametro['Municipio']= $this->input->post('txt_municipio');
		$parametro['CP']= $this->input->post('txt_cp');
		$parametro['TelefonoFranquicia']= $this->input->post('txt_telefono');
		$parametro['CorreoCorp']= $this->input->post('txt_correoc');
		$parametro['RegimenFiscal']= $this->input->post('txt_regimenf');
		$parametro['NombrePropietario']= $this->input->post('txt_nombrep');
		$parametro['CelularPropietario']= $this->input->post('txt_celularp');
		$parametro['RazonSocial']= $this->input->post('txt_razons');
		$parametro['CorreoPersonal']= $this->input->post('txt_correop');
		$parametro['CancelarCita'] = $this->input->post('cantidad').'*'.$this->input->post('abreviatura');
		$parametro['Zona_IdZona']= $this->input->post('txt_zona');

		$this->accionesfranquicia_model->guardar($parametro);
		// echo "<script>alert('Datos guardados correctamente');</script>";
		// //redirect('/franquicias/franquicias/administrador/franquiciaA', 'refresh');
		// redirect(base_url()."franquicias/franquicias/administrador/franquiciaA");

		echo "<script>alert('Franquicia registrada correctamente');
		window.location.href='".base_url()."franquicias/franquicias/administrador/franquiciaA';
		</script>";

	}
	public function eliminar() { //esta funcion permite eliminar un franquicia por medio de su id que es pasado mediante la url 
		 $id= $this->uri->segment(6);
		 $this->accionesfranquicia_model->eliminar($id);
		 //redirect(base_url());	 
	}


public function editar(){//esta funcioón muestra en la vista los datos guardados anteriormente de una franquicia para asi poder visualisar que cambios se desean realizar
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(6);
		$obtenerenlace = $this->accionesfranquicia_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdFranquicias = $fila->IdFranquicias;
				$Modelo_IdModelo=$fila->Modelo_IdModelo;
				$NombreFranquicia=$fila->NombreFranquicia;
				$RFC = $fila->RFC;
				$DomicilioFiscal=$fila->DomicilioFiscal;
				$DomicilioFranquicia=$fila->DomicilioFranquicia;
				$Estado = $fila->Estado;
				$Municipio=$fila->Municipio;
				$CP=$fila->CP;
				$TelefonoFranquicia = $fila->TelefonoFranquicia;
				$CorreoCorp=$fila->CorreoCorp;
				$RegimenFiscal=$fila->RegimenFiscal;
				$NombrePropietario = $fila->NombrePropietario;
				$CelularPropietario = $fila->CelularPropietario;
				$RazonSocial=$fila->RazonSocial;
				$CorreoPersonal=$fila->CorreoPersonal;
				$Zona_IdZona = $fila->Zona_IdZona;
				if($fila->CancelarCita!=null || $fila->CancelarCita!=""){

					$cantidad=explode("*",$fila->CancelarCita);
				} else{
					$cantidad[0]="";
					$cantidad[1]="";
				}


			}
			$data = array(
				'IdFranquicias' => $IdFranquicias,
				'Modelo_IdModelo' => $Modelo_IdModelo,
				'NombreFranquicia' => $NombreFranquicia,
				'RFC' => $RFC,
				'DomicilioFiscal' => $DomicilioFiscal,
				'DomicilioFranquicia' => $DomicilioFranquicia,
				'Estado' => $Estado,
				'Municipio' => $Municipio,
				'CP' => $CP,
				'TelefonoFranquicia' => $TelefonoFranquicia,
				'CorreoCorp' => $CorreoCorp,
				'RegimenFiscal' => $RegimenFiscal,
				'NombrePropietario' => $NombrePropietario,
				'CelularPropietario' => $CelularPropietario,
				'RazonSocial' => $RazonSocial,
				'CorreoPersonal' => $CorreoPersonal,
				'Zona_IdZona' => $Zona_IdZona,
				'cantidad' => $cantidad[0],
				'abreviatura' => $cantidad[1],
			);
			}else{
				$data ='';
				return FALSE;
			
		}
		$data['ReModelo']=$this->accionesfranquicia_model->BuscarModelo();
		$data['ReZona']=$this->accionesfranquicia_model->BuscarZona();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/franquicias/administrador/editarfranquicia_view', $data);
		$this->load->view('layout/footer');
	}
}

	public function editarenlace ()//esta funcion manda en un arreglo los datos que se desean cambiar al modelo para que se puedan guardar en la bd
	{
		$IdFranquicias= $this -> uri->segment(6);
		$data=array(
			'IdFranquicias' => $this -> input ->post('IdFranquicias', true),
			'Modelo_IdModelo' => $this -> input ->post('Modelo_IdModelo', true),
			'NombreFranquicia' => $this -> input ->post('NombreFranquicia', true),
			'RFC' => $this -> input ->post('RFC', true),
			'DomicilioFiscal' => $this -> input ->post('DomicilioFiscal', true),
			'DomicilioFranquicia' => $this -> input ->post('DomicilioFranquicia', true),
			'Estado' => $this -> input ->post('Estado', true),
			'Municipio' => $this -> input ->post('Municipio', true),
			'CP' => $this -> input ->post('CP', true),
			'TelefonoFranquicia' => $this -> input ->post('TelefonoFranquicia', true),
			'CorreoCorp' => $this -> input ->post('CorreoCorp', true),
			'RegimenFiscal' => $this -> input ->post('RegimenFiscal', true),
			'NombrePropietario' => $this -> input ->post('NombrePropietario', true),
			'CelularPropietario' => $this -> input ->post('CelularPropietario', true),
			'RazonSocial' => $this -> input ->post('RazonSocial', true),
			'CorreoPersonal' => $this -> input ->post('CorreoPersonal', true),
			'CancelarCita' => $this->input->post('cantidad',true).'*'.$this->input->post('abreviatura', true),
			'Zona_IdZona' => $this -> input ->post('Zona_IdZona', true)
			);
		$this->accionesfranquicia_model->editarenlace($IdFranquicias, $data);
		//$this->load->helper('url'); 
		//redirect('franquicias/franquicias/administrador/franquiciaA','refresh');
		
		//redirect(base_url()."franquicias/franquicias/administrador/franquiciaA",'refresh');
		echo "<script>alert('Franquicia actualizada correctamente');
		window.location.href='".base_url()."franquicias/franquicias/administrador/franquiciaA';
		</script>";
	

	}

//esta funcion permite buscar una franquicia por medio de su nombre y mostrar su información correspondiente
	public function buscar ()
	{	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accionesfranquicia_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/franquicias/administrador/buscarfranquicia_view', $data);
		$this->load->view('layout/footer');
		}
	}

public function MostrarZona(){ // aca se muestran en  una lista todas las zonas existentes para poder agregar una nueva franquicia
		$options ="";
		if($this->input->post('IdZona')){
			$IdZona=$this->input->post('Zona');
			$NombreZona=$this->accionesfranquicia_model->BuscarZona($IdZona);
			foreach ($NombreZona as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $zona_name ?></option>
                <?php
			}
		}

	}



	public function MostrarModelo(){// aca se muestran en  una lista todos los modelos existentes para poder agregar una nueva franquicia
		$options ="";
		if($this->input->post('IdModelo')){
			$IdModelo=$this->input->post('Modelo');
			$NombreModelo=$this->accionesfranquicia_model->BuscarModelo($IdModelo);
			foreach ($NombreModelo as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $modelo_name ?></option>
                <?php
			}
		}

	}

}




