<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class ZonaA extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('franquicias/zonas/administrador/accioneszona_model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url','form'));

	}

public function index()
{ //aca se muestra la pantalla principal de este modulo (lista de zonas)
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$this->db->order_by('IdZona','asc');
		$result = $this->db->get('zona');
		$data=array('consulta'=>$result);
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/zonas/administrador/listazona_view',$data);
		$this->load->view('layout/footer');
		}
	}

	public function agregar()
	{ //aca se muestra la vista con el formulario correspondiente para agregar una nueva zona
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/zonas/administrador/agregarzona_view');
		$this->load->view('layout/footer');
		}
	}

	public function guardar(){//esta funcion manda los datos capturados en la vista al modelo para que se puedan guardar  en la bd

		
		$parametro['NombreZona']= $this->input->post('textNombreZona');
		$parametro['DescripcionZona']= $this->input->post('txtDescripcionZona');
		$this->accioneszona_model->guardar($parametro);
		// echo "<script>alert('Datos guardados correctamente');</script>";
		// redirect(base_url().'franquicias/zonas/administrador/zonaA', 'refresh');

		echo "<script>alert('Zona registrada correctamente');
		window.location.href='".base_url()."franquicias/zonas/administrador/zonaA';
		</script>";
	}


	public function eliminar() { //esta función permite eliminar una zona de acuerdo al id que se manda en la url
		 $id= $this->uri->segment(6);
		 $this->accioneszona_model->eliminar($id);
	}

//esta función manda en un formulario los datos que han sido guardados anteriormente de una zona para poder editarlos
	public function editar(){ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(6);
		$obtenerenlace = $this->accioneszona_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdZona = $fila->IdZona;
				$NombreZona=$fila->NombreZona;
				$DescripcionZona=$fila->DescripcionZona;
			}
			$data = array(
				'IdZona' => $IdZona,
				'NombreZona' => $NombreZona,
				'DescripcionZona' => $DescripcionZona);
			}else{
				$data ='';
				return FALSE;
			
		}
		
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/zonas/administrador/editarzona_views', $data);
		$this->load->view('layout/footer');
	}
}

//esta función manda los datos capturados en la vista al modelo para que los cambios realizados sean guardados en la bd
	public function editarenlace ()
	{
		$IdZona= $this -> uri->segment(6);
		$data=array(
			'NombreZona' => $this -> input ->post('NombreZona', true),
			'DescripcionZona' => $this -> input ->post('DescripcionZona', true)		
			);
		$this->accioneszona_model->editarenlace($IdZona, $data);
		//redirect(base_url().'franquicias/zonas/administrador/zonaA','refresh');
		echo "<script>alert('Zona actualizada correctamente');
		window.location.href='".base_url()."franquicias/zonas/administrador/zonaA';
		</script>";
	}

	public function buscar () //esta función permite buscar una zona por medio de su nombre
	{   if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accioneszona_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/zonas/administrador/buscarzona_view', $data);
		$this->load->view('layout/footer');
	}

}

}