<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class InventarioA extends CI_Controller
{
	public function __construct()
	{
		parent::__construct(
		);
		//cargamos la libreria html2pdf

		$this->load->model('inventario/Administrador/inventario_models');
		//cargamos la libreria DOMPDF previamente se debe realizar el archivo MydomPDF para la conexion del la libreria y el controlador.
    	$this->load->library('Mydompdf');
    	
		$this->load->library(array('session','form_validation'));	
	}
 	
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('productosgenerales','productosGenerales_IdProductosGenerales = IdProductosGenerales','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
		$data['consulta']=$this->db->get('productosfranquicias')->result();
        $this->load->view('layout/header');
		$this->load->view('layout/menuAdmin'); 
		$data['ReFranq']=$this->inventario_models->BuscarFranq();
		$data['ReTipo']=$this->inventario_models->BuscarTipo();
		$this->load->view('inventario/Administrador/inventario_views',$data);
		$this->load->view('layout/footer');
      
    } 
 }

//creacon del reporte general de Productos

public function InventarioAPDF(){
	
	
     if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('productosgenerales','productosGenerales_IdProductosGenerales = IdProductosGenerales','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
		$data['consulta']=$this->db->get('productosfranquicias')->result();	
		//$data["numero"] = 176;
		$html=($this->load->view('inventario/Administrador/InventarioA_Pdf', $data, true));
    	$this->mydompdf->load_html(utf8_decode($html));
    	$this->mydompdf->render();	
    	$this->mydompdf->set_paper('a4', 'portrait'); 
   		$this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("InventarioGeneral.pdf", array("Attachment" => false));
 }
}
   


   
    //Creacion del reporte del inventario por franquicia
	public function BuscarPorFranquicia(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
  
		$this->db->select('*');
		$this->db->join('productosgenerales','productosGenerales_IdProductosGenerales = IdProductosGenerales','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('tipoproducto','TipoProducto_IdTipoProducto = IdTipoProducto','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->inventario_models->buscarporfranquicia(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->inventario_models->BuscarFranq();
		$data['ReTipo']=$this->inventario_models->BuscarTipo();
		$html=($this->load->view('inventario/Administrador/InventarioAPorFranquicia_Pdf', $data, true));
     	$this->mydompdf->load_html($html);	
     	$this->mydompdf->set_paper('a4', 'portrait'); 
    	$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("InventarioPorFranquicia.pdf", array("Attachment" => false));
		$this->load->view('layout/footer');

	}
}


public function BuscarPorTipo(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
	 //  $data['Franquicias']=$this->inventario_models->BuscarFranquicia();
		// foreach ($data['Franquicias'] as $i => $Franquicias)	
		// $this->db->where('Franquicias_IdFranquicias',$i);
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->inventario_models->buscarporTipo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReTipo']=$this->inventario_models->BuscarTipo();
		$html=($this->load->view('inventario/Administrador/InventarioPorTipoProducto', $data, true));
		$this->mydompdf->load_html($html);	
    	$this->mydompdf->set_paper('a4', 'portrait'); 
   		$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("InventarioGeneralPorTipoProducto.pdf", array("Attachment" => false));
		$this->load->view('layout/footer');
    }
  }
}
