<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class LeyendaA extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('leyendas/administrador/accionesleyenda_model');
		$this->load->library(array('session','form_validation'));

	}

	public function index(){ //esta función es la pantalla principal del módulo, aca se muestra la vista de las leyendas disponibles
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$result= $this->db->order_by('NombreLeyendas');
		$result = $this->db->get('leyendasgenerales');
		$data=array('consulta'=>$result);
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('leyendas/administrador/listaleyendas_view',$data);
		$this->load->view('layout/footer');
	
	}
}

public function agregar(){//Aca se mestra la vista con los formularios correspondientes para poder agregar una nueva leyenda
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('leyendas/administrador/agregarleyendageneral_view');
		$this->load->view('layout/footer');
	
	}
}
public function guardar(){//en esta función se mandan los datos capturados en la vista al modelo para poder guardarlos en la bd

		$parametro['IdLeyendas']= $this->input->post('txtid_idleyendas');
		$parametro['NombreLeyendas']= $this->input->post('txt_NombreLeyenda');
		$parametro['DescripcionLeyendas']= $this->input->post('txt_DescripcionLeyenda');
		$parametro['FechaInicioLeyendas']= $this->input->post('fechai');
		$parametro['FechaTerminoLeyendas']= $this->input->post('fechat');

		
		$this->accionesleyenda_model->guardar($parametro);
		//redirect('leyendas/administrador/leyendaA');
		echo "<script>alert('Leyenda registrada correctamente');
		window.location.href='".base_url()."franquicias/zonas/administrador/zonaA';
		</script>";

	}

		public function asignar(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
	
		$result = $this->db->get('franquicias');
		$data=array('consulta'=>$result);
		$this->db->join('leyendasgenerales','Leyendasgenerales_IdLeyendas=IdLeyendas','inner');
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReLeyendas']=$this->accionesleyenda_model->obtenerenlaceL($data);
		$this->load->view('leyendas/administrador/Asignarleyendas_view',$data);
		$this->load->view('layout/footer');
			}
		}
		public function AsignarFranquicia(){//en esta función se mandan los datos capturados en la vista al modelo para poder guardarlos en la bd
	
		$parametro['LeyendasGenerales_IdLeyendas']= $this->input->post('leyenda');
		$parametro['Franquicias_IdFranquicias']= $this->input->post('Franquicias');

		$this->accionesleyenda_model->AsignarFranquicia($parametro);
		//redirect('leyendas/administrador/leyendaA');
		echo "<script>alert('Leyenda asignada correctamente');
		window.location.href='".base_url()."leyendas/administrador/leyendaA';
		</script>";

	}

		public function MostrarAsignaciones(){

		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('leyendasgenerales','Leyendasgenerales_IdLeyendas=IdLeyendas','inner');
		$this->db->order_by('NombreLeyendas');
		$data['consulta']=$this->db->get('franquicias_has_leyendasgenerales')->result();
		$data['ReFranquicias']=$this->accionesleyenda_model->BuscarFranquicia();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('leyendas/administrador/MostarLeyendas_view',$data);
		$this->load->view('layout/footer');
		}

		public function obtenerenlaceL() { //esta función permite eliminar una leyenda por medio de su id que esta definido por el segmento 5 de la url
		 $id= $this->uri->segment(5);
		 $this->accionesleyenda_model->obtenerenlaceL($id);
		}




	public function eliminar() { //esta función permite eliminar una leyenda por medio de su id que esta definido por el segmento 5 de la url
		 $id= $this->uri->segment(5);
		 $this->accionesleyenda_model->eliminar($id);
		 //redirect('leyendas/administrador/leyendaA');
		 echo "<script>alert('Leyenda eliminada correctamente');
		window.location.href='".base_url()."leyendas/administrador/leyendaA';
		</script>";

	}

	public function eliminarL() { //esta función permite eliminar una leyenda por medio de su id que esta definido por el segmento 5 de la url
		 $id= $this->uri->segment(5);
		 $idDos= $this->uri->segment(6);
		 $this->accionesleyenda_model->eliminarL($id,$idDos);	
	}


	public function editar(){//esta función permite mostrar en un formulario los datos que ya han sido guardados anteriormente de una leyenda
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->accionesleyenda_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdLeyendas = $fila->IdLeyendas;
				$NombreLeyendas=$fila->NombreLeyendas;
				$DescripcionLeyendas=$fila->DescripcionLeyendas;
				$FechaInicioLeyendas=$fila->FechaInicioLeyendas;
				$FechaTerminoLeyendas=$fila->FechaTerminoLeyendas;

			}
			$data = array(
				'IdLeyendas' => $IdLeyendas,
				'NombreLeyendas' => $NombreLeyendas,
				'DescripcionLeyendas' => $DescripcionLeyendas,
				'FechaInicioLeyendas' => $FechaInicioLeyendas,
				'FechaTerminoLeyendas' => $FechaTerminoLeyendas);
			}else{
				$data ='';
				return FALSE;
			
		}
		
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('leyendas/administrador/editarleyendageneral_view', $data);
		$this->load->view('layout/footer');
	}
}
public function editarenlace ()//esta función permite pasar los datos que se desean modificar al modelo para que así se puedan guardar en la bd
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$IdLeyendas= $this -> uri->segment(5);
		$data=array(
			'IdLeyendas' => $this -> input ->post('IdLeyendas', true),
			'NombreLeyendas' => $this -> input ->post('NombreLeyendas', true),
			'DescripcionLeyendas' => $this -> input ->post('DescripcionLeyendas', true),
			'FechaInicioLeyendas' => $this -> input ->post('FechaInicioLeyendas', true),
			'FechaTerminoLeyendas' => $this -> input ->post('FechaTerminoLeyendas', true)		
			);
		$this->accionesleyenda_model->editarenlace($IdLeyendas, $data);
		//redirect('leyendas/administrador/leyendaA');
		echo "<script>alert('Leyenda actualizada correctamente');
		window.location.href='".base_url()."leyendas/administrador/leyendaA';
		</script>";

	}
}
public function buscar () //esta funcion permite buscar por medio de su nombre, y mostrar la información de la leyenda buscada
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accionesleyenda_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('leyendas/administrador/buscarleyenda_view', $data);
		$this->load->view('layout/footer');
	}
}

//Función que busca al usuario de acuerdo a la franquicia con la que se logueo el usuario 
	public function buscarporfranquicia(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('leyendasgenerales','Leyendasgenerales_IdLeyendas=IdLeyendas','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accionesleyenda_model->buscarporfranquicia(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$data['ReFranquicias']=$this->accionesleyenda_model->BuscarFranquicia();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('leyendas/administrador/BuscarLeyendas_view',$data);
		$this->load->view('layout/footer');
		}
	}



}