<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//Este controlador manda a traer las acciones que ayudará a que el módulo realize sus funciones(Administrador general)
ini_set('memory_limit', '-1');
class CitasCanceladasA extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('usuarios/Administrador/usuariosA_model');
		$this->load->library(array('session','form_validation'));
        $this->load->helper('form','url'); 
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaUsuariosA_view 
	public function index(){
	if (!$this->session->userdata('Rol_IdRol')){
      redirect('acceso/acceso');
    } else {
    $this->db->select('*');
	$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
	$this->db->join('rol','Rol_IdRol = IdRol','inner');
	$this->db->order_by("NombreUsuario","asc");
	//$this->db->order_by("Franquicias_IdFranquicias","asc");
	$data['consulta']=$this->db->get('usuarios')->result();
	$this->load->view('layout/header');
	$this->load->view('layout/menuAdmin');
	$data['ReFranq']=$this->usuariosA_model->BuscarFranq();
	$this->load->view('usuarios/Administrador/listaUsuariosA_view',$data);
	$this->load->view('layout/footer');
  		}
	}
		//Funcion que manda a traer la vista usuariosA_view para registrar un nuevo usuario
		public function agregar(){
		if (!$this->session->userdata('Rol_IdRol')){
      			redirect('acceso/acceso');
    	} else {
				$this->load->view('layout/header');
				$this->load->view('layout/menuAdmin');
				$datos['ReFranq']=$this->usuariosA_model->BuscarFranq();
				$datos['ReFranquicias']=$this->usuariosA_model->BuscarFranquicia();
				$datos['ReRol']=$this->usuariosA_model->BuscarRol();
				$this->load->view('usuarios/Administrador/usuariosA_view',$datos);
				$this->load->view('layout/footer');
				}
			}
	//Funcion que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar(){
		$parametro['NombreUsuario']= $this->input->post('txtnombre_completo')." ".$parametro['ApellidoPaterno']= $this->input->post('txtapellido_paterno')." ".$parametro['ApellidoMaterno']= $this->input->post('txtapellido_materno');
		$parametro['Usuario']= $this->input->post('text_usuario');
		$parametro['Contrasenia']= $this->input->post('txt_contrasenia');
		$parametro['Estatus']= $this->input->post('Estatus');
		$parametro['FechaNacimiento'] = $this->input->post('text_fecha');
        $parametro['NumeroTelefonicoUsuario'] = $this->input->post('text_telefono');
        $parametro['DireccionUsuario'] = $this->input->post('text_direccion');
        $parametro['Rol_IdRol'] = $this->input->post('Rol');
        $parametro['ProfesionUsuario'] = $this->input->post('text_profesion');
        $parametro['Franquicias_IdFranquicias'] = $this->input->post('franquicias');
		$this->usuariosA_model->GuardarUsuario($parametro);
		echo "<script>alert('Datos guardados correctamente');</script>";
		}
	//Función que manda a traer la vista editarUsuariosA_view con los datos del usuario seleccionado
	public function editar(){
		if (!$this->session->userdata('Rol_IdRol')){
      		redirect('acceso/acceso');
    	} else {
    	$data['ReFranquicias']=$this->usuariosA_model->BuscarFranquicia();
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->usuariosA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdUsuarios = $fila->IdUsuarios;
				$NombreUsuario=$fila->NombreUsuario;
				$Usuario=$fila->Usuario;
				$Contrasenia = $fila->Contrasenia;
				$Estatus = $fila->Estatus;
				$FechaNacimiento=$fila->FechaNacimiento;
				$NumeroTelefonicoUsuario=$fila->NumeroTelefonicoUsuario;
				$DireccionUsuario= $fila->DireccionUsuario;
				$Rol_IdRol= $fila->Rol_IdRol;
				$ProfesionUsuario= $fila->ProfesionUsuario;
				$Franquicias_IdFranquicias=$fila->Franquicias_IdFranquicias;
			}
			$data = array(
				'IdUsuarios' => $IdUsuarios,
				'NombreUsuario' => $NombreUsuario,
				'Usuario' => $Usuario,
				'Contrasenia' => $Contrasenia,
				'Estatus' => $Estatus,
				'FechaNacimiento' => $FechaNacimiento,
				'NumeroTelefonicoUsuario' => $NumeroTelefonicoUsuario,
				'DireccionUsuario' => $DireccionUsuario,
				'Rol_IdRol' => $Rol_IdRol,
				'ProfesionUsuario' => $ProfesionUsuario,
				'Franquicias_IdFranquicias' => $Franquicias_IdFranquicias);
			}else{
				$data ='';
				return FALSE;	
		}
		$data['ReRol']=$this->usuariosA_model->BuscarRol();
		$data['ReFranquicias']=$this->usuariosA_model->BuscarFranquicia();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('usuarios/Administrador/editarUsuariosA_view', $data);
		$this->load->view('layout/footer');
	  }
	}

	//Función que guarda los datos actualizados del usuario
	public function editarenlace ()
	{

		
		$IdUsuarios= $this -> uri->segment(5);
		$data=array(
			'Contrasenia' => ($this->input->post('Contrasenia',true)),
			'IdUsuarios' => $this ->input ->post('IdUsuarios', true),
			'NombreUsuario' => $this ->input ->post('NombreUsuario', true),
			'Usuario' => $this ->input ->post('Usuario', true),
			'Estatus' => $this ->input->post('Estatus',true),
			'FechaNacimiento' => $this ->input->post('FechaNacimiento', true),
			'NumeroTelefonicoUsuario' => $this ->input->post('NumeroTelefonicoUsuario',true),
			'Rol_IdRol' => $this ->input ->post('Rol_IdRol', true),
			'DireccionUsuario' => $this ->input ->post('DireccionUsuario',true),
			'ProfesionUsuario' => $this ->input ->post('ProfesionUsuario', true),
			'Franquicias_IdFranquicias' => $this ->input ->post('Franquicias_IdFranquicias', true)	
			);
		$this->usuariosA_model->editarenlace($IdUsuarios, $data);
		}
		//Función que elimina al usuario
		public function eliminar() {
		 $id= $this->uri->segment(5);
		 $this->usuariosA_model->eliminar($id);
		 //redirect('usuarios/Administrador/usuariosA');
	}


		
	//Función que manda a traer la vista buscarUsuariosA_view y hace la busqueda del usuario seleccionado
	public function buscar ()
	{
		$IdUsuarios=$this->uri->segment(5);
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->usuariosA_model->buscar($query);
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->usuariosA_model->BuscarFranq();
		$this->load->view('usuarios/Administrador/buscarUsuariosA_view',$data);
		$this->load->view('layout/footer');
	}

		public function ObtenerUsuario(){
		if (!$this->session->userdata('Rol_IdRol')){
      		redirect('acceso/acceso');
    	} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->usuariosA_model->obtenerFranquicia($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$NombreUsuario=$fila->NombreUsuario;
				$Rol_IdRol= $fila->Rol_IdRol;
				$Franquicias_IdFranquicias=$fila->Franquicias_IdFranquicias;
			}
			$data = array(
				'NombreUsuario' => $NombreUsuario,
				'Rol_IdRol' => $Rol_IdRol,
				'Franquicias_IdFranquicias' => $Franquicias_IdFranquicias);
			}else{
				$data ='';
				return FALSE;	
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('usuarios/Administrador/editarUsuariosA_view', $data);
		$this->load->view('layout/footer');
	  }
	}



	//Función que busca al usuario de acuerdo a la franquicia con la que se logueo el usuario 
	public function buscarporfranquicia(){
		if (!$this->session->userdata('Rol_IdRol')){
      		redirect('acceso/acceso');
    	} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol=IdRol','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->usuariosA_model->buscarporfranquicia(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
			$data['ReFranq']=$this->usuariosA_model->BuscarFranq();
		$this->load->view('usuarios/Administrador/buscarUsuariosA_view',$data);
		$this->load->view('layout/footer');
		}
	}




	//Función que muestra los roles 
	public function MostrarRol(){
		$options ="";
		if($this->input->post('IdRol')){
			$IdRol=$this->input->post('IdRol');
			$Nombre=$this->usuariosA_model->BuscarRol($IdRol);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $rol_name ?></option>
                <?php
			}
		}

	}

	public function MostrarRolSelect(){
		$options ="";
		if($this->input->post('IdRol')){
			$IdRol=$this->input->post('IdRol');
			$Nombre=$this->usuariosA_model->BuscarRolSelec($IdRol);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $rol_name ?></option>
                <?php
			}
		}

	}

	//Función que muestra las franquicias registradas
	public function MostrarFranquicia(){
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('IdFranquicias');
			$Nombre=$this->usuariosA_model->BuscarFranquicia($IdFranquicias);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}
	}
	//Función que muestra las franquicias registradas
	public function MostrarFranq(){
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('franquicias');
			$NombreFranquicia=$this->usuariosA_model->BuscarFranq($IdFranquicias);
			foreach ($NombreFranquicia as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}

	}


	

}