<?php
ini_set('memory_limit', '-1');
class ListacitasF extends CI_Controller {
	
	function __construct() {
		parent::__construct();
		
		$this->load->model('myagenda/franquiciatario/agendaF_model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url','form','color_helper'));
	}

	public function index(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//||$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {
			
    		$data['Franquicias']=$this->agendaF_model->BuscarFranquicia(); 
		 	foreach ($data['Franquicias'] as $i => $Franquicias) 
			$this->db->select('*');
			$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
			$this->db->where('Franquicias_IdFranquicias',$i);
			$data['consulta']=$this->db->get('agenda')->result();

			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$data['cabinas']=$this->cabinas(); 
			$data['ReCabina']=$this->agendaF_model->BuscarCabina(); 
			$data['ReCategoria']=$this->agendaF_model->BuscarCategoria();
			$data['ReEstatusCita']=$this->agendaF_model->BuscarEstatusCita();
			$data['ReUsuario']=$this->agendaF_model->BuscarUsuario();
			$this->load->view('myagenda/franquiciatario/agendaF_view',$data);
			$this->load->view('layout/footer');
		}
	}

	public function Myagenda($id){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//||$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {
    		$data['Franquicias']=$this->agendaF_model->BuscarFranquicia(); 
		 	foreach ($data['Franquicias'] as $i => $Franquicias) 
			$this->db->select('*');
			$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
			$this->db->where('Franquicias_IdFranquicias',$i);
			$data['consulta']=$this->db->get('agenda')->result();

			$this->db->select('*');
			$this->db->from('clientes');		
			$this->db->where('IdClientes',$id);
			$data['cliente']=$this->db->get()->row();

			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$data['cabinas']=$this->cabinas(); 
			$data['ReCabina']=$this->agendaF_model->BuscarCabina(); 
			$data['ReCategoria']=$this->agendaF_model->BuscarCategoria();
			$data['ReEstatusCita']=$this->agendaF_model->BuscarEstatusCita();
			$data['ReUsuario']=$this->agendaF_model->BuscarUsuario();

			$this->load->view('myagenda/franquiciatario/agendaFClient_view',$data);
			$this->load->view('layout/footer');
		}
	}

	public function horarioNoLab(){
		$horario=getBusinessHours();
	
		echo json_encode($horario);
	}

	// Busqueda de datos
	public function cabinasExistentes(){
		$cabinas=$this->agendaF_model->buscarCabinas();
		$datos=[];
		if($cabinas!=FALSE)
		{	$i=0;
			foreach($cabinas as $fila){
				$datos[$i]['IdCabina']=$fila->IdCabina;
				$datos[$i]['NombreCabina']=$fila->NombreCabina;	
				$datos[$i]['colorCabina']=$fila->colorCabina;	
				$i++;			
			}
		}
		echo json_encode($datos);
	}

	public function personalExistentes(){
		$personal=$this->agendaF_model->personalExistentes();
		echo json_encode($personal);
	}

	public function infoLaboral(){
		$i=$this->session->userdata('IdFranquicia');
		$dia = strtolower($this->input->post('dia'));
		$d =$this->input->post('dia');
		$this->db->select('*');
		$this->db->from('horarios');
		$this->db->where('IdFranquicias',$i);
		$this->db->where($dia,1);
		$query = $this->db->get();
	
		if($query){
			$horario = array();
			$v1  = 'horaIni'.$d;
			$v2 = 'horaFin'.$d;
			$horario['horaInicio'] = $query->row()->$v1;
			$horario['horaFin'] = $query->row()->$v2;
			
			echo json_encode($horario);
		}else{
			echo json_encode(false);
		}
	}

	public function listacitasFAct(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//|| $this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {			
    		$data['Franquicias']=$this->agendaF_model->BuscarFranquicia(); 
		 	foreach ($data['Franquicias'] as $i => $Franquicias) 
			$this->db->select('*');
			$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
			$this->db->where('Franquicias_IdFranquicias',$i);
			$data['consulta']=$this->db->get('agenda')->result();

			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$data['cabinas']=$this->cabinas(); 
			$data['ReCabina']=$this->agendaF_model->BuscarCabina(); 
			$data['ReCategoria']=$this->agendaF_model->BuscarCategoria();
			$data['ReEstatusCita']=$this->agendaF_model->BuscarEstatusCita();
			$data['ReUsuario']=$this->agendaF_model->BuscarUsuario();
			$this->load->view('myagenda/franquiciatario/agendaF_view',$data);
			$this->load->view('layout/footer');
		}
	}

	public function cabinas() {
		$cabinasExistentes=$this->agendaF_model->BuscarCabina();
		$i=0;
		foreach($cabinasExistentes as $i => $cabina)
		{
			$colores[$i]['id'] = $i;
			$colores[$i]['nombre'] = $cabina;
			switch($cabina)
			{
				case 'FACIAL':
					$colores[$i]['color'] = 'facial';
					break;
				case 'FACIAL 2':
					$colores[$i]['color'] = 'facial-2';
					break;
				case 'CORPORAL':
					$colores[$i]['color'] = 'corporal';
					break;
				case 'CORPORAL 2':
					$colores[$i]['color'] = 'corporal-2';
					break;
				case 'RELAJ/MASAJ':
					$colores[$i]['color'] = 'relajantes-masajes';
					break;
				case 'CAVITACION':
					$colores[$i]['color'] = 'cavitacion';
					break;
				case 'IPL/E-LIGHT':
					$colores[$i]['color'] = 'ipl-e-light';
					break;
				case 'PESTAÑAS':
					$colores[$i]['color'] = 'pestañas';
					break;
				case 'SAUNA':
					$colores[$i]['color'] = 'sauna';
					break;
				case 'SAUNA 2':
					$colores[$i]['color'] = 'sauna-2';
					break;
				case 'ADICIONAL':
					$colores[$i]['color'] = 'adicional';
					break;
				case 'CAPSULA INFRAROJA':
					$colores[$i]['color'] = 'capsula-infraroja';
					break;
				case 'UÑAS 1':
					$colores[$i]['color'] = 'uñas-1';
					break;
				case 'UÑAS 2':
					$colores[$i]['color'] = 'uñas-2';
					break;
				case 'UÑAS 3':
					$colores[$i]['color'] = 'uñas-3';
					break;
				default;
				$colores[$i]['color'] = 'blanco';
				break;
			}
			
			$i++;
			
		}
		
		return ($colores);
	}

	public function service(){
		$codigo = $this->input->post('codeService');
		/*echo  json_encode("codigo service".$codigo);*/
		$this->agendaF_model->BuscarServiciosNombre($codigo);
	}

	public function sesiones(){
		$tipo = $this->input->post('tipo');
		$id = $this->input->post('id');
		
		switch ($tipo) {
			case 'VF':
				$sesiones = $this->agendaF_model->obtenerSesioneXVFG($id, $tipo);
				break;
			case 'VG':
				$sesiones = $this->agendaF_model->obtenerSesioneXVFG($id, $tipo);
				break;
			case 'VP':
				$sesiones = $this->agendaF_model->obtenerSesioneXVP($id,$tipo);
				break;
			case 'SF':
				$sesiones = $this->agendaF_model->obtenerSesioneXVFG($id, $tipo);
				break;
			case 'SG':
				$sesiones = $this->agendaF_model->obtenerSesioneXVFG($id, $tipo);
				break;
			case 'SP':
				$sesiones = $this->agendaF_model->obtenerSesioneXVP($id,$tipo);
				break;									
			default:
				# code...
				break;
		}
		echo json_encode($sesiones);
  	}

	public function loadNamePromo(){
		$codigo = $this->input->post('codePromo');
		/*echo  json_encode("codigo service".$codigo);*/
		$this->agendaF_model->BuscarPromocionesNombre($codigo);
	}

	public function buscarporcabina (){ 
		$query2 = $this->input->get('query', TRUE);
		$r = $this->agendaF_model->buscarporcabina($query2);
		echo json_encode($r);
	}

	public function buscarAdeudos()	{
		$id=$_POST['id'];
		$this->Ventas_model->buscarAdeudos($id);
	}

	public function ServProm(){
		$data["sergen"] = $this->agendaF_model->BuscarServiciosGeneral();
		$data["serfranq"] = $this->agendaF_model->serviciosFranq();
		$data["promociones"] = $this->agendaF_model->promociones(); 
		echo json_encode($data);
	}

	public function personalExistentesCambio(){
		$dia = $this->input->post('dia');
		$inicio = $this->input->post('inicio');
		//$fin = $this->input->post('fin');
		$fechaElegida = $this->input->post('fechaElegida');
		$idCita = $this->input->post('idCita');
		$idPersonal = $this->input->post('idPersonal');

		$tiempo = array();
		$tiempo = explode( ' ', $_POST['duracion']); 

		switch ($tiempo[1]) {
			case 'min':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaElegida." ".$inicio."+ ".$tiempo[0]." minute"));
				$fin = explode( ' ', $Fecha1);
				break;
			case 'hrs':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaElegida." ".$inicio."+ ".$tiempo[0]." hour"));
				$fin = explode( ' ', $Fecha1);
				break;							
			default:
				# code...
				break;
		}

		$fechaCompleta = date("Y-m-d", strtotime($fechaElegida)).' '.$inicio;

		//obtener el tiempo que dura el servicio
		//sumarselo a la la hora de inicio seleccionada
		//tomarla como hora fin de servicio.
		//y verificar con esta y la de inicio si el usuario esta disponible entre
		//ese lapso de tiempo.  
		$personal = $this->agendaF_model->personalTrabajando($fechaElegida, $inicio, $fin[1], $idCita, $idPersonal);

		$array = array();
		foreach ($personal as $val) {
			if(strtotime($val['HoraInicio']) == strtotime($inicio) && strtotime($val['HoraFin'])==strtotime($fin[1])){
				$array[] = intval($val['Usuarios_IdUsuarios']);
			}elseif(strtotime($val['HoraInicio']) <= strtotime($inicio) && strtotime($fin[1]) <= strtotime($val['HoraFin'])){
				$array[] = intval($val['Usuarios_IdUsuarios']);
			}elseif(strtotime($inicio) <= strtotime($val['HoraInicio']) && strtotime($val['HoraFin']) <= strtotime($fin[1])){
				$array[] = intval($val['Usuarios_IdUsuarios']);
			}elseif(strtotime($inicio) < strtotime($val['HoraInicio']) && strtotime($val['HoraInicio']) < strtotime($fin[1])){
				$array[] = intval($val['Usuarios_IdUsuarios']);
			}elseif(strtotime($inicio) < strtotime($val['HoraFin']) && strtotime($val['HoraFin']) < strtotime($fin[1])){
				$array[] = intval($val['Usuarios_IdUsuarios']);
			}
		}
		
		$result=$this->agendaF_model->personalExistentesCambio($dia,$inicio,$fin[1],$array, $idPersonal);
		
		echo json_encode($result);
	}

	public function estados(){
		echo json_encode($this->agendaF_model->buscarEstados());
	}

	public function buscarCitasAgenda(){
		$fecha=date("Y-m-d",strtotime($_POST['fecha']));
		$tiempo = array();
		$tiempo = explode( ' ', $_POST['duracion']); 

		switch ($tiempo[1]) {
			case 'min':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fecha." ".$_POST["horaInicio"]."+ ".$tiempo[0]." minute"));
				$fin = explode( ' ', $Fecha1);
				break;
			case 'hrs':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fecha." ".$_POST["horaInicio"]."+ ".$tiempo[0]." hour"));
				$fin = explode( ' ', $Fecha1);
				break;							
			default:
				# code...
				break;
		}

		$buscaCitas=$this->agendaF_model->buscarCitasAgenda($_POST['idCabina'], $fecha, $_POST['horaInicio'], $fin[1]);
		echo json_encode($buscaCitas);
	}

	public function insertCita(){
		$e=$this->session->userdata('IdFranquicia');
 		$this->db->select('*');
		$this->db->from('franquicias');
		$this->db->where('IdFranquicias', $e);
		$query = $this->db->get();

		$fechaCompleta = date("Y-m-d", strtotime($_POST['fecha'])).' '.$_POST['horaInicio'];
		$tiempo = array();
		$tiempo = explode( ' ', $_POST['duracion']); 

		switch ($tiempo[1]) {
			case 'min':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." minute"));
				$fin = explode( ' ', $Fecha1);
				break;
			case 'hrs':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." hour"));
				$fin = explode( ' ', $Fecha1);
				break;							
			default:
				# code...
				break;
		}
		
		$cita = [];
		$camposCita=array(
			'Franquicias_IdFranquicias' => $e, 
			'Clientes_IdClientes' => $_POST['idCliente'],
			'Categoria_IdCategoria'=> '7',//'clientes_nombreClientes' => $this->Agenda_model->buscarNombreCliente($idCliente),
			'ServiciosFranquicias_IdServiciosFranquicias' => $_POST['idServicio'],
			'Promociones_IdPromociones' => $_POST['idPromo'],
			'SP_Agendado' => $_POST['nombreSer'],
			'Fecha' => date("Y-m-d",strtotime($_POST['fecha'])),
			'HoraInicio' => $_POST['horaInicio'],
			'HoraFin' => $fin[1],
			'DuracionCita' => $_POST['duracion'],
			'Cabina_IdCabina'=>$_POST['idCabina'],
			'estatuscitas_IdEstatusCita' => $_POST['isEstatus'],
			'Observaciones' => $_POST['observaciones'],
			'NumeroSesionesCitas' => $_POST['numeroSesiones'],
			'SesionActual' => $_POST['numeroSesion'],
			'SesionesFaltantesAgendar'=>($_POST['numeroSesiones']-$_POST['numeroSesion']),
			'Usuarios_IdUsuarios'=>$_POST['idUsuario'],
			'ventas_IdDetalleVenta'=>$_POST['idDetalleVentas'],
		);

		$insertaCita=$this->agendaF_model->guardarCita($camposCita);
		
		if($_POST['numeroSesion']===1 || $_POST['numeroSesion']==="1"){
			if ($_POST['isEstatus']==6) {
				$sesiones=array(
					'SesionesFaltantesCitas' => (int)$_POST['numeroSesiones']-1,
					'agenda_IdAgenda' => $insertaCita
				);
			} else {
				$sesiones=array(
					'SesionesFaltantesCitas' => (int)$_POST['numeroSesiones'],
					'agenda_IdAgenda' => $insertaCita
				);
			}		

			$this->agendaF_model->actSesion($sesiones, $insertaCita);
		}

		if($insertaCita != FALSE){
			if ($_POST['tipo'] == 'VG' || $_POST['tipo'] == 'VF') {
				$this->db->select('*');
				$this->db->from('ventas_has_serviciosfranquicias');
				$this->db->where('IdVentasServicios',$_POST['idDetalleVentas']);
				$query = $this->db->get()->row();

				$conteo =$query->conteoDetalleVentas;
				if ($conteo>0) {
					$total = $conteo-1;
				}else if($conteo==0){
					$total = $conteo;
				}
				
				if ($query->agenda_IdAgenda == null) {
					$ids = $insertaCita;
				}else{
					$ids = $query->agenda_IdAgenda.','.$insertaCita;
				}

				$this->db->set('conteoDetalleVentas', $total);
				$this->db->set('agenda_IdAgenda', $ids);
				$this->db->where('IdVentasServicios',$_POST['idDetalleVentas']);
				$this->db->update('ventas_has_serviciosfranquicias');
			}elseif ($_POST['tipo'] == 'VP') {
				$this->db->select('*');
				$this->db->from('ventas_has_promociones');
				$this->db->where('IdVentasPromociones',$_POST['idDetalleVentas']);
				$query = $this->db->get()->row();
				//echo json_encode($_POST['idDetalleVentas']);
				//exit();
				$conteo =$query->conteoDetalleVentas;
				if ($conteo>0) {
					$total = $conteo-1;
				}else if($conteo==0){
					$total = $conteo;
				}
				
				if ($query->agenda_IdAgenda == null) {
					$ids = $insertaCita;
				}else{
					$ids = $query->agenda_IdAgenda.','.$insertaCita;
				}

				$this->db->set('conteoDetalleVentas', $total);
				$this->db->set('agenda_IdAgenda', $ids);
				$this->db->where('IdVentasPromociones',$_POST['idDetalleVentas']);
				$this->db->update('ventas_has_promociones');
			}
			
			$estado="";
			$nombreEstado="";
			switch($_POST['isEstatus'])	{
				case '1': //CONFIRMADA
					$estado='#5F04B4';
					$nombreEstado="CONFIRMADA";
				break;
				case '2': //PENDIENTE POR CONFIRMAR
					$estado='#6b6b6f';
					$nombreEstado="PENDIENTE";
				break;
				case '3': //CANCELADA
					$estado='#FF0000';
					$nombreEstado="CANCELADA";
				break;                  
				case '4': //REAGENDADA
					$estado='#DF01A5';
					$nombreEstado="REAGENDADA";
				break;
				case '5'://ABIERTO
					$estado='#00FFFF';
					$nombreEstado="ABIERTO";
				break;
				case '6': //REALIZADA
					$estado='#04B404';
					$nombreEstado="REALIZADO";
				break;
				case '7': //TOMADO POR SISTEMA
					$estado='#F7FE2E';
					$nombreEstado="TOMADO POR SISTEMA";
					break;
				case '8': //ONLINE
					$estado='#FF8000';
					$nombreEstado="ONLINE";
					break;
			}
			
			$inicio=date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'];
			$cita[0] = array(
				'id' => (string)$insertaCita, 
				'resourceId' => $_POST['idCabina'], 
				'start' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
				'end' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$fin[1], 
				'title' => $_POST['nombreSer'], 
				'scolor' => $estado, 
				'description' => 'Inicio: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$_POST['horaInicio']))."\n".'Fin: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$fin[1]))."\n".
				'Cliente: '.$_POST['nombreCliente']."\n".'Servicio: '.$_POST['nombreSer'],
			);
			$cita[1] = array(
				'id' => (string)$insertaCita, 
				'resourceId' => $_POST['idUsuario'], 
				'start' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
				'end' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$fin[1], 
				'title' => $_POST['nombreSer'], 
				'scolor' => $estado, 
				'description' => 'Inicio: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$_POST['horaInicio']))."\n".'Fin: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$fin[1]))."\n".
				'Cliente: '.$_POST['nombreCliente']."\n".'Servicio: '.$_POST['nombreSer'],
				'color'=> $this->agendaF_model->buscarColorCabina($_POST['idCabina']), 
			);
		
			if(((int)$_POST['numeroSesiones']-1) !=0 ){
				$cita[2]=array(
					'idCita'=>$insertaCita,
					'idEstados'=>$_POST['isEstatus'],
					'idCabina'=>$_POST['idCabina'],
					'numeroSesion'=>(int)$_POST['numeroSesion']+1,
					'idUsuario'=>$_POST['idUsuario'],
					'nombreCliente'=>$_POST['nombreCliente'],
					'nombreServicio'=>$_POST['nombreSer'],
					'duracion'=>$_POST['duracion'],
				);
			}
			//$this->enviarCorreo($insertaCita,$_POST['idServicio'], $_POST['idPromo'],$_POST['nombreSer'],$_POST['idCliente'],$_POST['nombreCliente'],$_POST['isEstatus'],$_POST['idCabina'],$_POST['numeroSesion'],$_POST['fecha'],$_POST['horaInicio'],$fin[1],$_POST['observaciones'],$_POST['idUsuario'], $_POST['duracion'],'nuevaCita');
		}

		echo json_encode($cita);
	}

	public function agendarSigCita(){
		$e=$this->session->userdata('IdFranquicia');
 		$this->db->select('*');
		$this->db->from('franquicias');
		$this->db->where('IdFranquicias', $e);
		$query = $this->db->get();

		$cita = $this->agendaF_model->obtenerDatos($_POST['idCita']);
		$param['primer']=$cita;
		foreach($cita as $fila){
			$agenda_IdAgenda = $fila->agenda_IdAgenda;
		}

		$param['var']=$agenda_IdAgenda;

		$this->db->select('*');
		$this->db->from('agenda');
		$this->db->where('agenda_IdAgenda', $agenda_IdAgenda);
		$this->db->order_by('IdAgenda', 'DESC');
		$this->db->limit(1);
		$query2 = $this->db->get()->row();

		$IdAgenda=$query2->IdAgenda;

		$cita = $this->agendaF_model->obtenerDatos($IdAgenda);
		foreach($cita as $fila){
			$idCliente = $fila->Clientes_IdClientes;
			$nombreCliente=$fila->NombreCliente;
			$idServicio = $fila->ServiciosFranquicias_IdServiciosFranquicias;
			$idPromo = $fila->Promociones_IdPromociones;
			$nombreSer = $fila->SP_Agendado;
			$duracion= $fila->DuracionCita;
			$numeroSesiones = $fila->NumeroSesionesCitas;
			$sesionActual= $fila->SesionActual;
			$sesionesFaltantes=$fila->SesionesFaltantesCitas;
			$sesionesFaltantesAgendar=$fila->SesionesFaltantesAgendar;
			$idUsuario = $fila->Usuarios_IdUsuarios;
			$ventas_IdDetalleVenta = $fila->ventas_IdDetalleVenta;
			$agenda_IdAgendaF = $fila->agenda_IdAgenda;
		}
		
		$fechaCompleta = date("Y-m-d", strtotime($_POST['fecha'])).' '.$_POST['horaInicio'];
		$tiempo = array();
		$tiempo = explode( ' ', $duracion); 

		switch ($tiempo[1]) {
			case 'min':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." minute"));
				$fin = explode( ' ', $Fecha1);
				break;
			case 'hrs':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." hour"));
				$fin = explode( ' ', $Fecha1);
				break;							
			default:
				# code...
				break;
		}

		$cita = [];
		$camposCita=array(
			'Franquicias_IdFranquicias' => $e, 
			'Clientes_IdClientes' => $idCliente,
			'Categoria_IdCategoria'=> '7',
			'ServiciosFranquicias_IdServiciosFranquicias' => $idServicio,
			'Promociones_IdPromociones' => $idPromo,
			'SP_Agendado' => $nombreSer,
			'Fecha' => date("Y-m-d",strtotime($_POST['fecha'])),
			'HoraInicio' => $_POST['horaInicio'],
			'HoraFin' => $fin[1],
			'DuracionCita' => $duracion,
			'Cabina_IdCabina'=>$_POST['idCabina'],
			'estatuscitas_IdEstatusCita' => $_POST['idEstado'],
			'Observaciones' => $_POST['observaciones'],
			'NumeroSesionesCitas' => $numeroSesiones,
			'SesionActual' => (int)$sesionActual+1,
			'SesionesFaltantesAgendar'=>($sesionesFaltantesAgendar-1),
			'Usuarios_IdUsuarios'=>$idUsuario,
			'ventas_IdDetalleVenta'=>$ventas_IdDetalleVenta,
			'agenda_IdAgenda'=>$agenda_IdAgendaF
		);

		$campos=array(
			'SesionesFaltantesAgendar'=>($sesionesFaltantesAgendar-1),
		);

		$insertaCita=$this->agendaF_model->guardarCita($camposCita);
		
		if ($_POST['idEstado']==6) {
			$sesiones=array(
				'SesionesFaltantesCitas' => (int)$sesionesFaltantes-1,
			);
		} else {
			$sesiones=array(
				'SesionesFaltantesCitas' => (int)$sesionesFaltantes,
			);
		}

		$this->agendaF_model->actSesion($sesiones, $insertaCita);
		$this->db->where('agenda_IdAgenda', $agenda_IdAgendaF);
        $this->db->update('agenda',$campos);
         /*if ($this->db->affected_rows() > 0) {
            return 1;
         }else{
            return 0;
         }*/

		//$param['update']=$update;
		/*$param['sesiones']=$sesiones;
		$param['insertaCita']=$insertaCita;
		$param['campos']=$campos;
		$param['agenda_IdAgendaF']=$agenda_IdAgendaF;

		echo json_encode($param);
		exit();*/

		$cita = [];
		if($insertaCita != FALSE){
			$estado="";
			$nombreEstado="";
			switch($_POST['idEstado'])	{
				case '1': //CONFIRMADA
					$estado='#5F04B4';
					$nombreEstado="CONFIRMADA";
				break;
				case '2': //PENDIENTE POR CONFIRMAR
					$estado='#6b6b6f';
					$nombreEstado="PENDIENTE";
				break;
				case '3': //CANCELADA
					$estado='#FF0000';
					$nombreEstado="CANCELADA";
				break;                  
				case '4': //REAGENDADA
					$estado='#DF01A5';
					$nombreEstado="REAGENDADA";
				break;
				case '5'://ABIERTO
					$estado='#00FFFF';
					$nombreEstado="ABIERTO";
				break;
				case '6': //REALIZADA
					$estado='#04B404';
					$nombreEstado="REALIZADO";
				break;
				case '7': //TOMADO POR SISTEMA
					$estado='#F7FE2E';
					$nombreEstado="TOMADO POR SISTEMA";
					break;
				case '8': //ONLINE
					$estado='#FF8000';
					$nombreEstado="ONLINE";
					break;
			}
			
			$inicio=date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'];
			$cita[0] = array(
				'id' => (string)$insertaCita, 
				'resourceId' => $_POST['idCabina'], 
				'start' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
				'end' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$fin[1], 
				'title' => $nombreSer, 
				'scolor' => $estado, 
				'description' => 'Inicio: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$_POST['horaInicio']))."\n".'Fin: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$fin[1]))."\n".
				'Cliente: '.$nombreCliente."\n".'Servicio: '.$nombreSer,
			);
			$cita[1] = array(
				'id' => (string)$insertaCita, 
				'resourceId' => $idUsuario, 
				'start' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
				'end' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$fin[1], 
				'title' => $nombreSer, 
				'scolor' => $estado, 
				'description' => 'Inicio: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$_POST['horaInicio']))."\n".'Fin: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].' '.$fin[1]))."\n".
				'Cliente: '.$nombreCliente."\n".'Servicio: '.$nombreSer,
				'color'=> $this->agendaF_model->buscarColorCabina($_POST['idCabina']), 
			);
			
			$sesionActual=(int)$sesionActual+1;
			if(((int)$sesionesFaltantesAgendar-1) !=0 ){
				$cita[2]=array(
					'idCita'=>$insertaCita,
					'idEstados'=>$_POST['idEstado'],
					'idCabina'=>$_POST['idCabina'],
					'numeroSesion'=>(int)$sesionActual+1,
					'idUsuario'=>$idUsuario,
					'nombreCliente'=>$nombreCliente,
					'nombreServicio'=>$nombreSer,
				);
			}
			//$this->enviarCorreo($insertaCita,$idServicio, $idPromo,$nombreSer,$idCliente,$nombreCliente,$isEstatus,$idCabina,$numeroSesion,$fecha,$horaInicio,$fin[1],$observaciones,$idUsuario, $duracion,'nuevaCita');
		}

		echo json_encode($cita);
	}

	// --------------Guardar--------------
	/*public function guardarCita(){
		$i=getIdEstablecimiento();
		if($_POST['idCliente']=="" && $_POST['nombreCliente']!=""){
			$idCliente=$this->Agenda_model->guardarCliente($_POST['nombreCliente']);
		}else{
			$idCliente=$_POST['idCliente'];
		}
		$cita = [];
		$camposCita=array(
			'establecimientos_idEstablecimientos' => $i, 
			'servicios_idServicios' => $_POST['idServicio'],
			'servicios_nombreServicios' => $this->Agenda_model->buscarNombreServicio($_POST['idServicio']),
			'detalleventas_idDetalleVentas'=>$_POST['idDetalleVentas'],
			'clientes_idClientes' => $idCliente,
			'clientes_nombreClientes' => $this->Agenda_model->buscarNombreCliente($idCliente),
			'numeroSesionesCitas' => $_POST['numeroSesiones'],
			'sesionesFaltantesCitas' => (int)$_POST['numeroSesiones'],
			'sesionesFaltantesAgendar' => ((int)$_POST['numeroSesiones']-1),
		);
		$insertaCita=$this->Agenda_model->guardarCita($camposCita);
		
		if($insertaCita != FALSE){
			$camposDetalle=array(
				'citas_idCitas' =>$insertaCita , 
				'estadoscitas_idEstadosCitas' => $_POST['idEstados'], 
				'areastrabajo_idAreasTrabajo' => $_POST['idAreas'], 
				'areastrabajo_nombreAreasTrabajo' => $this->Agenda_model->buscarNombreAreas($_POST['idAreas']), 
				'numeroSesionDetalleCitas' => $_POST['numeroSesion'], 
				'fechaDetalleCitas' => date("Y-m-d",strtotime($_POST['fecha'])), 
				'duracionDetalleCitas' => '', 
				'horaInicioDetalleCitas' => $_POST['horaInicio'], 
				'horaFinDetalleCitas' => $_POST['horaFina'], 
				'comentarioDetalleCitas' => $_POST['comentario'],
				'usuarios_idUsuarios' => $_POST['idUsuario'], 
				'usuarios_nombreUsuarios' =>  getNombreUs($_POST['idUsuario']), 
				'usuarios_idUsuariosLog' => $this->session->userdata('idUsuarios'),
				'usuarios_nombreUsuariosLog' => getNombreUsuario(),
			);
			$insertaDetalle=$this->Agenda_model->guardarDetalleCita($camposDetalle);

			if($insertaDetalle!=FALSE)
			{ 
					$estado="";
					switch($_POST['idEstados'])
					{
					case '1':
						$estado='#00FFFF';
						break;
					case '2':
						$estado='#6b6b6f';
						break;
					case '3':
						$estado='#FF8000';
						break;
					case '4':
						$estado='#DF01A5';
						break;
					case '5':
						$estado='#F7FE2E';
						break;
					case '6':
						$estado='#FF0000';
						break;
					case '7':
						$estado='#5F04B4';
						break;
					case '8':
						$estado='#04B404';
						break;
					}
					$inicio=date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'];
				$cita[0] = array(
					'id' => (string)$insertaDetalle, 
					'resourceId' => $_POST['idAreas'], 
					'start' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
					'end' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaFina'], 
					'title' => $this->Agenda_model->buscarNombreServicio($_POST['idServicio']), 
					'scolor' => $estado, 
					'description' => 'Inicio: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].''.$_POST['horaInicio']))."\n".'Fin: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].''.$_POST['horaFina']))."\n".
					'Cliente: '.$this->Agenda_model->buscarNombreCliente($idCliente)."\n".'Servicio: '.$this->Agenda_model->buscarNombreServicio($_POST['idServicio']),
				);
				$cita[1] = array(
					'id' => (string)$insertaDetalle, 
					'resourceId' => $_POST['idUsuario'], 
					'start' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
					'end' => date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaFina'], 
					'title' => $this->Agenda_model->buscarNombreServicio($_POST['idServicio']), 
					'scolor' => $estado, 
					'description' => 'Inicio: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].''.$_POST['horaInicio']))."\n".'Fin: '.date("d-m-Y g:i A",strtotime($_POST['fecha'].''.$_POST['horaFina']))."\n".
					'Cliente: '.$this->Agenda_model->buscarNombreCliente($idCliente)."\n".'Servicio: '.$this->Agenda_model->buscarNombreServicio($_POST['idServicio']),
					'color'=> $this->Agenda_model->buscarColorArea($_POST['idAreas']), 
				);
				if(((int)$_POST['numeroSesiones']-1) !=0 ){
					$cita[2]=array(
						'idCita'=>$insertaCita,
						'idEstados'=>$_POST['idEstados'],
						'idAreas'=>$_POST['idAreas'],
						'numeroSesion'=>(int)$_POST['numeroSesion']+1,
						'idUsuario'=>$_POST['idUsuario'],
						'nombreCliente'=>$this->Agenda_model->buscarNombreCliente($idCliente),
						'nombreServicio'=>$this->Agenda_model->buscarNombreServicio($_POST['idServicio']),
					);
				}

				$this->enviarCorreo($insertaCita, $idCliente, $this->Agenda_model->buscarNombreServicio($_POST['idServicio']), date("Y-m-d",strtotime($_POST['fecha'])), $_POST['horaInicio'], $_POST['horaFina'],getNombreUs($_POST['idUsuario']), $this->Agenda_model->buscarNombreAreas($_POST['idAreas']), $_POST['numeroSesion'], $_POST['idEstados'], 'nuevaCita');
			}
		}
		echo json_encode($cita);
	}*/

	public function obtenerDatos(){
		$id=$_GET['id'];
		$result = $this->agendaF_model->obtenerDatos($id);
		
		$datosCitas=[];
		foreach($result as $fila){
			$idServicioAg = $fila->ServiciosFranquicias_IdServiciosFranquicias;
			if ($idServicioAg=="" || $idServicioAg==null) {
				$idServicioAg = $fila->Promociones_IdPromociones.'PA';
			}else{
				$idServicioAg = $idServicioAg.'SA';
			}

			$datosCitas=array(
				'IdAgenda'=> $fila->IdAgenda,
				'idCliente'=> $fila->Clientes_IdClientes,
				'nombreCliente'=> $fila->NombreCliente,
				//'datosCliente'=> $this->Agenda_model->obtenerDatosCliente($fila->clientes_idClientes),
				'idServicio'=> $idServicioAg,
				'nombreServicio'=> $fila->SP_Agendado,
				'sesiones'=> $fila->NumeroSesionesCitas,
				'numeroSesion'=> $fila->SesionActual,
				'fecha'=> $fila->Fecha,
				'horaInicio'=> $fila->HoraInicio,
				'horaFin'=> $fila->HoraFin,
				'duracion'=>$fila->DuracionCita,
				'idPersonal'=> $fila->Usuarios_IdUsuarios,
				'nombrePersonal'=> $fila->NombreUsuario,
				'idCabina'=> $fila->Cabina_IdCabina,
				'idEstado'=> $fila->estatuscitas_IdEstatusCita,
				'Observaciones'=>$fila->Observaciones,
				'sesionesFaltantesCitas'=>$fila->SesionesFaltantesCitas,
				'sesionesFaltantesAgendar'=>$fila->SesionesFaltantesAgendar,
			);
		}
		echo json_encode($datosCitas);
	}
	/*public function getEventos(){
		$filtro = $this->input->post('codecabina');
		$datosProcesados=[];
		$r = $this->agendaF_model->getEventos($filtro);
		$coloresCabina= array(
		            "FACIAL"  =>  '#37579D',
		            "FACIAL 2"  =>  '#D8907C',
		            "CORPORAL"  =>  '#C0473E',
		            "CORPORAL 2"  =>  '#BE304A',
		            "RELAJ/MASAJ"  =>  '#47A3A0',
		            "CAVITACION"  =>  '#DFA130',
		            "IPL/E-LIGHT"  =>  '#76B9E5',
		            "PESTAÑAS"  =>  '#1E7999',
		            "SAUNA"  =>  '#EAC595',
		            "SAUNA 2" =>  '#4C418E',
		            "ADICIONAL" =>  '#902456',
		            "CAPSULA INFRAROJA" =>  '#BD2367',
		            "UÑAS 1" =>  '#A71929',
		            "UÑAS 2" =>  '#7890C4',
		            "UÑAS 3" =>  '#9DAB2D',
		        );
		
		foreach ($r as $item) 
		{ 

				$tratamiento=$this->agendaF_model->nombreTratamiento($item->servicio, $item->promociones);
		        $datosProcesados[] = array(
		            "start"      =>  $item->start."T". $item->hoi,
		            "end"        =>  $item->start."T". $item->hof,
		            "id"         =>  $item->id,
		            "title" 	 =>  $item->clientes,
					"cabina"     =>  $item->cabina,
					"idCliente"   =>  $item->idC,
		            "clientes"   =>  $item->clientes,
		            "categoria"  =>  $item->categoria,
		            "promociones"=>  $item->promociones,
		            "servicio"   =>  $item->servicio,
		            "hoi"      =>  $item->hoi,
		            "hof"      =>  $item->hof,
		            "est"      =>  $item->est,
		            "obs"      =>  $item->obs,
		            "usu"      =>  $item->usu,
		            "fecha"    =>  $item->fecha,
					"nombreCabina"    =>  $item->NombreCabina,
					"descripcion"  =>  $tratamiento."\r\n".$item->clientes."\r\n".$item->Celular,
		            "color"    =>  $coloresCabina[(String)$item->NombreCabina]

		        );
		}


		echo json_encode($datosProcesados);
		/*echo json_encode($r);
	}*/

	public function getEventos(){
		$filtro = $this->input->post('codecabina');
		$idClient = $this->input->post('idClient');
		$datosProcesados=[]; 
		$r = $this->agendaF_model->getEventos($filtro, $idClient);
		
		echo json_encode($r);
		/*echo json_encode($r);*/
	}

	public function getEventos1(){
		$r = $this->agendaF_model->getEventos();
		echo json_encode($r);
	}

	// public function updEvento(){
	// 	$param['IdAgenda'] = $this->input->post('IdAgenda');
	// 	$param['Fecha'] = $this->input->post('Fecha');
	// 	//$param['fecfin'] = $this->input->post('fecfin');

	// 	$r = $this->agendaF_model->updEvento($param);

	// 	echo $r;
	// }

	public function deleteEvento(){

		$id = $this->input->post('id');
		$r = $this->agendaF_model->deleteEvento($id);
		echo $r;
	}

	public function enviaDatos(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//||			$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$result = $this->agendaF_model->BuscaCliente($id);
		if(count($result)>0){
				foreach ($result as $row){
				$IdClientes = $row->IdClientes;
				$NombreCliente=$row->NombreCliente;
				} 
					$datos = array(
						'IdClientes' => $IdClientes,
						'NombreCliente' => $NombreCliente,
					);
				}
				else{}
				
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$datos['ReCabina']=$this->agendaF_model->BuscarCabina();
	    $datos['ReFranquicia']=$this->agendaF_model->BuscarFranquicia();
	    $datos['ReUsuario']=$this->agendaF_model->BuscarUsuario();
	    $datos['ReCategoria']=$this->agendaF_model->BuscarCategoria();
		// // $datos['ReCliente']=$this->agendaF_model->BuscarCliente();
		// $datos['ReServicios']=$this->agendaF_model->BuscarServicios();
		// $datos['RePromocionesInstitucionales']=$this->agendaF_model->BuscarPromocionesinstitucionales();
		// $datos['RePromocionesLocales']=$this->agendaF_model->BuscarPromocionesLocales();
		 $datos['ReEstatusCita']=$this->agendaF_model->BuscarEstatusCita();
		$this->load->view('myagenda/franquiciatario/agregarcitaF_view', $datos);
		$this->load->view('layout/footer');
	 }

	}

	public function agregar(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//||$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {	
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$datos['ReCabina']=$this->agendaF_model->BuscarCabina();
			$datos['ReFranquicia']=$this->agendaF_model->BuscarFranquicia();
			$datos['ReUsuario']=$this->agendaF_model->BuscarUsuario();
			$datos['ReCategoria']=$this->agendaF_model->BuscarCategoria();
			// // $datos['ReCliente']=$this->agendaF_model->BuscarCliente();
			// $datos['ReServicios']=$this->agendaF_model->BuscarServicios();
			// $datos['RePromocionesInstitucionales']=$this->agendaF_model->BuscarPromocionesinstitucionales();
			// $datos['RePromocionesLocales']=$this->agendaF_model->BuscarPromocionesLocales();
			$datos['ReEstatusCita']=$this->agendaF_model->BuscarEstatusCita();
			$this->load->view('myagenda/franquiciatario/agregarcitaF_view', $datos);
			$this->load->view('layout/footer');	
		}
	}
 	
	//Esta funcion se uiliza para la vista agenda agregarCita_view
	public function guardar(){

		if(isset($_POST['txt_observaciones']))	{
			$observaciones=$this->input->post('txt_observaciones');
		}else{
			$observaciones="";
		}
		
		$data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$parametro['Clientes_IdClientes']= $this->input->post('idcliente');
		$parametro['Categoria_IdCategoria']= '7';
		$parametro['ServiciosFranquicias_IdServiciosFranquicias']= $this->input->post('idservi');
		//$parametro['ServiciosFranquicias_IdServiciosFranquicias']= $this->input->post('idserviGM');
		$parametro['Promociones_IdPromociones']= $this->input->post('idpromo');
	   // $parametro['Promociones_IdPromociones']= $this->input->post('idpromoInst');
		$parametro['Fecha']= $this->input->post('txtfecha');
		$parametro['HoraInicio']= $this->input->post('txthorai');
		$parametro['HoraFin']= $this->input->post('txthoraf');
		$parametro['Cabina_IdCabina']= $this->input->post('txt_cabina');
		$parametro['estatuscitas_IdEstatusCita']= $this->input->post('txtstatus');
		$parametro['Observaciones']=$observaciones; 
		$parametro['Franquicias_IdFranquicias']= $i;
		$parametro['Usuarios_IdUsuarios']= $this->input->post('txtusuario');

		$this->agendaF_model->guardar($parametro);

		redirect('myagenda/franquiciatario/listacitasF', 'refresh');
	}

	public function nuevaCita(){	
		$data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
			$parametro['Clientes_IdClientes']= $_POST['cliente'];
			$parametro['Categoria_IdCategoria']= '7';
			$parametro['ServiciosFranquicias_IdServiciosFranquicias']=$_POST['servicio'];
			//$parametro['ServiciosFranquicias_IdServiciosFranquicias']= $this->input->post('idserviGM');
			$parametro['Promociones_IdPromociones']= $_POST['promocion'];
			// $parametro['Promociones_IdPromociones']= $this->input->post('idpromoInst');
			$parametro['Fecha']=$_POST['fecha'];
			$parametro['HoraInicio']= date("H:i:s", strtotime($_POST['inicio']));
			$parametro['HoraFin']= date("H:i:s", strtotime($_POST['fin']));
			$parametro['Cabina_IdCabina']= $_POST['cabina'];
			$parametro['estatuscitas_IdEstatusCita']= $_POST['status'];
			$parametro['Observaciones']=$_POST['observaciones'];
			$parametro['Franquicias_IdFranquicias']= $i;
			$parametro['Usuarios_IdUsuarios']= $_POST['cosmetologo'];
		
		$datos=$this->agendaF_model->nuevaCita($parametro);
		
		if($datos==TRUE) {
			$this->getEventos();
		}
	}

	public function updEvento2(){
		$data['idCabina'] =  $this->input->post('idCabinaA');
		$data['nombreCliente'] =  $this->input->post('nombreClienteA');
		// $data['idCategoria'] =  $this->input->post('idCategoriaA');
		$data['codePromo'] =  $this->input->post('codePromoA');
		$data['codeService'] =  $this->input->post('codeServiceA');
		$data['fechaAgendada'] =  $this->input->post('fechaAgendadaA');
		$data['horaInicio'] =  $this->input->post('hourStart');
		$data['horaFin'] =  $this->input->post('hourEnd');
		$data['estado'] =  $this->input->post('status') ;
		$data['descripcion'] =  $this->input->post('script');
		$data['idUserChange'] =  $this->input->post('user');
		$data['idEvento'] =  $this->input->post('idEventoA');


		$request = $this->agendaF_model->updEvento2($data);
		echo json_encode($request);
	}

	public function buscarporfranquicia (){ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//||$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {
			$this->db->select('*');
			$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
			$data = array();
			$query = $this->input->get('query', TRUE);
			if ($query) {
				$result = $this->agendaF_model->buscarporfranquicia(trim($query));
				if ($result != FALSE){
					$data = array(
						'result' => $result,
					);
				}else{
					$data = array('result' => '');
				}	
			}else{
				$data = array('result' => '');
			}

			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$data['ReFranq']=$this->agendaF_model->BuscarFranq();
			$this->load->view('myagenda/franquiciatario/buscarAgendaF_view', $data);
			$this->load->view('layout/footer');
		}
	}

	public function citasCanceladas(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//||		$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {
			//  $data['Franquicias']=$this->agendaF_model->BuscarFranquicia();
				// foreach ($data['Franquicias'] as $i => $Franquicias) 
				// $this->db->select('*');
				// //$this->db->from('agenda');
				// $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
				// $this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
				// $this->db->join('cabina','Cabina_IdCabina = IdCabina','inner');
				// $this->db->join('clientes','Clientes_IdClientes = IdClientes','inner');
				// $this->db->where('IdFranquicias',$i);
				// $this->db->where('estatuscitas_IdEstatusCita = 3');
				// $data['consulta']=$this->db->get('agenda')->result();
				// $data['consulta2']=$this->agendaF_model->BuscarServiciosFranquicias();
				// $data['consulta3']=$this->agendaF_model->BuscarServiciosGeneral();
			// $data['consulta4']=$this->agendaF_model->Buscarpromos();
			$data['ReCabina']=$this->agendaF_model->BuscarCabina(); 
			$data['ReEstatusCita']=$this->agendaF_model->BuscarEstatusCita();
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('myagenda/franquiciatario/citasCanceladasF_view', $data);
			$this->load->view('layout/footer');
		}
	}

	public function buscarCitas(){
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'){//||$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {
			$inicio=date("Y-m-d", strtotime($_POST['finicio']));
			$fin=date("Y-m-d", strtotime($_POST['ffin']));
			$cabina=$_POST['cabina'];
			$status=$_POST['status'];

			$citas=$this->agendaF_model->buscarCitas($inicio, $fin, $cabina, $status);
		}
	}

	//Editar cita y sus respectivas validaciones
	public function editarCita(){	
		$id=$this->input->post('idDetalle');
		//$idCita=$this->Agenda_model->buscarCita($id)[0];
		//$idEstadoC = $this->input->post('idEstados');
		$fechaActual = $this->input->post('fechaActual');
		$idServ = $this->input->post('idServicio');
		$idPromo = $this->input->post('idPromo');
	
		// echo json_encode($idServicioEdit['idServicios']);
		$nombreServicio = $this->input->post('nombreSer');
		$idCliente = $this->input->post('idCliente');
		$nombreCliente = $this->input->post('nombreCliente');
		$numeroSesiones = $this->input->post('numeroSesiones');
		$idEstados = $this->input->post('idEstados');
		$idCabina = $this->input->post('idCabina');
		$numeroSesion = $this->input->post('numeroSesion');
		$fecha = date("Y-m-d",strtotime($this->input->post('fecha')));
		$horaInicio = $this->input->post('horaInicio');
		$horaFina = $this->input->post('horaFina');
		$duracion = $this->input->post('duracion');
		$observaciones = $this->input->post('observaciones');
		$idUsuario = $this->input->post('idUsuario');
		$nombreUsuario = $this->input->post('nombreUsuario');
		////////////////////////////////////
	
		//periodo para cancelar cita
		$periodo = $this->agendaF_model->periodoCancelacion();
		$valor = explode( '*', $periodo->CancelarCita);
	
		//Hora y fecha de la cita
		$cita = $this->agendaF_model->obtenerDatos($id);
		foreach($cita as $fila){
			$fechaCita = $fila->Fecha;
			$inicio = $fila->HoraInicio;
			$fin = $fila->HoraFin;
			$sesionesFaltantes=$fila->SesionesFaltantesCitas;
			$sesionesFaltantesAgendar=$fila->SesionesFaltantesAgendar;
			$agenda_IdAgenda=$fila->agenda_IdAgenda;
		}
		
		$idCita = $id;
	
		$personal = $idUsuario; 
		$Fecha1 = $this->nuevaFecha($fechaActual, $valor);
		$sesionesFaltantes = ($sesionesFaltantes - 1);
		//reagendar
		if ($idEstados == 4) {
			$reagendarF = $fecha;
			$reagendarH = $horaInicio; 
			$personal = $idUsuario; 
			if ($fechaCita==$fecha && $inicio==$horaInicio) {
				echo json_encode("error0");
			}else{
				if ($fechaActual <= $fechaCita.' '.$inicio) {
					$Fecha1 = $this->nuevaFecha($fechaActual, $valor);
					$result = $this->reagendar($fechaActual, $valor, $fechaCita, $inicio, $id, $reagendarF, $reagendarH, $personal, $Fecha1, $idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente, $numeroSesiones,$idEstados,$idCabina,$numeroSesion,$sesionesFaltantes,$fecha,$horaInicio,$horaFina,$observaciones,$idUsuario,$duracion);
					
					if ($result != 0){
						echo json_encode($result);
					}else if ($result == 0 || $result == 'error2') {
						# code.
						echo json_encode($result);
					}else{
						echo json_encode($result);
					}
				}else{
					echo json_encode("error1");
				}
			}
			exit();				
		}else if ($idEstados == 3) {
			# cancelada
			$personal = $idUsuario; 
			$Fecha1 = $this->nuevaFecha($fechaActual, $valor);
			$sesionesFaltantes = ($sesionesFaltantes - 1);
	
			$response = $this->cancelar($id, $agenda_IdAgenda, $idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$numeroSesiones,$idEstados,$idCabina,$numeroSesion,$sesionesFaltantes,$sesionesFaltantesAgendar,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $Fecha1,$fechaCita, $inicio, $duracion);
			if ($response != 0 ) {
				echo json_encode($response);
			}else if ($response == 0) {
				echo json_encode($response);
			}else{
				echo json_encode($response);
			}		
		}else if ($idEstados == 7) {
			# tomada por sistema
			$personal = $idUsuario; 
			$Fecha1 = $this->nuevaFecha($fechaActual, $valor);
			$sesionesFaltantes = ($sesionesFaltantes - 1);
			$response = $this->cancelar($id,$agenda_IdAgenda,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$numeroSesiones,$idEstados,$idCabina,$numeroSesion,$sesionesFaltantes,$sesionesFaltantesAgendar,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $Fecha1,$fechaCita, $inicio, $duracion);
			if ($response != 0 ) {
				echo json_encode($response);
			}else if ($response == 0) {
				echo json_encode($response);
			}else{
				echo json_encode($response);
			}	
		}else if ($idEstados == 1 || $idEstados == 2 || $idEstados == 5) {
			# code...
			$reagendarF = $fecha;
			$reagendarH = $horaInicio; 
			$personal = $idUsuario;
			if ($fechaActual <= $fechaCita.' '.$inicio) {
				$response=$this->ActualizarCitaAgenda($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $duracion);
			
				if ($response != 0) {
					echo json_encode($response);
				}else{
					echo json_encode($response);
				}		
			}else if($fechaActual > $fechaCita.' '.$inicio){
				# No se puede hacer el cambio
				echo json_encode('error4');
			}
			
			exit();
		}else if ($idEstados == 6) {
			$this->db->set('SesionesFaltantesCitas', $sesionesFaltantes);
			$this->db->where('IdAgenda', $id);
			$this->db->update('agenda');	
			$res=$this->db->affected_rows();

			$response=$this->ActualizarCitaAgenda($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $duracion);
			
			if ($response != 0) {
				echo json_encode($response);
			}else{
				echo json_encode($response);
			}
		}
	}
	
	public function nuevaFecha($fechaActual, $valor){
		switch ($valor[1]) {
			case 'min':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaActual."+".$valor[0]." minute"));
				return $Fecha1;
				break;
			case 'hrs':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaActual."+".$valor[0]." hour"));
				return $Fecha1;
				break;
			case 'd':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaActual."+".$valor[0]." day"));
				return $Fecha1;
				break;
			case 's':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaActual."+".$valor[0]." week"));
				return $Fecha1;
				break;							
			default:
				# code...
				break;
		}
	}
							  //$fechaActual, $valor, $fechaCita, $inicio, $id, $reagendarF, $reagendarH, $personal, $Fecha1
	public function reagendar($fechaActual, $valor, $fechaCita, $inicio, $id, $reagendarF, $reagendarH, $personal, $Fecha1, $idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente, $numeroSesiones,$idEstados,$idCabina,$numeroSesion,$sesionesFaltantes,$fecha,$horaInicio,$horaFina,$observaciones,$idUsuario,$duracion){
		if ($Fecha1 <= $reagendarF.' '.$reagendarH) {
			# Si se puede hacer el cambio	
			$fechaCompleta = date("Y-m-d", strtotime($reagendarF)).' '.$reagendarH;
			$tiempo = array();
			$tiempo = explode( ' ', $duracion); 
			$fin=array();

			switch ($tiempo[1]) {
				case 'min':
					$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." minute"));
					$fin = explode( ' ', $Fecha1);
					break;
				case 'hrs':
					$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." hour"));
					$fin = explode( ' ', $Fecha1);
					break;	
				case 'minutos':
					$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." minute"));
					$fin = explode( ' ', $Fecha1);
					break;
				case 'horas':
					$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." hour"));
					$fin = explode( ' ', $Fecha1);
					break;							
				default:
					# code...
					break;
			}


							
			$data= array(
					'Clientes_IdClientes'=> $idCliente,
					'ServiciosFranquicias_IdServiciosFranquicias'=> $idServ,
					'Promociones_IdPromociones'=> $idPromo,
					'SP_Agendado'=> $nombreServicio,
					'Fecha'=>date("Y-m-d", strtotime($reagendarF)),
					'HoraInicio' => $reagendarH,
					'HoraFin' =>  $fin[1],
					'DuracionCita'=>$duracion,
					'Cabina_IdCabina'=>$idCabina,
					'estatuscitas_IdEstatusCita' => $idEstados,
					'Observaciones'=>$observaciones,
					'SesionActual'=>$numeroSesion,
					'Usuarios_IdUsuarios' => $personal,
				);

			$actualizaCita=$this->agendaF_model->actualizaCita($id, $data);
			
			if($actualizaCita!=0){
				$estado="";
				$nombreEstado="";
				if($idEstados!=7){
					switch($idEstados)	{
						case '1': //CONFIRMADA
							$estado='#5F04B4';
							$nombreEstado="CONFIRMADA";
						break;
						case '2': //PENDIENTE POR CONFIRMAR
							$estado='#6b6b6f';
							$nombreEstado="PENDIENTE";
						break;
						case '3': //CANCELADA
							$estado='#FF0000';
							$nombreEstado="CANCELADA";
						break;                  
						case '4': //REAGENDADA
							$estado='#DF01A5';
							$nombreEstado="REAGENDADA";
						break;
						case '5'://ABIERTO
							$estado='#00FFFF';
							$nombreEstado="ABIERTO";
						break;
						case '6': //REALIZADA
							$estado='#04B404';
							$nombreEstado="REALIZADO";
						break;
						case '7': //TOMADO POR SISTEMA
							$estado='#F7FE2E';
							$nombreEstado="TOMADO POR SISTEMA";
							break;
						case '8': //ONLINE
							$estado='#FF8000';
							$nombreEstado="ONLINE";
							break;
					}
					
					$inicio=$fecha.' '.$horaInicio; 

					$cita[0] = array(
						'id' => $id, 
						'resourceId' => $idCabina, 
						'start' => $fecha.' '.$horaInicio, //date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
						'end' => $fecha.' '.$fin[1], //date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaFina'], 
						'title' => $nombreServicio, //$this->Agenda_model->buscarNombreServicio($_POST['idServicio']), 
						'scolor' => $estado, 
						'description' => 'Inicio: '.$fecha.' '.$horaInicio."\n".'Fin: '.$fecha.' '.$fin[1]."\n".
						'Cliente: '.$nombreCliente."\n".'Servicio: '.$nombreServicio."\n".'Estado: '.$nombreEstado,
					);
					$cita[1] = array(
						'id' => $id, 
						'resourceId' => $personal, 
						'start' => $fecha.' '.$horaInicio, 
						'end' => $fecha.' '.$fin[1], 
						'title' => $nombreServicio, 
						'scolor' => $estado, 
						'description' => 'Inicio: '.$fecha.' '.$horaInicio."\n".'Fin: '.$fecha.' '.$fin[1]."\n".
						'Cliente: '.$nombreCliente."\n".'Servicio: '.$nombreServicio."\n".'Estado: '.$nombreEstado,
						'color'=> $this->agendaF_model->buscarColorCabina($idCabina)
					);
				}else{
					$cita[0] = array();
					$cita[1] = array();
				}
				//$this->enviarCorreo($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$fin[1],$observaciones,$personal, $duracion,'updateCita');
				return $cita;
				//echo json_encode($cita);
			}else{
				return 0;
				//echo json_encode(0);
			}				
		}else if($Fecha1 > $reagendarF.' '.$reagendarH){
			# No se puede hacer el cambio
			return 'error2';
		}
	}
	
	public function cancelar($id, $agenda_IdAgenda, $idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$numeroSesiones,$idEstados,$idCabina,$numeroSesion,$sesionesFaltantes,$sesionesFaltantesAgendar,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $Fecha1,$fechaCita, $inicio, $duracion){
		if ($idEstados == 3) {
			if ($Fecha1 < $fechaCita.' '.$inicio) {
				# Si se puede hacer el cambio					
				$this->db->set('SesionesFaltantesAgendar', ($sesionesFaltantesAgendar+1));
				$this->db->where('agenda_IdAgenda', $agenda_IdAgenda);
				$this->db->update('agenda');	
				$res=$this->db->affected_rows();

				$response=$this->ActualizarCitaAgenda($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $duracion);
				
				if ($response != 0) {
					return $response;
				}else{
					return $response;
				}
			}else if($Fecha1 > $fechaCita.' '.$inicio){
				return 'error3';
			}
		}else if ($idEstados == 7) {
			# code...
			$this->db->set('SesionesFaltantesCitas', $sesionesFaltantes);
			$this->db->where('IdAgenda', $id);
			$this->db->update('agenda');	
			$res=$this->db->affected_rows();
	
			if ($res == 1) {
				$response=$this->ActualizarCitaAgenda($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $duracion);
			}else{
				$response = 0;
			}
			
			if ($response != 0 && $res != 0) {
				return $response;
			}else{
				return $response;
			}
		}
	}
										
	public function ActualizarCitaAgenda($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $duracion){
		$fechaCompleta = date("Y-m-d", strtotime($fecha)).' '.$horaInicio;
		$tiempo = array();
		$tiempo = explode( ' ', $duracion); 
		$fin = array();

		switch ($tiempo[1]) {
			case 'min':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." minute"));
				$fin = explode( ' ', $Fecha1);
				break;
			case 'hrs':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." hour"));
				$fin = explode( ' ', $Fecha1);
				break;
			case 'minutos':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." minute"));
				$fin = explode( ' ', $Fecha1);
				break;
			case 'horas':
				$Fecha1 = date("Y-m-d H:i:s",strtotime($fechaCompleta."+ ".$tiempo[0]." hour"));
				$fin = explode( ' ', $Fecha1);
				break;							
			default:
				# code...
				break;
		}
		
		$data= array(
			'Clientes_IdClientes'=> $idCliente,
			'ServiciosFranquicias_IdServiciosFranquicias'=> $idServ,
			'Promociones_IdPromociones'=> $idPromo,
			'SP_Agendado'=> $nombreServicio,
			'Fecha'=>date("Y-m-d", strtotime($fecha)),
			'HoraInicio' => $horaInicio,
			'HoraFin' =>  $fin[1],
			'DuracionCita'=>$duracion,
			'Cabina_IdCabina'=>$idCabina,
			'estatuscitas_IdEstatusCita' => $idEstados,
			'Observaciones'=>$observaciones,
			'SesionActual'=>$numeroSesion,
			'Usuarios_IdUsuarios' => $personal,
		);

		$actualizaCita=$this->agendaF_model->actualizaCita($id, $data);
		
		if($actualizaCita!=0){
			$estado="";
			$nombreEstado="";
			if($idEstados!=7){
				switch($idEstados)	{
					case '1': //CONFIRMADA
						$estado='#5F04B4';
						$nombreEstado="CONFIRMADA";
					break;
					case '2': //PENDIENTE POR CONFIRMAR
						$estado='#6b6b6f';
						$nombreEstado="PENDIENTE";
					break;
					case '3': //CANCELADA
						$estado='#FF0000';
						$nombreEstado="CANCELADA";
					break;                  
					case '4': //REAGENDADA
						$estado='#DF01A5';
						$nombreEstado="REAGENDADA";
					break;
					case '5'://ABIERTO
						$estado='#00FFFF';
						$nombreEstado="ABIERTO";
					break;
					case '6': //REALIZADA
						$estado='#04B404';
						$nombreEstado="REALIZADO";
					break;
					case '7': //TOMADO POR SISTEMA
						$estado='#F7FE2E';
						$nombreEstado="TOMADO POR SISTEMA";
						break;
					case '8': //ONLINE
						$estado='#FF8000';
						$nombreEstado="ONLINE";
						break;
				}
				
				$inicio=$fecha.' '.$horaInicio; 

				$cita[0] = array(
					'id' => $id, 
					'resourceId' => $idCabina, 
					'start' => $fecha.' '.$horaInicio, //date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaInicio'], 
					'end' => $fecha.' '.$fin[1], //date("Y-m-d",strtotime($_POST['fecha'])).' '.$_POST['horaFina'], 
					'title' => $nombreServicio, //$this->Agenda_model->buscarNombreServicio($_POST['idServicio']), 
					'scolor' => $estado, 
					'description' => 'Inicio: '.$fecha.' '.$horaInicio."\n".'Fin: '.$fecha.' '.$fin[1]."\n".
					'Cliente: '.$nombreCliente."\n".'Servicio: '.$nombreServicio,
				);
				$cita[1] = array(
					'id' => $id, 
					'resourceId' => $personal, 
					'start' => $fecha.' '.$horaInicio, 
					'end' => $fecha.' '.$fin[1], 
					'title' => $nombreServicio, 
					'scolor' => $estado, 
					'description' => 'Inicio: '.$fecha.' '.$horaInicio."\n".'Fin: '.$fecha.' '.$fin[1]."\n".
					'Cliente: '.$nombreCliente."\n".'Servicio: '.$nombreServicio,
					'color'=> $this->agendaF_model->buscarColorCabina($idCabina)
				);
			}else{
				$cita[0] = array();
				$cita[1] = array();
			}
			//$this->enviarCorreo($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$fin[1],$observaciones,$personal, $duracion,'updateCita');
			return $cita;
			//echo json_encode($cita);
		}else{
			return 0;
			//echo json_encode(0);
		}	
	}

	public function estadoCancelarTS($estado){
		$id=$this->input->post('idDetalle');
		$idServ = $this->input->post('idServicio');
		$idPromo = $this->input->post('idPromo');
		$nombreServicio = $this->input->post('nombreSer');
		$idCliente = $this->input->post('idCliente');
		$nombreCliente = $this->input->post('nombreCliente');
		$numeroSesiones = $this->input->post('numeroSesiones');
		$idEstados = $estado;//$this->input->post('idEstados');
		$idCabina = $this->input->post('idCabina');
		$numeroSesion = $this->input->post('numeroSesion');
		$fecha = date("Y-m-d",strtotime($this->input->post('fecha')));
		$horaInicio = $this->input->post('horaInicio');
		$horaFina = $this->input->post('horaFina');
		$duracion = $this->input->post('duracion');
		$observaciones = $this->input->post('observaciones');
		$idUsuario = $this->input->post('idUsuario');
		$nombreUsuario = $this->input->post('nombreUsuario');
			
		$cita = $this->agendaF_model->obtenerDatos($id);
		foreach($cita as $fila){
			$fechaCita = $fila->Fecha;
			$inicio = $fila->HoraInicio;
			$fin = $fila->HoraFin;
			$sesionesFaltantes=$fila->SesionesFaltantesCitas;
			$sesionesFaltantesAgendar=$fila->SesionesFaltantesAgendar;
			$agenda_IdAgenda=$fila->agenda_IdAgenda;
		}

		if ($idEstados == 3) {
			# Si se puede hacer el cambio					
			$this->db->set('SesionesFaltantesAgendar', ($sesionesFaltantesAgendar+1));
			$this->db->where('agenda_IdAgenda', $agenda_IdAgenda);
			$this->db->update('agenda');	
			$res=$this->db->affected_rows();

			$response=$this->ActualizarCitaAgenda($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$idUsuario, $duracion);
			
			if ($response != 0) {
				echo json_encode(1);//$response);
			}else{
				echo json_encode($response);
			}			
		}else if ($idEstados == 7) {
			# code...
			$this->db->set('SesionesFaltantesCitas', ($sesionesFaltantes-1));
			$this->db->where('IdAgenda', $id);
			$this->db->update('agenda');	
			$res=$this->db->affected_rows();
	
			if ($res == 1) {
				$response=$this->ActualizarCitaAgenda($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$idUsuario, $duracion);
			}else{
				$response = 0;
			}
			
			if ($response != 0 && $res != 0) {
				echo json_encode(1);//$response);
			}else{
				echo json_encode($response);
			}
		}
	}

	public function enviarCorreo($id,$idServ, $idPromo,$nombreServicio,$idCliente,$nombreCliente,$idEstados,$idCabina,$numeroSesion,$fecha,$horaInicio,$horaFina,$observaciones,$personal, $duracion, $tipo){
		$e=$this->session->userdata('IdFranquicia');
		$this->db->select('*');
		$this->db->from('franquicias');
		$this->db->where('IdFranquicias', $e);
		$query = $this->db->get();
		
		$this->db->select('*');
		$this->db->from('clientes');
		$this->db->where('IdClientes', $idCliente);
		$queryClient = $this->db->get();

			/*$this->db->select('*');
			$this->db->from('estatuscitas');
			$this->db->where('IdEstatusCita', $idEstados);
		$queryEstadoC = $this->db->get();*/

		$response['query']=$query;
		$response['queryClient']=$queryClient;
		//$response['queryEstadoC']=$queryEstadoC;
		$response['servicio']=$nombreServicio;
		$response['nombreCliente']=$nombreCliente;
		$response['fecha']=$fecha;
		$response['horaInicio']=$horaInicio;
		$response['horaFina']=$horaFina;
		$response['usuario']=$personal;
		$response['cabina']=$idCabina;
		$response['numSesion']=$numeroSesion;

		if ($tipo == 'nuevaCita') {
			$subjectMessage = "Notificación Sesión agendada-".$query->row()->NombreFranquicia;
			$response['inicio']= 'Cita agendada correctamente!';
			$response['cuerpo']='Confirmamos que su cita acaba de ser registrada';
			$message = $this->load->view('myagenda/franquiciatario/correoCita_view',$response, true);
		}else if($tipo == 'siguienteSesion'){
			$subjectMessage = "Notificación Sesión agendada-".$query->row()->NombreFranquicia;
			$message = $this->load->view('myagenda/franquiciatario/correoRegistroNext_view',$response, true);
		}else if ($tipo == 'updateCita') {
			$response['inicio']= 'Cita actualizada correctamente!';
			$response['cuerpo']='Confirmamos que su cita acaba de ser actualizada';
			$subjectMessage = "Notificación actualización de cita-".$query->row()->NombreFranquicia;
			$message = $this->load->view('myagenda/franquiciatario/correoCita_view',$response, true);
		}

	   $CorreoCorp = $query->row()->CorreoCorp;
	   if($CorreoCorp=="" || $CorreoCorp == null || strpos($CorreoCorp, 'yahoo') !== false){
		 $CorreoCorp='';
	   }				

	   $config['useragent'] = "CodeIgniter";
	   $config['protocol'] = "mail";
	   $config['mailpath'] = "/usr/sbin/sendmail"; // or "/usr/sbin/sendmail"
	   $config['mailtype'] = 'html';
	   $config['charset']  = 'utf-8';
	   $config['newline']  = "\r\n";
	   $config['wordwrap'] = TRUE;
	   $config['priority'] = 1;

	   $this->load->library('email');
	   $this->email->initialize($config);

		 $this->email->from($CorreoCorp, $query->row()->NombreFranquicia); 
		 $this->email->to($queryClient->row()->CorreoCliente);
		 $this->email->subject($subjectMessage);
		 $this->email->message($message);
		 $this->email->send();
		 
	   //return $CorreoCorp.' '.$subjectMessage.' '.$message;
   }

   	public function AlerTomadoS(){
		$AlertConfiguracion=$this->agendaF_model->AlerTomadoS();

		echo json_encode($AlertConfiguracion);
	}

	public function citasActuales(){
		$dateTimeAct = $this->input->post('dateTime');
		$dateTimeAnt = date("Y-m-d H:i:s",strtotime($dateTimeAct."- 15 minute"));
	
		$dateAnt = explode(" ", $dateTimeAnt);
		$dateAct = explode(" ", $dateTimeAct);
	
		$response = $this->agendaF_model->citasActuales($dateAnt,$dateAct);
	
		echo json_encode($response);
	}

	public function tablaCitasActuales(){
		$result = [];
		$dateTimeAct = $this->input->post('dateTime');
		$dateTimeAnt = date("Y-m-d H:i:s",strtotime($dateTimeAct."- 15 minute"));
	
		$dateAnt = explode(" ", $dateTimeAnt);
		$dateAct = explode(" ", date("Y-m-d H:i:s",strtotime($dateTimeAct)));
		
		$data = $this->agendaF_model->citasActuales($dateAnt,$dateAct);
		if ($data != false) {
	
			$estados=$this->agendaF_model->buscarEstados();
			foreach ($data as $value) {
	
				$nombreEstado='';
	
				$estadoS = '';
				$estadoS .=  '<select name="estadoEditar'.$value['IdAgenda'].'" id="estadoEditar'.$value['IdAgenda'].'" class="col-md-12">';			                		  
				  foreach ($estados as  $estado){ 
					if($estado['id']==3 || $estado['id']==6 || $estado['id']==7){ 
						$estadoS .='<option data-icon="colores '.$estado['clase'].'" value="'.$estado['id'].'">'.$estado['nombre'].'</option>';
					} 
				} 
	
				$estadoS .= '</select>';
				
				$comentario = '<textarea id="comentario'.$value['IdAgenda'].'" name="comentario'.$value['IdAgenda'].'" placeholder="Observaciones..." rows="1" maxlength="120">'.$value['Observaciones'].'</textarea>';
	
				$result[] = array(
					$value['IdAgenda'],
					$value['Fecha'].' '.$value['HoraInicio'],
					$value['NombreCliente'],
					$value['NombreEstatusCita'],
					$estadoS,
					$comentario
				);
			}
		}
		echo json_encode($result);
	}

	public function timeStatusC(){
		$time = $this->input->post('time');
		$response = $this->agendaF_model->registrarInicio($time);
		
		if ($response != false) {
			echo json_encode($time);
		}else{
			echo json_encode(false);
		}
	}

	public function cambiarStatusC(){
		$array=json_decode($_POST['data']);
		$validacion='';
		$contador=0;
	
		for($i=0; $i<count($array); $i++){
			if ($array[$i][1]->estado == 6 || $array[$i][1]->estado==7) {
				$contador=$i;
				$this->db->select('*');
				$this->db->from('agenda');
				$this ->db->where('IdAgenda', $array[$i][0]->idAgenda);
				$query = $this->db->get()->row();
	
				$sesionesFaltantes = ($query->SesionesFaltantesCitas - 1);
				$numeroSesiones = $sesionesFaltantes;
				$this->db->set('SesionesFaltantesCitas', $numeroSesiones);
				$this->db->where('IdAgenda', $query->IdAgenda);
				$this->db->update('agenda');
			}
	
			$datos=array(
				'estatuscitas_IdEstatusCita' => $array[$i][1]->estado,
				'Observaciones' => $array[$i][2]->observaciones
			);
	
			$data=$this->agendaF_model->ActualizarCitas($datos, $array[$i][0]->idAgenda);
	
			if($data!=FALSE){
				$contador+=1;
			}
		}
	
		if ($contador==count($array)) {
			echo json_encode($contador);
		}else{
			echo json_encode('Error');
		}
	}
}