<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class PagosF extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('pagos/franquiciatario/pagosF_model');
		$this->load->library(array('session','form_validation'));
		$this->load->library('Mydompdf');
		$this->load->helper(array('url'));

	}

	//Función que muestra las ventas generales
	public function index()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
	    $data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->where('Franquicias_IdFranquicias', $i);
		$this->db->where('EstatusV', 'ACTIVA');
		$this->db->order_by("FechaVenta","desc");
		$data['consulta']=$this->db->get('ventas')->result();
		$data['ReUsuario']=$this->pagosF_model->BuscarUsuario();
		
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		//$data['ReFranq']=$this->PagosF_model->BuscarFranq();
		$this->load->view('pagos/franquiciatario/listaVentas_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function UltimasVentas()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
		$this->session->userdata('Rol_IdRol') == '1'|| 
		$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$data['ReUsuario']=$this->pagosF_model->BuscarUsuario();		
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/listaUltimasVentas_view',$data);
		$this->load->view('layout/footer');
		}

	}

	//Función que muestra las ventas productos
	public function VentaProductos()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from(' ventas_has_productosfranquicias');
		$this->db->join('productosfranquicias','productosfranquicias_IdProductosFranquicias = IdProductosFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales = 	IdProductosGenerales','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas.EstatusV', 'ACTIVA');
		$this->db->where('Adeudo > 0');
		$this->db->order_by("FechaVenta","desc");
		$data['consulta']=$this->db->get()->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/listapagosF_view',$data);
		$this->load->view('layout/footer');
		}
	}
	public function PagoProductos()
	{
		$this->pagosF_model->PagoProductos();
	}

	//Función que muestra las ventas servicios
	public function VentaServicios()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {

		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		 foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
	    $this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
		$this->db->where('EstatusV', 'ACTIVA');
		$this->db->where('IdFranquicias',$i);
		$this->db->where('Adeudo > 0');
		$this->db->order_by("FechaVenta","desc");
		$data['consulta']=$this->db->get()->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/listapagosF2_view',$data);
		$this->load->view('layout/footer');
		}
	}
	
		public function VentaServiciosGenerales()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {

		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('EstatusV', 'ACTIVA');
		$this->db->where('Adeudo > 0');
		$this->db->order_by("FechaVenta","desc");
		$data['consulta']=$this->db->get()->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/listapagosF5_view',$data);
		$this->load->view('layout/footer');
		}
	}
	
	public function PagoServicios()
	{
		$serviciosA=$this->pagosF_model->PagoServiciosA();
		$serviciosG=$this->pagosF_model->PagoServiciosG();
		$servicios=[];
		if($serviciosA != FALSE)
		{
			foreach($serviciosA as $fila)
			{
				$servicios[]=array(
					$fila->folio,
					$fila->FolioVenta,
					$fila->ClienteVenta,
					date("d-m-Y H:i:s", strtotime($fila->FechaVenta)),
					$fila->NombreServicio,
					$fila->TotalPagar,
					$fila->exhibiciones_IdExhibiciones,
					$fila->Abono,
					$fila->Adeudo,
					$fila->VendedorUsuario,
					'<a href='.base_url().'pagos/franquiciatario/pagosF/editar2/'.$fila->IdVentasServicios.'/'.$fila->ventas_IdVentas.' class="label label-primary"><span class="glyphicon glyphicon-pencil"></a></span>'
				);
			}
		}
		if($serviciosG != FALSE)
		{
			foreach($serviciosG as $fila)
			{
				$servicios[]=array(
					$fila->folio,
					$fila->FolioVenta,
					$fila->ClienteVenta,
					date("d-m-Y H:i:s", strtotime($fila->FechaVenta)),
					$fila->NombreServicio,
					$fila->TotalPagar,
					$fila->exhibiciones_IdExhibiciones,
					$fila->Abono,
					$fila->Adeudo,
					$fila->VendedorUsuario,
					'<a href='.base_url().'pagos/franquiciatario/pagosF/editar3/'.$fila->IdVentasServicios.'/'.$fila->ventas_IdVentas.' class="label label-primary"><span class="glyphicon glyphicon-pencil"></a></span>'
				);
			}
		}

		echo json_encode($servicios);
	}

public function PagoPromociones()
{
	$this->pagosF_model->PagoPromociones();
}
public function TodasVentas()
{
	$this->pagosF_model->TodasVentas();
}
public function UltimasVentasRealizadas()
{
	$this->pagosF_model->UltimasVentasRealizadas();
}
public function agregarExhibicion()
{
		$Id= $this ->uri->segment(5);
		$ExhiAn=$this ->uri->segment(6);
		$ExhiAc=$ExhiAn + 1;
		$this->pagosF_model->exhiSer($Id, $ExhiAc);}

public function agregarExhibicionSG()
{
		$Id= $this ->uri->segment(5);
		$ExhiAn=$this ->uri->segment(6);
		$ExhiAc=$ExhiAn + 1;
		$this->pagosF_model->exhiSerGen($Id, $ExhiAc);}

public function agregarExhibicionPr()
{
		$Id= $this ->uri->segment(5);
		$ExhiAn=$this ->uri->segment(6);
		$ExhiAc=$ExhiAn + 1;
		$this->pagosF_model->exhiPromo($Id, $ExhiAc);}

	//Función que muestra las ventas generales

public function editar()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosF_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$folio=$fila->folio;
				$folioVenta=$fila->FolioVenta;
				$folio2=$fila->folio2;
				$IdVentasProductos=$fila->IdVentasProductos;
				$productosfranquicias_IdProductosFranquicias=$fila->productosfranquicias_IdProductosFranquicias;
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$PiezasTotales = $fila->PiezasTotales;
				$Descuento = $fila->Descuento;
				$Fecha1 = $fila->Fecha1;
				$Usuario1 = $fila->Usuario1;
				$ClienteVenta = $fila->ClienteVenta;
				$TotalVenta=$fila->TotalVenta;
				$TotalPagar = $fila->TotalPagar;
				$Adeudo=$fila->Adeudo;
				$Abono=$fila->Abono;
				$ComentarioDes=$fila->ComentarioDes;
				// $productosfranquicias_IdProductosFranquicias=$fila->productosfranquicias_IdProductosFranquicias;
				$NombreProducto = $fila->NombreProducto;
				$PiezasP =$fila->PiezasP;
				$SubTotalP=$fila->SubTotalP;
				$AdeudoVenta=$fila->AdeudoVenta;
				$AbonoVenta=$fila->AbonoVenta;
			}
			$data = array(
				'folio'=> $folio,
				'folioVenta'=> $folioVenta,
				'folio2'=> $folio2,
				'IdVentasProductos'=> $IdVentasProductos,
				'productosfranquicias_IdProductosFranquicias'=> $productosfranquicias_IdProductosFranquicias,
				'TotalPagar' => $TotalPagar,
				'ventas_IdVentas' => $ventas_IdVentas,
				'PiezasTotales' => $PiezasTotales,
				'Descuento' => $Descuento,
				'Fecha1' => $Fecha1,
				'Usuario1' => $Usuario1,
				'ClienteVenta' => $ClienteVenta,	
				'TotalVenta' => $TotalVenta,
				'Adeudo' => $Adeudo,
				'Abono' => $Abono,
				'ComentarioDes' => $ComentarioDes,
				'productosfranquicias_IdProductosFranquicias'=> $productosfranquicias_IdProductosFranquicias,
				'NombreProducto' => $NombreProducto,
				'PiezasP' => $PiezasP,
				'SubTotalP' => $SubTotalP,
				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,

				
			);
		}
		$data['ReUsuario']=$this->pagosF_model->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->pagosF_model->BuscarDatosFranquicia();
		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/editarPagos_view', $data);
		$this->load->view('layout/footer');
		}
	}

	public function generaTicket()
	{
		$id= $this->uri->segment(5);
		$id2= $this->uri->segment(6);
		$numPago= $this->uri->segment(7);
		$pago= $this->uri->segment(8); //Productos=1 Servicios=2 Promociones=3
		$data['datosFranquiciaTicket']=$this->pagosF_model->BuscarDatosFranquicia();
		$data['datosTicket']=$this->pagosF_model->BuscarDatosPago($id, $id2, $numPago, $pago);
		$data['id']=$id;
		$data['id2']=$id2;
		$data['numPago']=$numPago;
		$data['pago']=$pago;
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('pagos/franquiciatario/ticketPago_view', $data);
			$this->load->view('layout/footer');
		}
	}
	
	public function generaTicketPdf()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$id= $this->uri->segment(5);
			$id2= $this->uri->segment(6);
			$numPago= $this->uri->segment(7);
			$pago= $this->uri->segment(8); //Productos=1 Servicios=2 Promociones=3
			$data['datosFranquiciaTicket']=$this->pagosF_model->BuscarDatosFranquicia();
			$data['datosTicket']=$this->pagosF_model->BuscarDatosPago($id, $id2, $numPago, $pago);
			$html=($this->load->view('pagos/franquiciatario/generadorTicket',$data, true));
			$this->mydompdf->load_html($html,'UTF-8');	
			$this->mydompdf->set_paper(array(0,0,250,600)); 
			$this->mydompdf->render();	
			$this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); 
			$this->mydompdf->set_base_path('assets/dist/css/styles.css'); //agregar de nuevo el css
			$this->mydompdf->stream("Ticket de pago_".$data['datosTicket']['folioVenta'].".pdf");
		}

	}
	
	//Función que hace la busqueda de ventas 
	public function buscarp1()
	{	
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosF_model->buscarP1(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/buscarpago1_view', $data);
		$this->load->view('layout/footer');
	}



	//Función que muestra las ventas servicios
	public function editar2()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosF_model->obtenerenlace2($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$folio = $fila->folio;
				$folioVenta=$fila->FolioVenta;
				$folio2 = $fila->folio2;
				$folio3 = $fila->folio3;
				$folio4 = $fila->folio4;
				$IdVentasServicios = $fila->IdVentasServicios;
				$IdVentas = $fila->IdVentas;
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$serviciosfranquicias_IdServiciosFranquicias = $fila->serviciosfranquicias_IdServiciosFranquicias;
				$ClienteVenta = $fila->ClienteVenta;
				$NombreServicio = $fila->NombreServicio;
				$TotalPagar = $fila->TotalPagar;
				$SesionesS = $fila->SesionesS;
				$SubTotalS = $fila->SubTotalS;
				$exhibiciones_IdExhibiciones= $fila->exhibiciones_IdExhibiciones;
				$Abono= $fila->Abono;
				$Adeudo=$fila->Adeudo;
				$DescuentoS=$fila->DescuentoS;
				$ComentarioDesS = $fila->ComentarioDesS;
				$FolioC = $fila->FolioC;
				$NombreCertificadoS = $fila->NombreCertificadoS;
				$Fecha1 = $fila->Fecha1;
				$Usuario1 = $fila->Usuario1;

				$Fecha2 = $fila->Fecha2;
				$FolioVenta2 = $fila->FolioVenta2;
				$Contado2=$fila->Contado2;
				$TipoTarjeta2 = $fila->TipoTarjeta2;
				$CTarjeta2=$fila->CTarjeta2;
				$FolioTarjeta2=$fila->FolioTarjeta2;
				$Usuario2 = $fila->Usuario2;

				$Fecha3 = $fila->Fecha3;
				$FolioVenta3 = $fila->FolioVenta3;
				$Contado3=$fila->Contado3;
				$TipoTarjeta3 = $fila->TipoTarjeta3;
				$CTarjeta3=$fila->CTarjeta3;
				$FolioTarjeta3=$fila->FolioTarjeta3;
				$Usuario3 = $fila->Usuario3;

				$Fecha4 = $fila->Fecha4;
				$FolioVenta4 = $fila->FolioVenta4;
				$Contado4=$fila->Contado4;
				$TipoTarjeta4 = $fila->TipoTarjeta4;
				$CTarjeta4=$fila->CTarjeta4;
				$FolioTarjeta4=$fila->FolioTarjeta4;
				$Usuario4 = $fila->Usuario4;
			
				$AdeudoVenta = $fila->AdeudoVenta;
				$AbonoVenta = $fila->AbonoVenta;
			}
			$data = array(
				'folio' => $folio,
				'folioVenta'=> $folioVenta,
				'folio2' => $folio2,
				'folio3' => $folio3,
				'folio4' => $folio4,
				'IdVentasServicios' => $IdVentasServicios,
				'serviciosfranquicias_IdServiciosFranquicias' => $serviciosfranquicias_IdServiciosFranquicias,
				'IdVentas' => $IdVentas,
				'ventas_IdVentas' => $ventas_IdVentas,
				'ClienteVenta' => $ClienteVenta,
				'NombreServicio' => $NombreServicio,
				'SesionesS' => $SesionesS,
				'SubTotalS' => $SubTotalS,
				'exhibiciones_IdExhibiciones' => $exhibiciones_IdExhibiciones,
				'Abono' => $Abono,
				'Adeudo' => $Adeudo,
				'DescuentoS' => $DescuentoS,
				'ComentarioDesS' => $ComentarioDesS,
				'NombreCertificadoS' => $NombreCertificadoS,
				'FolioC' => $FolioC,
				'TotalPagar' => $TotalPagar,
				'Fecha1' => $Fecha1,

				'Usuario1' => $Usuario1,
				'Fecha2' => $Fecha2,
				'FolioVenta2' => $FolioVenta2,
				'Contado2' => $Contado2,
				'TipoTarjeta2' => $TipoTarjeta2,
				'CTarjeta2' => $CTarjeta2,
				'FolioTarjeta2' => $FolioTarjeta2,
				'Usuario2' => $Usuario2,

				'Fecha3' => $Fecha3,
				'FolioVenta3' => $FolioVenta3,
				'Contado3' => $Contado3,
				'TipoTarjeta3' => $TipoTarjeta3,
				'CTarjeta3' => $CTarjeta3,
				'FolioTarjeta3' => $FolioTarjeta3,
				'Usuario3' => $Usuario3,

				'Fecha4' => $Fecha4,
				'FolioVenta4' => $FolioVenta4,
				'Contado4' => $Contado4,
				'TipoTarjeta4' => $TipoTarjeta4,
				'CTarjeta4' => $CTarjeta4,
				'FolioTarjeta4' => $FolioTarjeta4,
				'Usuario4' => $Usuario4,

				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,
			);
		}else{
				$data ='';
				return FALSE;
		}
		$data['ReUsuario']=$this->pagosF_model->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->pagosF_model->BuscarDatosFranquicia();
		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		//$data['ReEx']=$this->pagosF_model->BuscarExhi();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/editarPagos2_view', $data);
		$this->load->view('layout/footer');
		}
	}

		public function editar3()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosF_model->obtenerenlace3($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$folio = $fila->folio;
				$folioVenta=$fila->FolioVenta;
				$folio2 = $fila->folio2;
				$folio3 = $fila->folio3;
				$folio4 = $fila->folio4;
				$IdVentasServicios = $fila->IdVentasServicios;
				$IdVentas = $fila->IdVentas;
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$serviciosfranquicias_IdServiciosFranquicias = $fila->serviciosfranquicias_IdServiciosFranquicias;
				$ClienteVenta = $fila->ClienteVenta;
				$NombreServicio = $fila->NombreServicio;
				$SesionesS = $fila->SesionesS;
				$SubTotalS = $fila->SubTotalS;
				$TotalPagar = $fila->TotalPagar;
				$exhibiciones_IdExhibiciones= $fila->exhibiciones_IdExhibiciones;
				$Abono= $fila->Abono;
				$Adeudo=$fila->Adeudo;
				$DescuentoS=$fila->DescuentoS;
				$ComentarioDesS = $fila->ComentarioDesS;
				$FolioC = $fila->FolioC;
				$NombreCertificadoS = $fila->NombreCertificadoS;
				$Fecha1 = $fila->Fecha1;
				$Usuario1 = $fila->Usuario1;

				$Fecha2 = $fila->Fecha2;
				$FolioVenta2 = $fila->FolioVenta2;
				$Contado2=$fila->Contado2;
				$TipoTarjeta2 = $fila->TipoTarjeta2;
				$CTarjeta2=$fila->CTarjeta2;
				$FolioTarjeta2=$fila->FolioTarjeta2;
				$Usuario2 = $fila->Usuario2;

				$Fecha3 = $fila->Fecha3;
				$FolioVenta3 = $fila->FolioVenta3;
				$Contado3=$fila->Contado3;
				$TipoTarjeta3 = $fila->TipoTarjeta3;
				$CTarjeta3=$fila->CTarjeta3;
				$FolioTarjeta3=$fila->FolioTarjeta3;
				$Usuario3 = $fila->Usuario3;

				$Fecha4 = $fila->Fecha4;
				$FolioVenta4 = $fila->FolioVenta4;
				$Contado4=$fila->Contado4;
				$TipoTarjeta4 = $fila->TipoTarjeta4;
				$CTarjeta4=$fila->CTarjeta4;
				$FolioTarjeta4=$fila->FolioTarjeta4;
				$Usuario4 = $fila->Usuario4;
			
				$AdeudoVenta = $fila->AdeudoVenta;
				$AbonoVenta = $fila->AbonoVenta;
			}
			$data = array(
				'folio' => $folio,
				'folioVenta'=> $folioVenta,
				'folio2' => $folio2,
				'folio3' => $folio3,
				'folio4' => $folio4,
				'IdVentasServicios' => $IdVentasServicios,
				'serviciosfranquicias_IdServiciosFranquicias' => $serviciosfranquicias_IdServiciosFranquicias,
				'IdVentas' => $IdVentas,
				'ventas_IdVentas' => $ventas_IdVentas,
				'ClienteVenta' => $ClienteVenta,
				'NombreServicio' => $NombreServicio,
				'SesionesS' => $SesionesS,
				'SubTotalS' => $SubTotalS,
				'TotalPagar' => $TotalPagar,
				'exhibiciones_IdExhibiciones' => $exhibiciones_IdExhibiciones,
				'Abono' => $Abono,
				'Adeudo' => $Adeudo,
				'DescuentoS' => $DescuentoS,
				'ComentarioDesS' => $ComentarioDesS,
				'NombreCertificadoS' => $NombreCertificadoS,
				'FolioC' => $FolioC,

				'Fecha1' => $Fecha1,
				'Usuario1' => $Usuario1,
				'Fecha2' => $Fecha2,
				'FolioVenta2' => $FolioVenta2,
				'Contado2' => $Contado2,
				'TipoTarjeta2' => $TipoTarjeta2,
				'CTarjeta2' => $CTarjeta2,
				'FolioTarjeta2' => $FolioTarjeta2,
				'Usuario2' => $Usuario2,

				'Fecha3' => $Fecha3,
				'FolioVenta3' => $FolioVenta3,
				'Contado3' => $Contado3,
				'TipoTarjeta3' => $TipoTarjeta3,
				'CTarjeta3' => $CTarjeta3,
				'FolioTarjeta3' => $FolioTarjeta3,
				'Usuario3' => $Usuario3,

				'Fecha4' => $Fecha4,
				'FolioVenta4' => $FolioVenta4,
				'Contado4' => $Contado4,
				'TipoTarjeta4' => $TipoTarjeta4,
				'CTarjeta4' => $CTarjeta4,
				'FolioTarjeta4' => $FolioTarjeta4,
				'Usuario4' => $Usuario4,

				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,
			);
		}else{
				$data ='';
				return FALSE;
		}
		$data['ReUsuario']=$this->pagosF_model->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->pagosF_model->BuscarDatosFranquicia();
		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		//$data['ReEx']=$this->pagosF_model->BuscarExhi();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/editarPagos2_view', $data);
		$this->load->view('layout/footer');
		}
	}

	public function editarenlace()
	{
		$Id= $this -> uri->segment(5);
		$Id2= $this -> uri->segment(6);
		$buscarFolio=$this->pagosF_model->buscarFolio();
		$folioPago=$buscarFolio+1;	
		$folios=array(
			'FolioVenta'=>$folioPago,
			'franquicias_IdFranquicias'=>$this->pagosF_model->BuscarIdFranquicia(),
			'IdUsuariosLog'=>$this->session->userdata('IdUsuarios'),
		);		
		$insertaFolio=$this->pagosF_model->insertaFolio($folios);
		if($insertaFolio!=FALSE)
		{
			$parametro['FolioVenta2']=$folioPago;
		}	
		$parametro['Fecha2'] = $this->input->post('fecha2');
		$parametro['Contado2'] = $this->input->post('Contado2');
		$parametro['TipoTarjeta2'] = $this->input->post('TipoTarjeta2');
		$parametro['CTarjeta2'] = $this->input->post('CTarjeta2');
		$parametro['FolioTarjeta2'] = $this->input->post('FolioTarjeta2');
		$parametro['Usuario2'] = $this->input->post('Usuario2');
		$parametro['Adeudo'] = $this->input->post('AdeudoFinal');
		$parametro['Abono'] = $this->input->post('AbonoFinal');
		$parametro['folio2'] = $this->input->post('folio2');

		$campo['AdeudoVenta'] = $this->input->post('AdeudoVenta');	
		$campo['AbonoVenta'] = $this->input->post('AbonoVenta');

		$dato['IdProductosFranquicias'] = $this->input->post('IdProductosFranquicias');	
		$dato['PiezasTotales'] = $this->input->post('PiezasTotales');

		$this->pagosF_model->editar($Id,$Id2,$parametro,$campo,$dato);
	}

	public function editarenlaceS()
	{
		if(!isset($_POST['CTarjeta']))
		{
			$CTarjeta='';
			$FolioTarjeta='';
		}else{
			$CTarjeta=$_POST['CTarjeta'];
			$FolioTarjeta=$_POST['FolioTarjeta'];
		}
		if(!isset($_POST['TipoTarjeta']))
		{
			$TipoTarjeta='';
		}else{
			$TipoTarjeta=$_POST['TipoTarjeta'];
		}
		$Id= $this ->uri->segment(5);
		$Id2= $this ->uri->segment(6);
		$NumPago=$_POST['pago'];
		$buscarFolio=$this->pagosF_model->buscarFolio();
		$folioPago=$buscarFolio+1;	
		$folios=array(
			'FolioVenta'=>$folioPago,
			'franquicias_IdFranquicias'=>$this->pagosF_model->BuscarIdFranquicia(),
			'IdUsuariosLog'=>$this->session->userdata('IdUsuarios'),
		);		
		$insertaFolio=$this->pagosF_model->insertaFolio($folios);
		if($insertaFolio!=FALSE)
		{
			$datos['FolioVenta']=$folioPago;
		}	
		$datos['Fecha']=$_POST['fecha'];
		$datos['Contado']=$_POST['Contado'];
		$datos['TipoTarjeta']=$TipoTarjeta;
		$datos['CantidadTarjeta']=$CTarjeta;
		$datos['FolioTarjeta']=$FolioTarjeta;
		$datos['Usuario']=$_POST['Usuario'];
		$datos['Adeudo']=$_POST['AdeudoFinal'];
		$datos['Abono']=$_POST['AbonoFinal'];
		
		$contado= floatval($_POST['Contado']);
		$tarjeta= floatval($CTarjeta);
		$abonoTotal= $contado + $tarjeta;
		$actualizaVenta=$this->pagosF_model->ActualizarVenta($Id2, $abonoTotal);
		$actualizaServicio=$this->pagosF_model->PagoServicio($Id, $datos, $NumPago);
		if($actualizaVenta==true && $actualizaServicio==true)
		{
			echo "<script>alert('Pago guardado correctamente');
			window.location.href='".base_url()."pagos/franquiciatario/pagosF/generaTicket/$Id2/$Id/$NumPago/2';
			</script>"; 
			// redirect(base_url().'pagos/franquiciatario/pagosF/generaTicket/'.$Id2.'/'.$Id.'/'.$NumPago.'/2');
		}else{
			echo "<script>alert('No se pudieron registrar los datos ingresados');</script>";
			redirect(base_url().'pagos/franquiciatario/pagosF/VentaServicios','refresh');
		}
	}
	public function editarenlacePro()
	{
		if(!isset($_POST['CTarjeta']))
		{
			$CTarjeta='';
			$FolioTarjeta='';
		}else{
			$CTarjeta=$_POST['CTarjeta'];
			$FolioTarjeta=$_POST['FolioTarjeta'];
		}
		if(!isset($_POST['TipoTarjeta']))
		{
			$TipoTarjeta='';
		}else{
			$TipoTarjeta=$_POST['TipoTarjeta'];
		}
		$Id= $this ->uri->segment(5);
		$Id2= $this ->uri->segment(6);
		$NumPago=$_POST['pago'];
		$buscarFolio=$this->pagosF_model->buscarFolio();
		$folioPago=$buscarFolio+1;	
		$folios=array(
			'FolioVenta'=>$folioPago,
			'franquicias_IdFranquicias'=>$this->pagosF_model->BuscarIdFranquicia(),
			'IdUsuariosLog'=>$this->session->userdata('IdUsuarios'),
		);		
		$insertaFolio=$this->pagosF_model->insertaFolio($folios);
		if($insertaFolio!=FALSE)
		{
			$datos['FolioVenta']=$folioPago;
		}	
		$datos['Fecha']=$_POST['fecha'];
		$datos['Contado']=$_POST['Contado'];
		$datos['TipoTarjeta']=$TipoTarjeta;
		$datos['CantidadTarjeta']=$CTarjeta;
		$datos['FolioTarjeta']=$FolioTarjeta;
		$datos['Usuario']=$_POST['Usuario'];
		$datos['Adeudo']=$_POST['AdeudoFinal'];
		$datos['Abono']=$_POST['AbonoFinal'];
		$contado= floatval($_POST['Contado']);
		$tarjeta= floatval($CTarjeta);
		$abonoTotal= $contado + $tarjeta;
		$actualizaVenta=$this->pagosF_model->ActualizarVenta($Id2, $abonoTotal);
		$actualizaPromo=$this->pagosF_model->PagoPromocion($Id, $datos, $NumPago);
		if($actualizaVenta==true && $actualizaPromo==true)
		{
			echo "<script>alert('Pago guardado correctamente');
			// redirect('pagos/franquiciatario/pagosF/generaTicket/'.$Id2.'/'.$Id.'/'.$NumPago.'/3','refresh');
			window.location.href='".base_url()."pagos/franquiciatario/pagosF/generaTicket/$Id2/$Id/$NumPago/3';
			</script>";
		}else{
			echo "<script>alert('No se pudieron registrar los datos ingresados');</script>";
			redirect(base_url().'pagos/franquiciatario/pagosF/VentaPromociones','refresh');
		}
	}
	//Función que edita guarda los pagos de las ventas servicios
	// public function editarenlaceVS()
	// {
	// 	$Id= $this ->uri->segment(5);
	// 	$Id2= $this ->uri->segment(6);
		
	// 	$parametro['Fecha2'] = $this->input->post('Fecha2');
	// 	$parametro['folio2'] = $this->input->post('folio2');
	// 	$parametro['Contado2'] = $this->input->post('Contado2');
	// 	$parametro['TipoTarjeta2'] = $this->input->post('TipoTarjeta2');
	// 	$parametro['CTarjeta2'] = $this->input->post('CTarjeta2');
	// 	$parametro['FolioTarjeta2'] = $this->input->post('FolioTarjeta2');
	// 	$parametro['Usuario2'] = $this->input->post('Usuario2');		
	// 	$parametro['Fecha3'] = $this->input->post('Fecha3');
	// 	$parametro['folio3'] = $this->input->post('folio3');
	// 	$parametro['Contado3'] = $this->input->post('Contado3');
	// 	$parametro['TipoTarjeta3'] = $this->input->post('TipoTarjeta3');
	// 	$parametro['CTarjeta3'] = $this->input->post('CTarjeta3');
	// 	$parametro['FolioTarjeta3'] = $this->input->post('FolioTarjeta3');
	// 	$parametro['Usuario3'] = $this->input->post('Usuario3');
	// 	$parametro['Fecha4'] = $this->input->post('Fecha4');
	// 	$parametro['folio4'] = $this->input->post('folio4');
	// 	$parametro['Contado4'] = $this->input->post('Contado4');
	// 	$parametro['TipoTarjeta4'] = $this->input->post('TipoTarjeta4');
	// 	$parametro['CTarjeta4'] = $this->input->post('CTarjeta4');
	// 	$parametro['FolioTarjeta4'] = $this->input->post('FolioTarjeta4');
	// 	$parametro['Usuario4'] = $this->input->post('Usuario4');

	// 	$campo['AdeudoVenta'] = $this->input->post('AdeudoVenta');


	// 	$this->pagosF_model->editarVS($Id,$Id2,$parametro,$campo);
		

	// }

	// public function editarenlaceSM()
	// {
	// 	$Id= $this ->uri->segment(5);
	// 	$Id2= $this ->uri->segment(6);
		
	// 	$parametro['Fecha2'] = $this->input->post('Fecha2');
	// 	$parametro['folio2'] = $this->input->post('folio2');
	// 	$parametro['Contado2'] = $this->input->post('Contado2');
	// 	$parametro['TipoTarjeta2'] = $this->input->post('TipoTarjeta2');
	// 	$parametro['CTarjeta2'] = $this->input->post('CTarjeta2');
	// 	$parametro['FolioTarjeta2'] = $this->input->post('FolioTarjeta2');
	// 	$parametro['Usuario2'] = $this->input->post('Usuario2');		
	// 	$parametro['Fecha3'] = $this->input->post('Fecha3');
	// 	$parametro['folio3'] = $this->input->post('folio3');
	// 	$parametro['Contado3'] = $this->input->post('Contado3');
	// 	$parametro['TipoTarjeta3'] = $this->input->post('TipoTarjeta3');
	// 	$parametro['CTarjeta3'] = $this->input->post('CTarjeta3');
	// 	$parametro['FolioTarjeta3'] = $this->input->post('FolioTarjeta3');
	// 	$parametro['Usuario3'] = $this->input->post('Usuario3');
	// 	$parametro['Fecha4'] = $this->input->post('Fecha4');
	// 	$parametro['folio4'] = $this->input->post('folio4');
	// 	$parametro['Contado4'] = $this->input->post('Contado4');
	// 	$parametro['TipoTarjeta4'] = $this->input->post('TipoTarjeta4');
	// 	$parametro['CTarjeta4'] = $this->input->post('CTarjeta4');
	// 	$parametro['FolioTarjeta4'] = $this->input->post('FolioTarjeta4');
	// 	$parametro['Usuario4'] = $this->input->post('Usuario4');

	// 	$campo['AdeudoVenta'] = $this->input->post('AdeudoVenta');

	// 	$this->pagosF_model->editarSM($Id,$Id2,$parametro,$campo);
	// }

	//Función que busca los Servicios
	public function buscarSer()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosF_model->buscarP2(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,		
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/buscarpago2_view', $data);
		$this->load->view('layout/footer');
	}
	public function buscarSerM()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosF_model->buscarP5(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,		
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/buscarpago5_view', $data);
		$this->load->view('layout/footer');
	}
	//Función que muestra las ventas_promociones
	public function VentaPromociones()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from('ventas_has_promociones');
		$this->db->join('promociones','IdPromociones = promociones_IdPromociones','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias', $i);
		$this->db->where('EstatusV', 'ACTIVA');
		$this->db->where('Adeudo > 0');
		$this->db->order_by("FechaVenta","desc");
		$data['consulta']=$this->db->get()->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/listapagosF3_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//funcion que muestra los datos de promociones
	public function editarPro()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);
    	$obtenerenlace = $this->pagosF_model->obtenerenlacePro($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$folio = $fila->folio;
				$folioVenta=$fila->FolioVenta;
				$folio2 = $fila->folio2;
				$folio3 = $fila->folio3;
				$folio4 = $fila->folio4;
				$IdVentasPromociones = $fila->IdVentasPromociones;
				$ventas_IdVentas = $fila->ventas_IdVentas;
				$promociones_IdPromociones = $fila->promociones_IdPromociones;
				$NombrePromocion = $fila->NombrePromocion;
				$SesionesPr = $fila->SesionesPr;
				$SubTotalPr = $fila->SubTotalPr;
				$TotalPagar = $fila->TotalPagar;
				$exhibiciones_IdExhibiciones = $fila->exhibiciones_IdExhibiciones;
				$NombreCertificadoPr = $fila->NombreCertificadoPr;
				$FolioPr = $fila->FolioPr;
				$SesionesPr = $fila->SesionesPr;
				$DescuentoPr = $fila->DescuentoPr;
				$ComentarioDesPr = $fila->ComentarioDesPr;
				$Adeudo = $fila->Adeudo;
				$Abono = $fila->Abono;
				$ClienteVenta = $fila->ClienteVenta;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$AbonoVenta=$fila->AbonoVenta;
				$Fecha1 = $fila->Fecha1;
				$Usuario1 = $fila->Usuario1;

				$Fecha2 = $fila->Fecha2;
				$FolioVenta2 = $fila->FolioVenta2;
				$Contado2=$fila->Contado2;
				$TipoTarjeta2 = $fila->TipoTarjeta2;
				$CTarjeta2=$fila->CTarjeta2;
				$FolioTarjeta2=$fila->FolioTarjeta2;
				$Usuario2 = $fila->Usuario2;

				$Fecha3 = $fila->Fecha3;
				$FolioVenta3 = $fila->FolioVenta3;
				$Contado3=$fila->Contado3;
				$TipoTarjeta3 = $fila->TipoTarjeta3;
				$CTarjeta3=$fila->CTarjeta3;
				$FolioTarjeta3=$fila->FolioTarjeta3;
				$Usuario3 = $fila->Usuario3;

				$Fecha4 = $fila->Fecha4;
				$FolioVenta4 = $fila->FolioVenta4;
				$Contado4=$fila->Contado4;
				$TipoTarjeta4 = $fila->TipoTarjeta4;
				$CTarjeta4=$fila->CTarjeta4;
				$FolioTarjeta4=$fila->FolioTarjeta4;
				$Usuario4 = $fila->Usuario4;
			}
			$data = array(

				'folio' => $folio,	
				'folioVenta'=> $folioVenta,
				'folio2' => $folio2,	
				'folio3' => $folio3,			
				'folio4' => $folio4,
				'IdVentasPromociones' => $IdVentasPromociones,
				'promociones_IdPromociones' => $promociones_IdPromociones,
				'ventas_IdVentas' => $ventas_IdVentas,
				'NombrePromocion' => $NombrePromocion,
				'DescuentoPr' => $DescuentoPr,
				'ComentarioDesPr' => $ComentarioDesPr,
				'ClienteVenta' => $ClienteVenta,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'Adeudo' => $Adeudo,
				'Abono' => $Abono,
				'SesionesPr' => $SesionesPr,
				'exhibiciones_IdExhibiciones' => $exhibiciones_IdExhibiciones,
				'SubTotalPr' => $SubTotalPr,
				'Adeudo' => $Adeudo,
				'AdeudoVenta'=> $AdeudoVenta,
				'AbonoVenta'=> $AbonoVenta,
				'TotalPagar' => $TotalPagar,


				'NombreCertificadoPr'=> $NombreCertificadoPr,
				'FolioPr'=>$FolioPr,
				'Fecha1' => $Fecha1,

				'Usuario1' => $Usuario1,
				'Fecha2' => $Fecha2,
				'FolioVenta2' => $FolioVenta2,
				'Contado2' => $Contado2,
				'TipoTarjeta2' => $TipoTarjeta2,
				'CTarjeta2' => $CTarjeta2,
				'FolioTarjeta2' => $FolioTarjeta2,
				'Usuario2' => $Usuario2,

				'Fecha3' => $Fecha3,
				'FolioVenta3' => $FolioVenta3,
				'Contado3' => $Contado3,
				'TipoTarjeta3' => $TipoTarjeta3,
				'CTarjeta3' => $CTarjeta3,
				'FolioTarjeta3' => $FolioTarjeta3,
				'Usuario3' => $Usuario3,

				'Fecha4' => $Fecha4,
				'FolioVenta4' => $FolioVenta4,
				'Contado4' => $Contado4,
				'TipoTarjeta4' => $TipoTarjeta4,
				'CTarjeta4' => $CTarjeta4,
				'FolioTarjeta4' => $FolioTarjeta4,
				'Usuario4' => $Usuario4,	
			);
		}else{
				$data ='';
				return FALSE;
			
		}
		$data['ReUsuario']=$this->pagosF_model->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->pagosF_model->BuscarDatosFranquicia();
		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/editarPagos3_view', $data);
		$this->load->view('layout/footer');
		}
	}

	//funcion que guarda todas las promociones
	// public function editarenlacePro()
	// {
	// 	$Id= $this ->uri->segment(5);
	// 	$Id2= $this ->uri->segment(6);
		
	// 	$parametro['Fecha2'] = $this->input->post('Fecha2');
	// 	$parametro['folio2'] = $this->input->post('folio2');
	// 	$parametro['Contado2'] = $this->input->post('Contado2');
	// 	$parametro['TipoTarjeta2'] = $this->input->post('TipoTarjeta2');
	// 	$parametro['CTarjeta2'] = $this->input->post('CTarjeta2');
	// 	$parametro['FolioTarjeta2'] = $this->input->post('FolioTarjeta2');
	// 	$parametro['Usuario2'] = $this->input->post('Usuario2');		
	// 	$parametro['Fecha3'] = $this->input->post('Fecha3');
	// 	$parametro['folio3'] = $this->input->post('folio3');
	// 	$parametro['Contado3'] = $this->input->post('Contado3');
	// 	$parametro['TipoTarjeta3'] = $this->input->post('TipoTarjeta3');
	// 	$parametro['CTarjeta3'] = $this->input->post('CTarjeta3');
	// 	$parametro['FolioTarjeta3'] = $this->input->post('FolioTarjeta3');
	// 	$parametro['Usuario3'] = $this->input->post('Usuario3');
	// 	$parametro['Fecha4'] = $this->input->post('Fecha4');
	// 	$parametro['folio4'] = $this->input->post('folio4');
	// 	$parametro['Contado4'] = $this->input->post('Contado4');
	// 	$parametro['TipoTarjeta4'] = $this->input->post('TipoTarjeta4');
	// 	$parametro['CTarjeta4'] = $this->input->post('CTarjeta4');
	// 	$parametro['FolioTarjeta4'] = $this->input->post('FolioTarjeta4');
	// 	$parametro['Usuario4'] = $this->input->post('Usuario4');

	// 	$campo['AdeudoVenta'] = $this->input->post('AdeudoVenta');

	// 	$this->pagosF_model->editarVPro($Id,$parametro,$Id2,$campo);
	// }


   //funcion para agregar un nuevo cliente que nos muestra la vista con todos sus formularios
	public function buscarp3()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->pagosF_model->buscarP3(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
			);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/buscarpago3_view', $data);
		$this->load->view('layout/footer');
	}

	

	public function ticket(){
		$id= $this->uri->segment(5);
			$result = $this->pagosF_model->BuscarVenta($id);
				if(count($result)>0){
				foreach ($result as $row) 
					$arr_result[] = array(
					'folio' => $row->folio,
					'fecha' => $row->FechaVenta,
					'cliente' => $row->ClienteVenta,
					'total'=>$row->TotalVenta,
					'subtotal'=>$row->Subtotal,
					'iva'=>$row->Iva,
					'Abono'=>$row->AbonoVenta,
					'Adeudo'=>$row->AdeudoVenta,

				);
					echo json_encode($arr_result);
				}
			
	}
	//funcion para agregar un nuevo cliente que nos muestra la vista con todos sus formularios correspondientes
	public function mostrarVenta() { 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$id= $this->uri->segment(5);

    	$result = $this->pagosF_model->obtenerenlaceV($id);

		if($result != FALSE){
			foreach ($result->result() as $fila) {
				$folio = $fila->folio;
				$FechaVenta = $fila->FechaVenta;
				$FolioVenta = $fila->FolioVenta;
				$IdVentas = $fila->IdVentas;
				$TotalVentaGeneral = $fila->TotalVentaGeneral;
				$ClienteVenta = $fila->ClienteVenta;
				$Subtotal=$fila->Subtotal;
				$Iva=$fila->Iva;
				$TotalVenta=$fila->TotalVenta;
				$AdeudoVenta=$fila->AdeudoVenta;
				$AbonoVenta=$fila->AbonoVenta;
				$VendedorUsuario=$fila->VendedorUsuario;
				$TotalPropina=$fila->TotalPropina;
				$UsuarioPropina=$fila->UsuarioPropina;
				$Comentario=$fila->Comentario;
				$Contado=$fila->Contado;
				$CantidadTarjetaUno=$fila->CantidadTarjetaUno;
				$CantidadTarjetaDos=$fila->CantidadTarjetaDos;

			}
			$data = array(
				'folio' => $folio,
				'FechaVenta' => $FechaVenta,
				'FolioVenta' => $FolioVenta,
				'IdVentas' => $IdVentas,
				'TotalVentaGeneral' => $TotalVentaGeneral,
				'ClienteVenta' => $ClienteVenta,
				'Subtotal' => $Subtotal,
				'Iva' => $Iva,
				'TotalVenta' => $TotalVenta,
				'AdeudoVenta' => $AdeudoVenta,
				'AbonoVenta' => $AbonoVenta,
				'VendedorUsuario' => $VendedorUsuario,
				'TotalPropina' => $TotalPropina,
				'UsuarioPropina' => $UsuarioPropina,
				'Comentario' => $Comentario,
				'Contado' => $Contado,
				'CantidadTarjetaUno' => $CantidadTarjetaUno,
				'CantidadTarjetaDos' => $CantidadTarjetaDos,	
			);

		}else{
				$data ='';
				return FALSE;	
		}

		$data['Franquicias']=$this->pagosF_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias) 
		$this->db->select('*');
		$this->db->from('ventas_has_productosfranquicias');
		$this->db->join('productosfranquicias','productosfranquicias_IdProductosFranquicias = IdProductosFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales = IdProductosGenerales','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta1']=$this->db->get()->result();

//........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
	    $this->db->join('franquicias','franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('serviciosfranquicias','ServiciosFranquicias_IdServiciosFranquicias = IdServiciosFranquicias','inner');
		$this->db->join('serviciosgenerales','ServiciosGenerales_IdServiciosGenerales = IdServiciosGenerales','inner');
		
		$this->db->where('IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta2']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from(' ventas_has_serviciosfranquicias');
	    $this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->join('serviciosgenerales','ServiciosFranquicias_IdServiciosFranquicias = Codigo_Servicios','inner');
		$this->db->where('ventas.franquicias_IdFranquicias',$i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta3']=$this->db->get()->result();
//.........................................................
		$this->db->select('*');
		$this->db->from('ventas_has_promociones');
		$this->db->join('promociones','IdPromociones = promociones_IdPromociones','inner');
		$this->db->join('ventas','ventas_IdVentas = IdVentas','inner');
		$this->db->where('ventas.franquicias_IdFranquicias', $i);
		$this->db->where('ventas_IdVentas', $id);
		$this->db->order_by("FechaVenta","desc");
		$data['consulta4']=$this->db->get()->result();

		//............................................................
		$this->db->select('*');
		$this->db->from('franquicias_has_leyendasgenerales');
		$this->db->join('leyendasgenerales','LeyendasGenerales_IdLeyendas = IdLeyendas','inner');
		$this->db->where('franquicias_has_leyendasgenerales.Franquicias_IdFranquicias', $i);
		$this->db->order_by("FechaCreacionL","desc");
		$data['leyenda']=$this->db->get()->result();

		
		$data['ReUsuario']=$this->pagosF_model->BuscarUsuario();
		$data['datosFranquiciaTicket'] = $this->pagosF_model->BuscarDatosFranquicia();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('pagos/franquiciatario/detallesVenta_view', $data);
		$this->load->view('layout/footer');
		}
	}
	public function cancelarventa(){
		$id= $this->uri->segment(5);
		$this->pagosF_model->CancelarVenta($id);
	}
	public function cancelarActualizar(){
		$id= $this->uri->segment(5);
		$this->pagosF_model->CancelarActualizarVenta($id);
	}
	public function todosAdeudos(){	
		$id=$_POST['id'];	
		$this->pagosF_model->ObtenerAdeudos($id);
	}
	public function aumentarExhibicion()
	{
		$id=$_POST['id'];
		$tipo=$_POST['tipo'];
		$this->pagosF_model->aumentarExhibicion($id, $tipo);
	}
	public function pagarTodo()
	{
		$data = json_decode($_POST['array']);
		$idVenta=$_POST['id'];
		$abono=$_POST['abono'];
		$bandera='true';
		$datosTicket=$idVenta.'F';
		$buscarFolio=$this->pagosF_model->buscarFolio();
		$folioPago=$buscarFolio+1;	
		$folios=array(
			'FolioVenta'=>$folioPago,
			'franquicias_IdFranquicias'=>$this->pagosF_model->BuscarIdFranquicia(),
			'IdUsuariosLog'=>$this->session->userdata('IdUsuarios'),
		);		
		$insertaFolio=$this->pagosF_model->insertaFolio($folios);
		for($i=0; $i<count($data); $i++)
		{			
			$datos['Fecha']=$data[$i][18];
			if($insertaFolio!=FALSE)
			{
				$datos['FolioVenta']=$folioPago;
			}			
			$datos['Contado']=$data[$i][13];
			$datos['TipoTarjeta']=$data[$i][14];
			$datos['CantidadTarjeta']=$data[$i][15];
			$datos['FolioTarjeta']=$data[$i][16];
			$datos['Usuario']=$data[$i][17];
			switch($data[$i][4])
			{
				case '1':
					$abonoAdeudo=$this->pagosF_model->ObtenerAdeudoP($data[$i][2]);
					$datos['Abono']=$abonoAdeudo['Abono']+$data[$i][12];
					$datos['Adeudo']=$abonoAdeudo['Adeudo']-$data[$i][12];
					$pago=$this->pagosF_model->PagoProducto($data[$i][2], $data[$i][3], $datos, $data[$i][6], $data[$i][12]);
					break;
				case '2':
					$abonoAdeudo=$this->pagosF_model->ObtenerAdeudoSe($data[$i][2]);
					$datos['Abono']=$abonoAdeudo['Abono']+$data[$i][12];
					$datos['Adeudo']=$abonoAdeudo['Adeudo']-$data[$i][12];
					$pago=$this->pagosF_model->PagoServicio($data[$i][2], $datos, $data[$i][10]);
					break;
				case '3':
					$abonoAdeudo=$this->pagosF_model->ObtenerAdeudoPr($data[$i][2]);
					$datos['Abono']=$abonoAdeudo['Abono']+$data[$i][12];
					$datos['Adeudo']=$abonoAdeudo['Adeudo']-$data[$i][12];
					$pago=$this->pagosF_model->PagoPromocion($data[$i][2], $datos, $data[$i][10]);
					break;
			}
			if($pago!=true)
			{
				$bandera='false';
			}
			$datosTicket=$datosTicket.$data[$i][2].'D'.$data[$i][4].'D'.$data[$i][10].'I';
		}
		if($bandera !='false')
		{
			$actualizar=$this->pagosF_model->ActualizarVenta($idVenta, $abono);	
			if($actualizar == true)
			{
				echo json_encode($datosTicket);
			}else{
				echo json_encode('error');
			}
		}else{
			echo json_encode('error');
		}
	}

	public function generaTicketPago()
	{
		$datos=$this->uri->segment(5);
		$separaTexto = explode("F", $datos);
		$obtenerTodosDatos = explode("I", $separaTexto[1]);
		$id=$separaTexto[0];
		$ventas= array();
		for($i=0; $i<(count($obtenerTodosDatos)-1); $i++)
		{
			$obtenerDatos = explode("D", $obtenerTodosDatos[$i]);		
			$venta=$this->pagosF_model->BuscarDatosPago($id, $obtenerDatos[0], $obtenerDatos[2], $obtenerDatos[1]);	
			array_push($ventas, $venta);
		}
		$data['datosTicket']=$ventas;
		$data['cliente']=$ventas[0]['cliente'];
		$data['fecha']=$ventas[0]['fechaPago'];
		$data['folioVenta']=$ventas[0]['folioVenta'];
		$data['atendio']=$ventas[0]['atendio'];
		$data['datosFranquiciaTicket']=$this->pagosF_model->BuscarDatosFranquicia();
		$data['datos']=$datos;
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('pagos/franquiciatario/ticketPagos_view', $data);
			$this->load->view('layout/footer');
		}
	}

	public function generaTicketPagoPdf()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
		$this->session->userdata('Rol_IdRol') == '1'|| 
		$this->session->userdata('Rol_IdRol') == '3')
	{
		redirect(base_url().'acceso/acceso');
	} else {
		$datos=$this->uri->segment(5);
		$separaTexto = explode("F", $datos);
		$obtenerTodosDatos = explode("I", $separaTexto[1]);
		$id=$separaTexto[0];
		$ventas= array();
		for($i=0; $i<(count($obtenerTodosDatos)-1); $i++)
		{
			$obtenerDatos = explode("D", $obtenerTodosDatos[$i]);		
			$venta=$this->pagosF_model->BuscarDatosPago($id, $obtenerDatos[0], $obtenerDatos[2], $obtenerDatos[1]);	
			array_push($ventas, $venta);
		}
		$data['datosTicket']=$ventas;
		$data['cliente']=$ventas[0]['cliente'];
		$data['fecha']=$ventas[0]['fechaPago'];
		$data['folioVenta']=$ventas[0]['folioVenta'];
		$data['atendio']=$ventas[0]['atendio'];
		$data['datosFranquiciaTicket']=$this->pagosF_model->BuscarDatosFranquicia();
		
		$html=($this->load->view('pagos/franquiciatario/generadorTicketPago',$data, true));
		$this->mydompdf->load_html($html,'UTF-8');	
		$this->mydompdf->set_paper(array(0,0,250,600)); 
		$this->mydompdf->render();	
		$this->mydompdf->set_base_path('./assets/dist/css/dompdf.css'); 
		$this->mydompdf->set_base_path('assets/dist/css/styles.css'); //agregar de nuevo el css
		$this->mydompdf->stream("Ticket de pago_".$ventas[0]['folioVenta'].".pdf");
	}
	}
}