<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Cosmetólogo)
class productosInternosA extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación y manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('productos/Cosmetologo/productoInternoA_model');
		$this->load->library(array('session','form_validation'));
	}


	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaProductoInternoA_view
	//Hace la consulta para mostrar todos los productos al público que esten registrados en la franquicia del usuario logueado
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data['Franquicias']=$this->productoInternoA_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$this->db->where('TipoProducto_IdTipoProducto','1');
		$data['consulta']=$this->db->get('productosfranquicias')->result();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('productos/Cosmetologo/listaProductoInternoA_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Funcion que muestra los datos del producto seleccionado y los muestra en la vista editarProductoInterno_view
	public function VerInformacion()
	{	
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->productoInternoA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdProductosFranquicias = $fila->IdProductosFranquicias;
				$NombreProducto=$fila->NombreProducto;
				$TipoProducto_IdTipoProducto=$fila->TipoProducto_IdTipoProducto;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$StockMinimo=$fila->StockMinimo;
				$PrecioVenta=$fila->PrecioVenta;
				$PrecioCompra=$fila->PrecioCompra;
				$DescripcionProducto = $fila->DescripcionProducto;
			}$data = array(
				'IdProductosFranquicias' => $IdProductosFranquicias,
				'NombreProducto' => $NombreProducto,
				'TipoProducto_IdTipoProducto' =>$TipoProducto_IdTipoProducto,		
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'StockMinimo' => $StockMinimo,
				'PrecioVenta' => $PrecioVenta,
				'PrecioCompra' => $PrecioCompra,
				'DescripcionProducto' => $DescripcionProducto);
			}else{
				$data ='';
				return FALSE;
		}
		$data['ReTipo']=$this->productoInternoA_model->BuscarTipo();
		$data['ReCategoria']=$this->productoInternoA_model->BuscarCategoria();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('productos/Cosmetologo/editarProductoInterno_view',$data);
		$this->load->view('layout/footer');
		}
	}


	//Función que muestra el tipo del producto
	public function MostrarTipo()
	{
		$options ="";
		if($this->input->post('IdTipoProducto')){
			$IdTipo=$this->input->post('IdTipoProducto');
			$Nombre=$this->productoPublicoA_model->BuscarTipo($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el tipo de categoría 
	public function MostrarCategoria()
	{
		$options ="";
		if($this->input->post('IdCategoria')){
			$IdCategoria=$this->input->post('IdCategoria');
			$Nombre=$this->productoProductoA_model->BuscarCategoria($IdCategoria);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra todos los productos al público registrados
	public function BuscarProducto()
	{
     $query = $this->db-> query('SELECT IdProductosGenerales,NombreProducto FROM productosgenerales WHERE TipoProducto_IdTipoProducto = 2'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdProductosGenerales, ENT_QUOTES)] = htmlspecialchars($row->NombreProducto, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
    }

	//Función que muestra la franquicia a la que pertenece el usuario logueado
	public function BuscarFranquicia()
	{
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
    }
	
}