<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class PromocionlocalA extends CI_Controller {
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','form_validation'));
		$this->load->model('promociones/administrador/promocionlocalA_model');
	}

	public function listaPromociones(){
		$this->promocionlocalA_model->buscarPromociones();
	}
//aca se muestra la pantalla principal de este modulo (lista de promocioneslocales)
	public function index() { 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3'){
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','zona_IdZona = IdZona','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->where('TipoPromocion_IdTipoPromocion',2);
		$this->db->order_by("NombreFranquicia","asc");
		$data['consulta']=$this->db->get('promociones')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/listapromocionlocalA_view',$data);
		$this->load->view('layout/footer');
		}
	}



// Aca se muestra la vista del formularios para agregar una nueva promoción local
	public function agregar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$datos['ReTipoPromocion']=$this->promocionlocalA_model->BuscarTipoPromocion();
		$datos['ReCategoria']=$this->promocionlocalA_model->BuscarCategoria();
		$datos['ReFranquicia']=$this->promocionlocalA_model->BuscarFranquicia();
		$this->load->view('promociones/administrador/agregarpromocionlocalA_view', $datos);
		$this->load->view('layout/footer');
		}
	}
//esta funcion manda los datos capturados en la vista al modelo para que puedan ser guardados en la bd
	public function guardar()
	{ 
		$parametro['NombrePromocion']= "PL-".$this->input->post('txt_NombrePromocionpro')."   ".$parametro['txt_cantidad']= $this->input->post('txt_cantidad')." SESIONES";
		$parametro['FolioPromocion']="FMAS".$this->input->post('txt_idfranquicia')."PL";
		$parametro['Cantidad']= $this->input->post('txt_cantidad');
		$parametro['Precio']= $this->input->post('txtnumero_servicios');
		$parametro['SesionesPromocion']= $this->input->post('txt_cantidad');
		$parametro['DuracionPromocion']= $this->input->post('tiempo');
		$parametro['DescripcionPromocion']= $this->input->post('txt_DescripcionPromocion');
		$parametro['FechaInicioPromocion']= $this->input->post('txt_fechai');
		$parametro['FechaTerminoPromocion']= $this->input->post('txt_fechaf');
		$parametro['Estatus']= $this->input->post('txt_estatus');
		$parametro['tipopromocion_IdTipoPromocion']= $this->input->post('txt_idtipopro');
		$parametro['categoria_IdCategoria']= $this->input->post('txtcategoria');
		$parametro['zona_IdZona']= $this->input->post('txt_idzona');
		$parametro['ClasePromocion']= $this->input->post('Clase');
		$parametro['ClasificacionPromocion']= $this->input->post('Clasificacion');
		$parametro['franquicias_IdFranquicias']= $this->input->post('txt_idfranquicia');		
		$this->promocionlocalA_model->guardar($parametro);
		
		//redirect('promociones/administrador/promocionlocalA');

	}

	//esta función elimina una promoción por medio de su id  
	public function eliminar() 
	{  

		 $id= $this->uri->segment(5);
		 $this->promocionlocalA_model->eliminar($id);
		 redirect('promociones/administrador/promocionlocalA');
	}

	//esta función sirve para mostrar en un formulario los datos guardados anteriormenet de una promocion para poder editarlos
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->promocionlocalA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$franquicias_IdFranquicias=$fila->franquicias_IdFranquicias;
				$NombrePromocion=$fila->NombrePromocion;
				$categoria_IdCategoria = $fila->categoria_IdCategoria;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$Estatus =$fila->Estatus;
				$zona_IdZona=$fila->zona_IdZona;
				$franquicias_IdFranquicias = $fila->franquicias_IdFranquicias;
				$ClasePromocion=$fila->ClasePromocion;
				$ClasificacionPromocion=$fila->ClasificacionPromocion;	
				$DuracionPromocion=$fila->DuracionPromocion;	
			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'franquicias_IdFranquicias' => $franquicias_IdFranquicias,
				'NombrePromocion' => $NombrePromocion,
				'categoria_IdCategoria' => $categoria_IdCategoria,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'Estatus' => $Estatus,
				'zona_IdZona' => $zona_IdZona,
				'ClasePromocion' => $ClasePromocion,
				'ClasificacionPromocion' => $ClasificacionPromocion,
				'franquicias_IdFranquicias' => $franquicias_IdFranquicias,
				'DuracionPromocion' => $DuracionPromocion
				);
			}else{
				$data ='';
				return FALSE;	
		}
		$data['ReTipoPromocion']=$this->promocionlocalA_model->BuscarTipoPromocion();
		$data['ReCategoria']=$this->promocionlocalA_model->BuscarCategoria();
		$data['ReZona']=$this->promocionlocalA_model->BuscarZonaRe();
		$data['ReFranquicia']=$this->promocionlocalA_model->BuscarFranquicia();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/editarpromocionlocalA_view', $data);
		$this->load->view('layout/footer');
		}
	}

	//esta función manda los datos que se desean modificar al modelo para que se puedan guardar en la bd
	public function editarenlace () 
	{
		$IdPromociones= $this -> uri->segment(5);
		$data=array(
				
				'NombrePromocion' => $this ->input ->post('NombrePromocion',true),
				'Categoria_IdCategoria' => $this -> input ->post('Categoria_IdCategoria', true),	
				'Precio'=> $this->input-> post('Precio',true),
				'DuracionPromocion'=> $this ->input->post('tiempo',true),
				'DescripcionPromocion'=> $this ->input->post('DescripcionPromocion',true),
				'FechaInicioPromocion' => $this->input->post('FechaInicioPromocion',true),
				'FechaTerminoPromocion'=>$this->input->post('FechaTerminoPromocion',true),
				'ClasificacionPromocion' => $this -> input ->post('ClasificacionPromocion', true),
				'ClasePromocion' => $this -> input ->post('ClasePromocion', true),
				'Estatus'=>$this->input->post('txt_estatus',true)

			);
		$this->promocionlocalA_model->editarenlace($IdPromociones, $data);
		
	}

	//esta función permite buscar una promoción por medio de su nombre y muestra los resultados buscados
	public function buscar () 
	{	
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->promocionlocalA_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('promociones/administrador/buscarpromocionlocalA_view', $data);
		$this->load->view('layout/footer');
		}
	}
	//esta función muestra e una lista desplegable los tipos de promocion que esxisten para poder agregar una nueva promoción
	public function MostrarTipoPromocion()
	{ 
		$options ="";
		if($this->input->post('TipoPromocion')){
			$IdTipoPromocion=$this->input->post('tipopromocion');
			$NombrePromocion=$this->promocionlocalA_model->BuscarTipoPromocion($IdTipoPromocion);
			foreach ($NombrePromocion as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipopromocion_name ?></option>
                <?php
			}
		}

	}
	//esta función muestra en una lista desplegable las categorias que existen para poder agregar una nueva promoción
	public function MostrarCategoria()
	{ 
		$options ="";
		if($this->input->post('categoria')){
			$IdCategoria=$this->input->post('categoria');
			$NombreCategoria=$this->promocionlocalA_model->BuscarCategoria($IdCategoria);
			foreach ($NombreCategoria as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}

	}

	public function MostrarZona()
	{
		$options ="";
		$IdFranquicias=$this->input->post('IdFranquicias');
		if($IdFranquicias){
			$this->load->model('promocionlocalA_model');
			$zonas=$this->promocionlocalA_model->BuscarZona($IdFranquicias);
			foreach ($zonas as $zona) {

				echo "<option value='".$zona['Zona_IdZona']."'>".$zona['NombreZona']."</option>";
			}
		}
		
	}

}