<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class PromocioninstitucionalC extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('promociones/cosmetologo/promocioninstitucionalC_model');
		$this->load->library(array('session','form_validation'));
	}

	//Acá se muestra la pantalla principal del módulo de promociones intitucionales (lista de promociones)
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->promocioninstitucionalC_model->BuscarFranquicia();
		 foreach ($data['Franquicias'] as $i => $Franquicias) 

		 $data['Zona']=$this->promocioninstitucionalC_model->BuscarZonaPer();
		 foreach ($data['Zona'] as $a => $Zona)
		$this->db->where('TipoPromocion_IdTipoPromocion',1);
		$this->db->where('Estatus','ACTIVA');
		$this->db->where('Zona_IdZona',$a);
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
		$data['consulta']=$this->db->get('promociones')->result();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('promociones/cosmetologo/listapromocioninstitucionalC_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Esta función muestra en un formulario los datos que ya han sido guardados anteriormente para poder ser editados  
	public function editar()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->promocioninstitucionalC_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdPromociones = $fila->IdPromociones;
				$tipopromocion_IdTipoPromocion=$fila->tipopromocion_IdTipoPromocion;
				$NombrePromocion=$fila->NombrePromocion;
				$categoria_IdCategoria = $fila->categoria_IdCategoria;
				$Precio=$fila->Precio;
				$DescripcionPromocion=$fila->DescripcionPromocion;
				$FechaInicioPromocion = $fila->FechaInicioPromocion;
				$FechaTerminoPromocion=$fila->FechaTerminoPromocion;
				$zona_IdZona=$fila->zona_IdZona;
			}
			$data = array(
				'IdPromociones' => $IdPromociones,
				'tipopromocion_IdTipoPromocion' => $tipopromocion_IdTipoPromocion,
				'NombrePromocion' => $NombrePromocion,
				'categoria_IdCategoria' => $categoria_IdCategoria,
				'Precio' => $Precio,
				'DescripcionPromocion' => $DescripcionPromocion,
				'FechaInicioPromocion' => $FechaInicioPromocion,
				'FechaTerminoPromocion' => $FechaTerminoPromocion,
				'zona_IdZona' => $zona_IdZona);
			}else{
				$data ='';
				return FALSE;	
		}
			$data['ReCategoria']=$this->promocioninstitucionalC_model->BuscarCategoria();
			$data['ReZona']=$this->promocioninstitucionalC_model->BuscarZona();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('promociones/cosmetologo/editarpromocioninstitucionalC_view', $data);
		$this->load->view('layout/footer');
		}
	}

	// en esta función se mandan los datos que han sido registrados en el formulario al modelo para que los cambios puedan ser realizados en la bd
	public function editarenlace ()
	{
		$IdPromociones= $this -> uri->segment(5);
		$data=array(
			'IdPromociones' => $this -> input ->post('IdPromociones', true),
			'TipoPromocion_IdTipoPromocion' => $this -> input ->post('TipoPromocion_IdTipoPromocion', true),
			'NombrePromocion' => $this -> input ->post('NombrePromocion', true),
			'Categoria_IdCategoria' => $this -> input ->post('Categoria_IdCategoria', true),
			'Precio' => $this -> input ->post('Precio', true),
			'DescripcionPromocion' => $this -> input ->post('DescripcionPromocion', true),
			'FechaInicioPromocion' => $this -> input ->post('FechaInicioPromocion', true),
			'FechaTerminoPromocion' => $this -> input ->post('FechaTerminoPromocion', true),
			'Zona_IdZona' => $this -> input ->post('Zona_IdZona', true)		
			);
		$this->promocioninstitucionalF_model->editarenlace($IdPromociones, $data);
		redirect('promociones/cosmetologo/promocioninstitucionalC');
	}

	//esta función permite buscar alguna promoción por medio de su nombre
	public function buscar ()
	{		
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {

		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->promocioninstitucionalC_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('promociones/cosmetologo/buscarpromocioninstitucionalC_view', $data);
		$this->load->view('layout/footer');
		}
	}
	
	// Esta función muestra en una lista desplegable losnombes de todas las franquicias para poder dar de alta una nueva promoción
	public function MostrarFranquicia()
	{ 
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('franquicias');
			$NombreFranquicia=$this->accionesfranquiciaC_model->BuscarFranquicia($IdFranquicias);
			foreach ($NombreFranquicia as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}
	}

	public function MostrarFranq()
	{
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('franquicias');
			$NombreFranquicia=$this->accionesfranquiciaC_model->BuscarFranq($IdFranquicias);
			foreach ($NombreFranquicia as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $franquicia_name ?></option>
                <?php
			}
		}
	}
}

	
