<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class ClientesR extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Administrador/Clientes_model');
		$this->load->library(array('session','form_validation')); 
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal clientes_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    		$this->db->select('*');
			$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
			$data['consulta']=$this->db->get('clientes')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Clientes_model->BuscarFranq();
		$data['ReZona']=$this->Clientes_model->BuscarZona();
		$this->load->view('reportes/Administrador/MenuClientes',$data);
		$this->load->view('layout/footer');
		}
	}

	//Función que busca al cliente de acuerdo a la franquicia con la que se logueo el usuario 
	public function buscarporfran()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias= IdFranquicias','inner');
		$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Clientes_model->buscarporfran(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
						);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarClientes_view',$data);
		$data['ReFranq']=$this->Clientes_model->BuscarFranq();
		$this->load->view('layout/footer');
		}
	}
	//Función que busca a la franquicia de acuerdo a la zona con la que se logueo el usuario 
	public function buscarporzona()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Clientes_model->buscarporzona(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarClientes_view',$data);
		$data['Rezona']=$this->Clientes_model->Buscarzona();
		$this->load->view('layout/footer');
		}
	}

	public function buscar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarClientes_view',$data);
		$data['ReFranq']=$this->Clientes_Model->BuscarFranq();
		$data['ReZona']=$this->Clientes_Model->BuscarZona();
		$this->load->view('layout/footer');
	}
}