<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class RClientes extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Administrador/Clientes_model');
		$this->load->library(array('session','form_validation')); 
		 $this->load->library('mydompdf');

	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal clientes_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    		$this->db->select('*');
			$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$this->db->join('zona','Zona_IdZona = IdZona','inner');
			$data['consulta']=$this->db->get('clientes')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Clientes_model->BuscarFranq();
		$data['ReZona']=$this->Clientes_model->BuscarZona();
		$this->load->view('reportes/Administrador/MenuClientes',$data);
		$this->load->view('layout/footer');
		}
	}
	public function buscarporfran()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
			$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Clientes_model->buscarporfran(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->Clientes_model->BuscarFranq();
      $html=($this->load->view('reportes/Administrador/ReporteCPorFranquicia', $data, true));
      	$this->mydompdf->load_html($html);  
     	$this->mydompdf->set_paper('a4', 'landscape'); 
      	$this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte Por Franquicia.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
		}
	}
	public function buscarporzona()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
	    $this->db->join('zona','Zona_IdZona= IdZona','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Clientes_model->buscarporzona(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReZona']=$this->Clientes_model->BuscarZona();
		$html=($this->load->view('reportes/Administrador/ReporteCPorZona', $data, true));
      	$this->mydompdf->load_html($html);  
      	$this->mydompdf->set_paper('a4', 'landscape'); 
      	$this->mydompdf->render();
      	$this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
      	$this->mydompdf->stream("Reporte Por Zona.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
	    }
    }
 	public function buscar()
 	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarClientes_view',$data);
		$data['ReFranq']=$this->Clientes_Model->BuscarFranq();
		$data['ReZona']=$this->Clientes_Model->BuscarZona();
		$this->load->view('layout/footer');
    	}
    	
    public function actiongeneral()
 	{
 	$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
	    $this->db->join('zona','Zona_IdZona= IdZona','inner');
		$query=$this->db->get('clientes');
  	$this->load->model("Clientes_Model");
  	$this->load->library("GenerarReporteExcel/excel");
  	$object = new PHPExcel();
  	$object->setActiveSheetIndex(0);
  	$object->getActiveSheet()->setTitle('Reporte General de Clientes');
  	$object->getActiveSheet()->getStyle('3')->applyFromArray(
  	array(
  	'font' => array(
  	'bold' => TRUE)));
  	$table_columns = array("NOMBRE","CORREO", "TELÉFONO","CELULAR","DIRECCIÓN","FECHA DE NACIMIENTO","MEDIO","FRANQUICIA","AUTORIZA");
  	$column = 0;
  	$field = 3;
  
  		foreach($table_columns as $field)
  		{
  			$object->getActiveSheet()->setCellValueByColumnAndRow($column,3, $field);
  			$column++;
  		}
  		$clientes = $this->Clientes_Model->fetch_data();
  		$excel_row = 4;
  		foreach($clientes as $row)
  		{
 	//funcion para dar el tamaño a cada columna del formato excel.
   		$object->getActiveSheet()->getColumnDimension('A')->setWidth(30);
	    $object->getActiveSheet()->getColumnDimension('B')->setWidth(30);
	    $object->getActiveSheet()->getColumnDimension('C')->setWidth(15);
	    $object->getActiveSheet()->getColumnDimension('D')->setWidth(15);
	    $object->getActiveSheet()->getColumnDimension('E')->setWidth(30);
	    $object->getActiveSheet()->getColumnDimension('F')->setWidth(30);
	    $object->getActiveSheet()->getColumnDimension('G')->setWidth(30);
	    $object->getActiveSheet()->getColumnDimension('H')->setWidth(20);
	    $object->getActiveSheet()->getColumnDimension('J')->setWidth(10);

   
		   $object->getActiveSheet()->setCellValueByColumnAndRow(0, $excel_row, $row->NombreCliente);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(1, $excel_row, $row->CorreoCliente);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(2, $excel_row, $row->TelefonoCliente);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(3, $excel_row, $row->CelularCliente);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(4, $excel_row, $row->DireccionCliente);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(5, $excel_row, $row->FechaNacimientoCliente);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(6, $excel_row, $row->MedioInformacion);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(7, $excel_row, $row->NombreFranquicia);
		   $object->getActiveSheet()->setCellValueByColumnAndRow(8, $excel_row, $row->Autoriza);
		   
		   $excel_row++;
		}

	  $object_writer = PHPExcel_IOFactory::createWriter($object, 'Excel5');
	  header('Content-Type: application/vnd.ms-excel');
	  header('Content-Disposition: attachment;filename="Reporte General de Clientes.xls"');
	  $object_writer->save('php://output');
 }

}