<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Administrador general)
class ServiciosR extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Administrador/Servicios_Model');
		$this->load->library(array('session','form_validation'));
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal FranquiciasR_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReZona']=$this->Servicios_Model->Buscarzona();
		$data['ReModel']=$this->Servicios_Model-> BuscarModelo();
		$data['ReTipo']=$this->Servicios_Model-> BuscarTipo();
		$this->load->view('reportes/Administrador/MenuServicios',$data);
		$this->load->view('layout/footer');
	}
}
		//Función que busca a la franquicia de acuerdo la zona con la que se logueo el usuario
	public function buscarporzona()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('zona','Zona_IdZona= IdZona','inner');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Servicios_Model->buscarporzona(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarServicios_view',$data);
		$data['ReZona']=$this->Servicios_Model->Buscarzona();
		$this->load->view('layout/footer');
	}
}
	//Función que busca a la franquicia de acuerdo al modelo.
    public function buscarpormodelo()
    {
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('modelo','Modelo_IdModelo = IdModelo','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Servicios_Model->buscarpormodelo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,	
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarServicios_view',$data);
		$data['ReModel']=$this->Servicios_Model->buscarpormodelo();
		$this->load->view('layout/footer');
		}
	}
	
	public function buscarportipo()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('tiposervicio','TipoServicio_IdTipoServicio = IdTipoServicio','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Servicios_Model->buscarportipo(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,			
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarServicios_view',$data);
		$data['ReTipo']=$this->Servicios_Model->buscarportipo();
		$this->load->view('layout/footer');
		}
	}
    public function buscar()
    {
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('reportes/Administrador/BuscarServicios_view',$data);
		$data['ReZona']=$this->Servicios_Model->Buscarzona();
		$data['ReModel']=$this->Servicios_Model->BuscarModelo();
		$data['ReTipo']=$this->Servicios_Model->BuscarTipo();
		$this->load->view('layout/footer');
    }
}