<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará aque el modulo realize sus funciones(Franquiciatario.)
class RUsuarios extends CI_Controller
{
	//Construtor que manda a traer las librerias de sesión y validación
	//Manda a llamar el modelo
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/Usuarios_model');
		//cargamos la libreria DOMPDF previamente se debe realizar el archivo MydomPDF para la conexion del la libreria y el controlador.
    	$this->load->library('mydompdf');
		$this->load->library(array('session','form_validation')); 
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal Usuarios_view
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
        $data['Franquicias']=$this->Usuarios_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
    	
    	$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('usuarios')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReRol']=$this->Usuarios_model-> BuscarRol();
		$this->load->view('reportes/Franquiciatario/Usuarios_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//creacion del reporte general de Usuarios
	public function ReporteUGeneral()
	{
     	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
        $data['Franquicias']=$this->Usuarios_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
    	$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data['consulta']=$this->db->get('usuarios')->result();
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReRol']=$this->Usuarios_model-> BuscarRol();	
		$html=($this->load->view('reportes/Franquiciatario/ReporteUsuarioG', $data, true));
    	$this->mydompdf->load_html($html);	
    	$this->mydompdf->set_paper('a4', 'landscape'); 
   		$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("Reporte General de Usuarios.pdf", array("Attachment" => false));
    	$this->load->view('layout/footer');
 		}
	}

	//Consulta para buscar por rol al usuario.
 	public function buscarporrol()
 	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->Usuarios_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
		$this->db->select('*');
	    $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('rol','Rol_IdRol = IdRol','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->Usuarios_model->buscarporrol(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$data['ReRol']=$this->Usuarios_model->BuscarRol();
		$html=($this->load->view('reportes/Franquiciatario/ReportePorRolF_Pdf', $data, true));
    	$this->mydompdf->load_html($html);	
    	$this->mydompdf->set_paper('a4', 'landscape'); 
   		$this->mydompdf->render();
	    $this->mydompdf->set_base_path('./assets/dist/css/dompdf1.css'); //agregar de nuevo el css
    	$this->mydompdf->stream("Reporte de Usuarios Por Rol.pdf", array("Attachment" => false));
		$this->load->view('layout/footer');
    	}
	}

	//Función que busca solo los datos que fueron seleccionados.
 	public function buscar()
 	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$data = array('result' => '');
		}
		$this->load->view('layout/headerFran');
		$this->load->view('layout/menuFranquicia');
		$this->load->view('reportes/Franquiciatario/BuscarUsuarios_view',$data);
		$data['ReRol']=$this->Usuarios_model->BuscarRol();
		$this->load->view('layout/footer');
   	}

	 //funcion para mandar a traer los datos solo del usuario logueado.
	public function BuscarFranquicia()
	{
	     $this->db->from('usuarios');
	     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
	     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
	     $query=$this->db->get();
	     if ($query->num_rows() > 0) { 
	     foreach($query->result() as $row) 
	     $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
	     $query->free_result(); 
	     return $arrDatos; }
    }
}