<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class ReporteIngresos extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('reportes/Franquiciatario/ReporteIngresos_Model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper('url'); 
	}

	public function index()
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
			$this->load->view('layout/headerFran');
			$this->load->view('layout/menuFranquicia');
			$this->load->view('reportes/Franquiciatario/ReporteIngresos');	
			$this->load->view('layout/footer');
		}

	}


	public function reporteIngresos(){
		$inicio = date("Y-m-d", strtotime($this->input->post('finicio')));
		$fin = date("Y-m-d", strtotime($this->input->post('ffin')));
		$query = [];
		$data = [];
		$query['ventasGeneral'] = $this->ReporteIngresos_Model->reporteIngresosM($inicio,$fin);
		$query['pagosServicios'] = $this->reportePagosServicios($inicio,$fin);
		$query['pagosPromociones'] = $this->reportePagosPromociones($inicio,$fin);
		$query['pagosProductos'] = $this->reportePagosProductos($inicio,$fin);

 		if(count($query['ventasGeneral']) != null ){
			foreach($query['ventasGeneral'] as $vg) {
				if($vg[8] == 1){
						$vg[8] = "TARJETA DE CRÉDITO";
					}
					else if($vg[8] == 2){
						$vg[8] = "TARJETA DE DÉBITO";
					}
					else {
						$vg[8] = "";
					}
				$data[] = array(
					$vg[0],
					date("d-m-Y", strtotime($vg[1])),		
					$vg[2],
					$vg[3],
					date("d-m-Y H:i:s", strtotime($vg[4])),
					$vg[5],
					$vg[6],
					$vg[7],
					$vg[8],
				);
			}	
		}	

		if(count($query['pagosServicios']) != null ){
			foreach($query['pagosServicios'] as $ps) {
				$data[] = array(
					$ps[0],
					date("d-m-Y", strtotime($ps[1])),		
					$ps[2],
					$ps[3],
					date("d-m-Y H:i:s", strtotime($ps[4])),
					$ps[5],
					$ps[6],
					$ps[7],
					$ps[8],
				);
			}	
		}
		if(count($query['pagosPromociones']) != null ){
			foreach($query['pagosPromociones'] as $pp) {
				$data[] = array(
					$pp[0],
					date("d-m-Y", strtotime($pp[1])),		
					$pp[2],
					$pp[3],
					date("d-m-Y H:i:s", strtotime($pp[4])),
					$pp[5],
					$pp[6],
					$pp[7],
					$pp[8],
				);
			}	
		}
		if(count($query['pagosProductos']) != null ){
			foreach($query['pagosProductos'] as $ppr) {
				if($ppr[8] == 1){
						$ppr[8] = "TARJETA DE CRÉDITO";
					}
					else if($ppr[8] == 2){
						$ppr[8] = "TARJETA DE DÉBITO";
					}
					else {
						$ppr[8] = "";
					}
				$data[] = array(
					$ppr[0],
					date("d-m-Y H:i:s", strtotime($ppr[1])),		
					$ppr[2],
					$ppr[3],
					date("d-m-Y H:i:s", strtotime($ppr[4])),
					$ppr[5],
					$ppr[6],
					$ppr[7],
					$ppr[8],
				);
			}	
		}

		echo json_encode($data );
	}





	public function reportePagosServicios($inicio,$fin){

		$query= $this->ReporteIngresos_Model->reportePagosServicios($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){
			foreach($query['F2']->result() as $pago) {
				$data[] = array(
					$pago->folio2,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					date("d-m-Y H:i:s", strtotime($pago->Fecha2)),
					$pago->Usuario2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$pago->TipoTarjeta2,
				);
			}	
		}


		if(count($query['F3']->result()) != null ){
			foreach($query['F3']->result() as $pago) {
				$data[] = array(
					$pago->folio3,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					date("d-m-Y H:i:s", strtotime($pago->Fecha3)),
					$pago->Usuario3,
					$pago->Contado3,
					$pago->CTarjeta3,
					$pago->TipoTarjeta3,
				);
			}
		}


		if(count($query['F4']->result()) != null ){
			foreach($query['F4']->result() as $pago) {
				$data[] = array(
					$pago->folio4,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					date("d-m-Y H:i:s", strtotime($pago->Fecha4)),
					$pago->Usuario4,
					$pago->Contado4,
					$pago->CTarjeta4,
					$pago->TipoTarjeta4,

				);
			}
		}
		if(count($query['F2G']->result()) != null ){
			foreach($query['F2G']->result() as $pago) {
				$data[] = array(
					$pago->folio2,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					date("d-m-Y H:i:s", strtotime($pago->Fecha2)),
					$pago->Usuario2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$pago->TipoTarjeta2,

				);
			}	
		}
		if(count($query['F3G']->result()) != null ){
			foreach($query['F3G']->result() as $pago) {
				$data[] = array(
					$pago->folio3,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					date("d-m-Y H:i:s", strtotime($pago->Fecha3)),
					$pago->Usuario3,
					$pago->Contado3,
					$pago->CTarjeta3,
					$pago->TipoTarjeta3,

				);
			}	
		}
		if(count($query['F4G']->result()) != null ){
			foreach($query['F4G']->result() as $pago) {
				$data[] = array(
					$pago->folio4,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreServicio,
					date("d-m-Y H:i:s", strtotime($pago->Fecha4)),
					$pago->Usuario4,
					$pago->Contado4,
					$pago->CTarjeta4,
					$pago->TipoTarjeta4,

				);
			}	
		}
		/*echo json_encode($data);*/
		return $data;


	}	



	public function reportePagosPromociones($inicio,$fin){
		/*$inicio = $this->input->post('finicio');
		$fin = $this->input->post('ffin');*/
		$query= $this->ReporteIngresos_Model->reportePagosPromociones($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){
			foreach($query['F2']->result() as $pago) {
				$data[] = array(
					$pago->folio2,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombrePromocion,
					date("d-m-Y H:i:s", strtotime($pago->Fecha2)),
					$pago->Usuario2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$pago->TipoTarjeta2,
				);
			}	
		}


		if(count($query['F3']->result()) != null ){
			foreach($query['F3']->result() as $pago) {
				$data[] = array(
					$pago->folio3,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombrePromocion,
					date("d-m-Y H:i:s", strtotime($pago->Fecha3)),
					$pago->Usuario3,
					$pago->Contado3,
					$pago->CTarjeta3,
					$pago->TipoTarjeta3,
				);
			}
		}


		if(count($query['F4']->result()) != null ){
			foreach($query['F4']->result() as $pago) {
				$data[] = array(
					$pago->folio4,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombrePromocion,
					date("d-m-Y H:i:s", strtotime($pago->Fecha4)),
					$pago->Usuario4,
					$pago->Contado4,
					$pago->CTarjeta4,
					$pago->TipoTarjeta4,
				);
			}
		}

		/*echo json_encode($data);*/
		return $data;


	}


	public function reportePagosProductos($inicio,$fin){
		/*$inicio = $this->input->post('finicio');
		$fin = $this->input->post('ffin');*/
		$query= $this->ReporteIngresos_Model->reportePagosProductos($inicio,$fin);
		$data = [];

		if(count($query['F2']->result()) != null ){
			foreach($query['F2']->result() as $pago) {

				$data[] = array(
					$pago->folio2,
					date("d-m-Y H:i:s", strtotime($pago->FechaVenta)),		
					$pago->ClienteVenta,
					$pago->NombreProducto,
					date("d-m-Y H:i:s", strtotime($pago->Fecha2)),
					$pago->Usuario2,
					$pago->Contado2,
					$pago->CTarjeta2,
					$pago->TipoTarjeta2,
				);
			}	
		}


		/*echo json_encode($data);*/
		return $data;

	}
}