<?php
class HistoricoAccesos_models extends CI_Model{
    public function __construct()
    {
        parent::__construct();
    }

    public function IdFranquicia(){
        $this->db->select('Franquicias_IdFranquicias');
        $this->db->from('usuarios');
        $this->db->where('IdUsuarios', $this->session->userdata('IdUsuarios'));
        $data=$this->db->get();
        return $data->row()->Franquicias_IdFranquicias;
    }

    public function registroHistoricoA($idUsuario, $ip, $date){
        date_default_timezone_set('America/Mexico_City');
        if ($this->session->userdata('Rol_IdRol') ==1) {
            $franquicia = null;
        }else{
            $franquicia = $this->HistoricoAccesos_models->IdFranquicia();
        }
        $data = array(
            'IdUsuarios' =>  $idUsuario,
            'IdFranquicias' => $franquicia,
            'IpAcceso' => $ip,
            'FechaInicioS' => $date
            //'FechaFinS' =>                  
            //'FechaCreacion' => //date("Y-m-d H:i:s")//'2020-02-10 12:25:52'      
        );
    
        $response = $this->db->insert('historicoaccesos', $data);
        $id=$this->db->insert_id();
    
        if ($response) 
            return $id;
        else
            return "Ocurrio un error...";
    }
    
    public function updateRegistro($id, $fecha){
        $data = array(
            'FechaFinS' => $fecha
          );
          //$this->db->SET($data);
          $this->db->where('IdAcceso', $id);
          $this->db->update('historicoaccesos', $data);
          $res=$this->db->affected_rows();
          return $res."Actualización realizada exitosamente";
    }

    // public function getAccesos($inicio,$fin){
    //     $this->db->select('*');
    //     $this->db->from('historicoaccesos');
    //     //$this->db->where('IdUsuarios', $this->session->userdata('IdUsuarios'));
    //     $data1=$this->db->get();
    //     $query= $data1->result_array();

    //     if ($query) {
    //         return $query;
    //     }else{
    //         return "ErrorModel";
    //     }
    // }


    public function getAccesos($inicio,$fin){
        $data = [];
        $data['F2'] = $this->getAccesosF($inicio,$fin,'a.FechaCreacion');
        //$data['F3'] = $this->prueba($inicio,$fin,'a.FechaCreacion');
        return $data;
    }
    
      public function getAccesosF($inicio,$fin, $fecha){
        $idFranquicia =  $this->IdFranquicia();
    
        $this->db->select('a.IdAcceso, a.IdUsuarios,a.IdFranquicias, a.IpAcceso, a.FechaInicioS, a.FechaFinS, a.FechaCreacion, a.FechaModificacion, u.NombreUsuario'); 
        $this->db->from('usuarios u');
        $this->db->join('historicoaccesos a','u.IdUsuarios = a.IdUsuarios','inner');
        $this->db->where('a.IdFranquicias', $idFranquicia); 
        $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
        $this->db->where( $fecha.'<=', $fin.' 23:59:59');
        $query = $this->db->get();
        return $query;
          
    }

    public function prueba($fechaInicio, $fechaFin){
        $idFranquicia =  $this->IdFranquicia();
        $this->db->select('a.IdAcceso, a.IdUsuarios,a.IdFranquicias, a.IpAcceso, a.FechaInicioS, a.FechaFinS, a.FechaCreacion, a.FechaModificacion, u.NombreUsuario'); 
        $this->db->from('usuarios u');
        $this->db->join('historicoaccesos a','u.IdUsuarios = a.IdUsuarios','inner');
        $this->db->where('a.IdFranquicias', $idFranquicia); 
        $this->db->where( 'a.FechaInicioS >=', $fechaInicio.' 00:00:00');
        $this->db->where( 'a.FechaInicioS<=', $fechaFin.' 23:59:59');
        $query = $this->db->get();
        return $query;
    }
}
?>