<?php
class PromocionEmergenteA_model extends CI_Model { 
   public function __construct() {
      parent::__construct();
   }

   public function buscarPromociones()
   {
      $this->db->select('*');
		$this->db->join('categoria','Categoria_IdCategoria = IdCategoria','inner');
		$this->db->join('zona','zona_IdZona = IdZona','inner');
		$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
      $this->db->where('TipoPromocion_IdTipoPromocion',4);
      $query=$this->db->get('promociones');
      $data=[];
      if($query->num_rows()>0){
         foreach($query->result() as $fila)
         {
            $botones="<a href='".base_url()."promociones/administrador/promocionemergenteA/editar/".$fila->IdPromociones."' class='label label-primary'><span class='glyphicon glyphicon-pencil'></a></span>"."&nbsp;&nbsp;"."<a onclick= 'if(confirma() == false) return false' href='".base_url()."promociones/administrador/promocionemergenteA/eliminar/".$fila->IdPromociones."' class='label label-danger'> <span class='glyphicon glyphicon-trash'></a></span>";
            $data[]=array(
               $fila->FolioPromocion,
               $fila->NombrePromocion,
               $fila->NombreCategoria,
               $fila->Precio,
               $fila->FechaInicioPromocion,
               $fila->FechaTerminoPromocion,
               $fila->Estatus,
               $botones
            );
         }
      }
      echo json_encode($data);

   }
  public function guardar($parametro){//guarda los datos de una nueva promoción en la bd
      $campos=array(  
         'NombrePromocion' => $parametro['NombrePromocion'],
         'FolioPromocion' => $parametro['FolioPromocion'],
         'Precio' => $parametro['Precio'],
         'SesionesPromocion' => $parametro['SesionesPromocion'],
         'DuracionPromocion' => $parametro['DuracionPromocion'],
         'DescripcionPromocion' => $parametro['DescripcionPromocion'],
         'FechaInicioPromocion' => $parametro['FechaInicioPromocion'],
         'FechaTerminoPromocion' => $parametro['FechaTerminoPromocion'],
         'Estatus' => $parametro['Estatus'],
         'tipopromocion_IdTipoPromocion' => $parametro['tipopromocion_IdTipoPromocion'],
         'categoria_IdCategoria' => $parametro['categoria_IdCategoria'],
         'zona_IdZona' => $parametro['zona_IdZona'],
          'ClasificacionPromocion' => $parametro['ClasificacionPromocion'],
         'ClasePromocion' => $parametro['ClasePromocion'],
         'franquicias_IdFranquicias' => $parametro['franquicias_IdFranquicias']
            );
          $this->db->insert('promociones',$campos);
          $id=$this->db->insert_id();
          $res=$this->db->affected_rows();
          if($res == 1){
            $folio=$campos['FolioPromocion'].$id;
            $this->db->set('FolioPromocion', $folio);
            $this->db->where('IdPromociones', $id);
            $this->db->update('promociones');
            $actualizacion=$this->db->affected_rows();
            if($actualizacion>0)
            {
            // echo "<script>alert('Datos guardados correctamente');</script>";
            // redirect('promociones/administrador/promocionEmergenteA','refresh');
            echo "<script>alert('Datos guardados correctamente');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";

            }else{
               // echo "<script>alert('Los datos no pudierón ser guardados correctamente');</script>";
               // redirect('promociones/administrador/promocionEmergenteA','refresh');
               echo "<script>alert('Los datos no pudierón ser guardados correctamente');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";

            }
          }else {
                // echo "<script>alert('Los datos no pudierón ser guardados correctamente');</script>";
                // redirect('promociones/administrador/promocionEmergenteA','refresh');
                echo "<script>alert('Los datos no pudierón ser guardados correctamente');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";            
          }
        }
   
   public function eliminar ($id){//elimina una promoción por medio de la variable $id que es pasada por el controlador
      
      $this->db->where('IdPromociones', $id);
      $this->db->delete('promociones');
      $res=$this->db->affected_rows();
      if($res>0){
        //Muestra una alerta cuando se realizo
          // echo "<script>alert('Los datos se han eliminado correctamente');</script>";
          // redirect('promociones/administrador/promocionEmergenteA','refresh');
           echo "<script>alert('Los datos se han eliminado correctamente');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";
      }else{
        //Muestra una alerta cuando no se realizo
          // echo "<script>alert('Error, no se pudierón eliminar los datos debido a que se estan usuando en otras tablas');</script>";
          // redirect('promociones/administrador/promocionEmergenteA','refresh');
           echo "<script>alert('Error, no se pudierón eliminar los datos debido a que se estan usuando en otras tablas');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";
      }
   }

 public function obtenerenlace ($id){//permite acceder al id de la promoción que se desea editar por medio de la variable $id que es pasada por el controlador



      $this->db->where('IdPromociones', $id);
      $query=$this->db->get('promociones');


      if($query->num_rows()>0){
         return $query;

      }else{
         return FALSE;
      }

   }
   function editarenlace ($IdPromociones, $data)//permite guardar en la bd la información que se modificó de la promoción
   {
      $this->db->where('IdPromociones', $IdPromociones);
      $this->db->update('promociones', $data);
      $res=$this->db->affected_rows();
          if($res == 1){
            // echo "<script>alert('Datos guardados correctamente');</script>";
            // redirect('promociones/administrador/promocionEmergenteA','refresh');
             echo "<script>alert('Datos guardados correctamente');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";
          }else {
                // echo "<script>alert('Los datos no pudierón ser guardados correctamente');</script>";
                // redirect('promociones/administrador/promocionEmergenteA','refresh');
                echo "<script>alert('Los datos no pudierón ser guardados correctamente');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";
          }
   }




     function buscar($query) {//Realiza una búsqueda en la bd por medio de la variable $query que es pasada por el controlador (nombre de la promoción)
    $this->db->select('*');
    $this->db->from('promociones');
    $this->db->join('Categoria','Categoria_IdCategoria=IdCategoria','inner');
    $this->db->join('zona','zona_IdZona = IdZona','inner');
    $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
    $this->db->where('TipoPromocion_IdTipoPromocion','4');
    $this->db->like('NombrePromocion', $query);

    $query = $this->db->get();

    if ($query->num_rows() > 0){
      return $query;
    }else{
      // echo "<script>alert('No se encontrarón los datos solicitados');</script>";
      //     redirect('promociones/administrador/promocionEmergenteA','refresh');
      echo "<script>alert('No se encontrarón los datos solicitados');
                 window.location.href='".base_url()."promociones/administrador/promocionEmergenteA';
                 </script>";
    }
  }

 public function BuscarTipoPromocion(){// Realiza una consulta a la bd para buscar los tipos de promoción que existen y poder mandar el resultado
     $query = $this->db-> query('SELECT IdTipoPromocion,TipoPromocion FROM tipopromocion where IdTipoPromocion = 4'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdTipoPromocion, ENT_QUOTES)] = htmlspecialchars($row->TipoPromocion, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }

 public function BuscarCategoria(){// Realiza una consulta a la bd para buscar las categorías que existen y poder mandar el resultado
     $query = $this->db-> query('SELECT IdCategoria,NombreCategoria FROM categoria'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdCategoria, ENT_QUOTES)] = htmlspecialchars($row->NombreCategoria, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }
   public function BuscarZona($IdFranquicias){// Realiza una consulta a la bd para buscar los clientes que existen y poder mandar el resultado
      $this->db->select('*');
      $this->db->from('franquicias');
      $this->db->join('zona','Zona_IdZona=IdZona','inner');
      $this->db->where('IdFranquicias',$IdFranquicias);
      $query=$this->db->get();
      return $query->result_array();
         }

      public function BuscarZonaRe(){// Realiza una consulta a la bd para buscar los clientes que existen y poder mandar el resultado
       $query = $this->db-> query('SELECT IdZona,NombreZona FROM zona'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdZona, ENT_QUOTES)] = htmlspecialchars($row->NombreZona, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }


  


      public function BuscarFranquicia(){// Realiza una consulta a la bd para buscar las franquicias que existen y poder mandar el resultado
     $query = $this->db-> query('SELECT IdFranquicias,NombreFranquicia FROM franquicias'); 
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
         $arrDatos[htmlspecialchars($row->IdFranquicias, ENT_QUOTES)] = htmlspecialchars($row->NombreFranquicia, ENT_QUOTES); 
            $query->free_result(); 
            return $arrDatos; }
         }



}

  