<?php
class ReporteGastos_Model extends CI_Model
{ 
  public function ingresosDesglosados($inicio,$fin){
    
    // $data = [];
    // $data['F2'] = $this->reporteGastosTotalesF($inicio,$fin,'g.FechaCreacion');
    // return $data;
  }

  public function reporteGastosTotales($inicio,$fin){
    $data = [];
    $data['F2'] = $this->reporteGastosTotalesF($inicio,$fin,'g.FechaCreacion');
    return $data;
  }

  public function reporteGastosTotalesF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select('g.IdGasto, g.NombreArchivo,g.FechaCreacion, g.Tipo, g.NombreGasto, g.Cantidad, g.Precio, g.Total, u.NombreUsuario, g.Ruta'); 
    $this->db->from('usuarios u');
    $this->db->join('gastos g','u.IdUsuarios = g.IdUsuarios','inner');
    $this->db->where('g.IdFranquicias', $idFranquicia); 
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $query = $this->db->get();
    return $query;
      
  }

  public function reporteGastosPorTipo($inicio,$fin, $tipo){
    $data = [];
    $data['F2'] = $this->reporteGastosPorTipoF($inicio,$fin,'g.FechaCreacion', $tipo);
    return $data;
  }

  public function reporteGastosPorTipoF($inicio,$fin, $fecha, $tipo){
    $idFranquicia =  $this->BuscarIdFranquicia();
    $this->db->select('g.IdGasto, g.NombreArchivo,g.FechaCreacion, g.Tipo, g.NombreGasto, g.Cantidad, g.Precio, g.Total, u.NombreUsuario, g.Ruta'); 
    $this->db->from('usuarios u');
    $this->db->join('gastos g','u.IdUsuarios = g.IdUsuarios','inner');
    $this->db->where('g.IdFranquicias', $idFranquicia); 
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('g.Tipo', $tipo);
    $query = $this->db->get();
    return $query;
      
  }

   public function BuscarIdFranquicia(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0) { 
        foreach($query->result() as $row) 
              return $row->IdFranquicias; }
  } 
  

}
?>