<?php
class ReporteIngresosT_Model extends CI_Model
{ 

  public function reportePagosServicios($inicio,$fin){
    $data = [];
    $idFranquicia =  $this->BuscarIdFranquicia();
 
    $data['F1'] = $this->reportePagosServiciosF($inicio,$fin,'Fecha1');
    $data['F2'] = $this->reportePagosServiciosF($inicio,$fin,'Fecha2');
    $data['F3'] = $this->reportePagosServiciosF($inicio,$fin,'Fecha3');
    $data['F4'] = $this->reportePagosServiciosF($inicio,$fin,'Fecha4');
    $data['F1G'] = $this->reportePagosServiciosGeneralesF($inicio,$fin,'Fecha1');
    $data['F2G'] = $this->reportePagosServiciosGeneralesF($inicio,$fin,'Fecha2');
    $data['F3G'] = $this->reportePagosServiciosGeneralesF($inicio,$fin,'Fecha3');
    $data['F4G'] = $this->reportePagosServiciosGeneralesF($inicio,$fin,'Fecha4');

    return $data;
  }

  public function reportePagosServiciosF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();
    $this->db->select("ventas.folio,FolioVenta1, FechaVenta, ClienteVenta,VendedorUsuario, NombreServicio, SesionesS, Comentario, Fecha1, Contado1, TipoTarjeta1, CTarjeta1, TipoTarjeta1A, CTarjeta1A, Usuario1, Fecha2, folio2,FolioVenta2, Contado2, TipoTarjeta2, CTarjeta2, Usuario2, Fecha3, folio3,FolioVenta3, Contado3, TipoTarjeta3, CTarjeta3, Usuario3, Fecha4, folio4,FolioVenta4, Contado4, CTarjeta4, TipoTarjeta4, Usuario4");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('serviciosfranquicias','IdServiciosFranquicias=serviciosfranquicias_IdServiciosFranquicias','inner');
    $this->db->join('serviciosgenerales','IdServiciosGenerales=ServiciosGenerales_IdServiciosGenerales','inner');
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_serviciosfranquicias');
    $query = $this->db->get();
    $this->db->save_queries = FALSE;
    return $query;
  }

  public function reportePagosServiciosGeneralesF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("ventas.folio,FolioVenta1, FechaVenta, ClienteVenta,VendedorUsuario, NombreServicio, SesionesS, Comentario, Fecha1, Contado1, TipoTarjeta1, CTarjeta1, TipoTarjeta1A, CTarjeta1A, Usuario1, Fecha2, folio2,FolioVenta2, Contado2, TipoTarjeta2, CTarjeta2, Usuario2, Fecha3, folio3,FolioVenta3, Contado3, TipoTarjeta3, CTarjeta3, Usuario3, Fecha4, folio4,FolioVenta4, Contado4, CTarjeta4, TipoTarjeta4, Usuario4");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('serviciosgenerales','Codigo_Servicios=serviciosfranquicias_IdServiciosFranquicias ','inner');
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_serviciosfranquicias');
    $query = $this->db->get();
    $this->db->save_queries = FALSE;
    return $query;
      
  }


  public function reportePagosPromociones($inicio,$fin){
    $data = [];
    $data['F1'] = $this->reportePagosPromocionesF($inicio,$fin,'Fecha1');
    $data['F2'] = $this->reportePagosPromocionesF($inicio,$fin,'Fecha2');
    $data['F3'] = $this->reportePagosPromocionesF($inicio,$fin,'Fecha3');
    $data['F4'] = $this->reportePagosPromocionesF($inicio,$fin,'Fecha4');


    return $data;
  }


  public function reportePagosPromocionesF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("*");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('promociones','IdPromociones=promociones_IdPromociones','inner');
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_promociones');
    $query = $this->db->get();
    $this->db->save_queries = FALSE;
    return $query;
      
  }



   public function reportePagosProductos($inicio,$fin){
    $data = [];
    $data['F1'] = $this->ProductosF($inicio,$fin,'Fecha1');
    $data['F2'] = $this->ProductosF($inicio,$fin,'Fecha2');

    return $data;
  }


  public function ProductosF($inicio,$fin, $fecha){
    $idFranquicia =  $this->BuscarIdFranquicia();

    $this->db->select("*");
    $this->db->join('ventas','IdVentas=ventas_idVentas','inner');
    $this->db->join('productosfranquicias','IdProductosFranquicias=productosfranquicias_IdProductosFranquicias','inner');
    $this->db->join('productosgenerales','IdProductosGenerales=ProductosGenerales_IdProductosGenerales','inner');
    $this->db->where('ventas.franquicias_IdFranquicias',$idFranquicia);
    $this->db->where( $fecha.'>=', $inicio.' 00:00:00');
    $this->db->where( $fecha.'<=', $fin.' 23:59:59');
    $this->db->where('ventas.EstatusV', 'ACTIVA');
    $this->db->from('ventas_has_productosfranquicias');
    $query = $this->db->get();
    $this->db->save_queries = FALSE;
    return $query;
      
  }
 
   public function BuscarIdFranquicia(){
     $this->db->select('*');
     $this->db->from('usuarios');
     $this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
     $this->db->where('IdUsuarios',$this->session->userdata('IdUsuarios'));
     $query=$this->db->get();
       if ($query->num_rows() > 0)
       { 
        foreach($query->result() as $row) 
           {  return $row->IdFranquicias; }
      }
  } 
  

}
?>
