<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class ClienteA extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('clientes/administrador/accionescliente_model');
		$this->load->library(array('session','form_validation'));
		$this->load->helper(array('url'));
	
	}

public function index(){ //pagina principal de modulo clientes, aqui se muestra la lista de los clientes
	if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
	$this->db->select('*');
	$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
	$this->db->order_by('NombreFranquicia','asc');
	$data['consulta']=$this->db->get('clientes')->result();

		
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->accionescliente_model->BuscarFranq(); 
		$this->load->view('clientes/administrador/listacliente_view',$data);
		$this->load->view('layout/footer');
	
	}}


	public function agregar(){ //funcion para agregar un nuevo cliente
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		//$datos['ReCliente']=$this->accionescliente_model->BuscarCliente(); // se mostraran en una lista desplegable los nombres de los clientes
		
		$datos['ReFranquicia']=$this->accionescliente_model->BuscarFranquicia();// se mostraran en un alista desplegable los nombres de las franquicias
		$this->load->view('clientes/administrador/agregarcliente_view',$datos);
		$this->load->view('layout/footer');
	
	}}

public function guardar(){ // esta funcion manda a traer todos los datos que tiene cargados la vista para posteriormente mandarlos al modelo y poder guardar los datos introducidos
if(count($_POST)>0){ // permite acceder a la pagina solamente si se a logueado antes
	$Autoriza=0;
	if(isset($_POST["Autoriza"])){$Autoriza=1;}

		$parametro['NombreCliente']= $this->input->post('txt_nombrecliente')." ".$parametro['ApellidoPaterno']= $this->input->post('txt_apaterno')." ".$parametro['ApellidoMaterno']= $this->input->post('txt_amaterno');
		$parametro['FechaNacimientoCliente']= $this->input->post('txt_fechanac');
		$parametro['TelefonoCliente']= $this->input->post('txt_TelefonoCliente');
		$parametro['CelularCliente']= $this->input->post('txt_CelularCliente');
		$parametro['CorreoCliente']= $this->input->post('txt_CorreoCliente');
		$parametro['DireccionCliente']= $this->input->post('txt_DireccionCliente');
		$parametro['EdadCliente']= $this->input->post('txt_EdadCliente');
		$parametro['SexoCliente']= $this->input->post('txt_SexoCliente');
		$parametro['EstadoCivil']= $this->input->post('txt_estadociv');
		$parametro['Ocupacion']= $this->input->post('txt_ocupacion');
		$parametro['MedioInformacion']= $this->input->post('txt_medio');
		$parametro['RecomendadoPor']= $this->input->post('txt_recomendado');
		$parametro['Franquicias_IdFranquicias']= $this->input->post('txt_franquicia');
		$parametro['Autoriza']= $this->input->post('Autoriza');
	

		$this->accionescliente_model->guardar($parametro);
		// echo "<script>alert('Datos guardados correctamente');</script>";
		// redirect(base_url().'clientes/administrador/clienteA', 'refresh');
		echo "<script>alert('Datos guardados correctamente');
  window.location.href='/SM/clientes/administrador/ClienteA';
  </script>";

	}
}

	public function eliminar() { // esta funcion permite eliminar un cliente mandando a traer su id que estara en el segmento 5 de la url
		 $id= $this->uri->segment(5); //aca decimos que la variable $id sera el segmento 5 de la url
		 $this->accionescliente_model->eliminar($id); //eliminar el cliente que tenga como id el $id
		// echo "<script>confirm('extas seguro de e');</script>";	 
	}


	public function editar(){ //esta funcion nos permite editar los datos del cliente, mandando a traer sus datos por medio de su id que será el segmento 5 de la url
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {

		$id= $this->uri->segment(5); //la variable $id es el segmento 5 de la url que se obtiene de la funcion obtener enlace
		$obtenerenlace = $this->accionescliente_model->obtenerenlace($id); // se manda a traer la funcion obtener enlace para obtener el id del cliente
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdClientes = $fila->IdClientes;
				$NombreCliente=$fila->NombreCliente;
				$FechaNacimientoCliente=$fila->FechaNacimientoCliente;
				$TelefonoCliente = $fila->TelefonoCliente;
				$CelularCliente=$fila->CelularCliente;
				$CorreoCliente=$fila->CorreoCliente;
				$DireccionCliente = $fila->DireccionCliente;
				$EdadCliente=$fila->EdadCliente;
				$SexoCliente=$fila->SexoCliente;
				$EstadoCivil = $fila->EstadoCivil;
				$Ocupacion=$fila->Ocupacion;
				$MedioInformacion=$fila->MedioInformacion;
				$RecomendadoPor = $fila->RecomendadoPor;
				$Franquicias_IdFranquicias=$fila->Franquicias_IdFranquicias;
				$Autoriza=$fila->Autoriza;
				
				

			}
			$data = array( //en un arreglo se mandan todo los datos del cliente a la vista para poder editarlos
				'IdClientes' => $IdClientes,
				'NombreCliente' => $NombreCliente,
				'FechaNacimientoCliente' => $FechaNacimientoCliente,
				'TelefonoCliente' => $TelefonoCliente,
				'CelularCliente' => $CelularCliente,
				'CorreoCliente' => $CorreoCliente,
				'DireccionCliente' => $DireccionCliente,
				'EdadCliente' => $EdadCliente,
				'SexoCliente' => $SexoCliente,
				'EstadoCivil' => $EstadoCivil,
				'Ocupacion' => $Ocupacion,
				'MedioInformacion' => $MedioInformacion,
				'RecomendadoPor' => $RecomendadoPor,
				'Franquicias_IdFranquicias' => $Franquicias_IdFranquicias,
				'Autoriza' => $Autoriza);
			}else{
				$data ='';
				return FALSE;
			
		}

   
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReCliente']=$this->accionescliente_model->BuscarCliente();
		$data['ReFranquicia']=$this->accionescliente_model->BuscarFranquicia();
		$this->load->view('clientes/administrador/editarcliente_view', $data);
		$this->load->view('layout/footer');
	}
}

	public function editarenlace () // con esta funcion podemos realizar cambios a los datos del cliente, estos datos se pasan al modelo para poder guardarlos en la base de datos
	{
		$IdClientes= $this -> uri->segment(5);
		$data=array(
			'IdClientes' => $this -> input ->post('IdClientes', true),
			'NombreCliente' => $this -> input ->post('NombreCliente', true),
			'FechaNacimientoCliente' => $this -> input ->post('FechaNacimientoCliente', true),
			'TelefonoCliente' => $this -> input ->post('TelefonoCliente', true),
			'CelularCliente' => $this -> input ->post('CelularCliente', true),
			'CorreoCliente' => $this -> input ->post('CorreoCliente', true),
			'DireccionCliente' => $this -> input ->post('DireccionCliente', true),
			'EdadCliente' => $this -> input ->post('EdadCliente', true),
			'SexoCliente' => $this -> input ->post('SexoCliente', true),
			'EstadoCivil' => $this -> input ->post('EstadoCivil', true),
			'Ocupacion' => $this -> input ->post('Ocupacion', true),
			'MedioInformacion' => $this -> input ->post('MedioInformacion', true),
			'RecomendadoPor' => $this -> input ->post('RecomendadoPor', true),
			'Franquicias_IdFranquicias' => $this -> input ->post('Franquicias_IdFranquicias', true)	,
			'Autoriza' => $this -> input ->post('Autoriza', true)	
			);
		$this->accionescliente_model->editarenlace($IdClientes, $data); // se pasa como parametros el arreglo con todos los datos del cliente y el Id del cliente para mostrar que ahi será donde se guarden los datos.
	}
	
public function buscar () // con esta funcion podemos buscar el nombre de algun cliente y que nos muestre sus datos correspondientes
	{ 
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accionescliente_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}


		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->accionescliente_model->BuscarFranq();
		$this->load->view('clientes/administrador/buscarcliente_view', $data);
		$this->load->view('layout/footer');
	}
}

public function buscarporfranquicia ()
	{ 
if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
	$this->db->join('franquicias','Franquicias_IdFranquicias = IdFranquicias','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accionescliente_model->buscarporfranquicia(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$data['ReFranq']=$this->accionescliente_model->BuscarFranq();
		$this->load->view('clientes/administrador/buscarcliente_view', $data);
		$this->load->view('layout/footer');
	}
}


	public function error(){
 	$idd  =  $this -> uri -> segment ( 5 ,  0 );
    $this->load->view('layout/header');
    $this->load->view('layout/menuAdmin');
    $this->load->view('expediente/administrador/error_view', $id);
    $this->load->view('layout/footer');
    echo $idd;
	}

	public function MostrarCliente(){
		$options ="";
		$IdFranquicias=$this->input->post('IdFranquicias');
		if($IdFranquicias){
			$this->load->model('accionescliente_model');
			$clientes=$this->accionescliente_model->BuscarCliente($IdFranquicias);
			foreach ($clientes as $cliente) {

				echo "<option value='".$cliente['IdClientes']."'>".$cliente['NombreCliente']."</option>";
			}
		}
		
	}
}
