<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
class ModeloA extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('franquicias/modelos/administrador/accionesmodelo_model');
		$this->load->library(array('session','form_validation'));

	}

	public function index(){ //aca se muestra la pantalla principal de los modelos (lista de modelos)
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$this->db->order_by('NombreModelo','asc');
		$result = $this->db->get('modelo');
		$data=array('consulta'=>$result);
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/modelos/administrador/listamodelo_view',$data);
		$this->load->view('layout/footer');
	
	}
}
public function agregar(){ //aca se muestra la vista con los campos correspondeinetes para agregar un nuevo modelo
	if (!$this->session->userdata('Rol_IdRol')){
      redirect('acceso/acceso');
    } else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/modelos/administrador/agregarmodelo_view');
		$this->load->view('layout/footer');
	
	}
}
	public function guardar(){ //Esta función manda los datos que fueron capturados en la vista , al modelo para asi poder guardarlos en la bd

		
		$parametro['NombreModelo']= $this->input->post('txtnombre_modelo');
		$parametro['NoCabinas']= $this->input->post('txtnumero_cabinas');
		$parametro['NoServicios']= $this->input->post('txtnumero_servicios');

		
		$this->accionesmodelo_model->guardar($parametro);

	}

		public function eliminar() { //esta función permite eliminar un modelo por medio de su id, que sera definido por el segmento 5 de la url
		 $id= $this->uri->segment(6);
		 $this->accionesmodelo_model->eliminar($id);
	}

	public function editar(){//esta función permite muestra en un formulario los datos de un modelo que ya han sido guardados anteriormente
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(6);
		$obtenerenlace = $this->accionesmodelo_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdModelo = $fila->IdModelo;
				$NombreModelo=$fila->NombreModelo;
				$NoCabinas=$fila->NoCabinas;
				$NoServicios=$fila->NoServicios;

			}
			$data = array(
				'IdModelo' => $IdModelo,
				'NombreModelo' => $NombreModelo,
				'NoCabinas' => $NoCabinas,
				'NoServicios' => $NoServicios);
			}else{
				$data ='';
				return FALSE;
			
		}
		
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/modelos/administrador/editarmodelo_view', $data);
		$this->load->view('layout/footer');
	}
}
	public function editarenlace ()// esta funcion permite editar los datos de un modelo y manda esta informacion al modelo para que puedan ser guardados en la bd
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$IdModelo= $this -> uri->segment(6);
		$data=array(
			'IdModelo' => $this -> input ->post('IdModelo', true),
			'NombreModelo' => $this -> input ->post('NombreModelo', true),
			'NoCabinas' => $this -> input ->post('NoCabinas', true),
			'NoServicios' => $this -> input ->post('NoServicios', true)		
			);
		$this->accionesmodelo_model->editarenlace($IdModelo, $data);
		// echo "<script>alert('Datos guardados correctamente');</script>";
		// redirect('franquicias/modelos/administrador/modeloA','refresh');
		echo "<script>alert('Modelo de Franquicia registrada correctamente');
		window.location.href='".base_url()."franquicias/modelos/administrador/modeloA';
		</script>";
	}
}
	public function buscar () //esta función permite buscar por medio del nombre un mmodelo en específico y mostrar su información 
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->accionesmodelo_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('franquicias/modelos/administrador/buscarmodelo_view', $data);
		$this->load->view('layout/footer');
	}
}
}
