<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Administrador general)
class ProductoPublico extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->library(array('session','form_validation'));
		$this->load->model('productos/Administrador/productoPublicoA_model');
	}
	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaProductoPublicoA_views
	//Hace la consulta para mostrar todos los productos al público
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$this->db->where('TipoProducto_IdTipoProducto','2');
			$this->db->order_by("NombreCategoria","asc");
		$data['consulta']=$this->db->get('productosgenerales')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('productos/Administrador/listaProductoPublicoA_view',$data);
		$this->load->view('layout/footer');
			}
	}

	//Funcion que manda a traer la vista agregaProductoPublicoA_view para registrar el producto al público 
	public function agregar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
  		$datos['ReCategoria']=$this->productoPublicoA_model->BuscarCategoria();
  		$datos['ReTipo']=$this->productoPublicoA_model->BuscarTipo();
		$this->load->view('productos/Administrador/agregaProductoPublicoA_view',$datos);
		$this->load->view('layout/footer');
		}
	}

	//Funcion que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar()
	{
		$parametro['IdProductosGenerales']="PP".$this->input->post('txt_codigo');
		$parametro['NombreProducto']="PP-".$this->input->post('txt_nombre')." ".$parametro['txt_presentación']= $this->input->post('txt_presentación');
		$parametro['TipoProducto_IdTipoProducto']= $this->input->post('Tipo');
		$parametro['Categoria_IdCategoria'] = $this->input->post('Categoria');
        $parametro['StockMinimo'] = $this->input->post('txt_stoc');
        $parametro['PrecioCompra'] = $this->input->post('text_compra');
        $parametro['PrecioVenta'] = $this->input->post('text_venta');
        $parametro['DescripcionProducto'] = $this->input->post('text_descripcion');
		$this->productoPublicoA_model->guardar($parametro);
		// echo "<script>alert('Datos guardados correctamente');</script>";
		// redirect('productos/Administrador/productoPublico','refresh');	
			echo "<script>alert('Producto al Público registrado correctamente');
		window.location.href='".base_url()."productos/Administrador/productoPublico';
		</script>";
	}

	//Función que elimina al producto 	
	public function eliminar() 
	{
		 $id= $this->uri->segment(5);
		 $this->productoPublicoA_model->eliminar($id);
		// redirect('productos/Administrador/productoPublico');
		 echo "<script>alert('Producto al público eliminado correctamente');
		window.location.href='".base_url()."productos/Administrador/productoPublico';
		</script>";
	}

	//Función que manda a traer la vista editarProductoPublico_view con los datos del producto seleccionado
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->productoPublicoA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdProductosGenerales = $fila->IdProductosGenerales;
				$NombreProducto=$fila->NombreProducto;
				$TipoProducto_IdTipoProducto=$fila->TipoProducto_IdTipoProducto;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$StockMinimo=$fila->StockMinimo;
				$PrecioVenta=$fila->PrecioVenta;
				$PrecioCompra=$fila->PrecioCompra;
				$DescripcionProducto = $fila->DescripcionProducto;
			}$data = array(
				'IdProductosGenerales' => $IdProductosGenerales,
				'NombreProducto' => $NombreProducto,
				'TipoProducto_IdTipoProducto' =>$TipoProducto_IdTipoProducto,		
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'StockMinimo' => $StockMinimo,
				'PrecioVenta' => $PrecioVenta,
				'PrecioCompra' => $PrecioCompra,
				'DescripcionProducto' => $DescripcionProducto);
			}else{
				$data ='';
				return FALSE;
			
		}

		$data['ReCategoria']=$this->productoPublicoA_model->BuscarCategoria();
  		$data['ReTipo']=$this->productoPublicoA_model->BuscarTipo();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('productos/Administrador/editarProductoPublico_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Función que manda a traer la vista editarProductoPublico_view con los datos del producto seleccionado
	public function editarenlace ()
	{
		$IdProductosGenerales= $this -> uri->segment(5);
		$data=array(
		'IdProductosGenerales'=> $this->input->post('IdProductosGenerales',true),
		'NombreProducto'=> $this->input->post('NombreProducto',true),
		'TipoProducto_IdTipoProducto'=> $this->input->post('TipoProducto_IdTipoProducto'),
		'Categoria_IdCategoria' => $this->input->post('Categoria_IdCategoria',true),
        'StockMinimo' => $this->input->post('StockMinimo',true),
        'PrecioVenta' => $this->input->post('PrecioVenta'),
        'PrecioCompra' => $this->input->post('PrecioCompra'),
        'DescripcionProducto' => $this->input->post('DescripcionProducto'),
			);
		$this->productoPublicoA_model->editarenlace($IdProductosGenerales, $data);
		// echo "<script>alert('Datos guardados correctamente');</script>";
		// redirect('productos/Administrador/productoPublico','refresh');
		 echo "<script>alert('Producto al Público modificado correctamente');
		window.location.href='".base_url()."productos/Administrador/productoPublico';
		</script>";
	}

	//Función que manda a traer la vista buscarProductoPublicoA_view  
	//Hace la busqueda del producto seleccionado 
	public function buscar ()
	{
		$this->db->join('categoria','Categoria_IdCategoria=IdCategoria','inner');
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->productoPublicoA_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}
		$data['ReCategoria']=$this->productoPublicoA_model->BuscarCategoria();
  		$data['ReTipo']=$this->productoPublicoA_model->BuscarTipo();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('productos/Administrador/buscarProductoPublicoA_view',$data);
		$this->load->view('layout/footer');
	}

	//Funcion que manda a traer la vista listaProductoPublicoA_view de todos los productos al público registrados
	public function mostrar ()
	{
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->productoPublicoA_model->mostrar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('productos/Administrador/listaProductoPublicoA_view',$data);
		$this->load->view('layout/footer');
	}




	//Función que muestra el tipo del producto 
	public function MostrarTipo()
	{
		$options ="";
		if($this->input->post('IdTipoProducto')){
			$IdTipo=$this->input->post('IdTipoProducto');
			$NombreTipoProducto=$this->productoPublicoA_model->BuscarTipo($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}
	}

	//Función que muestra el tipo de categoría
	public function MostrarCategoria()
	{
		$options ="";
		if($this->input->post('IdCategoria')){
			$IdCategoria=$this->input->post('IdCategoria');
			$NombreCategoria=$this->productoProductoA_model->BuscarCategoria($IdCategoria);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}

	}
	
}