<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Administrador general)
class productosAdicionalesA extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación 
	//Manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->library(array('session','form_validation'));
		$this->load->model('productos/Administrador/productoAdicionalA_model');
	}

	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaProductoAdicionalA_view 
	//Hace la consulta para mostrar todos los productos adicionales
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$this->db->where('TipoProducto_IdTipoProducto','3');
		$this->db->order_by("NombreFranquicia","asc");
		$data['consulta']=$this->db->get('productosfranquicias')->result();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('productos/Administrador/listaProductoAdicionalA_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Funcion que manda a traer la vista agregaProductoAdicionalA_view para registrar el producto al público 
	public function agregar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
  		$datos['ReCategoria']=$this->productoAdicionalA_model->BuscarCategoria();
  		$datos['ReTipo']=$this->productoAdicionalA_model->BuscarTipo();
  		$datos['ReFranquicias']=$this->productoAdicionalA_model->BuscarFranquicia();
  		$datos['ReUsuario']=$this->productoAdicionalA_model->BuscarUsuario();
		$this->load->view('productos/Administrador/agregaProductoAdicionalA_view',$datos);
		$this->load->view('layout/footer');
		}
	}


	//Funcion que guarda los datos ingresados para poder registrarlos en la base de datos 
	public function guardar(){
		$parametro['IdProductosGenerales']="PA".$this->input->post('txt_codigo');
		$parametro['NombreProducto']= "PA-".$this->input->post('txt_nombre')." ".$parametro['txt_presentación']= $this->input->post('txt_presentación');
		$parametro['TipoProducto_IdTipoProducto']= $this->input->post('Tipo');
		$parametro['Categoria_IdCategoria'] = $this->input->post('Categoria');
        $parametro['StockMinimo'] = $this->input->post('txt_stoc');
        $parametro['PrecioVenta'] = $this->input->post('text_venta');
        $parametro['PrecioCompra'] = $this->input->post('text_compra');
        $parametro['DescripcionProducto'] = $this->input->post('text_descripcion');

        $producto=$this->db->insert_id();
        $parametro['IdProductosFranquicias']= "FMAS".$this->input->post('Franquicia').$parametro['txt_codigo']= $this->input->post('txt_codigo');
        $parametro['ProductosGenerales_IdProductosGenerales']=$this->input->post($producto);
        $parametro['PiezasTotales'] = $this->input->post('text_piezas');
        $parametro['Franquicias_IdFranquicias'] = $this->input->post('Franquicia');
        $parametro['Usuarios_IdUsuarios'] = $this->input->post('Usuario');
		$this->productoAdicionalA_model->guardar($parametro);	 
	}

	//Función que elimina al producto
	public function eliminar() {
		 $id= $this->uri->segment(5);
		 $this->productoAdicionalA_model->eliminar($id);
		 //redirect('productos/Administrador/productosAdicionalesA');
		  echo "<script>alert('Producto adicional eliminado correctamente');
		window.location.href='".base_url()."productos/Administrador/productoPublico';
		</script>";
	}

	//Función que manda a traer la vista editarProductoInterno_view con los datos del producto seleccionado
	public function editar()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->productoAdicionalA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdProductosGenerales = $fila->IdProductosGenerales;
				$NombreProducto=$fila->NombreProducto;
				$TipoProducto_IdTipoProducto=$fila->TipoProducto_IdTipoProducto;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$StockMinimo=$fila->StockMinimo;
				$PrecioVenta=$fila->PrecioVenta;
				$PrecioCompra=$fila->PrecioCompra;
				$DescripcionProducto = $fila->DescripcionProducto;
			}$data = array(
				'IdProductosGenerales' => $IdProductosGenerales,
				'NombreProducto' => $NombreProducto,
				'TipoProducto_IdTipoProducto' =>$TipoProducto_IdTipoProducto,		
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'StockMinimo' => $StockMinimo,
				'PrecioVenta' => $PrecioVenta,
				'PrecioCompra' => $PrecioCompra,
				'DescripcionProducto' => $DescripcionProducto);
			}else{
				$data ='';
				return FALSE;
			
		}
		$data['ReCategoria']=$this->productoAdicionalA_model->BuscarCategoria();
  		$data['ReTipo']=$this->productoAdicionalA_model->BuscarTipo();
		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('productos/Administrador/editarProductoAdicional_view',$data);
		$this->load->view('layout/footer');
		}
	}


	//Función que manda a traer la vista editarProductoInterno_view con los datos del producto seleccionado
	public function editarenlace ()
		{
		$IdProductosGenerales= $this -> uri->segment(5);
		$data=array(
		'IdProductosGenerales'=> $this->input->post('IdProductosGenerales',true),
		'NombreProducto'=> $this->input->post('NombreProducto',true),
		'TipoProducto_IdTipoProducto'=> $this->input->post('TipoProducto_IdTipoProducto'),
		'Categoria_IdCategoria' => $this->input->post('Categoria_IdCategoria',true),
        'StockMinimo' => $this->input->post('StockMinimo',true),
        'PrecioVenta' => $this->input->post('PrecioVenta'),
        'PrecioCompra' => $this->input->post('PrecioCompra'),
        'DescripcionProducto' => $this->input->post('DescripcionProducto'),
			);
		$this->productoAdicionalA_model->editarenlace($IdProductosGenerales, $data);
	
	}

//Función que manda a traer la vista buscarProductoInternoA_view 
//Hace la busqueda del producto seleccionado
	public function buscar ()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '2'|| 
			$this->session->userdata('Rol_IdRol') == '3')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$data = array();
		$query = $this->input->get('query', TRUE);
		if ($query) {
			$result = $this->productoAdicionalA_model->buscar(trim($query));
			
			if ($result != FALSE){
				$data = array(
					'result' => $result,
					
		);
			}else  {
				$data = array('result' => '');
			}	
		}else{
			$data = array('result' => '');
		}

		$this->load->view('layout/header');
		$this->load->view('layout/menuAdmin');
		$this->load->view('productos/Administrador/buscarProductoAdicionalA_view',$data);
		$this->load->view('layout/footer');
		}
	}




	//Función que muestra el tipo del producto 
	public function MostrarTipo(){
		$options ="";
		if($this->input->post('IdTipoProducto')){
			$IdTipo=$this->input->post('IdTipoProducto');
			$Nombre=$this->productoPublicoA_model->BuscarTipo($IdTipo);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $tipo_name ?></option>
                <?php
			}
		}

	}

	//Función que muestra la categoría del producto 
	public function MostrarCategoria(){
		$options ="";
		if($this->input->post('IdCategoria')){
			$IdCategoria=$this->input->post('IdCategoria');
			$NombreCategoria=$this->productoProductoA_model->BuscarCategoria($IdCategoria);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}

	}


	//Función que muestra la categoría del producto 
	public function MostrarFranquicia(){
		$options ="";
		if($this->input->post('IdFranquicias')){
			$IdFranquicias=$this->input->post('IdFranquicias');
			$NombreFranquicia=$this->productoAdicionalA_model->BuscarCategoria($IdFranquicias);
			foreach ($Nombre as $fila) {
				?>
                <option value="<?php echo $fila->id ?>"><?php echo $categoria_name ?></option>
                <?php
			}
		}

	}
	
}