<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
ini_set('memory_limit', '-1');
//Este controlador manda a traer las acciones que ayudará a que el módulo realiza sus funciones(Cosmetólogo)
class ProductoPublico extends CI_Controller
{
	//Constructor que manda a traer las librerias de sesión y validación y manda a llamar el modelo 
	public function __construct()
	{
		parent::__construct();
		$this->load->model('productos/Cosmetologo/productoPublicoA_model');
		$this->load->library(array('session','form_validation'));
	}


	//Función principal que valida que el usuario este logueado
	//Manda a traer la vista principal listaProductoPublicoA_view 
	//Hace la consulta para mostrar todos los productos al público que esten registrados en la franquicia del usuario logueado
	public function index()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
    	$data['Franquicias']=$this->productoPublicoA_model->BuscarFranquicia();
		foreach ($data['Franquicias'] as $i => $Franquicias)
		$this->db->select('*');
		$this->db->join('franquicias','Franquicias_IdFranquicias=IdFranquicias','inner');
		$this->db->join('productosgenerales','ProductosGenerales_IdProductosGenerales=IdProductosGenerales','inner');
		$this->db->join('categoria','Categoria_IdCategoria= IdCategoria','inner');
		$this->db->where('Franquicias_IdFranquicias',$i);
		$this->db->where('TipoProducto_IdTipoProducto','2');
		$data['consulta']=$this->db->get('productosfranquicias')->result();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('productos/Cosmetologo/listaProductoPublicoA_view',$data);
		$this->load->view('layout/footer');
		}
	}

	//Funcion que muestra en la vista editarProductoPublico_view los datos del seleccionado 
	public function VerInformacion()
	{
		if($this->session->userdata('Rol_IdRol')==FALSE || 
			$this->session->userdata('Rol_IdRol') == '1'|| 
			$this->session->userdata('Rol_IdRol') == '2')
		{
			redirect(base_url().'acceso/acceso');
		} else {
		$id= $this->uri->segment(5);
		$obtenerenlace = $this->productoPublicoA_model->obtenerenlace($id);
		if($obtenerenlace != FALSE){
			foreach ($obtenerenlace->result() as $fila) {
				$IdProductosFranquicias = $fila->IdProductosFranquicias;
				$NombreProducto=$fila->NombreProducto;
				$TipoProducto_IdTipoProducto=$fila->TipoProducto_IdTipoProducto;
				$Categoria_IdCategoria = $fila->Categoria_IdCategoria;
				$StockMinimo=$fila->StockMinimo;
				$PrecioVenta=$fila->PrecioVenta;
				$PrecioCompra=$fila->PrecioCompra;
				$DescripcionProducto = $fila->DescripcionProducto;
				$PiezasTotales= $fila->PiezasTotales;
			}$data = array(
				'IdProductosFranquicias' => $IdProductosFranquicias,
				'NombreProducto' => $NombreProducto,
				'TipoProducto_IdTipoProducto' =>$TipoProducto_IdTipoProducto,		
				'Categoria_IdCategoria' => $Categoria_IdCategoria,
				'StockMinimo' => $StockMinimo,
				'PrecioVenta' => $PrecioVenta,
				'PrecioCompra' => $PrecioCompra,
				'PiezasTotales' => $fila->PiezasTotales,
				'DescripcionProducto' => $DescripcionProducto);
			}else{
				$data ='';
				return FALSE;	
		}
		$data['ReTipo']=$this->productoPublicoA_model->BuscarTipo();
		$data['ReCategoria']=$this->productoPublicoA_model->BuscarCategoria();
		$this->load->view('layout/headerCos');
		$this->load->view('layout/menuCosmetologo');
		$this->load->view('productos/Cosmetologo/editarProductoPublico_view',$data);
		$this->load->view('layout/footer');
		}
	}

}